function RS = table(varargin)

% RS = table(SX,Z,sw)
%
% table(SX,Z,sw) adds headings etc to an output matrix.  
% Shifts t-1 variables to t if sw==1.
%
% Written by Alan Sutherland, 24 September 2003
%

SX=varargin{1};
Z=varargin{2};
if length(varargin)==3
    sw=varargin{3};
else
    sw=1;
end    

[nv,nx]=size(Z);

ofst=zeros(nv,1);
z=Z;

if sw==1
    for i=1:nv
        tmp=Z{i,1};
        [name,time]=strtok(tmp,'(');
        if strcmp(time,'(t-1)')
            ofst(i,1)=0;
        end
        if strcmp(time,'(t)')
            ofst(i,1)=-1;
        end
        if strcmp(time,'(t+1)')
            ofst(i,1)=-2;
        end
        z{i,1}=strcat(name,'(t)');
    end
end    

[nt,nv]=size(SX);

RS{1,1}=' Period';

for j=1:nv
    RS{1,j+1}=['   ',z{j,1}];
end  

for i=0:nt-1
    RS{i+2,1}=['  ',num2str(i+1-sw,'%12.0f')];
    for j=1:nv
        if i+1+ofst(j,1)>0
            if SX(i+1+ofst(j,1),j)<0
                pd=' ';
            else
                pd='  ';
            end   
            RS{i+2,j+1}=[pd,num2str(SX(i+1+ofst(j,1),j),'%12.6f')];
        else
            pd='  ';
            RS{i+2,j+1}=[pd,num2str(0.0,'%12.6f')];  
        end    
    end    
end    
