function ER = second_order_check(A1,A2,A3,B1,B2,SOL,LAMBDA)

% ER = second_order_check(A1,A2,A3,B1,B2,SOL,LAMBDA) 
% Substitutes the solution generated by second_order.m into the second-order 
% system of equations and calculates the errors.  If any error is larger than 
% approximately 1.0e-14 then there may be problems with the model setup or solution 
% algorithm.  Note that second_order_check only checks that the 
% second-order solution solves the second-order equations - it does note provide 
% any indication of the accuracy of the second-order solution as a solution 
% to the original non-linear model.
%
% Written by Alan Sutherland, 24 September 2003
%

[hr,nv]=size(SOL);
X=SOL';
L=LAMBDA(1:hr,:);
L=L';
P=(A2+B2)*X+A3*L;

ER=[];

for ii=1:hr-1
    er=P(:,ii)-(A1+B1)*X(:,ii+1);
    ER=[ER; er'];
end    