function [SOL] = second_order(varargin)

% 
% second_order(A1,A2,A3,B1,B2,LAMBDA,ns) uses the time series for the 
% second-order terms generated by lambdas.m to generate the solution to 
% the second-order system. 
%
% The following input is required:
%
% 1. 	The coefficient matrices of the second-order system - A1,A2,A3,B1,B2.
% 2.	The time series for the second-order terms  - LAMBDA.
% 3.	The total number of (endogenous and exogenous) predetermined variables - ns.
%
% hr1 and hr2 may be included as optional arguments.  (hr1 and hr2 must be included with the 
% same values as given in first_order and lambdas).
%
% Some sections of code relating to the QZ decomposition are taken
% from solab.m written by Paul Klein.
%
% Calls qzdiv() (by Christopher Sims)
%
% Written by Alan Sutherland, 24 September 2003
%
% Corrected input of hr1,hr2 (12/12/03)
% Corrected A1+B1, A2+B2 (4/5/04)


A1=varargin{1};
A2=varargin{2};
A3=varargin{3};
B1=varargin{4};
B2=varargin{5};
LAMBDA=varargin{6};
ns=varargin{7};

if length(varargin)>=9
    hr1=varargin{8};
    hr2=varargin{9};
else
    hr1=200;
    hr2=200;
end    

if length(varargin)==10
    SV=varargin{10};
else
    SV=zeros(ns,1);
end

hr3=hr1+hr2;

A1=A1+B1;
A2=A2+B2;

[nd,nd]=size(A1);
nu=nd-ns;
[nx,nl]=size(A3);

LAMBDA=LAMBDA';

stake=1.000001;

[s,t,qk,z] = qz(A1,A2);            
[s,t,qk,z] = qzdiv(stake,s,t,qk,z); 

z11=z(1:ns,1:ns);
z12=z(1:ns,ns+1:nd);

if rank(z11)<ns;
 error('Invertibility condition violated')
end

if abs(t(ns,ns))>stake*abs(s(ns,ns)) | abs(t(ns+1,ns+1))<stake*abs(s(ns+1,ns+1));
 warning('Wrong number of stable eigenvalues.');
end
s11=s(1:ns,1:ns);
t11=t(1:ns,1:ns);

t12=t(1:ns,ns+1:nd);
t22=t(ns+1:nd,ns+1:nd);

s12=s(1:ns,ns+1:nd);
s22=s(ns+1:nd,ns+1:nd);

LT=qk*A3*LAMBDA;

ti=inv(t22);
ts=ti*s22;

tss=eye(nu);
fw=zeros(nu,1);
hr1=hr1+1;
hr3=hr3+1;
tt=hr1;
for ii=0:hr2
    fw=fw-tss*ti*LT(ns+1:nd,tt+ii);
    tss=ts*tss;
end
tmp=inv(eye(nu)-ts)*tss;
adj=-tmp*ti*LT(ns+1:nd,hr3);
fw=fw+adj;
uu=fw;

for jj=1:hr1-1;
    tt=hr1-jj;
    fw=ts*fw-ti*LT(ns+1:nd,tt);
    uu=[fw uu];
end

u1=uu(1:nu,1);
s1=inv(z11)*(SV-z12*u1);
yy=[s1; u1];

for tt=2:hr1
    uv=uu(1:nu,tt);  
    sv=inv(s11)*([t11 t12]*yy(1:nd,tt-1)-s12*uv+LT(1:ns,tt-1));
    yv=[sv; uv];
    yy=[yy yv];
end

xx=z*yy;

SOL=real(xx');

SOL(hr1,:)=[];
