function [prmn,prmv,SIGMA] = load_parameters(pfile);

%
% load_parameters(parameter-filename) loads the parameter names and values.
% 
% Written by Alan Sutherland, 24 September 2003
% Corrected bug in line 57, 8 January 2006
%


[prmx]=textread(pfile, '%s','delimiter','\n','commentstyle','matlab');

prmx=cellstr(prmx);

[nm,nx]=size(prmx);

j=1;
for i=1:nm
    tmp1=prmx{i};
    tmp2={deblank(strtok(tmp1,'%'))};
    tmp3=strcat(tmp2,'%');
    if strcmp(tmp3{1},'%')==0;
        prmx1{j,1}=tmp2{1};
        j=j+1;
    end    
end    

prmx=prmx1;

[nm,nx]=size(prmx);

i=2;
j=1;
while strcmp(prmx{i}(1,1),'$')==0
    [name,val]=strtok(prmx{i},'=');
    val=strrep(val,'=','');
    prmn{j,1}=strrep(name,' ','');
    prme{j,1}=strrep(val,' ','');
    i=i+1;
    j=j+1;
end    

i=i+1;
j=1;
while strcmp(prmx{i}(1,1),'$')==0
    tmp1=prmx{i};
    tmp2=str2num([tmp1]);
    SIGMA(j,:)=tmp2;
    i=i+1;
    j=j+1;
end    

np=length(prmn);

for i=1:np
    for j=1:i-1
        prme{i,1}=strrep(prme{i,1},prmn{j,1},strcat('(',prme{j,1},')'));
    end
    prmv(i,1)=str2double(char(1.0*sym(prme{i,1})));
end
