function [a1,a2,a3,a4,b1,b2,sc,Z,ns,ER,LR] = load_model(mfile);

% [a1,a2,a3,a4,b1,b2,sc,Z,ns,ER,LR] = load_model(mfile)
%
% load_model(model-filename) loads the model equations and definitions 
% of the second-order terms and converts them into symbolic matrix form. 
% The output argument ER and LR provide a check that the model has been 
% correctly formatted and that it has been correctly converted into matrix 
% form.  A non-zero element of ER indicates an error in processing the 
% corresponding model equation and a non-zero element of LR indicates 
% an error in processing the corresponding second-order term.
% 
% Written by Alan Sutherland, 24 September 2003
%

[model]=textread(mfile, '%s','delimiter','\n','commentstyle','matlab');

model=cellstr(model);

[nm,nx]=size(model);

j=1;
for i=1:nm
    tmp1=model{i};
    tmp2={deblank(strtok(tmp1,'%'))};
    tmp3=strcat(tmp2,'%');
    if strcmp(tmp3{1},'%')==0;
        model1{j,1}=tmp2{1};
        j=j+1;
    end    
end    

model=model1;

[nm,nx]=size(model);

i=2;
j=1;
while strcmp(model{i}(1,1),'$')==0
    tmp=strrep(model{i},' ','');
    [lhs,rhs]=strtok(tmp,'=');
    rhs=strrep(rhs,'=','');
    EQ{j,1}=char(sym(lhs)-sym(rhs));
    i=i+1;
    j=j+1;
end 

i=i+1;
j=1;
while strcmp(model{i}(1,1),'$')==0
    tmp=strrep(model{i},' ','');
    [name,def]=strtok(tmp,'=');
    def=strrep(def,'=','');
    def=strrep(def,'Et[','');
    def=strrep(def,'Eo[','');
    def=strrep(def,']','');
    Lds{j,1}=def;
    LL{j,1}=name;
    i=i+1;
    j=j+1;
end 

i=i+1;
j=1;
while strcmp(model{i}(1,1),'$')==0
    Z{j,1}=strrep(model{i},' ','');
    i=i+1;
    j=j+1;
end  

nb=j-1;
i=i+1;
k=1;
while strcmp(model{i}(1,1),'$')==0
    Z{j,1}=strrep(model{i},' ','');
    ES1{k,1}=strcat('Et',strrep(Z{j,1},'(t)','(t+1)'));
    ES2{k,1}=strrep(Z{j,1},'(t)','(t+1)');
    i=i+1;
    j=j+1;
    k=k+1;
end  

nk=j-1-nb;
i=i+1;
while strcmp(model{i}(1,1),'$')==0
    Z{j,1}=strrep(model{i},' ','');
    i=i+1;
    j=j+1;
end 

i=i+1;
j=1;
while strcmp(model{i}(1,1),'$')==0
    SH{j,1}=strrep(model{i},' ','');
    i=i+1;
    j=j+1;
end  

[nd,nx]=size(Z);
[nl,nx]=size(LL);

ns=nb+nk;

for i=1:nd
        
    ZM{i,1}=strrep(Z{i,1},'(t-1)','(t-2)');
    ZM{i,1}=strrep(ZM{i,1},'(t)','(t-1)');   
    
    ZT{i,1}=Z{i,1};

    ZP{i,1}=strrep(Z{i,1},'(t)','(t+1)');
    ZP{i,1}=strrep(ZP{i,1},'(t-1)','(t)');
    
    ZF{i,1}=ZP{i,1};    
    if i>ns
        ZF(i,1)=strcat('Et',ZF(i,1));
    end    
    
    EZT(i,1)=strcat('Eo',Z(i,1));
    EZF(i,1)=strcat('Eo',ZP(i,1));
    
end 


for i=1:nd
    
    ZZM{i,1}=strrep(Z{i,1},'(t-1)','m2');
    ZZM{i,1}=strrep(ZZM{i,1},'(t)','m1');
    
    ZZT{i,1}=strrep(Z{i,1},'(t-1)','m1');
    ZZT{i,1}=strrep(ZZT{i,1},'(t)','t');
    
    ZZP{i,1}=strrep(Z{i,1},'(t)','p1');
    ZZP{i,1}=strrep(ZZP{i,1},'(t-1)','t');  
    
    ZZF{i,1}=strrep(ZF{i,1},'(t)','t');
    ZZF{i,1}=strrep(ZZF{i,1},'(t+1)','p1');
    
    EZZT{i,1}=strrep(EZT{i,1},'(t-1)','m1');
    EZZT{i,1}=strrep(EZZT{i,1},'(t)','t');

    EZZF{i,1}=strrep(EZF{i,1},'(t)','t');
    EZZF{i,1}=strrep(EZZF{i,1},'(t+1)','p1');
    
end 

vzm=ZZM{1};
vzt=ZZT{1};
vzp=ZZP{1};
vzf=ZZF{1};
vezt=EZZT{1};
vezf=EZZF{1};

zm=strcat('[',vzm);
zt=strcat('[',vzt);
zp=strcat('[',vzp);   
zf=strcat('[',vzf);
ezt=strcat('[',vezt);
ezf=strcat('[',vezf);   

for i=2:nd
    vzm=ZZM{i};
    vzt=ZZT{i};
    vzp=ZZP{i};
    vzf=ZZF{i};
    vezt=EZZT{i};
    vezf=EZZF{i};
    zm=strcat(zm,',',vzm);
    zt=strcat(zt,',',vzt);
    zp=strcat(zp,',',vzp);  
    zf=strcat(zf,',',vzf);
    ezt=strcat(ezt,',',vezt);
    ezf=strcat(ezf,',',vezf);      
end  

zm=strcat(zm,']');
zt=strcat(zt,']');
zp=strcat(zp,']');  
zf=strcat(zf,']');
ezt=strcat(ezt,']');
ezf=strcat(ezf,']');  

zts=sym(zt);
zfs=sym(zf);
ezts=sym(ezt);
ezfs=sym(ezf);

vll=LL{1};
vll=strrep(vll,'(t)','t');
ll=strcat('[',vll);

for i=2:nl
    vll=LL{i};
    vll=strrep(vll,'(t)','t');
    ll=strcat(ll,',',vll);
end

ll=strcat(ll,']');

lls=sym(ll);
    
syms a1 a2 a3 b1 b2 sc eqs;

for ieq=1:nd    

    eq=EQ{ieq};
    eq=strrep(eq,']','');
    eq=strrep(eq,'Et[','Et'); 
    eq=strrep(eq,'Eo[','Eo');        
    
    for ish=1:nk
        eq=strrep(eq,ES1{ish,1},ES2{ish,1});
    end        
    
    EQ{ieq}=eq;
    
    eq=strrep(eq,'(t-2)','m2');
    eq=strrep(eq,'(t-1)','m1');
    eq=strrep(eq,'(t)','t');
    eq=strrep(eq,'(t+1)','p1');
    
    eq=sym(eq);
    
    eqs(ieq,1)=eq;
    
end  

a1=jacobian(eqs,zfs);
a2=-jacobian(eqs,zts);
a3=-jacobian(eqs,lls);
b1=jacobian(eqs,ezfs);
b2=-jacobian(eqs,ezts);

a4=sym([zeros(nb,nk); eye(nk); zeros(nd-ns,nk)]);

ix=1;

zr=sym('0');

for il=1:nl;

    ld=Lds{il};
    ld=strrep(ld,'(t-2)','m2');
    ld=strrep(ld,'(t-1)','m1');
    ld=strrep(ld,'(t)','t');
    ld=strrep(ld,'(t+1)','p1');
    ld=strcat('(',ld,')/2');
    drm=sym(maple('hessian',ld,zm));
    drt=sym(maple('hessian',ld,zt));
    drp=sym(maple('hessian',ld,zp));
        
    for i=1:nd
        for j=i:nd
            cf1=drm(i,j);
            cf2=drt(i,j);
            cf3=drp(i,j);
            if cf1~=zr
                if i~=j
                    cf1=2*cf1;
                end    
                sc(ix,1)=il;
                sc(ix,2)='-1';
                sc(ix,3)=i;
                sc(ix,4)=j;
                sc(ix,5)=cf1;
                ix=ix+1;
            end
            if cf2~=zr
                if i~=j
                    cf2=2*cf2;
                end    
                sc(ix,1)=il;
                sc(ix,2)='0';
                sc(ix,3)=i;
                sc(ix,4)=j;
                sc(ix,5)=cf2;
                ix=ix+1;
            end
            if cf3~=zr
                if i~=j
                    cf3=2*cf3;
                end    
                sc(ix,1)=il;
                sc(ix,2)='1';
                sc(ix,3)=i;
                sc(ix,4)=j;
                sc(ix,5)=cf3;
                ix=ix+1;
            end
        
         end
    end 

end

ER=EQ;

for i=1:nd
    eq=ER{i,1};
    
    for j=1:nd 
        cf=char(a1(i,j));
        if strcmp(cf,'0')==0
            eq=strcat(eq,'-(',cf,')*',ZF{j,1});
        end    
    end
    
    for j=1:nd 
        cf=char(a2(i,j));
        if strcmp(cf,'0')==0
            eq=strcat(eq,'+(',cf,')*',ZT{j,1});
        end    
    end 

    for j=1:nl
        cf=char(a3(i,j));
        if strcmp(cf,'0')==0
            eq=strcat(eq,'+(',cf,')*',LL{j,1});
        end    
    end 
    
    for j=1:nk
        cf=char(a4(i,j));
        if strcmp(cf,'0')==0
            eq=strcat(eq,'+(',cf,')*',SH{j,1});
        end    
    end 

    for j=1:nd 
        cf=char(b1(i,j));
        if strcmp(cf,'0')==0
            eq=strcat(eq,'-(',cf,')*',EZF{j,1});
        end    
    end
    
    for j=1:nd 
        cf=char(b2(i,j));
        if strcmp(cf,'0')==0
            eq=strcat(eq,'+(',cf,')*',EZT{j,1});
        end    
    end 

    exs=char(simplify(sym(eq)));
    ER{i,1}=exs;
end   

[nxx,nx]=size(sc);

LR=Lds;
for i=1:nxx
    g1=int32(double(sc(i,1)));
    tx=int32(double(sc(i,2)));
    g3=int32(double(sc(i,3)));
    g4=int32(double(sc(i,4)));
    cf=char(sc(i,5));
    eq=LR{g1,1};
    if tx==-1
        eq=strcat(eq,'-(',cf,')*',ZM{g3,1},'*',ZM{g4,1});
    end 
    if tx==0
        eq=strcat(eq,'-(',cf,')*',ZT{g3,1},'*',ZT{g4,1});
    end    
    if tx==1
        eq=strcat(eq,'-(',cf,')*',ZP{g3,1},'*',ZP{g4,1});
    end  
    exs=char(simplify(sym(eq)));
    LR{g1,1}=exs;
end

