function LAMBDA = lambdas(varargin)

% LAMBDA = lambdas(SC,VC) 
% Uses conditional second moments to generate a time series for the 
% second-order terms in a stochastic dynamic model. 
%
% The following input is required:
%
% 1. SC - the coefficients of the second-order terms.
% 2. VC - the conditional second moments of the variables of the model 
%         (as generated by first_order).
%
% hr1 and hr2 may be included as optional arguments.  (hr1 and hr2 must be 
% included with the same values as given in first_order).
%
% Written by Alan Sutherland, 24 September 2003
%

SC=varargin{1};
VC=varargin{2};
if length(varargin)==4
    hr1=varargin{3};
    hr2=varargin{4};
else
    hr1=200;
    hr2=200;
end    


hr3=hr1+hr2;

[nxx,nx]=size(SC);

nl=max(SC(:,1));

LAMBDA=zeros(nl,hr3+2);
for tt=1:hr3+2
    for ii=1:nxx
        g1=SC(ii,1);
        tx=int32(tt+1+SC(ii,2));        
        g3=SC(ii,3);
        g4=SC(ii,4);
        cf=SC(ii,5);
        vx=cf*VC(g3,g4,tx);
        LAMBDA(g1,tt)=LAMBDA(g1,tt)+vx;
    end
end

LAMBDA=LAMBDA';