function ER = impulse_response_check(A1,A2,IRP)

% ER = impulse_response_check(A1,A2,IRP)
%
% impulse_response_check(A1,A2,IRP) substitutes the solution generated 
% by impulse_response.m into the first-order system of equations 
% and calculates the errors.  If any error is larger than approximately 
% 1.0e-14 then there may be problems with the model setup or solution 
% algorithm.  
%
% Written by Alan Sutherland, 24 September 2003
%

[hr,nv]=size(IRP);
X=IRP';
P=A2*X;

ER=[];

for ii=1:hr-1
    er=P(:,ii)-A1*X(:,ii+1);
    ER=[ER; er'];
end    