function IR = impulse_response(varargin)

% IR = impulse_response(A1,A2,SV)
%
% Solves a first-order approximation of a dynamic model and returns 
% the deterministic time-paths of variables for a given set of initial
% conditions.
%
% Some sections of code relating to the QZ decomposition are taken
% from solab.m written by Paul Klein.
%
% Calls qzdiv() (by Christopher Sims)
% 
% Written by Alan Sutherland, 24 September 2003
%


A1=varargin{1};
A2=varargin{2};
SV=varargin{3};
ns=varargin{4};
if length(varargin)==5
    hr=varargin{6};
else
    hr=30;
end    

[nd,nd]=size(A1);
nu=nd-ns;

stake=1.000001;

[s,t,qk,z] = qz(A1,A2);            
[s,t,qk,z] = qzdiv(stake,s,t,qk,z); 

z11=z(1:ns,1:ns);
z21=z(ns+1:end,1:ns);

if rank(z11)<ns;
 error('Invertibility condition violated')
end

if abs(t(ns,ns))>stake*abs(s(ns,ns)) | abs(t(ns+1,ns+1))<stake*abs(s(ns+1,ns+1));
 warning('Wrong number of stable eigenvalues.');
end

z11i=z11\eye(ns);

s11=s(1:ns,1:ns);
t11=t(1:ns,1:ns);

dyn=s11\t11;

G=real(z11*dyn*z11i);
F=real(z21*z11i); 

% generate impulse response

BV=SV;
FV=F*BV;

IX(:,1)=[BV; FV];

for t=2:hr
    BV=G*BV;
    FV=F*BV;
    IX(:,t)=[BV; FV];
end

IR=IX';