% loads model in numeric form and solves

clear all

load growth.mat A1 A2 A3 A4 B1 B2 SC SIGMA ns Z;

% second-order solution %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

VC = first_order(A1,A2,A4,SIGMA,ns);

LAMBDA = lambdas(SC,VC);

SOL = second_order(A1,A2,A3,B1,B2,LAMBDA,ns);

% impulse response %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[nk,nk]=size(SIGMA);

nb=ns-nk;

SV=zeros(ns,1);

SV(nb+1,1)=1;

IRP = impulse_response(A1,A2,SV,ns);

% tables %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

SOLt = table(SOL,Z,0,1);

IRPt = table(IRP,Z,0,1);

% check results %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ER1 = second_order_check(A1,A2,A3,B1,B2,SOL,LAMBDA);

ER2 = impulse_response_check(A1,A2,IRP);
