% loads model in symbolic form and solves

clear all

% load model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

mfile='closed_model.dat';

[a1,a2,a3,a4,b1,b2,sc,Z,ns,ER,LR] = load_model(mfile);

pfile='closed_parameters.dat';

[prmn,prmv,SIGMA] = load_parameters(pfile);

[A1,A2,A3,A4,B1,B2,SC] = s2n(a1,a2,a3,a4,b1,b2,sc,prmn,prmv);

% second-order solution %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

VC = first_order(A1,A2,A4,SIGMA,ns);

LAMBDA = lambdas(SC,VC);

SOL = second_order(A1,A2,A3,B1,B2,LAMBDA,ns);

% impulse response %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[nk,nk]=size(SIGMA);

nb=ns-nk;

SV=zeros(ns,1);

SV(nb+1,1)=1;

IRP = impulse_response(A1,A2,SV,ns);

% tables %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

SOLt = table(SOL,Z);

IRPt = table(IRP,Z);

% check solution %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ER1 = second_order_check(A1,A2,A3,B1,B2,SOL,LAMBDA);

ER2 = impulse_response_check(A1,A2,IRP);
