
(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var particles,energy=[-1,-1],scale,pointer_offset,images=[],full_expression=false,simulation=true,current_challenge=1;var help_text=[];help_text["Stage_help_default"]="Two identical quantum particles such as electrons with parallel spins<br>have no distinguishing features. If we place them both in the same infinite square well so that their probability densities overlap, we have no way of knowing which electron is which: two quantum particles can be <it>indistinguishable</it>. <b>Press the \"?\" buttons for information on the displayed quantities. Click on or slide through the energy levels below. Then try the challenges in the Challenges tab!</b>";help_text["Stage_help_swap"]="The probability density for two indistinguishable particles must<br>remain unchanged if the positions of the two particles are exchanged, as we cannot keep track of which particle is which. Thus, for indistinguishable particles we must have <nobr>|&Psi;(x<sub>1</sub>, x<sub>2</sub>)|<sup>2</sup> = |&Psi;(x<sub>2</sub>, x<sub>1</sub>)|<sup>2</sup></nobr>. For distinguishable particles, the probability density may well be different if we exchange the positions of the two particles, and here we assume that both have definite energies. How can you see this in the graphs?";help_text["Stage_help_expression"]="As <nobr>&Psi;<sub>nm</sub>(x<sub>1</sub>, x<sub>2</sub>)</nobr> and <nobr>&Psi;<sub>nm</sub>(x<sub>2</sub>, x<sub>1</sub>)</nobr> with n&ne;m correspond to the same<br>total energy, we can create two new eigenfunctions with this same total energy, one symmetric "+"&Psi;<sub>+,nm</sub>(x<sub>1</sub>, x<sub>2</sub>) = 1/&radic;<span style='text-decoration:overline;'>2</span>(&Psi;<sub>nm</sub>(x<sub>1</sub>, x<sub>2</sub>) + &Psi;<sub>nm</sub>(x<sub>2</sub>, x<sub>1</sub>))<br>"+"and one antisymmetric under exchange of the two particles<br>"+"&Psi;<sub>&#8211;,nm</sub>(x<sub>1</sub>, x<sub>2</sub>) = 1/&radic;<span style='text-decoration:overline;'>2</span>(&Psi;<sub>nm</sub>(x<sub>1</sub>, x<sub>2</sub>) &#8211; &Psi;<sub>nm</sub>(x<sub>2</sub>, x<sub>1</sub>))<br>"+"In nature, indistinguishable spinless bosons have symmetric spatial eigenfunctions and indistinguishable fermions with parallel spins have antisymmetric spatial eigenfunctions.";help_text["Stage_help_line"]="For all points on the line <nobr>x<sub>1</sub> = x<sub>2</sub></nobr>, both particles are at the same<br>position in space. If you compare states with two different energies, are the indistinguishable fermions with parallel spins less likely or more likely to be found at the same position (along the line <nobr>x<sub>1</sub> = x<sub>2</sub></nobr>) than distinguishable particles each with definite energy? Are the indistinguishable spinless bosons less likely or more likely to be found at the same position than distinguishable particles each with definite energy?";help_text["Stage_help_graph"]="The graphs show you the energy eigenfunction <nobr>&Psi;(x<sub>1</sub>, x<sub>2</sub>)</nobr> and the associated probability density <nobr>|&Psi;(x<sub>1</sub>, x<sub>2</sub>)|<sup>2</sup></nobr> for two particles in a one-dimensional infinite square well. x<sub>1</sub> and x<sub>2</sub> are the positions of particles 1 and 2 respectively. In nature, indistinguishable fermions with parallel spins have antisymmetric spatial eigenfunctions that change sign under exchange of the two particles, <nobr>ψ<sub>&#8211;</sub>(x<sub>1</sub>, x<sub>2</sub>) = &#8211;ψ<sub>&#8211;</sub>(x<sub>2</sub>, x<sub>1</sub>)</nobr>. Indistinguishable spinless bosons have symmetric eigenfunctions that remain unchanged under exchange of the two particles, <nobr>ψ<sub>+</sub>(x<sub>1</sub>, x<sub>2</sub>) = +ψ<sub>+</sub>(x<sub>2</sub>, x<sub>1</sub>)</nobr>.";help_text["Stage_help_energy"]="You can choose the energies in the two-particle quantum state. The single particle energy levels are shown as dashed lines, with E<sub>1</sub> being the ground state energy. If you choose two different energies for indistinguishable particles, then both particles are in a superposition of the two energies. How are indistinguishable particles different from distinguishable ones in terms of their energy eigenfunctions and associated probability densities?";help_text["Stage_help_radio0"]="For two distinguishable particles (such as a neutron and a proton),<br>we can keep track of which particle is which. Here we assume both particles have definite energies. The energy eigenfunction <nobr>&Psi;<sub>nm</sub>(x<sub>1</sub>, x<sub>2</sub> ) = &Psi;<sub>n</sub>(x<sub>1</sub>) &Psi;<sub>m</sub>(x<sub>2</sub>)</nobr> for such distinguishable particles implies particle 1 is in the eigenstate n and particle 2 in the eigenstate m. This energy eigenfunction is the same irrespective of whether one or more of the particles is a fermion (a particle with half-integer spin) or a boson (a particle with integer spin).";help_text["Stage_help_radio1"]="Fermions are particles with half-integer spin such as electrons.<br>For two electrons with parallel spins in an infinite square well, we can not keep track of which electron is which: electrons are indistinguishable particles. Thus, a physically meaningful eigenfunction for the two electrons must have the same probability density if the positions of the two electrons are exchanged, and thus fulfil <nobr>|&Psi;<sub>nm</sub>(x<sub>1</sub>, x<sub>2</sub>)|<sup>2</sup> = |&Psi;<sub>nm</sub>(x<sub>2</sub>, x<sub>1</sub>)|<sup>2</sup></nobr>.";help_text["Stage_help_radio2"]="Bosons are particles with integer spin. Spinless bosons are particles with total spin zero such as <nobr>helium-4</nobr> nuclei. For two indistinguishable spinless bosons in an infinite square well, we cannot keep track of which boson is which. Thus, a physically meaningful eigenfunction for the two bosons must have the same probability density if their positions are exchanged, and thus fulfil <nobr>|&Psi;<sub>nm</sub>(x<sub>1</sub>, x<sub>2</sub>)|<sup>2</sup> = |&Psi;<sub>nm</sub>(x<sub>2</sub>, x<sub>1</sub>)|<sup>2</sup></nobr>.";function showHelpText(sym,e){var help_button;if(e===undefined){help_button=$("#Stage_help_default");}else{help_button=$(e.target).parent();}
sym_enable(sym.$('.disabled.help'));sym_disable(help_button);sym.$('help_text').html(help_text[help_button.attr("id")]);sym.$("help_content").show();}
function preloadImages(){var prefixes=['d','dpr','f','fpr','b','bpr'],length=prefixes.length;for(var i=0;i<length;i++){_preloadImages(prefixes[i]);}}
function _preloadImages(prefix){for(var i=1;i<=5;i++){for(var j=1;j<=5;j++){var name=prefix+i+'Ny'+j,image=new Image();image.onload=function(){};image.onerror=function(){console.error("Error occur while preloading image: "+name);};image.src='./images/graphs/'+name+'.png';images.push(image);}}}
function updateState(){if(simulation){updateCheckbox();updateParticle();updateEnergy();updatePointer();}
updateGraph();updateExpression();}
function updateCheckbox(){if($('#Stage_checkbox_show_expression').hasClass('selected')){full_expression=true;}else{full_expression=false;}}
function updateEnergy(){var length=energy.length;for(var i=0;i<length;i++){energy[i]=getEnergyLevel($("#Stage_slider_part"+i).data('val'));}}
function getEnergyLevel(slider_val){return 4-slider_val;}
function updateParticle(){if($("#Stage_radio0").hasClass('selected'))
particles='d';else if($("#Stage_radio1").hasClass('selected'))
particles='f';else if($("#Stage_radio2").hasClass('selected'))
particles='b';}
function updatePointer(){var length=energy.length;for(var i=0;i<length;i++){var bottom=Math.round(Math.pow(energy[i],2)*scale-pointer_offset),pointer=$("#Stage_pointer_part"+i);pointer.css('bottom',bottom+'px');}}
function updateGraph(){var graph0=$("#Stage_graph0"),graph1=$("#Stage_graph1"),src0='./images/graphs/'+particles+energy[0]+'Ny'+energy[1]+'.png',src1='./images/graphs/'+particles+'pr'+energy[0]+'Ny'+energy[1]+'.png';graph0.attr("src",src0);graph1.attr("src",src1);}
function updateExpression(){var top_expression=$('#Stage_top_expression'),btm_expression=$('#Stage_bottom_expression'),top_str='&Psi;',btm_str;if(!simulation){top_str+='<sub>?</sub>';}else if(particles=='d'||(particles=='b'&&energy[0]==energy[1])){top_str+='<sub>'+energy[0]+energy[1]+'</sub>';}else if(particles=='f'){top_str+='<sub>&#8211;, '+energy[0]+energy[1]+'</sub>';}else if(particles=='b'){top_str+='<sub>+, '+energy[0]+energy[1]+'</sub>';}
top_str+='(x<sub>1</sub>, x<sub>2</sub>)'
btm_str='|'+top_str+'|<sup>2</sup>';if(full_expression){var expression
if(particles=='d'||(particles=='b'&&energy[0]==energy[1])){expression='&Psi;<sub>'+energy[0]+'</sub>(x<sub>1</sub>)'+'&Psi;<sub>'+energy[1]+'</sub>(x<sub>2</sub>)';top_str+=' = '+expression;btm_str+=' = |'+expression+'|<sup>2</sup>';}else if(particles=='f'){expression='(&Psi;<sub>'+energy[0]+'</sub>(x<sub>1</sub>)&Psi;<sub>'+energy[1]+'</sub>(x<sub>2</sub>) &#8211; &Psi;<sub>'+energy[0]+'</sub>(x<sub>2</sub>)&Psi;<sub>'+energy[1]+'</sub>(x<sub>1</sub>))';top_str+=' = 1/&radic;<span style="text-decoration:overline;">2</span>'+expression;btm_str+=' = 1/2|'+expression+'|<sup>2</sup>';}else if(particles=='b'){expression='(&Psi;<sub>'+energy[0]+'</sub>(x<sub>1</sub>)&Psi;<sub>'+energy[1]+'</sub>(x<sub>2</sub>) + &Psi;<sub>'+energy[0]+'</sub>(x<sub>2</sub>)&Psi;<sub>'+energy[1]+'</sub>(x<sub>1</sub>))';top_str+=' = 1/&radic;<span style="text-decoration:overline;">2</span>'+expression;btm_str+=' = 1/2|'+expression+'|<sup>2</sup>';}}
if(particles=='f'&&energy[0]==energy[1]){top_str+=' = 0';btm_str+=' = 0<br>Not a possible quantum state!';top_expression.css('color','rgb(192, 0, 0)');btm_expression.css('color','rgb(192, 0, 0)');}else{top_expression.css('color','rgb(0, 0, 0)');btm_expression.css('color','rgb(0, 0, 0)');}
top_expression.html(top_str);btm_expression.html(btm_str);}
function initSim(){simulation=true;updateState();}
var score_for_challenge=[15,15,15,15,20,20],challenge_complete=[false,false,false,false,false,false],totalScore=0,fireworkProb=1,challenge_text=[],challenge_config=[];challenge_text.push("The graphs show a two-particle quantum state with two different energies in a one-dimensional infinite square well. What types of particles are depicted in the graphs?");challenge_text.push("What happens to the energy eigenfunction ψ shown if you swap the position of the two particles?");challenge_text.push("The graphs show a two-particle quantum state in a one-dimensional infinite square well. Both particles have the same energy. What types of particles are depicted in the graphs?");function initChallenge(){simulation=false;full_expression=false;}
function rerenderRadio(e){if(!$(e.target).data('rerender')){sym_features();$(e.target).data('rerender',true);}}
function step_functions(step){clearTimeout(AdobeEdge.step_animation);var text=$("#Stage_challenge_text");current_challenge=step;$("#Stage_feedback_text").hide();sym_select($("#Stage_radio_answer0"));$('.group_answer').show();switch(current_challenge){case 1:case 2:case 3:$("#Stage_radio_label_answer0").html('Two distinguishable particles each with definite energy');$("#Stage_radio_label_answer1").html('Two indistinguishable fermions with parallel spins');$("#Stage_radio_label_answer2").html('Two indistinguishable spinless bosons');$("#Stage_radio_label_answer3").html('Not possible to tell just from the graphs');$("#Stage_radio_answer0").data('particles','d');$("#Stage_radio_answer1").data('particles','f');$("#Stage_radio_answer2").data('particles','b');$("#Stage_radio_answer3").data('particles','n');text.html(challenge_text[0]);particles=challenge_config[current_challenge-1];energy[0]=Math.floor((Math.random()*5)+1);if(energy[0]!=5)energy[1]=5;else energy[1]=Math.floor((Math.random()*4)+1);break;case 4:case 5:$("#Stage_radio_label_answer0").html('<nobr>&Psi;(x<sub>1</sub>, x<sub>2</sub>) = &#8211; &Psi;(x<sub>2</sub>, x<sub>1</sub>)</nobr>,<br>e.g. &Psi; is antisymmetric');$("#Stage_radio_label_answer1").html('<nobr>&Psi;(x<sub>1</sub>, x<sub>2</sub>) = +&Psi;(x<sub>2</sub>, x<sub>1</sub>)</nobr>,<br>e.g. &Psi; is symmetric');$("#Stage_radio_label_answer2").html('&psi; is neither symmetric or antisymmetric');$("#Stage_radio_answer0").data('particles','f');$("#Stage_radio_answer1").data('particles','b');$("#Stage_radio_answer2").data('particles','n');$("#Stage_radio_answer3").hide();text.html(challenge_text[1]);particles=challenge_config[current_challenge-1];energy[0]=Math.floor((Math.random()*4)+1);energy[1]=Math.floor((Math.random()*3)+1);if(energy[0]==energy[1])energy[1]=energy[1]+1;break;case 6:$("#Stage_radio_label_answer0").html('Two distinguishable particles each with definite energy');$("#Stage_radio_label_answer1").html('Two indistinguishable fermions with parallel spins');$("#Stage_radio_label_answer2").html('Two indistinguishable spinless bosons');$("#Stage_radio_label_answer3").html('Not possible to tell just from the graphs');text.html(challenge_text[2]);particles=challenge_config[current_challenge-1];energy[0]=Math.floor((Math.random()*5)+1);energy[1]=energy[0];break;}
updateState();}
function shuffle(array){var currentIndex=array.length,temporaryValue,randomIndex;while(0!==currentIndex){randomIndex=Math.floor(Math.random()*currentIndex);currentIndex-=1;temporaryValue=array[currentIndex];array[currentIndex]=array[randomIndex];array[randomIndex]=temporaryValue;}
return array;}
function setupChallenge(){var challenge_particles=["d","f","b"];shuffle(challenge_particles);challenge_config=challenge_particles;challenge_particles=["f","b"];shuffle(challenge_particles);$.merge(challenge_config,challenge_particles);challenge_particles=["d","b"];shuffle(challenge_particles);challenge_particles.splice(-1,1);$.merge(challenge_config,challenge_particles);}
function challengeSubmit(){var feedback=$('#Stage_feedback_text'),result=checkAnswer();feedback.fadeOut("fast",function(){if(result.correct){feedback.css('color','#008f00');}else{feedback.css('color','#960000');}
feedback.html(result.feedback_str);feedback.fadeIn("fast");});if(result.correct&&!challenge_complete[current_challenge-1]){$('#Stage_steps_tick'+current_challenge).show();challenge_complete[current_challenge-1]=true;addScore(score_for_challenge[current_challenge-1]);}}
function checkAnswer(){var result={correct:false,feedback_str:"Something wrong"},all_zero=true;switch(current_challenge){case 1:case 2:case 3:var answer=$(".group_answer.selected").data('particles');if(answer==particles){switch(particles){case"f":result.feedback_str="Correct, congratulations! Indistinguishable fermions with parallel spins have an antisymmetric spatial energy eigenfunction. This leads to a reduction in the probability density along the line <nobr>x<sub>1</sub> = x<sub>2</sub></nobr>. The two fermions are less likely to be found at the same position than two distinguishable particles.";break;case"b":result.feedback_str="Correct, congratulations! Indistinguishable spinless bosons have a symmetric spatial energy eigenfunction. This leads to an increase in the probability density along the line <nobr>x<sub>1</sub> = x<sub>2</sub></nobr>. The two bosons are more likely to be found at the same position than two distinguishable particles.";break;case"d":result.feedback_str="Correct, congratulations! For distinguishable particles, there is no symmetry requirement and the energy eigenfunction is the product of the eigenfunctions for particles 1 and 2. Thus, the probability density peaks are aligned with the x- and y-axes.";break;}
result.correct=true;}else if(particles=='d'&&(answer=="b"||answer=="f")){result.feedback_str="This is not yet correct. For distinguishable particles, there is no symmetry requirement and the energy eigenfunction is the product of the eigenfunctions for particles 1 and 2. Thus, the probability density peaks are aligned with the x- and y-axes.";result.correct=false;}else{result.feedback_str="This is not yet correct. For states consisting of two different energies as here, the antisymmetry requirement for the fermions and the symmetry requirement for the bosons leads to a reduction and an increase respectively in the probability density along the line <nobr>x<sub>1</sub> = x<sub>2</sub></nobr>. The two fermions are less likely to be found at the same position, the two bosons more likely to be found at the same position compared with distinguishable particles.";result.correct=false;}
break;case 4:case 5:var answer=$(".group_answer.selected").data('particles');if(answer==particles){switch(particles){case"b":result.feedback_str="Correct, congratulations! The energy eigenfunction graph would look the same if the labels x<sub>1</sub> and x<sub>2</sub> were swapped. Thus, the energy eigenfunction is symmetric under interchange of particles.";break;case"f":result.feedback_str="Correct, congratulations! The energy eigenfunction graph would look inverted (maxima turn into minima and vice versa) if the labels x<sub>1</sub> and x<sub>2</sub> were swapped. Thus, the energy eigenfunction is antisymmetric under interchange of particles.";break;}
result.correct=true;}else{result.feedback_str="This is not yet correct. Consider whether the energy eigenfunction graph would look the same or inverted (maxima turn into minima and vice versa) if the labels x<sub>1</sub> and x<sub>2</sub> were swapped. These two cases correspond to a symmetric and an antisymmetric eigenfunction respectively.";result.correct=false;}
break;case 6:if($("#Stage_radio_answer3").hasClass('selected')){result.feedback_str="Correct, congratulations! For two distinguishable particles and for two spinless bosons with the same energy, the energy eigenfunction is <nobr>&Psi;<sub>nn</sub>(x<sub>1</sub>, x<sub>2</sub>)</nobr>. Thus, the graph alone does not allow you to distinguish these two cases.";result.correct=true;}else if($("#Stage_radio_answer1").hasClass('selected')){result.feedback_str="This is not yet correct. Indistinguishable fermions with parallel spins have an antisymmetric spatial energy eigenfunction. Thus, it is not possible for the two fermions to have the same energy, as the wavefunction for this case <nobr>&Psi;<sub>&#8211;, nn</sub>(x<sub>1</sub>, x<sub>2</sub>) = 1/&radic;<span style='text-decoration:overline'>2</span>(&Psi;<sub>nn</sub>(x<sub>1</sub>, x<sub>2</sub> ) &#8211; &Psi;<sub>nn</sub>(x<sub>2</sub>, x<sub>1</sub>)) = 0</nobr>.";result.correct=false;}else{result.feedback_str="This is not yet correct. For two distinguishable particles with the same energy, the energy eigenfunction is <nobr>&Psi;<sub>nn</sub>(x<sub>1</sub>, x<sub>2</sub>)</nobr>. Indistinguishable spinless bosons have a symmetric spatial energy eigenfunction. However, <nobr>&Psi;<sub>nn</sub>(x<sub>1</sub>, x<sub>2</sub>)</nobr> is already symmetric under interchange of the particles.";result.correct=false;}}
return result;}
function addScore(score){var currentScore=totalScore;totalScore+=score;startScoreAnimation(currentScore,totalScore);if(Math.random()<fireworkProb&&totalScore!=100){fireworks();fireworkProb=0.25;}else
fireworkProb=2*fireworkProb;if(totalScore==100){$("#Stage_fancyExcellent").show();AdobeEdge.getComposition(compId).getStage().getSymbol('fancyExcellent').play();}}
function fireworks(){var star_id='#Stage_stars';var stick_ele=$('#Stage_stick');var number=6;var spread=75;var delay_const=500;var speed_const=700;var speed_const_offset=500;var x0=stick_ele.css('left'),y0=stick_ele.css('top');var totalDelay=0;$('#Stage .star').hide();$('#Stage .star').css({'left':x0,'top':y0,'opacity':1});$('#Stage .star').fadeIn(500);for(var i=0;i<number;i++){var left=Math.round(Math.random()*spread);if(Math.random()<0.5)
left='-='+left+'px';else
left='+='+left+'px';var delay1=Math.round((Math.random()+.25)*delay_const);totalDelay+=delay1;var speed=Math.round((Math.random()+.5)*speed_const)+speed_const_offset;$('#Stage_stars'+i).delay(delay1).animate({'left':left,'top':'-=500px','opacity':0},speed);}
$('#Stage .star').delay(1000).fadeOut();}
function startScoreAnimation(startValue,endValue){var text_score=$('#Stage_text_score');var duration=800;var currentValue=startValue;var interval=duration/(endValue-startValue);if(endValue>startValue){function recursiveFunc(){text_score.text(++currentValue+'/100');if(currentValue==endValue)
return;setTimeout(recursiveFunc,interval);}
recursiveFunc();}else throw'startValue is larger than endValue';}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});{$('#Stage .slider.vertical').each(function(){if($(this).hasClass("fancy-css"))
return
else
$(this).addClass("fancy-css");var slider_color=$(this).find('div[id^="Stage_slider_bar"]').css("border-top-color");$(this).children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});$(this).find('div[id^="Stage_slider_bar"]').css({'border-top-color':tinycolor(slider_color).darken(10).toHexString(),'border-right-color':tinycolor(slider_color).darken(13).toHexString(),'border-bottom-color':tinycolor(slider_color).darken(10).toHexString(),'border-left-color':tinycolor(slider_color).toHexString()});});}
var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;if(slider.hasClass('nonlinear')){var step_vals=slider.data('step_vals'),snap_steps=step_vals[step_vals.length-1],snap_interval=range/snap_steps;pos=closest(Math.round(pos/snap_interval),step_vals)*snap_interval;}else{var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;}
slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function closest(val,arr){var curr=arr[0],length=arr.length;for(var i=1;i<length;i++){if(Math.abs(val-arr[i])<Math.abs(val-curr))
curr=arr[i];}
return curr;}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var slider=$(element);var min=slider.data('min');var max=slider.data('max');var range=slider.hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;if(slider.hasClass('nonlinear')){var step_vals=slider.data('step_vals'),snap_steps=step_vals[step_vals.length-1],snap_interval=range/snap_steps,snap=slider.data('snap'),index;if(val>max)val=max;else if(val<min)val=min;index=val-min/snap;pos=step_vals[index]*snap_interval;}else{pos=(val-min)/(max-min)*range;}
slider.find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');slider.data('val',val);slider.data('timeout_val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym.$('slider_part0').data('step_vals',[0,7,12,15]);sym.$('slider_part1').data('step_vals',[0,7,12,15]);sym_features();sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});yepnope({load:"normalize.css"});showHelpText(sym);sym.$('checkbox_label_show_expression').html('Show expression for &Psi; and |&Psi;|<sup>2</sup>');for(var i=0;i<4;i++){sym.$('slider_label_part0'+i).html('E<sub>'+(i+1)+'</sub>');sym.$('slider_label_part1'+i).html('E<sub>'+(i+1)+'</sub>');}
sym.$('dash_line_label').html('x<sub>1</sub> = x<sub>2</sub>');sym.$('top_x1_label').html('x<sub>1</sub>');sym.$('top_x2_label').html('x<sub>2</sub>');sym.$('btm_x1_label').html('x<sub>1</sub>');sym.$('btm_x2_label').html('x<sub>2</sub>');sym.$("square_well").css('border-top-color','rgba(0,0,0,0)');sym.$(".energy_lvl").css('top','auto');var offset=$("#Stage_part0_e1").height()/2;scale=sym.$("energy_lvl_area").height()/16;pointer_offset=$("#Stage_pointer_part0").height()/2;$("#Stage_part0_e1, #Stage_part1_e1").css('bottom',Math.round(1*scale-offset)+'px');$("#Stage_part0_e2, #Stage_part1_e2").css('bottom',Math.round(4*scale-offset)+'px');$("#Stage_part0_e3, #Stage_part1_e3").css('bottom',Math.round(9*scale-offset)+'px');$("#Stage_part0_e4, #Stage_part1_e4").css('bottom',Math.round(16*scale-offset)+'px');preloadImages();updateState();$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider_part0');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));updateState();},20));}});$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider_part1');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));updateState();},20));}});setupChallenge();$('#Stage .star').hide();$('.tick').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){sym.stop('simulation');initSim();sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_challenge}","click",function(sym,e){sym.stop('challenge');initChallenge();sym_step(current_challenge);sym_features();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_help_close}","click",function(sym,e){sym_enable(sym.$('.disabled.help'));sym.$('help_content').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_default}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_radio0}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_show_expression}","click",function(sym,e){updateState();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_expression}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_submit}","click",function(sym,e){challengeSubmit();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_energy}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_swap}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_swap}","click",function(sym,e){var temp=energy[0];energy[0]=energy[1];energy[1]=temp;sym_val($('#Stage_slider_part0'),4-energy[0]);sym_val($('#Stage_slider_part1'),4-energy[1]);updateState();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_radio1}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_radio2}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_line}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_graph}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio0}","click",function(sym,e){updateState();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio1}","click",function(sym,e){updateState();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio2}","click",function(sym,e){updateState();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_answer0}","click",function(sym,e){rerenderRadio(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_answer1}","click",function(sym,e){rerenderRadio(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_answer2}","click",function(sym,e){rerenderRadio(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_answer3}","click",function(sym,e){rerenderRadio(e);});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'highlight_1'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight_1");
//Edge symbol end:'highlight_1'

//=========================================================

//Edge symbol: 'fancyExcellent'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){$("#Stage_fancyExcellent").hide();sym.stop(0);});
//Edge binding end
})("fancyExcellent");
//Edge symbol end:'fancyExcellent'
})(jQuery,AdobeEdge,"EDGE-19890435");