#pragma once


// CRotatableGLWnd

#include "OpenGlWnd.h"
class CRotatableGLWnd : public COpenGLWnd
{
	DECLARE_DYNAMIC(CRotatableGLWnd)

public:
	CRotatableGLWnd();
	virtual ~CRotatableGLWnd();

	void MakeAVI(int fpSec, int fpCircle,int rotType);
	void SetRotationType(int rotationType);
	int GetRotationType() {return m_RotationType;}
	void SetRotate(float x,float y) 
	{
		m_xRotation=x; 
		m_yRotation=y;
	}
	void SetAutorotateAngle(float angle) {m_AutoRotationAngle=angle;}

protected:
	void DoRotate();
	float m_xRotation;
	float m_yRotation;

	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);

private:
	UINT m_TimerTime;
	float m_AutoRotationAngle;
	int m_RotationTimerID;
	int m_RotationType;
	BOOL m_bInMouseRotate;
	CPoint m_LeftDownPos;

	DECLARE_MESSAGE_MAP()
};


