// RotatableGLWnd.cpp : implementation file
//

#include "stdafx.h"
#include "KlustaWin.h"
#include "RotatableGLWnd.h"
#include "ConstructVideo.h"

#include <math.h>


// CRotatableGLWnd

IMPLEMENT_DYNAMIC(CRotatableGLWnd, COpenGLWnd)

CRotatableGLWnd::CRotatableGLWnd()
{
	m_RotationType=0;	// 0=not allowed, 1=mouse, 2=autoRotateY, 3=X
	m_RotationTimerID=0;
	m_bInMouseRotate=FALSE;

	m_xRotation = 0.0f;
	m_yRotation = 0.0f;

	m_AutoRotationAngle=-3.0f;
	m_TimerTime=20;
}

CRotatableGLWnd::~CRotatableGLWnd()
{
}


BEGIN_MESSAGE_MAP(CRotatableGLWnd, COpenGLWnd)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_TIMER()
END_MESSAGE_MAP()

// CRotatableGLWnd message handlers

void CRotatableGLWnd::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if (m_RotationType==1)
	{
		m_LeftDownPos = point;
		SetCapture();
		::SetCursor(LoadCursor(NULL, IDC_SIZEALL));
// NOTE: we need a flag, can't just check whether got capture, 
// since capture might be set in a derived class for another reason
		m_bInMouseRotate=TRUE;
	}
	
	COpenGLWnd::OnLButtonDown(nFlags, point);
}

void CRotatableGLWnd::OnLButtonUp(UINT nFlags, CPoint point) 
{
	m_LeftDownPos = CPoint(0,0);	// forget where we clicked
	SetMouseCursor(	AfxGetApp()->LoadStandardCursor(IDC_ARROW));
	ReleaseCapture();
	m_bInMouseRotate=FALSE;
	
	COpenGLWnd::OnLButtonUp(nFlags, point);
}

void CRotatableGLWnd::OnMouseMove(UINT nFlags, CPoint point) 
{
// check if we are in mouse rotate
// can't just check if got capture, because might be captured in derived class for another reason
	if (m_bInMouseRotate)
	{
		ASSERT(GetCapture()==this);
		::SetCursor(LoadCursor(NULL, IDC_SIZEALL));
		m_yRotation -= (float)(m_LeftDownPos.x - point.x)/3.0f;
		m_xRotation -= (float)(m_LeftDownPos.y - point.y)/3.0f;
		m_LeftDownPos = point;
		InvalidateRect(NULL,FALSE);
	}
	// TODO: Add your message handler code here and/or call default
	
	COpenGLWnd::OnMouseMove(nFlags, point);
}

void CRotatableGLWnd::DoRotate()
{
	glRotatef(m_xRotation, 1.0, 0.0, 0.0);
	glRotatef(m_yRotation, 0.0, 1.0, 0.0);
}

void CRotatableGLWnd::SetRotationType(int rotationType)
{
	m_RotationType=rotationType;
	if (m_RotationType==2 || m_RotationType==3)	// autorotate
		m_RotationTimerID=SetTimer(1,m_TimerTime,NULL);
	else
		KillTimer(m_RotationTimerID);
}


void CRotatableGLWnd::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent==m_RotationTimerID)
	{
		if (m_RotationType==2)	// Y
		{
			m_yRotation+=m_AutoRotationAngle;
			m_yRotation=fmod(m_yRotation,360);
		}
		else
		{
			ASSERT(m_RotationType==3);
			m_xRotation+=m_AutoRotationAngle;
			m_xRotation=fmod(m_xRotation,360);
		}
		InvalidateRect(NULL,FALSE);
	}
	COpenGLWnd::OnTimer(nIDEvent);
}

void CRotatableGLWnd::MakeAVI(int fpSec, int fpCircle, int rotType)
{
	int count;
	CWaitCursor waitCur;	

	KillTimer(m_RotationTimerID);	// should not be necessary, but just in case
	Invalidate();	// force window redraw to get rid of any dlg before capturing bitmap
	UpdateWindow();

	float rotAngle=-360.0F/fpCircle;

	CRect rect1;
	GetClientRect(&rect1);
	CClientDC dc(this);

	CConstructVideo ConstructVideo;

#if USE_GDI
	CDC dcMem;
	CBitmap bm;
	CBitmap* pbmOld = NULL;
	VERIFY(dcMem.CreateCompatibleDC(&dc));
	VERIFY(bm.CreateCompatibleBitmap(&dc,rect1.Width(),rect1.Height()));
   	ASSERT(bm.m_hObject != NULL);
	pbmOld = dcMem.SelectObject(&bm);

	
// this is where the bit that repeats for each frame starts	
	dcMem.PatBlt(0,0,rect1.Width(),rect1.Height(),WHITENESS);
	dcMem.BitBlt(0,0,rect1.Width(),rect1.Height(),
		&dc,0,0,SRCCOPY);
	dcMem.SelectObject(pbmOld);

	// audio bits and palette depth implicit at end
	if (!ConstructVideo.Create(bm,CSize(rect1.Width(),rect1.Height()),fpSec))
	{	// might CANCEL within Create
		bm.DeleteObject();
		return;
	}

// this is where the bit that repeats for each frame starts	
	for (count=0; count<fpCircle; count++)
	{
// do rotation first
		if (rotType==0)	// Y
		{
			m_yRotation+=rotAngle;
			m_yRotation=fmod(m_yRotation,360);
		}
		else
		{
			ASSERT(rotType==1);
			m_xRotation+=rotAngle;
			m_xRotation=fmod(m_xRotation,360);
		}
		InvalidateRect(NULL,FALSE);
		UpdateWindow();

 		ASSERT(bm.m_hObject != NULL);
		pbmOld = dcMem.SelectObject(&bm);
		dcMem.PatBlt(0,0,rect1.Width(),rect1.Height(),WHITENESS);
		dcMem.BitBlt(0,0,rect1.Width(),rect1.Height(),
			&dc,0,0,SRCCOPY);
		dcMem.SelectObject(pbmOld);

		if (!ConstructVideo.WriteFrame(bm,count))
		{
			AfxMessageBox("error writing video frame");
			break;
		}
	}
	bm.DeleteObject();
#else

/*
THE PROBLEM
1. OpenGL returns RGB values, whatever the screen colour setting
2. The RLE codec in MakeVideo is the best for scattergraphs, because lossless and good compression
3. RLE codec requires 8-bit colour

So need to convert 24-bit RGB values into 8-bit, given that screen colour setting
may be anything!

Solution: make a 24-bit DIB, then use GetDIBits to retrieve data in 8-bit format
then pass header + data to ConstructVideo::MakeFrame etc
*/

	int rv;
	CSize size(rect1.Width(),rect1.Height());
// Lines have to be 32 bytes aligned, so crop if not
	size.cx -= size.cx % 4; 

	int numPixels=size.cx*size.cy;	// num pixels on screen
	int numBytes = 3*numPixels;		// num Bytes for 24-bit colour returned by OpenGL

	ASSERT(dc.m_hDC!=NULL);

// Make the info structure for a 24-bit DIB
// BITMAPINFO = BITMAPINFOHEADER followed by colour table
// but 24-bit DIBs do not have a colour table
	BITMAPINFO bmInfo24;
	ZeroMemory( &bmInfo24.bmiHeader, sizeof(BITMAPINFOHEADER) );
	bmInfo24.bmiHeader.biWidth=size.cx;
	bmInfo24.bmiHeader.biHeight=size.cy;	// +ve, so origin is lower-left corner (upper left if -ve)
	bmInfo24.bmiHeader.biPlanes=1;
	bmInfo24.bmiHeader.biBitCount=24; // Can be 8, 16, 32 bpp or 
							   // other number; but OpenGL returns 24-bit values
	bmInfo24.bmiHeader.biSizeImage=numBytes;
	bmInfo24.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	bmInfo24.bmiHeader.biClrUsed= 0;
	bmInfo24.bmiHeader.biClrImportant= 0;

	BYTE *pPixelData;
	HBITMAP hBmp= CreateDIBSection( dc.m_hDC,
									&bmInfo24,
									DIB_RGB_COLORS,
									(void **)&pPixelData,
									NULL,
									0 );

/* 
Notes on accessing bitmap pixel data in CreateDIBSection
We pass in the address of a byte pointer, but at this stage this does not point to any allocated memory. 
CreateDIBSection allocates enough memory to hold the bitmap data, 
and sets the byte pointer to point to the start of this memory block. 
So we can put an image into the bitmap by assigning data to the memory pointed to by the pointer
Thus after creating the DIBSection as above we could set
pPixelData[0]= ..
pPixelData[1]= ..
pPixelData[2]= ..
to set the RGB values of the first pixel (bottom left) in the bitmap
*/

/* 
Before writing video frames we have to set the video format using AVIStreamSetFormat.
This needs a pointer to an 8-bit BITMAPINFOHEADER followed contiguously by a colour table
We construct our own BITMAPINFOHEADER, but we use GetDIBits to construct the table
We need to allocate an 8-bit BITMAPINFO (hdr + uninitialised colour table) to pass to GetDIBits.
Colour table will be 256*sizeof(RGBQUAD) = 1024 bytes, and will be filled in by GetDIBits.
CConstructVideo::Create calls AVIStreamSetFormat.
*/

	BITMAPINFO *pBmInfo8=(BITMAPINFO *) new BYTE[sizeof(BITMAPINFOHEADER) + 1024];

// BITMAPINFOHEADER is just first part of BITMAPINFO 
	BITMAPINFOHEADER  *pBmInfoHdr8 =(LPBITMAPINFOHEADER)pBmInfo8;

// fill in members of 8-bit BITMAPINFOHEADER  
	pBmInfoHdr8->biSize = sizeof(BITMAPINFOHEADER) ;
	pBmInfoHdr8->biWidth = size.cx;
	pBmInfoHdr8->biHeight = size.cy;
	pBmInfoHdr8->biPlanes = 1 ;
	pBmInfoHdr8->biBitCount = 8;
	pBmInfoHdr8->biCompression = BI_RGB ;	// = no compression
	pBmInfoHdr8->biSizeImage = numPixels;	// 1 byte per pixel for 8-bit image
	pBmInfoHdr8->biXPelsPerMeter = 0 ;
	pBmInfoHdr8->biYPelsPerMeter = 0 ;
	pBmInfoHdr8->biClrUsed = 256;
	pBmInfoHdr8->biClrImportant = 0 ;

// allocate memory to receive transformed (24->8 bit) pixel data
	BYTE *pPixel8Data = new BYTE[numPixels];

/* 
Using GetDIBits(...)
hBmp is the DIBSection we constructed earlier with 24-bit source data.
At the moment it has no image data in it.
pBmInfo8 is the header (+ unitialised colour table) that tells GetDIBits 
that we want a 24->8 bit transform.
pPixel8Data will receive the transformed data

From MSDN: "If the requested format for the DIB matches its internal format, 
the RGB values for the bitmap are copied. If the requested format doesn't match 
the internal format, a color table is synthesized."

So it seems that GetDIBits synthesises the required colour table for the 24->8 bit transform
using the colours in the original (and probaly the DC). It fills in the colour table
that follows pBmInfoHdr8.

Thus in this program GetDIBits will do 2 jobs: 
1) synthesise the colour table which is passed to AVIStreamSetFormat 
2) transform 24->8 bit data, which are passed to AVIStreamWrite
*/


// fill image data memory of 24-bit bitmap from OpenGL, so that GetDIBits can synthesise colour table 
// before sending BITMAPINFOHEADER to AVIStreamSetFormat 
// NOTE; pPixelData points to the data memory of the 24-bit DIBSection
	BeginGLCommands();
	::glReadPixels(0,0,size.cx,size.cy,GL_BGR_EXT,GL_UNSIGNED_BYTE,pPixelData); 
	EndGLCommands();

// now synthesise colour table
	rv=::GetDIBits(dc.m_hDC,hBmp,0,size.cy,pPixel8Data,(LPBITMAPINFO) pBmInfo8, DIB_RGB_COLORS);
// in case GetDIBits messed this up - not sure why its needed, but MS example has this
	pBmInfoHdr8->biClrUsed = 256;

	if (!ConstructVideo.Create(pBmInfoHdr8,size,fpSec)) // might CANCEL within Create
	{
		delete [] pPixel8Data;
		delete [] pBmInfo8;
		DeleteObject(hBmp);
		return;	
	}

// this is where the bit that repeats for each frame starts	
	for (count=0; count<fpCircle; count++)
	{
// do rotation first
		if (rotType==0)	// Y
		{
			m_yRotation+=rotAngle;
			m_yRotation=fmod(m_yRotation,360);
		}
		else
		{
			ASSERT(rotType==1);
			m_xRotation+=rotAngle;
			m_xRotation=fmod(m_xRotation,360);
		}
		InvalidateRect(NULL,FALSE);
		UpdateWindow();

// fill DIBSection with new image
		BeginGLCommands();
		::glReadPixels(0,0,size.cx,size.cy,GL_BGR_EXT,GL_UNSIGNED_BYTE,pPixelData); 
		EndGLCommands();

// so now we have a 24-bit DIB in hBmp, need to get data for 8-bit dib
		rv=::GetDIBits(dc.m_hDC,hBmp,0,size.cy,pPixel8Data,(LPBITMAPINFO) pBmInfo8, DIB_RGB_COLORS);

// and write data to video stream
		rv=ConstructVideo.WriteFrame(pBmInfoHdr8,pPixel8Data,count);

		if (!rv)
		{
			AfxMessageBox(_T("error writing video frame"));
			break;
		}
	}

	delete [] pPixel8Data;
	delete [] pBmInfo8;
	DeleteObject(hBmp);
#endif
}

