// Output.cpp : implementation file
//

#include "stdafx.h"
#include "KlustaWin.h"
#include "Output.h"


// COutput dialog

IMPLEMENT_DYNAMIC(COutput, CDialog)

COutput::COutput(CWnd* pParent /*=NULL*/)
	: CDialog(COutput::IDD, pParent)
{
	m_Output = _T("");
}

COutput::~COutput()
{
}

void COutput::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_OUTPUT, m_Output);
}


BEGIN_MESSAGE_MAP(COutput, CDialog)
	ON_BN_CLICKED(IDC_COPY, OnCopy)
END_MESSAGE_MAP()


// COutput message handlers
void COutput::OnCopy() 
{
//	CopyStringToClipboard(this,m_Output);
	if(OpenClipboard())
	{
		HGLOBAL clipbuffer;
		char * buffer;
		EmptyClipboard();
		clipbuffer = GlobalAlloc(GMEM_DDESHARE, m_Output.GetLength()+1);
		buffer = (char*)GlobalLock(clipbuffer);
		for (int i=0; i<m_Output.GetLength(); i++)
		{
			char c=m_Output.GetAt(i);
			buffer[i]=c;
		}
		buffer[m_Output.GetLength()]='\0';
		GlobalUnlock(clipbuffer);
		SetClipboardData(CF_TEXT,clipbuffer);
		CloseClipboard();
	}	
}

BOOL COutput::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
#ifdef _DEBUG

	int lt=((CEdit *)(GetDlgItem(IDC_OUTPUT)))->GetLimitText();
	TRACE("Limit text in CEdit = %d\n",lt);
#endif
	

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
