
// KlustaWinDlg.h : header file
//

#pragma once


// CKlustaWinDlg dialog
class CGLSelectableScatterGraph;
class CClusterDetails
{
public:
	CClusterDetails(int numClassesFound,float score,int itemCount,int *pClassID);
	~CClusterDetails();

	int m_NumClusters;	// not really needed because held in map key, but may be useful as check
	float m_BestScore;
	float m_SumScore;
	int m_NumOccurrences;
	int *m_pList;
};

class CKlustaWinDlg : public CDialogEx
{
// Construction
public:
	CKlustaWinDlg(CWnd* pParent = NULL);	// standard constructor
	virtual ~CKlustaWinDlg();

// Dialog Data
	enum { IDD = IDD_KLUSTAWIN_DIALOG };

		CComboBox	m_cClusterCountList;
	CSpinButtonCtrl	m_cXAxisSpin;
	CSpinButtonCtrl	m_cYAxisSpin;
	CSpinButtonCtrl	m_cZAxisSpin;
	CComboBox	m_cClusterList;
	int		m_DimCount;
	int		m_ItemCount;
	int		m_SymbolSize;
	int		m_NumClassesFound;
	int		m_ClusterList;
	int		m_ProjType;
	BOOL	m_bAutoSclX;
	BOOL	m_bAutoSclY;
	BOOL	m_bAutoSclZ;
	int		m_RotationType;
	float	m_MaxX;
	float	m_MinX;
	float	m_MaxY;
	float	m_MinY;
	float	m_MaxZ;
	float	m_MinZ;
	float	m_AutoRotateSpeed;
	BOOL	m_bLogFile;
	int		m_Score;
	int		m_BestScore;
	BOOL	m_bSaveBest;
	int		m_NumRuns;
	int		m_RunsDone;
	int		m_BestNumClusters;
	int		m_ClusterCountList;
	int		m_TotalRuns;

	int GetPartitionData(VARIANT *pData);
	void SetData(int numDims,int numItems,COleSafeArray& saData);
	CString m_CommandLineFile;
	BOOL DoOpen(CString fName);
	BOOL IsNumberOrSpace(TCHAR c) {return (isspace(c) || isdigit(c) || c=='.' || c=='+' || c=='-' || c=='e' || c=='E');}
	CGLSelectableScatterGraph *m_pGraphWnd;
	BOOL GetFloatFromString(CString& str, float& x);
	int CountFloatsInString(CString str);

	BOOL LoadPartition(FILE *fp);
	BOOL LoadData(FILE *fp);
	void UpdateLogFileName();
	void SetClusterCols();
	void ResetOutput();
	void GetStats(int cluster,CClusterDetails *pCD, int dim, float& avg,float& sd, int& n);

	CString m_LogFileName;
	float **m_ppData;	// will be Data[Dim][Item], read from file
	float *m_pData;		// 3 contiguous dims, passed to graph
	int *m_pClassID;
	COLORREF m_DefClassCol[12];
	BOOL m_bGraphCreated;
	void SetGraphData();
	COLORREF *m_pColList;	// list of colours of each point, sent to graph
	COLORREF *m_pClusterCols;	// list of colours used by each class
	COLORREF m_ClearCol;

	CString m_FileName;
	int m_SaveNum;	// append to output filename to make series
	int m_MaxClassFound;
	CMap<int,int,int,int> m_ScoreMap;
	CMap<int,int,int,int> m_NumClustersCountMap;
	CMap<int,int,float,float> m_SumScoreMap;
	CMap<int,int,CClusterDetails *,CClusterDetails *> m_ClusterDetailsMap;

	int m_OldRotType;
	void SetupForCalc();
	int m_XAxisDataID;
	int m_YAxisDataID;
	int m_ZAxisDataID;

	afx_msg void OnLoadFile();
	afx_msg void OnCalc();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnKillfocusSymbolSize();
	afx_msg void OnMakeSel();
	afx_msg void OnCancelSel();
	afx_msg void OnZoomSel();
	afx_msg void OnParams();
	afx_msg void OnSave();
	afx_msg void OnDropFiles(HDROP hDropInfo);
	afx_msg void OnColour();
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	afx_msg void OnSelendokClusterList();
	afx_msg void OnProjectionType1();
	afx_msg void OnProjectionType2();
	afx_msg void OnAutosclX();
	afx_msg void OnAutosclY();
	afx_msg void OnAutosclZ();
	afx_msg void OnCopy();
	afx_msg void OnRotType1();
	afx_msg void OnRotType2();
	afx_msg void OnRotType3();
	afx_msg void OnRotType4();
	afx_msg void OnKillfocusXMax();
	afx_msg void OnKillfocusXMin();
	afx_msg void OnKillfocusYMax();
	afx_msg void OnKillfocusYMin();
	afx_msg void OnKillfocusZMax();
	afx_msg void OnKillfocusZMin();
	afx_msg void OnClearColour();
	afx_msg void OnKillfocusAutoSpeed();
	afx_msg void OnDefView();
	afx_msg void OnFrontView();
	afx_msg void OnSideView();
	afx_msg void OnTopView();
	afx_msg void OnLogFile();
	afx_msg void OnShowAbout();
	afx_msg void OnMakeVideo();
	afx_msg void OnPasteData();
	afx_msg void OnCopyData();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSaveBest();
	afx_msg void OnKk();
	afx_msg void OnSummary();
	afx_msg void OnSelendokClusterCountList();
	afx_msg void OnShowBest();

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	CToolTipCtrl *m_pToolTip;

	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

};
