
// KlustaWinDlg.cpp : implementation file
//

#include "stdafx.h"
#include "KlustaWin.h"
#include "KlustaWinDlg.h"
#include "afxdialogex.h"

#include <math.h>
#include <stdio.h>
#include <limits.h>
#include <float.h>
#include <time.h>

#include "ConstructVideo.h"
#include "VideoProps.h"
#include "output.h"
#include "cluster.h"
#include "ClusterParams.h"
#include "GLSelectableScatterGraph.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

const int STRLEN=10000;

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


CClusterDetails::CClusterDetails(int numClassesFound,float score,int itemCount,int *pClassID)
{
	m_NumClusters=numClassesFound;	// not really needed because held in map key, but may be useful as check
	m_BestScore=score;
	m_SumScore=score;
	m_NumOccurrences=1;
	m_pList=new int[itemCount];

	for (int i=0; i<itemCount; i++)
		m_pList[i]=pClassID[i];
}

CClusterDetails::~CClusterDetails()
{
	delete [] m_pList;
}


// CKlustaWinDlg dialog

/*
Log files.
Every time we load a source file, get a log filename by appending _log to title.
Check whether file exists already, and if it does, ask whether to append or delete existing.
Delete if necessary.
In OnCalc, open log file for appending, then close after DoPartition, so can read
externally
*/

CKlustaWinDlg::CKlustaWinDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CKlustaWinDlg::IDD, pParent)
{
	m_DimCount = 0;
	m_ItemCount = 0;
	m_SymbolSize = 5;
	m_NumClassesFound = 0;
	m_ClusterList = 0;
	m_ProjType = 0;
	m_bAutoSclX = TRUE;
	m_bAutoSclY = TRUE;
	m_bAutoSclZ = TRUE;
	m_RotationType = 1;
	m_MaxX = 1.0f;
	m_MinX = 0.0f;
	m_MaxY = 1.0f;
	m_MinY = 0.0f;
	m_MaxZ = 1.0f;
	m_MinZ = 0.0f;
	m_AutoRotateSpeed = 3.0f;
	m_bLogFile = FALSE;
	m_Score = 0;
	m_BestScore = 0;
	m_bSaveBest = FALSE;
	m_NumRuns = 1;
	m_RunsDone = 0;
	m_BestNumClusters = 0;
	m_ClusterCountList = -1;
	m_TotalRuns = 0;

	m_pToolTip=NULL;
	m_bGraphCreated=FALSE;
	m_ppData=NULL;
	m_pData=NULL;
	m_pGraphWnd=NULL;
	m_pColList=NULL;
	m_pClassID=NULL;

	m_DefClassCol[0]=RGB(255,0,0);	// 
	m_DefClassCol[1]=RGB(0,255,255);	// 
	m_DefClassCol[2]=RGB(0,0,255);	// 
	m_DefClassCol[3]=RGB(255,0,255);	// 
	m_DefClassCol[4]=RGB(0,128,0);	// 
	m_DefClassCol[5]=RGB(128,0,128);	// 
	m_DefClassCol[6]=RGB(128,0,0);	// 
	m_DefClassCol[7]=RGB(0,255,0);	// 
	m_DefClassCol[8]=RGB(0,0,128);	// 
	m_DefClassCol[9]=RGB(255,255,0);	// 
	m_DefClassCol[10]=RGB(0,128,128);	// 
	m_DefClassCol[11]=RGB(128,128,0);	// 
	m_pClusterCols=new COLORREF[1];
	m_pClusterCols[0]=m_DefClassCol[0];
	m_ClearCol=RGB(0,0,0);

	srand( (unsigned)time( NULL ) );


	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

CKlustaWinDlg::~CKlustaWinDlg()
{
//	ResetOutput();	// NO; need to destroy before windows HWND goes, because clears combo list
	if (m_pGraphWnd!=NULL)
		delete m_pGraphWnd;
	ASSERT(m_pClusterCols!=NULL);
	delete [] m_pClusterCols;

	if (m_pToolTip!=NULL)
		delete m_pToolTip;
}

void CKlustaWinDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CLUSTER_COUNT_LIST, m_cClusterCountList);
	DDX_Control(pDX, IDC_X_SPIN, m_cXAxisSpin);
	DDX_Control(pDX, IDC_Y_SPIN, m_cYAxisSpin);
	DDX_Control(pDX, IDC_Z_SPIN, m_cZAxisSpin);
	DDX_Control(pDX, IDC_CLUSTER_LIST, m_cClusterList);
	DDX_Text(pDX, IDC_DIM_COUNT, m_DimCount);
	DDX_Text(pDX, IDC_ITEM_COUNT, m_ItemCount);
	DDX_Text(pDX, IDC_SYMBOL_SIZE, m_SymbolSize);
	DDV_MinMaxInt(pDX, m_SymbolSize, 0, 9);
	DDX_Text(pDX, IDC_NUM_CLUSTERS, m_NumClassesFound);
	DDX_CBIndex(pDX, IDC_CLUSTER_LIST, m_ClusterList);
	DDX_Radio(pDX, IDC_PROJECTION_TYPE1, m_ProjType);
	DDX_Check(pDX, IDC_AUTOSCL_X, m_bAutoSclX);
	DDX_Check(pDX, IDC_AUTOSCL_Y, m_bAutoSclY);
	DDX_Check(pDX, IDC_AUTOSCL_Z, m_bAutoSclZ);
	DDX_Radio(pDX, IDC_ROT_TYPE1, m_RotationType);
	DDX_Text(pDX, IDC_X_MAX, m_MaxX);
	DDX_Text(pDX, IDC_X_MIN, m_MinX);
	DDX_Text(pDX, IDC_Y_MAX, m_MaxY);
	DDX_Text(pDX, IDC_Y_MIN, m_MinY);
	DDX_Text(pDX, IDC_Z_MAX, m_MaxZ);
	DDX_Text(pDX, IDC_Z_MIN, m_MinZ);
	DDX_Text(pDX, IDC_AUTO_SPEED, m_AutoRotateSpeed);
	DDV_MinMaxFloat(pDX, m_AutoRotateSpeed, 0.1f, 30.f);
	DDX_Check(pDX, IDC_LOG_FILE, m_bLogFile);
	DDX_Text(pDX, IDC_SCORE, m_Score);
	DDX_Text(pDX, IDC_BEST_SCORE, m_BestScore);
	DDX_Check(pDX, IDC_SAVE_BEST, m_bSaveBest);
	DDX_Text(pDX, IDC_NUM_RUNS, m_NumRuns);
	DDV_MinMaxInt(pDX, m_NumRuns, 1, 500);
	DDX_Text(pDX, IDC_RUNS_DONE, m_RunsDone);
	DDX_Text(pDX, IDC_BEST_NUM_CLUSTERS, m_BestNumClusters);
	DDX_CBIndex(pDX, IDC_CLUSTER_COUNT_LIST, m_ClusterCountList);
	DDX_Text(pDX, IDC_TOTAL_RUNS, m_TotalRuns);
}

BEGIN_MESSAGE_MAP(CKlustaWinDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()

	ON_WM_CLOSE()
//	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_LOAD_FILE, OnLoadFile)
	ON_BN_CLICKED(IDC_CALC, OnCalc)
	ON_WM_SIZE()
	ON_EN_KILLFOCUS(IDC_SYMBOL_SIZE, OnKillfocusSymbolSize)
	ON_BN_CLICKED(IDC_MAKE_SEL, OnMakeSel)
	ON_BN_CLICKED(IDC_CANCEL_SEL, OnCancelSel)
	ON_BN_CLICKED(IDC_ZOOM_SEL, OnZoomSel)
	ON_BN_CLICKED(IDC_PARAMS, OnParams)
	ON_BN_CLICKED(IDC_SAVE, OnSave)
	ON_WM_DROPFILES()
	ON_BN_CLICKED(IDC_COLOUR, OnColour)
	ON_WM_DRAWITEM()
	ON_CBN_SELENDOK(IDC_CLUSTER_LIST, OnSelendokClusterList)
	ON_BN_CLICKED(IDC_PROJECTION_TYPE1, OnProjectionType1)
	ON_BN_CLICKED(IDC_PROJECTION_TYPE2, OnProjectionType2)
	ON_BN_CLICKED(IDC_AUTOSCL_X, OnAutosclX)
	ON_BN_CLICKED(IDC_AUTOSCL_Y, OnAutosclY)
	ON_BN_CLICKED(IDC_AUTOSCL_Z, OnAutosclZ)
	ON_BN_CLICKED(IDC_COPY, OnCopy)
	ON_BN_CLICKED(IDC_ROT_TYPE1, OnRotType1)
	ON_BN_CLICKED(IDC_ROT_TYPE2, OnRotType2)
	ON_BN_CLICKED(IDC_ROT_TYPE3, OnRotType3)
	ON_BN_CLICKED(IDC_ROT_TYPE4, OnRotType4)
	ON_EN_KILLFOCUS(IDC_X_MAX, OnKillfocusXMax)
	ON_EN_KILLFOCUS(IDC_X_MIN, OnKillfocusXMin)
	ON_EN_KILLFOCUS(IDC_Y_MAX, OnKillfocusYMax)
	ON_EN_KILLFOCUS(IDC_Y_MIN, OnKillfocusYMin)
	ON_EN_KILLFOCUS(IDC_Z_MAX, OnKillfocusZMax)
	ON_EN_KILLFOCUS(IDC_Z_MIN, OnKillfocusZMin)
	ON_BN_CLICKED(IDC_CLEAR_COLOUR, OnClearColour)
	ON_EN_KILLFOCUS(IDC_AUTO_SPEED, OnKillfocusAutoSpeed)
	ON_BN_CLICKED(IDC_DEF_VIEW, OnDefView)
	ON_BN_CLICKED(IDC_FRONT_VIEW, OnFrontView)
	ON_BN_CLICKED(IDC_SIDE_VIEW, OnSideView)
	ON_BN_CLICKED(IDC_TOP_VIEW, OnTopView)
	ON_BN_CLICKED(IDC_LOG_FILE, OnLogFile)
	ON_BN_CLICKED(IDC_SHOW_ABOUT, OnShowAbout)
	ON_BN_CLICKED(IDC_MAKE_VIDEO, OnMakeVideo)
	ON_BN_CLICKED(IDC_PASTE_DATA, OnPasteData)
	ON_BN_CLICKED(IDC_COPY_DATA, OnCopyData)
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_SAVE_BEST, OnSaveBest)
	ON_BN_CLICKED(IDC_KK, OnKk)
	ON_BN_CLICKED(IDC_SUMMARY, OnSummary)
	ON_CBN_SELENDOK(IDC_CLUSTER_COUNT_LIST, OnSelendokClusterCountList)
	ON_BN_CLICKED(IDC_SHOW_BEST, OnShowBest)
END_MESSAGE_MAP()


// CKlustaWinDlg message handlers

BOOL CKlustaWinDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	// Enable drag/drop open
	DragAcceptFiles();


	// TODO: Add extra initialization here
	m_pGraphWnd=new CGLSelectableScatterGraph;

	CRect rect(10,10,10,10);
	if (!m_pGraphWnd->Create( NULL,   //CWnd default
						NULL,   //has no name
						WS_CHILD|WS_CLIPSIBLINGS|WS_CLIPCHILDREN|WS_VISIBLE,
						rect,
						this,   //this is the parent
						0))     //this should really be a different number... check resource.h
	{
		TRACE("Failed to create 3D Graph window\n");
		ASSERT(0);
	}
		
	m_bGraphCreated=TRUE;

// generate OnSize to get Graph window positioned right
	CRect r;
	GetWindowRect(&r);
	r.InflateRect(1,1);
    MoveWindow(r);

	m_pGraphWnd->SetProjection(m_ProjType);
	m_pGraphWnd->SetSymbolSize(m_SymbolSize);
	m_pGraphWnd->SetClearCol(m_ClearCol);
	m_pGraphWnd->SetRotationType(1);
	
	m_pGraphWnd->SetData(0,RGB(128,0,0),m_pData,m_pColList);
	OnAutosclX();	// scale data and fill edit boxes
	OnAutosclY();
	OnAutosclZ();

	m_pToolTip= new CToolTipCtrl();
	m_pToolTip->Create(this);
	m_pToolTip->AddTool(GetDlgItem(IDC_LOAD_FILE),_T("Load a text file with the data to cluster. See Help for format."));
	m_pToolTip->AddTool(GetDlgItem(IDC_PASTE_DATA),_T("Paste text from the clipboard with the data to cluster. See Help for format."));
	m_pToolTip->AddTool(GetDlgItem(IDC_ITEM_COUNT),_T("Shows the number of data items, each with 2 or more dimensions."));
	m_pToolTip->AddTool(GetDlgItem(IDC_DIM_COUNT),_T("Shows the number of dimensions for each data item."));
	m_pToolTip->AddTool(GetDlgItem(IDC_CALC),_T("Perform Cluster analysis on the loaded data."));
	m_pToolTip->AddTool(GetDlgItem(IDC_PARAMS),_T("Set parameters to optimize clustering."));
	m_pToolTip->AddTool(GetDlgItem(IDC_SUMMARY),_T("Show summary statistics of clusters."));
	m_pToolTip->AddTool(GetDlgItem(IDC_CALC),_T("Perform Cluster analysis on the loaded data."));
	m_pToolTip->AddTool(GetDlgItem(IDC_COPY_DATA),_T("Copy the cluster allocation for each item to the clipboard."));
	m_pToolTip->AddTool(GetDlgItem(IDC_SAVE),_T("Write the cluster allocations to a file. Filename taken from source file if Loaded, 'opN' appended."));
	m_pToolTip->AddTool(GetDlgItem(IDC_NUM_RUNS),_T("Set the number of cluster runs to perform automatically."));
	m_pToolTip->AddTool(GetDlgItem(IDC_RUNS_DONE),_T("Show the number of runs done in this clustering sequence."));
	m_pToolTip->AddTool(GetDlgItem(IDC_TOTAL_RUNS),_T("Show the total number of cluster runs on this data load."));
	m_pToolTip->AddTool(GetDlgItem(IDC_NUM_CLUSTERS),_T("Show the number of clusters found in the data."));
	m_pToolTip->AddTool(GetDlgItem(IDC_SCORE),_T("Show the score (fit metric) for this cluster run."));
	m_pToolTip->AddTool(GetDlgItem(IDC_CLUSTER_LIST),_T("Show a list of the clusters found (1 is noise). Colour applies to cluster selected in this list."));
	m_pToolTip->AddTool(GetDlgItem(IDC_COLOUR),_T("Set colour of cluster selected in list above."));
	m_pToolTip->AddTool(GetDlgItem(IDC_SHOW_BEST),_T("Show the best cluster (highest score) found in clustering run."));
	m_pToolTip->AddTool(GetDlgItem(IDC_CLUSTER_COUNT_LIST),_T("Select best allocations for each number of clusters found in run."));
	m_pToolTip->AddTool(GetDlgItem(IDC_X_AXIS),_T("Select data dimension to show on X axis."));
	m_pToolTip->AddTool(GetDlgItem(IDC_Y_AXIS),_T("Select data dimension to show on Y axis."));
	m_pToolTip->AddTool(GetDlgItem(IDC_Z_AXIS),_T("Select data dimension to show on Z axis."));
	m_pToolTip->AddTool(GetDlgItem(IDC_SYMBOL_SIZE),_T("Set the size of the point symbols in the display (1-9)."));
	m_pToolTip->AddTool(GetDlgItem(IDC_CLEAR_COLOUR),_T("Set the background colour of the display."));
	m_pToolTip->AddTool(GetDlgItem(IDC_PROJECTION_TYPE1),_T("Set projection as orthogonal."));
	m_pToolTip->AddTool(GetDlgItem(IDC_PROJECTION_TYPE2),_T("Set projection as perspective."));
	m_pToolTip->AddTool(GetDlgItem(IDC_ROT_TYPE1),_T("Do not rotate the display."));
	m_pToolTip->AddTool(GetDlgItem(IDC_ROT_TYPE2),_T("Allow the user to rotate the display by dragging with the mouse."));
	m_pToolTip->AddTool(GetDlgItem(IDC_ROT_TYPE3),_T("Autorotate the display about the Y axis."));
	m_pToolTip->AddTool(GetDlgItem(IDC_ROT_TYPE4),_T("Autorotate the display about the X axis."));
	m_pToolTip->AddTool(GetDlgItem(IDC_AUTO_SPEED),_T("Set the relative speed for autorotation. Bigger value means faster."));
	m_pToolTip->AddTool(GetDlgItem(IDC_DEF_VIEW),_T("View from the default orientation."));
	m_pToolTip->AddTool(GetDlgItem(IDC_FRONT_VIEW),_T("View from the front."));
	m_pToolTip->AddTool(GetDlgItem(IDC_SIDE_VIEW),_T("View from the side."));
	m_pToolTip->AddTool(GetDlgItem(IDC_TOP_VIEW),_T("View from the top."));
	m_pToolTip->AddTool(GetDlgItem(IDC_MAKE_VIDEO),_T("Make an avi video of the rotating view."));
	m_pToolTip->AddTool(GetDlgItem(IDC_AUTOSCL_X),_T("Autoscale the X axis to show all data."));
	m_pToolTip->AddTool(GetDlgItem(IDC_AUTOSCL_Y),_T("Autoscale the Y axis to show all data."));
	m_pToolTip->AddTool(GetDlgItem(IDC_AUTOSCL_Z),_T("Autoscale the Z axis to show all data."));
	m_pToolTip->AddTool(GetDlgItem(IDC_X_MIN),_T("Set the minimum X axis scale (disabled if autoscale)."));
	m_pToolTip->AddTool(GetDlgItem(IDC_X_MAX),_T("Set the maximum X axis scale (disabled if autoscale)."));
	m_pToolTip->AddTool(GetDlgItem(IDC_Y_MIN),_T("Set the minimum Y axis scale (disabled if autoscale)."));
	m_pToolTip->AddTool(GetDlgItem(IDC_Y_MAX),_T("Set the maximum Y axis scale (disabled if autoscale)."));
	m_pToolTip->AddTool(GetDlgItem(IDC_Z_MIN),_T("Set the minimum Z axis scale (disabled if autoscale)."));
	m_pToolTip->AddTool(GetDlgItem(IDC_Z_MAX),_T("Set the maximum Z axis scale (disabled if autoscale)."));
	m_pToolTip->AddTool(GetDlgItem(IDC_MAKE_SEL),_T("Select points on the graph by dragging around them."));
	m_pToolTip->AddTool(GetDlgItem(IDC_CANCEL_SEL),_T("Cancel any point selection."));
	m_pToolTip->AddTool(GetDlgItem(IDC_ZOOM_SEL),_T("Zoom the display to show only selected points."));
	m_pToolTip->AddTool(GetDlgItem(ID_HELP),_T("Display on-line help."));
	m_pToolTip->AddTool(GetDlgItem(IDC_COPY),_T("Copy the graph as a bitmap image."));
	m_pToolTip->AddTool(GetDlgItem(IDOK),_T("Close KlustaWin."));
	m_pToolTip->AddTool(GetDlgItem(IDC_SHOW_ABOUT),_T("Show information about KlustaWin."));
//	m_pToolTip->AddTool(GetDlgItem(IDC_CALC),_T("."));

	m_pToolTip->Activate(TRUE);

	if (!m_CommandLineFile.IsEmpty())
		DoOpen(m_CommandLineFile);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CKlustaWinDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CKlustaWinDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CKlustaWinDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


///////////////////////////
void CKlustaWinDlg::OnLoadFile() 
{
	CFileDialog dlg(TRUE,NULL,NULL);
	if (dlg.DoModal()!=IDOK)
		return;

	DoOpen(dlg.GetPathName());
}

void CKlustaWinDlg::OnDropFiles(HDROP hDropInfo) 
{


	TCHAR fName[1000];
	::DragQueryFile(hDropInfo,0,fName,1000);
TRACE("File %s got dropped here\n",fName);

	CDialogEx::OnDropFiles(hDropInfo);

	DoOpen(fName);
}

BOOL CKlustaWinDlg::DoOpen(CString fName)
{
	CString str;
	char line[STRLEN];
	FILE *fp;

	fp = _wfopen(fName, _T("r"));
	if (!fp) 
	{
		CString msg(_T("Couldn't open file: "));
		msg+=fName;
		AfxMessageBox(msg,MB_ICONWARNING);
		return FALSE;
	}

	fgets(line, STRLEN, fp);	// read first line to check whether partition
	fseek(fp, 0, SEEK_SET);		// put back first line
	if (strcmp(line,"Klustawin output\n")==0)
	{
		if (m_ItemCount==0)
		{
			AfxMessageBox(_T("ERROR: You must load a data file before loading a partition file"),MB_ICONWARNING);
			return FALSE;
		}
		return LoadPartition(fp);
	}

// must be data file
	m_FileName=fName;
	return LoadData(fp);
}

void CKlustaWinDlg::SetGraphData()
{
	m_XAxisDataID=m_cXAxisSpin.GetPos()-1;
	m_YAxisDataID=m_cYAxisSpin.GetPos()-1;
	m_ZAxisDataID=m_cZAxisSpin.GetPos()-1;

	ASSERT(m_XAxisDataID>=0 && m_XAxisDataID<m_DimCount);
	ASSERT(m_YAxisDataID>=0 && m_YAxisDataID<m_DimCount);
	ASSERT(m_ZAxisDataID>=0 && m_ZAxisDataID<m_DimCount);

	int i;
	for (i=0; i<m_ItemCount; i++)
	{
// parent data organisation is m_ppData[Dim][Item]
		m_pData[i*3+0]=m_ppData[m_XAxisDataID][i];
		m_pData[i*3+1]=m_ppData[m_YAxisDataID][i];
		m_pData[i*3+2]=m_ppData[m_ZAxisDataID][i];
	}

	m_pGraphWnd->SetData(m_ItemCount,RGB(128,0,0),m_pData,m_pColList);
	m_pGraphWnd->InvalidateRect(NULL);
	OnAutosclX();
	OnAutosclY();
	OnAutosclZ();
}

// Original, uses CCluster
void CKlustaWinDlg::OnCalc() 
{
	int i;
	//count,score,bestNumClusters,recentScore,recentNumClassesFound;
	CString str;
	float recentScore;
	BOOL bGotEntry;
	CClusterDetails *pClusterDetails;

	if (m_ItemCount==0)
		return;

	if (!UpdateData())	// pick up NumRuns
		return;
	ASSERT(m_bLogFile==!m_LogFileName.IsEmpty());	// should be empty if not saving log

	CWaitCursor cur;
	m_RunsDone=0;
	UpdateData(FALSE);

	CCluster cluster;

// at end of runs, leave screen showing best output (different from previous version, where just showed latest run)
	while (m_RunsDone<m_NumRuns)
	{
#ifdef _DEBUG
		cluster.m_nSplitError=0;
#endif

		m_NumClassesFound=cluster.DoPartition(m_ppData,m_ItemCount,m_DimCount,m_pClassID,m_LogFileName,recentScore);
#ifdef _DEBUG
		TRACE("Split error count = %d\n",cluster.m_nSplitError);
#endif

#if 0
	int xx;
	for (xx=0; xx<m_ItemCount; xx++)
		TRACE("item %d, id = %d\n",xx,m_pClassID[xx]);
#endif

		m_MaxClassFound=max(m_MaxClassFound,m_NumClassesFound);

		ASSERT(m_NumClassesFound>0);

		m_Score=int(-recentScore);
		m_RunsDone++;
		m_TotalRuns++;
		UpdateData(FALSE);	// so that m_RunsDone doesn't get reset during SetGraphData(), which calls UpdateData()

		SetClusterCols();

		if (m_NumClassesFound>12)
			AfxMessageBox(_T("Found more than 12 classes, some classes will share colours. Check with list box."));

		SetGraphData();

// store cluster details if either new cluster number, or best of type
		bGotEntry=m_ClusterDetailsMap.Lookup(m_NumClassesFound,pClusterDetails);
		if (bGotEntry==FALSE)
		{
			pClusterDetails=new CClusterDetails(m_NumClassesFound,-recentScore,m_ItemCount,m_pClassID);
			m_ClusterDetailsMap.SetAt(m_NumClassesFound,pClusterDetails);
		}
		else
		{
			ASSERT(pClusterDetails->m_NumClusters==m_NumClassesFound);
			pClusterDetails->m_NumOccurrences++;
			pClusterDetails->m_SumScore+=(-recentScore);
			if ((-recentScore)>pClusterDetails->m_BestScore)
			{
				pClusterDetails->m_BestScore=-recentScore;
				for (i=0; i<m_ItemCount; i++)
					pClusterDetails->m_pList[i]=m_pClassID[i];
			}
		}


#if 0
// keep track of how many times this number of clusters has been found
		bGotEntry=m_NumClustersCountMap.Lookup(m_NumClassesFound,count);
		if (bGotEntry==FALSE)
		{
			count=1;
			m_NumClustersCountMap.SetAt(m_NumClassesFound,count);
			sumScore=m_Score;
			m_SumScoreMap.SetAt(m_NumClassesFound,sumScore);
		}
		else
		{
			count++;
			m_NumClustersCountMap.SetAt(m_NumClassesFound,count);
			VERIFY(m_SumScoreMap.Lookup(m_NumClassesFound,sumScore));
			sumScore+=m_Score;
			m_SumScoreMap.SetAt(m_NumClassesFound,sumScore);
		}

// save best scores for each cluster number found
		if (m_bSaveBest)
		{
// check previous best score, if any, for this number of clusters
			bGotEntry=m_ScoreMap.Lookup(m_NumClassesFound,score);
			if (bGotEntry==FALSE || m_Score>score)
			{
// no previous score for this number of clusters, or this one better
				m_ScoreMap.SetAt(m_NumClassesFound,m_Score);

// save best op file for this number of clusters
				CString outName=m_FileName;
				CString op="_Best";
				CString numClass;
				numClass.Format("_%d_classes",m_NumClassesFound);
				op+=numClass;
				i=m_FileName.ReverseFind('.');
				if (i==-1)	// no extension
					outName+=op;
				else
				{
					outName=m_FileName.Left(i);
					outName+=op;
					outName+=m_FileName.Right(m_FileName.GetLength()-i);
				}
				TRY
				{
					CStdioFile F(outName,CFile::modeCreate|CFile::modeWrite|CFile::typeText);
					F.WriteString("Klustawin output\n");
					str.Format("Number of classes found = %d\n", m_NumClassesFound);	// number of classes found
					F.WriteString(str);
					str.Format("Score = %d\n",m_Score);
					F.WriteString(str);
					for (i=0; i<m_ItemCount; i++)
					{
#if SAVE_CLASS_ID
// this saves just the partition number
// NORMAL OUTPUT
						str.Format("%d\n", m_pClassID[i]);	// which class item p belongs to 
#else
// this saves 1st 3 dimensions plus colour
// JUST FOR PROVIDING SOURCE FOR SCATTERPLOT
						str.Format("%f\t%f\t%f\t%d\n",m_ppData[0][i],
							m_ppData[1][i],m_ppData[2][i],m_pColList[i]);
#endif
						F.WriteString(str);
					}

					F.Close();
				}
				CATCH( CFileException, e )
				{
				   #ifdef _DEBUG
					  afxDump << "File could not be opened "
							  << e->m_cause << "\n";
				   #endif
				}
				END_CATCH
			}
		}

//		if (m_Score>m_BestScore)
//		{
//			m_BestScore=m_Score;
//			m_BestNumClusters=m_NumClassesFound;
//		}
#endif
		
		UpdateData(FALSE);
		UpdateWindow();
	}

// store most recent in map
	if (m_ClusterDetailsMap.Lookup(0,pClusterDetails))	// already got a most recent, delete
	{
		m_ClusterDetailsMap.RemoveKey(0);
		delete pClusterDetails;
	}
	pClusterDetails=new CClusterDetails(m_NumClassesFound,-recentScore,m_ItemCount,m_pClassID);
	m_ClusterDetailsMap.SetAt(0,pClusterDetails);


#if 0
	if (m_bSaveBest)
	{
// save/update summary file
		CString outName=m_FileName;
		CString op="_Summary";
		i=m_FileName.ReverseFind('.');
		if (i==-1)	// no extension
			outName+=op;
		else
		{
			outName=m_FileName.Left(i);
			outName+=op;
			outName+=m_FileName.Right(m_FileName.GetLength()-i);
		}
		TRY
		{
			CStdioFile F(outName,CFile::modeCreate|CFile::modeWrite|CFile::typeText);
			F.WriteString("Klustawin summary\n");
			str.Format("In %d runs\n", m_TotalRuns);	// number of classes found
			F.WriteString(str);
			for (i=0; i<=m_MaxClassFound; i++)
			{
				bGotEntry=m_NumClustersCountMap.Lookup(i,count);
				if (bGotEntry==FALSE)	// never found i classes
					continue;
				int score;
				VERIFY(m_ScoreMap.Lookup(i,score));
				VERIFY(m_SumScoreMap.Lookup(i,sumScore));
				str.Format("Found %d clusters %d times, with a maximum score of %d, and an average score of %f\n",i,count,score,sumScore/count);
				F.WriteString(str);
			}
			F.Close();
		}
		CATCH( CFileException, e )
		{
		   #ifdef _DEBUG
			  afxDump << "File could not be opened "
					  << e->m_cause << "\n";
		   #endif
		}
		END_CATCH
	}
#endif

// setup the list of numbers of clusters found
//	bestScore=0.;
//	bestNumClusters=0;
	m_cClusterCountList.ResetContent();
	m_cClusterCountList.AddString(_T("recent"));
	m_cClusterCountList.SetItemData(0,0);

	for (i=1; i<CCluster::s_MaxPossibleClusters; i++)
	{
		bGotEntry=m_ClusterDetailsMap.Lookup(i,pClusterDetails);
		if (bGotEntry)
		{
			ASSERT(i==0 || i==pClusterDetails->m_NumClusters);	// key 0 is most recent
			TRACE("num clusters = %d, best score = %f, num occurrences = %d, avg score = %f\n",pClusterDetails->m_NumClusters,
				pClusterDetails->m_BestScore,pClusterDetails->m_NumOccurrences,pClusterDetails->m_SumScore/pClusterDetails->m_NumOccurrences);
//			if (pClusterDetails->m_BestScore>bestScore)
//			{
//				bestScore=pClusterDetails->m_BestScore;
//				bestNumClusters=i;
//			}
			str.Format(_T("%d: %d"),i,int(pClusterDetails->m_BestScore));
			m_cClusterCountList.AddString(str);
//			int xxx=m_cClusterCountList.GetCount();
			m_cClusterCountList.SetItemData(m_cClusterCountList.GetCount()-1,i);
		}
	}
	m_cClusterCountList.SetCurSel(0);


#if 0
	m_ClusterDetailsMap.Lookup(bestNumClusters,pClusterDetails);
	m_Score=pClusterDetails->m_BestScore;
	m_NumClassesFound=bestNumClusters;
	UpdateData(FALSE);
	for (i=0; i<m_ItemCount; i++)
		m_pClassID[i]=pClusterDetails->m_pList[i];

	SetClusterCols();
#endif

/////////
	GetDlgItem(IDC_SAVE)->EnableWindow();
	GetDlgItem(IDC_COPY_DATA)->EnableWindow();
	GetDlgItem(IDC_SUMMARY)->EnableWindow();
	GetDlgItem(IDC_SHOW_BEST)->EnableWindow();
	m_cClusterList.ResetContent();
	m_cClusterList.AddString(_T("noise: 1"));
	for (i=1; i<m_NumClassesFound; i++)
	{
		str.Format(_T("class: %d"),i+1);
		m_cClusterList.AddString(str);
	}
	m_cClusterList.SetCurSel(0);
	UpdateData();
}



void CKlustaWinDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialogEx::OnSize(nType, cx, cy);
	
	if (m_bGraphCreated==FALSE)		// OnSize is first called before Buttons created??
		return;
	CRect R;
    GetDlgItem(IDC_GRAPH_TOPLEFT)->GetWindowRect(R);		// get dimensions of Button
    ScreenToClient(R);
//    R.left=R.right+10;
//    R.top=10;
    R.right=cx-10;
    R.bottom=cy-10;
    m_pGraphWnd->MoveWindow(R);
	
}

void CKlustaWinDlg::OnKillfocusSymbolSize() 
{
	int oldS=m_SymbolSize;
	if (!UpdateData())
		return;
	else
		if (oldS!=m_SymbolSize)
		{
			m_pGraphWnd->SetSymbolSize(m_SymbolSize);
			m_pGraphWnd->InvalidateRect(NULL);
		}
}

#if 0
void CKlustaWinDlg::OnSelendokXAxis() 
{
	UpdateData();
	SetGraphData();
}

void CKlustaWinDlg::OnSelendokYAxis() 
{
	UpdateData();
	SetGraphData();
}

void CKlustaWinDlg::OnSelendokZAxis() 
{
	UpdateData();
	SetGraphData();
}
#endif

void CKlustaWinDlg::OnMakeSel() 
{
	m_pGraphWnd->StartMakeSel();
	m_OldRotType=m_RotationType;
	m_RotationType=0;
	UpdateData(FALSE);
	GetDlgItem(IDC_ROT_TYPE1)->EnableWindow(FALSE);
	GetDlgItem(IDC_ROT_TYPE2)->EnableWindow(FALSE);
	GetDlgItem(IDC_ROT_TYPE3)->EnableWindow(FALSE);
	GetDlgItem(IDC_ROT_TYPE4)->EnableWindow(FALSE);
}

void CKlustaWinDlg::OnCancelSel() 
{
	m_pGraphWnd->CancelSel();
	m_RotationType=m_OldRotType;
	UpdateData(FALSE);
	GetDlgItem(IDC_ROT_TYPE1)->EnableWindow();
	GetDlgItem(IDC_ROT_TYPE2)->EnableWindow();
	GetDlgItem(IDC_ROT_TYPE3)->EnableWindow();
	GetDlgItem(IDC_ROT_TYPE4)->EnableWindow();
}

void CKlustaWinDlg::OnZoomSel() 
{
	m_pGraphWnd->ZoomSel();
	m_bAutoSclX=m_bAutoSclY=m_bAutoSclZ=FALSE;
	OnCancelSel();
	m_MaxX=m_pGraphWnd->GetMaxX();
	m_MinX=m_pGraphWnd->GetMinX();
	m_MaxY=m_pGraphWnd->GetMaxY();
	m_MinY=m_pGraphWnd->GetMinY();
	m_MaxZ=m_pGraphWnd->GetMaxZ();
	m_MinZ=m_pGraphWnd->GetMinZ();
	UpdateData(FALSE);
	((CEdit *)GetDlgItem(IDC_X_MIN))->SetReadOnly(m_bAutoSclX);
	((CEdit *)GetDlgItem(IDC_X_MAX))->SetReadOnly(m_bAutoSclX);
	((CEdit *)GetDlgItem(IDC_Y_MIN))->SetReadOnly(m_bAutoSclY);
	((CEdit *)GetDlgItem(IDC_Y_MAX))->SetReadOnly(m_bAutoSclY);
	((CEdit *)GetDlgItem(IDC_Z_MIN))->SetReadOnly(m_bAutoSclZ);
	((CEdit *)GetDlgItem(IDC_Z_MAX))->SetReadOnly(m_bAutoSclZ);
}

void CKlustaWinDlg::OnParams() 
{
	CClusterParams dlg;	
	dlg.m_DistThresh = CCluster::s_DistThresh;
	dlg.m_FullStepEvery = CCluster::s_FullStepEvery;
	dlg.m_ChangedThresh = CCluster::s_ChangedThresh;
	dlg.m_MaxIter = CCluster::s_MaxIter;
	dlg.m_MinClusters = CCluster::s_MinClusters;
	dlg.m_MaxClusters = CCluster::s_MaxClusters;
	dlg.m_MaxClusters = CCluster::s_MaxClusters;
	dlg.m_BIC_AIC = CCluster::s_PenaltyMix;
	dlg.m_MaxPossibleClusters = CCluster::s_MaxPossibleClusters;
	dlg.m_SplitEvery = CCluster::s_SplitEvery;
//	dlg.m_Starts = CCluster::s_NumStarts;


	if (dlg.DoModal()!=IDOK)
		return;

	if (dlg.m_RandSeed==0)
		srand( (unsigned)time( NULL ) );
	else
		srand(1);


	CCluster::s_DistThresh=dlg.m_DistThresh;
	CCluster::s_FullStepEvery=dlg.m_FullStepEvery;
	CCluster::s_ChangedThresh=dlg.m_ChangedThresh;
	CCluster::s_MaxIter=dlg.m_MaxIter;
	CCluster::s_MinClusters=dlg.m_MinClusters;
	CCluster::s_MaxClusters=dlg.m_MaxClusters;
	CCluster::s_MaxClusters=dlg.m_MaxClusters;
	CCluster::s_PenaltyMix=dlg.m_BIC_AIC;
	CCluster::s_MaxPossibleClusters=dlg.m_MaxPossibleClusters;
	CCluster::s_SplitEvery=dlg.m_SplitEvery;
//	CCluster::s_NumStarts=dlg.m_Starts;
}

void CKlustaWinDlg::OnSave() 
{
	if (!UpdateData())
		return;

	if (m_FileName=="")	// came from paste
	{
		CFileDialog dlg(FALSE,_T("txt"),NULL,OFN_HIDEREADONLY,
			_T("text (.txt)|*.txt|all files|*.*||"));
		if (dlg.DoModal()!=IDOK)
			return;
		m_FileName=dlg.GetPathName();
	}
	int i;
	CString outName=m_FileName;
	CString op;

	if (m_ClusterCountList==0)	// save most recent
	{
		op.Format(_T("_op%d"),m_SaveNum++);
		i=m_FileName.ReverseFind('.');
		if (i==-1)	// no extension
			outName+=op;
		else
		{
			outName=m_FileName.Left(i);
			outName+=op;
			outName+=m_FileName.Right(m_FileName.GetLength()-i);
		}

		TRY
		{
			CStdioFile F(outName,CFile::modeCreate|CFile::modeWrite|CFile::typeText);
			F.WriteString(_T("Klustawin output\n"));
			CString str;
			str.Format(_T("Number of classes found = %d\n"), m_NumClassesFound);	// number of classes found
			F.WriteString(str);
			str.Format(_T("Score = %d\n"),m_Score);
			F.WriteString(str);
			for (i=0; i<m_ItemCount; i++)
			{
	#if SAVE_CLASS_ID
	// this saves just the partition number
				str.Format(_T("%d\n"), m_pClassID[i]);	// which class item p belongs to 
	#else
	// this saves 1st 3 dimensions plus colour
				str.Format(_T("%f\t%f\t%f\t%d\n"),m_ppData[0][i],
					m_ppData[1][i],m_ppData[2][i],m_pColList[i]);
	#endif
				F.WriteString(str);
			}

			F.Close();
		}
		CATCH( CFileException, e )
		{
		   #ifdef _DEBUG
			  afxDump << "File could not be opened "
					  << e->m_cause << "\n";
		   #endif
		}
		END_CATCH
	}
	else
	{
		CClusterDetails *pClusterDetails;
		UpdateData();
		int clusterCount=m_cClusterCountList.GetItemData(m_ClusterCountList);
		m_ClusterDetailsMap.Lookup(clusterCount,pClusterDetails);

// save best op file for this number of clusters
		op="_Best";
		CString numClass;
		numClass.Format(_T("_%d_classes"),pClusterDetails->m_NumClusters);
		op+=numClass;
		i=m_FileName.ReverseFind('.');
		if (i==-1)	// no extension
			outName+=op;
		else
		{
			outName=m_FileName.Left(i);
			outName+=op;
			outName+=m_FileName.Right(m_FileName.GetLength()-i);
		}
		TRY
		{
			CStdioFile F(outName,CFile::modeCreate|CFile::modeWrite|CFile::typeText);
			F.WriteString(_T("Klustawin output\n"));
			op.Format(_T("Number of classes found = %d\n"), pClusterDetails->m_NumClusters);	// number of classes found
			F.WriteString(op);
			op.Format(_T("Score = %f\n"),pClusterDetails->m_BestScore);
			F.WriteString(op);
			for (i=0; i<m_ItemCount; i++)
			{
#if SAVE_CLASS_ID
// this saves just the partition number
// NORMAL OUTPUT
				op.Format(_T("%d\n"), pClusterDetails->m_pList[i]);	// which class item p belongs to 
#else
// this saves 1st 3 dimensions plus colour
// JUST FOR PROVIDING SOURCE FOR SCATTERPLOT
				op.Format(_T("%f\t%f\t%f\t%d\n"),m_ppData[0][i],
					m_ppData[1][i],m_ppData[2][i],m_pColList[i]);
#endif
				F.WriteString(op);
			}

			F.Close();
		}
		CATCH( CFileException, e )
		{
		   #ifdef _DEBUG
			  afxDump << "File could not be opened "
					  << e->m_cause << "\n";
		   #endif
		}
		END_CATCH
	}
}

void CKlustaWinDlg::OnColour() 
{
	int i;
	CColorDialog dlg;
	if (dlg.DoModal()!=IDOK)
		return;

	m_pClusterCols[m_ClusterList]=dlg.GetColor();	// for drawing button
	GetDlgItem(IDC_COLOUR)->Invalidate();

	for (i=0; i<m_ItemCount; i++)
		m_pColList[i]=m_pClusterCols[m_pClassID[i]-1];
	SetGraphData();	// will update col list
}

void CKlustaWinDlg::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	if (nIDCtl ==IDC_COLOUR ||nIDCtl ==IDC_CLEAR_COLOUR )
	{
		if (lpDrawItemStruct->itemAction & ODA_DRAWENTIRE)
		{
			HBRUSH hBrush;
			if (nIDCtl ==IDC_COLOUR)
				hBrush=::CreateSolidBrush(m_pClusterCols[m_ClusterList]);
			else
			{
				ASSERT(nIDCtl ==IDC_CLEAR_COLOUR);
				hBrush=::CreateSolidBrush(m_ClearCol);
			}
	
			::FillRect(lpDrawItemStruct->hDC,&(lpDrawItemStruct->rcItem),
				hBrush);
			::DeleteObject(hBrush);
		}
		else if (lpDrawItemStruct->itemAction & ODA_FOCUS)
		{
			RECT focusR=lpDrawItemStruct->rcItem;
			focusR.top+=2;
			focusR.bottom-=2;
			focusR.left+=2;
			focusR.right-=2;
			::DrawFocusRect(lpDrawItemStruct->hDC,&focusR);
		}
	return;		// eat it		
	}		
	
	CDialogEx::OnDrawItem(nIDCtl, lpDrawItemStruct);
}

void CKlustaWinDlg::OnSelendokClusterList() 
{
	UpdateData();
	GetDlgItem(IDC_COLOUR)->Invalidate();
}


void CKlustaWinDlg::OnProjectionType1() 
{
	UpdateData();
	m_pGraphWnd->SetProjection(m_ProjType);
	m_pGraphWnd->Invalidate(FALSE);
}

void CKlustaWinDlg::OnProjectionType2() 
{
	UpdateData();
	m_pGraphWnd->SetProjection(m_ProjType);
	m_pGraphWnd->Invalidate(FALSE);
}

void CKlustaWinDlg::OnAutosclX() 
{
	UpdateData();
	m_pGraphWnd->SetAutoScaleX(m_bAutoSclX);
	m_MaxX=m_pGraphWnd->GetMaxX();
	m_MinX=m_pGraphWnd->GetMinX();
	UpdateData(FALSE);
	((CEdit *)GetDlgItem(IDC_X_MIN))->SetReadOnly(m_bAutoSclX);
	((CEdit *)GetDlgItem(IDC_X_MAX))->SetReadOnly(m_bAutoSclX);
}

void CKlustaWinDlg::OnAutosclY() 
{
	UpdateData();
	m_pGraphWnd->SetAutoScaleY(m_bAutoSclY);
	m_MaxY=m_pGraphWnd->GetMaxY();
	m_MinY=m_pGraphWnd->GetMinY();
	UpdateData(FALSE);
	((CEdit *)GetDlgItem(IDC_Y_MIN))->SetReadOnly(m_bAutoSclY);
	((CEdit *)GetDlgItem(IDC_Y_MAX))->SetReadOnly(m_bAutoSclY);
}

void CKlustaWinDlg::OnAutosclZ() 
{
	UpdateData();
	m_pGraphWnd->SetAutoScaleZ(m_bAutoSclZ);
	m_MaxZ=m_pGraphWnd->GetMaxZ();
	m_MinZ=m_pGraphWnd->GetMinZ();
	UpdateData(FALSE);
	((CEdit *)GetDlgItem(IDC_Z_MIN))->SetReadOnly(m_bAutoSclZ);
	((CEdit *)GetDlgItem(IDC_Z_MAX))->SetReadOnly(m_bAutoSclZ);
}

void CKlustaWinDlg::OnCopy() 
{
	m_pGraphWnd->CopyToClipboard();
}

void CKlustaWinDlg::OnRotType1() 
{
	UpdateData();
	m_pGraphWnd->SetRotationType(0);
}

void CKlustaWinDlg::OnRotType2() 
{
	UpdateData();
	m_pGraphWnd->SetRotationType(1);
}

void CKlustaWinDlg::OnRotType3() 
{
	UpdateData();
	m_pGraphWnd->SetRotationType(2);
}

void CKlustaWinDlg::OnRotType4() 
{
	UpdateData();
	m_pGraphWnd->SetRotationType(3);
}

void CKlustaWinDlg::OnKillfocusXMax() 
{
	UpdateData();
	m_pGraphWnd->SetMaxX(m_MaxX);
}

void CKlustaWinDlg::OnKillfocusXMin() 
{
	UpdateData();
	m_pGraphWnd->SetMinX(m_MinX);
}

void CKlustaWinDlg::OnKillfocusYMax() 
{
	UpdateData();
	m_pGraphWnd->SetMaxY(m_MaxY);
}

void CKlustaWinDlg::OnKillfocusYMin() 
{
	UpdateData();
	m_pGraphWnd->SetMinY(m_MinY);
}

void CKlustaWinDlg::OnKillfocusZMax() 
{
	UpdateData();
	m_pGraphWnd->SetMaxZ(m_MaxZ);
}

void CKlustaWinDlg::OnKillfocusZMin() 
{
	UpdateData();
	m_pGraphWnd->SetMinZ(m_MinZ);
}

void CKlustaWinDlg::OnClearColour() 
{
	CColorDialog dlg;
	if (dlg.DoModal()!=IDOK)
		return;

	m_ClearCol=dlg.GetColor();	// for drawing button
	GetDlgItem(IDC_CLEAR_COLOUR)->Invalidate();

	m_pGraphWnd->SetClearCol(m_ClearCol);
}

void CKlustaWinDlg::OnKillfocusAutoSpeed() 
{
	if (UpdateData())
		m_pGraphWnd->SetAutorotateAngle(-m_AutoRotateSpeed);	// -ve angle goes right way round
}

void CKlustaWinDlg::OnDefView() 
{
	m_pGraphWnd->SetRotate(10,-15);
	m_pGraphWnd->Invalidate();
}

void CKlustaWinDlg::OnFrontView() 
{
	m_pGraphWnd->SetRotate(0,0);
	m_pGraphWnd->Invalidate();
}

void CKlustaWinDlg::OnSideView() 
{
	m_pGraphWnd->SetRotate(0,-90);
	m_pGraphWnd->Invalidate();
}

void CKlustaWinDlg::OnTopView() 
{
	m_pGraphWnd->SetRotate(90,0);
	m_pGraphWnd->Invalidate();
}


void CKlustaWinDlg::OnLogFile() // clicked LogFile check box
{
	UpdateData();
	UpdateLogFileName();
}

void CKlustaWinDlg::UpdateLogFileName()
{
	int i;
	if (m_bLogFile)
	{
		if (m_FileName=="")	// came from paste
		{
			CFileDialog dlg(FALSE,_T("txt"),NULL,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
				_T("text (.txt)|*.txt|all files|*.*||"));
			if (dlg.DoModal()!=IDOK)
				return;
			m_FileName=dlg.GetPathName();
		}
// append _log to filename, then stick ext back on
		m_LogFileName=m_FileName;
		CString op=_T("_log");
		i=m_FileName.ReverseFind('.');
		if (i==-1)	// no extension
			m_LogFileName+=op;
		else
		{
			m_LogFileName=m_FileName.Left(i);
			m_LogFileName+=op;
			m_LogFileName+=m_FileName.Right(m_FileName.GetLength()-i);
		}
	TRACE("Log filename = %s\n",m_LogFileName);
	// test whether log file already exists
		CFileStatus status;
		if(CFile::GetStatus(m_LogFileName,status))   // static function
		{
			i=AfxMessageBox(_T("Log file already exists. Delete (Yes), Append (No) or Cancel writing to log?"),MB_YESNOCANCEL|MB_ICONQUESTION);
			if (i==IDYES)
			{
				CFile::Remove(m_LogFileName);
			}
			else if (i==IDCANCEL)
			{
				m_bLogFile=FALSE;
				UpdateData(FALSE);
			}
		}
	}
	else
		m_LogFileName.Empty();
}

BOOL CKlustaWinDlg::LoadData(FILE *fp)
{
	int i,j,rv,readCount;
	CString str,errStr;
	char line[STRLEN];
	COLORREF old1;
	
	ResetOutput();

// find lines with text in them, and skip
	int linesToSkip=0;
	errStr.Empty();
	BOOL skipLine;
	do
	{
		skipLine=FALSE;
		fgets(line, STRLEN, fp);
		for (i=0; i<strlen(line); i++)
		{
			if (!IsNumberOrSpace(line[i]))
			{
				skipLine=TRUE;
				linesToSkip++;
				break;
			}
		}
	} while (skipLine==TRUE);

// line now holds text which is entirely decimal numbers + whitespace 
// should be first line of data

	m_ItemCount=1;
// count dimensions (number of floats in line)
	BOOL bInFlt=FALSE;
	m_DimCount=0;
	for (i=0; i<int(strlen(line)); i++)
	{
		if (isspace(line[i]))
		{
			if (bInFlt)
			{
				bInFlt=FALSE;
				m_DimCount++;
			}
		}
		else
			bInFlt=TRUE;
	}
// find number of items	
	while (fgets(line, STRLEN, fp))
		m_ItemCount++;

// rewind file
	fseek(fp, 0, SEEK_SET);
// skip header lines
	for (i=0; i<linesToSkip; i++)
		fgets(line, STRLEN, fp);

	int m_PointCount=m_ItemCount*m_DimCount;
	if (m_PointCount<4)
	{
		errStr="ERROR: Less than 4 data items read from file.";
		goto abandon;
	}

	m_ppData=(float **) new float[m_DimCount];
	for (i=0; i<m_DimCount; i++)
		m_ppData[i]=(float *) new float[m_ItemCount];

	// load data
	readCount=0;
	float x;
	for (i=0; i<m_ItemCount; i++) 
	{
		for (j=0; j<m_DimCount; j++)
		{
			rv = fscanf(fp, "%f", &x);
			if (rv!=1)
			{
				errStr=_T("Error reading feature file, too few numbers, or non-number in file");
				goto abandon;
			}
			m_ppData[j][i]=x;
			readCount++;
		}
	}

	float dummy;
	while (((rv=fscanf(fp, "%f", &dummy))==1))
		readCount++;

	if (readCount!=m_PointCount)
	{
		errStr.Format(_T("Error: expected to read %d * %d = %d numbers, read %d instead"),m_DimCount,m_ItemCount,readCount);
		goto abandon;
	}

	fclose(fp);
	
	TRACE("Loaded %d data points of dimension %d.\n", m_ItemCount, m_DimCount);
#ifdef _DEBUG
	for (i=0; i<10; i++)
	{
		TRACE("item %d\t",i);
		for (j=0; j<m_DimCount; j++)
			TRACE("dim%d = %f\t",j,m_ppData[j][i]);
		TRACE("\n");
	}
#endif

// m_pClassID will hold integer value representing which cluster item belongs to
	m_pClassID=new int[m_ItemCount];	
	for (i=0; i<m_ItemCount; i++)
		m_pClassID[i]=1;

// update axis combo selection 
	m_cXAxisSpin.SetRange(1,m_DimCount);
	m_cYAxisSpin.SetRange(1,m_DimCount);
	m_cZAxisSpin.SetRange(1,m_DimCount);

	m_cXAxisSpin.SetPos(1);
	m_cYAxisSpin.SetPos((m_DimCount>1)?2:1);
	m_cZAxisSpin.SetPos((m_DimCount>2?3:((m_DimCount>1)?2:1)));

#if 0
	m_cYDataType.ResetContent();
	m_cXDataType.ResetContent();
	m_cZDataType.ResetContent();
	for (i=0; i<m_DimCount; i++)
	{
		str.Format("Dim %d",i+1);
		m_cYDataType.AddString(str);
		m_cXDataType.AddString(str);
		m_cZDataType.AddString(str);
	}
	m_XAxisDataID=0;
	m_YAxisDataID=((m_DimCount>1)?1:0);
	m_ZAxisDataID=((m_DimCount>2?2:((m_DimCount>1)?1:0)));
#endif

	GetDlgItem(IDC_CALC)->EnableWindow();
	GetDlgItem(IDC_PARAMS)->EnableWindow();
	UpdateData(FALSE);

	old1=m_pClusterCols[0];
	ASSERT(m_pClusterCols!=NULL);
	delete [] m_pClusterCols;
	m_pClusterCols=new COLORREF[1];
	m_pClusterCols[0]=old1;
	
	m_pColList=new COLORREF[m_ItemCount];
	for (i=0; i<m_ItemCount; i++)
		m_pColList[i]=m_pClusterCols[0];

	m_pData=new float[m_ItemCount*3];

	SetGraphData();

	m_cClusterList.ResetContent();
	m_cClusterList.AddString(_T("raw"));
	m_cClusterList.SetCurSel(0);
	UpdateData();


// do Log File stuff
	UpdateLogFileName();

	return TRUE;

abandon:
	AfxMessageBox(errStr);
	for (i=0; i<m_DimCount; i++)
		delete [] m_ppData[i];
	delete m_ppData;
	m_ppData=NULL;
	fclose(fp);
	m_ItemCount=0;
	m_pGraphWnd->SetData(0,RGB(128,0,0),m_pData,m_pColList);
	m_pGraphWnd->InvalidateRect(NULL);
	m_FileName.Empty();
	return FALSE;

}

BOOL CKlustaWinDlg::LoadPartition(FILE *fp)
{
	CClusterDetails *pCD;
	char line[STRLEN];
	int i,which,numClass,score;
	CString str;
	COLORREF old1;

	fgets(line, STRLEN, fp);
	ASSERT(strcmp(line,"Klustawin output\n")==0);	// should have been checked already
	fgets(line, STRLEN, fp);
	if (sscanf(line,"Number of classes found = %d",&numClass)!=1)
		goto abandon;
	fgets(line, STRLEN, fp);
	if (sscanf(line,"Score = %d",&score)!=1)
		goto abandon;

// check at least item count entries
	for (i=0; i<m_ItemCount; i++)
	{
		if (fscanf(fp, "%d", &which)!=1)
			goto abandon;
	}

// if got here seems OK format
// rewind file
	fseek(fp, 0, SEEK_SET);
// skip header lines
	for (i=0; i<3; i++)
		fgets(line, STRLEN, fp);

	m_Score=m_BestScore=score;
	m_NumClassesFound=numClass;

	for (i=0; i<m_ItemCount; i++)
		fscanf(fp, "%d", m_pClassID+i);

	old1=m_pClusterCols[0];
	ASSERT(m_pClusterCols!=NULL);
	delete [] m_pClusterCols;
	m_pClusterCols=new COLORREF[m_NumClassesFound];
	m_pClusterCols[0]=old1;
	for (i=1; i<m_NumClassesFound; i++)		// already got noise class colour
		m_pClusterCols[i]=m_DefClassCol[i%12];

	if (m_pColList!=NULL)
		delete [] m_pColList;
	m_pColList=new COLORREF[m_ItemCount];
	for (i=0; i<m_ItemCount; i++)
		m_pColList[i]=m_pClusterCols[m_pClassID[i]-1];

	if (m_NumClassesFound>12)
		AfxMessageBox(_T("Found >12 classes, some classes will share colours. Check with list box."));

	UpdateData(FALSE);
	SetGraphData();

	UpdateWindow();

	m_cClusterList.ResetContent();
	m_cClusterList.AddString(_T("noise: 1"));
	for (i=1; i<m_NumClassesFound; i++)
	{
		str.Format(_T("class: %d"),i+1);
		m_cClusterList.AddString(str);
	}
	m_cClusterList.SetCurSel(0);

// add "loaded" to clusterCountList
	pCD=new CClusterDetails(m_NumClassesFound,score,m_ItemCount,m_pClassID);
	m_ClusterDetailsMap.SetAt(-1,pCD);
	m_cClusterCountList.AddString(_T("loaded"));
	m_cClusterCountList.SetItemData(m_cClusterCountList.GetCount()-1,-1);


	m_cClusterCountList.SetCurSel(0);

	fclose(fp);
	return TRUE;
abandon:
	fclose(fp);
	AfxMessageBox(_T("ERROR: couldn't read import file format"));
	return FALSE;
}

void CKlustaWinDlg::OnShowAbout() 
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

void CKlustaWinDlg::OnMakeVideo() 
{
	CVideoProps dlg;
	if (dlg.DoModal()!=IDOK)
		return;

	// filename is obtained in CConstructVideo::Create(...)
	m_pGraphWnd->MakeAVI(dlg.m_FramesPerSecond,dlg.m_FramesPerCircle,dlg.m_RotationType);
}

void CKlustaWinDlg::OnPasteData() 
{
	m_FileName.Empty();

	CString strData;
	COleDataObject Obj;
	if (!Obj.AttachClipboard())
	{
		AfxMessageBox(_T("Couldn't attach clipboard"));
		return;
	}
	if (Obj.IsDataAvailable(CF_TEXT))
	{
		STGMEDIUM stg;
		FORMATETC fmt;
		fmt.cfFormat=CF_TEXT;
		fmt.dwAspect=DVASPECT_CONTENT;
		fmt.lindex=-1;
		fmt.ptd=NULL;
		fmt.tymed=TYMED_HGLOBAL;
		if (!Obj.GetData(CF_TEXT,&stg,&fmt))
			AfxMessageBox(_T("COleDataObject::GetData failed in Paste operation"));
		else if (stg.tymed!=TYMED_HGLOBAL)
			AfxMessageBox(_T("Unrecognised format in Paste operation"));
		else
		{
			strData=(LPSTR)::GlobalLock(stg.hGlobal);
			
			::ReleaseStgMedium(&stg);
		}
	}
	Obj.Detach();

	int i,j,rv,readCount;
	float x;
	CString str,errStr,line;

	ResetOutput();

	errStr.Empty();

// find lines with text in them, and skip, get DimCount of first OK line
	m_DimCount=0;
	while (strData.GetLength()>0)	// don't continue if remove all input str
	{
		line=strData.SpanExcluding(_T("\n"));	// line does not include \n
		rv=CountFloatsInString(line);
		if (rv<1)	// got empty line or non-number in line, scrap it
// remove line from strData, lineLen+1 to include the trailing \n
			strData.Delete(0,line.GetLength()+1);
		else
		{
			m_DimCount=rv;
			break;
		}
	}

// find total number of items
	readCount=CountFloatsInString(strData);
	if (readCount==-1)
	{
		errStr=_T("Got non-numeric value in body of Paste string; abandoning");
		goto abandon;
	}
	else if (readCount<4)
	{
		errStr=_T("ERROR: Less than 4 data items read from file.");
		goto abandon;
	}
	else if (readCount%m_DimCount!=0)
	{
		errStr.Format(_T("Missing items. There are %d items in first data line, but %d total items; abandoning"),m_DimCount,readCount);
		goto abandon;
	}

	m_ItemCount=readCount/m_DimCount;

	m_ppData=(float **) new float[m_DimCount];
	for (i=0; i<m_DimCount; i++)
		m_ppData[i]=(float *) new float[m_ItemCount];

	// load data
	for (i=0; i<m_ItemCount; i++) 
	{
		for (j=0; j<m_DimCount; j++)
		{
			BOOL b=GetFloatFromString(strData,x);
			if (b==FALSE)
			{
				errStr=_T("THIS SHOULD NOT HAPPEN; Error reading feature file, too few numbers, or non-number in file. Contact Author");
				for (i=0; i<m_DimCount; i++)
					delete [] m_ppData[i];
				delete m_ppData;
				goto abandon;
			}
			m_ppData[j][i]=x;
			readCount++;
		}
	}
	
	TRACE("Loaded %d data points of dimension %d.\n", m_ItemCount, m_DimCount);
#ifdef _DEBUG
	for (i=0; i<min(m_ItemCount,10); i++)
	{
		TRACE("item %d\t",i);
		for (j=0; j<m_DimCount; j++)
			TRACE("dim%d = %f\t",j,m_ppData[j][i]);
		TRACE("\n");
	}
#endif

	SetupForCalc();

	return;

abandon:
	AfxMessageBox(errStr);
	m_ppData=NULL;
	m_ItemCount=0;
	m_pGraphWnd->SetData(0,RGB(128,0,0),m_pData,m_pColList);
	m_pGraphWnd->InvalidateRect(NULL);
	m_FileName.Empty();
}

void CKlustaWinDlg::SetupForCalc()
{
	int i;
	CString str;
	COLORREF old1;

	// m_pClassID will hold integer value representing which cluster item belongs to
	m_pClassID=new int[m_ItemCount];	
	for (i=0; i<m_ItemCount; i++)
		m_pClassID[i]=1;

// update axis combo selection 
	m_cXAxisSpin.SetRange(1,m_DimCount);
	m_cYAxisSpin.SetRange(1,m_DimCount);
	m_cZAxisSpin.SetRange(1,m_DimCount);

	m_cXAxisSpin.SetPos(1);
	m_cYAxisSpin.SetPos((m_DimCount>1)?2:1);
	m_cZAxisSpin.SetPos((m_DimCount>2?3:((m_DimCount>1)?2:1)));

	GetDlgItem(IDC_CALC)->EnableWindow();
	GetDlgItem(IDC_PARAMS)->EnableWindow();
	UpdateData(FALSE);

	old1=m_pClusterCols[0];
	ASSERT(m_pClusterCols!=NULL);
	delete [] m_pClusterCols;
	m_pClusterCols=new COLORREF[1];
	m_pClusterCols[0]=old1;
	
	m_pColList=new COLORREF[m_ItemCount];
	for (i=0; i<m_ItemCount; i++)
		m_pColList[i]=m_pClusterCols[0];

	m_pData=new float[m_ItemCount*3];

	SetGraphData();

	m_cClusterList.ResetContent();
	m_cClusterList.AddString(_T("raw"));
	m_cClusterList.SetCurSel(0);
	UpdateData();


// do Log File stuff
	UpdateLogFileName();
}

void CKlustaWinDlg::OnCopyData() 
{
	int i;
	CString str;
	if (m_ppData==NULL)
	{
		AfxMessageBox(_T("No data to copy"),MB_ICONSTOP);
		return;
	}

	for (i=0; i<m_ItemCount; i++)
	{
#if SAVE_CLASS_ID
// this saves just the partition number
		str.AppendFormat(_T("%d\r\n"), m_pClassID[i]);	// which class item p belongs to 
#else
// this saves 1st 3 dimensions plus colour
		str.AppendFormat(_T("%f\t%f\t%f\t%d\r\n"),m_ppData[0][i],
			m_ppData[1][i],m_ppData[2][i],m_pColList[i]);
#endif
	}

	if(OpenClipboard())
	{
		HGLOBAL clipbuffer;
		char * buffer;
		EmptyClipboard();
		clipbuffer = GlobalAlloc(GMEM_DDESHARE, str.GetLength()+1);
		buffer = (char*)GlobalLock(clipbuffer);
		for (int i=0; i<str.GetLength(); i++)
		{
			char c=str.GetAt(i);
			buffer[i]=c;
		}
		buffer[str.GetLength()]='\0';
		GlobalUnlock(clipbuffer);
		SetClipboardData(CF_TEXT,clipbuffer);
		CloseClipboard();
	}	




#if 0
	COleDataSource *pSource=new COleDataSource();
	int len=strOp.GetLength()+1;
	HGLOBAL hText=::GlobalAlloc(GMEM_SHARE,len);
	LPTSTR pText=(LPTSTR)::GlobalLock(hText);
	_tcscpy(pText,strOp);
	::GlobalUnlock(hText);
	FORMATETC fmt;
	fmt.cfFormat=CF_TEXT;
	fmt.dwAspect=DVASPECT_CONTENT;
	fmt.lindex=-1;
	fmt.ptd=NULL;
	fmt.tymed=TYMED_HGLOBAL;
	pSource->CacheGlobalData(CF_TEXT,hText,&fmt);
	pSource->SetClipboard();
#endif
}

/*
Pass in a string consisting of numbers and white space
Fill the float with the first number, and truncate the
string from left to remove number.
Return TRUE if got number, FALSE if not got number
*/
BOOL CKlustaWinDlg::GetFloatFromString(CString& str, float& x)
{
// NOTE following TRACE causes exception with v long string
//TRACE("entering ::GetFloatFromString, str = %s\n",str);
	int rv;
	if (str.IsEmpty())
		return FALSE;
	str.TrimLeft();	// remove leading whitespace
	rv=swscanf(str,_T("%f"),&x);
	if (rv!=1)
		return FALSE;

	rv=str.FindOneOf(_T(" \t\r\n"));	// find next whitespace
	if (rv==-1)
		str.Empty();
	else
	{
#if 0
		CString s=str;
		int l=s.GetLength();
		str=s.Right(l-rv);
#endif
		str.Delete(0,rv);
	}
// NOTE following TRACE causes exception with v long string
//TRACE("leaving::GetFloatFromString, str = %s, x = %f\n",str,x);
	return TRUE;
}
/*
Count the number of floating point numbers in string containing
nothing but numbers and white space
returns -1 if encounters wrong character
*/
int CKlustaWinDlg::CountFloatsInString(CString str)
{
	int i;
	BOOL bInFlt=FALSE;
	int Count=0;
	for (i=0; i<str.GetLength(); i++)
	{
		if (!IsNumberOrSpace(str[i]))
			return -1;	
		if (isspace(str[i]))
		{
			if (bInFlt)
			{
				bInFlt=FALSE;
				Count++;
			}
		}
		else
			bInFlt=TRUE;
	}
	if (bInFlt==TRUE)	// no whitespace after last number
		Count++;
	return Count;
}

void CKlustaWinDlg::SetData(int numDims, int numItems, COleSafeArray &saData)
{
	int i,j;
	float x;
	CString str,errStr,line;
	long idx[1];
	ResetOutput();
	
	m_DimCount=numDims;
	m_ItemCount=numItems;

	m_ppData=(float **) new float[m_DimCount];
	for (i=0; i<m_DimCount; i++)
		m_ppData[i]=(float *) new float[m_ItemCount];

	// load data
	for (i=0; i<m_ItemCount; i++) 
	{
		for (j=0; j<m_DimCount; j++)
		{
			idx[0]=i*m_DimCount+j;
			saData.GetElement(idx,&x);
			m_ppData[j][i]=x;
		}
	}
	
	TRACE("Loaded %d data points of dimension %d.\n", m_ItemCount, m_DimCount);
#ifdef _DEBUG
	for (i=0; i<min(m_ItemCount,10); i++)
	{
		TRACE("item %d\t",i);
		for (j=0; j<m_DimCount; j++)
			TRACE("dim%d = %f\t",j,m_ppData[j][i]);
		TRACE("\n");
	}
#endif

	SetupForCalc();
}

int CKlustaWinDlg::GetPartitionData(VARIANT *pData)
{
	if (m_ItemCount==0)
		return FALSE;
	VariantInit (pData);
	pData->vt = VT_EMPTY;
	VariantInit (pData);
	pData->vt = VT_ARRAY | VT_I4; 
	// Array of ints
	SAFEARRAY* psa;
	//number of elements 
	SAFEARRAYBOUND bound = { m_ItemCount, 0 }; // m_ItemCount elements, 0-based index
	psa = SafeArrayCreate ( VT_I4, 1, &bound);
	if (psa == NULL)
	{
		TRACE("out of memory\n");
		return FALSE;
	}
	for (long i=0; i<m_ItemCount; i++)
	{
		SafeArrayPutElement( psa, &i,&(m_pClassID[i]));
	}
	pData->parray = psa;
	return TRUE;
}

void CKlustaWinDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetGraphData();		
	CDialogEx::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CKlustaWinDlg::OnSaveBest() 
{
	UpdateData();
	if (m_bSaveBest)
	{
		if (m_FileName=="")	// came from paste
		{
			CFileDialog dlg(FALSE,_T("txt"),NULL,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
				_T("text (.txt)|*.txt|all files|*.*||"));
			if (dlg.DoModal()!=IDOK)
				return;
			m_FileName=dlg.GetPathName();
		}
	}
}

void CKlustaWinDlg::OnKk() 
{
#if INCLUDE_KK
	int i,c,p,count,score;
	float sumScore;
	CString str;
	BOOL bGotEntry;




	KK::MinClusters=CCluster::s_MinClusters; // Min and MaxClusters includes cluster 1, the noise cluster
KK::MaxClusters=CCluster::s_MaxClusters;
KK::MaxPossibleClusters=CCluster::s_MaxPossibleClusters; // splitting can't make it exceed this
KK::nStarts=CCluster::s_NumStarts; // number of times to start count from each number of clusters
KK::DistThresh=CCluster::s_DistThresh;
			// the best do not get E-step recalculated - and that's most of them
KK::FullStepEvery=CCluster::s_FullStepEvery;
KK::ChangedThresh=CCluster::s_ChangedThresh;
KK::MaxIter=CCluster::s_MaxIter;
KK::SplitEvery=CCluster::s_SplitEvery;
KK::penaltyMix=CCluster::s_PenaltyMix;







	float Score,BestScore=FLT_MAX;
	if (m_ItemCount==0)
		return;

	if (!UpdateData())	// pick up NumRuns
		return;
	ASSERT(m_bLogFile==!m_LogFileName.IsEmpty());	// should be empty if not saving log

	CWaitCursor cur;
	m_RunsDone=0;
	UpdateData(FALSE);



#ifdef _DEBUG
	CMemoryState oldMemState, newMemState, diffMemState;
	oldMemState.Checkpoint();
#endif	


	KK *pK1=new KK;



	pK1->LoadData(m_ppData,m_ItemCount,m_DimCount);

#if 0
	delete pK1;

	#ifdef _DEBUG
	newMemState.Checkpoint();
	if( diffMemState.Difference( oldMemState, newMemState ) )
	{
		TRACE( "Memory leaked!\n" );
		diffMemState.DumpStatistics();
	}
	#endif
	return;
#endif	



	KK::kSv.BestWeight.SetSize(KK::MaxPossibleClusters);	// for saving 
	KK::kSv.BestMean.SetSize(KK::MaxPossibleClusters*pK1->nDims);	// for saving 


	while (m_RunsDone<m_NumRuns)
	{
		TRACE("m_RunsDone = %d\n",m_RunsDone);
// loop through numbers of clusters ...
		for(pK1->nStartingClusters=KK::MinClusters; pK1->nStartingClusters<=KK::MaxClusters; pK1->nStartingClusters++) 
		{
			for(i=0; i<KK::nStarts; i++) 
			{
// do CEM iteration
				TRACE("Starting from %d clusters...\n", pK1->nStartingClusters);
				Score = pK1->CEM();

				TRACE("%d->%d Clusters: Score %f, best is %f\n", pK1->nStartingClusters, pK1->nClustersAlive, Score, BestScore);

				if (Score < BestScore) 
				{
					TRACE("THE BEST YET in loop through clusters!\n");
					// New best classification found
					BestScore = Score;

					if (BestScore < KK::kSv.BestScoreSave) 
					{
						TRACE("BestScoreSave updated from %f to %f\n",KK::kSv.BestScoreSave,BestScore);
						KK::kSv.BestScoreSave = BestScore;
					}

					for(p=0; p<pK1->nPoints; p++) 
						pK1->BestClass[p] = pK1->Class[p];

					//			SaveOutput(K1.BestClass);

				}
				TRACE("\n");
			}
		}

		// Ken agrees not needed, but harmless  
		//	SaveOutput(K1.BestClass);

		//	if (fSaveModel) export_model(pModelFile);

		//	Output("That took %f seconds.\n", (clock()-Clock0)/(float) CLOCKS_PER_SEC);

		//	if (DistDump) fclose(Distfp);

		//	if (fSaveModel) fclose(pModelFile);


		int MaxClass = 0;
		Array<int> cClustMembs(KK::MaxPossibleClusters);
		Array<int> NewLabel(KK::MaxPossibleClusters);

		// find non-empty clusters
		for(c=0;c<KK::MaxPossibleClusters;c++) 
			NewLabel[c] = cClustMembs[c] = 0;
		// count cluster members
		for(p=0; p<pK1->BestClass.size(); p++) 
			++cClustMembs[pK1->BestClass[p]];

		// make new cluster labels so we don't have empty ones
		NewLabel[0] = 1;
		MaxClass = 1;
		for(c=1; c<KK::MaxPossibleClusters;c++) 
		{
			if (cClustMembs[c] > 0) 
			{
				MaxClass++;
				NewLabel[c] = MaxClass;
			}
		}


		m_NumClassesFound=MaxClass;

		for (p=0; p<pK1->BestClass.size(); p++) 
		{
		//		fprintf(fp, "%d\n", NewLabel[K1.BestClass[p]]);
			m_pClassID[p]=NewLabel[pK1->BestClass[p]];
//			TRACE("item %d in class %d\n",p,m_pClassID[p]);
		}


#ifdef _DEBUG
		{
			TRACE("SaveOutput:  cluster counts =\n");
			for (int i=0; i<MaxClass; i++)
				TRACE("%d\n",cClustMembs[i]);
		}
#endif



		m_MaxClassFound=max(m_MaxClassFound,m_NumClassesFound);

		ASSERT(m_NumClassesFound>0);

		m_Score=int(-BestScore);
		m_RunsDone++;
		m_TotalRuns++;
		UpdateData(FALSE);	// fix m_RunsDone because UpdateData() gets called in SetGraphData

		COLORREF old1=m_pClusterCols[0];
		ASSERT(m_pClusterCols!=NULL);
		delete [] m_pClusterCols;
		m_pClusterCols=new COLORREF[m_NumClassesFound];
		m_pClusterCols[0]=old1;
		for (i=1; i<m_NumClassesFound; i++)		// already got noise class colour
			m_pClusterCols[i]=m_DefClassCol[i%12];

		if (m_pColList!=NULL)
			delete [] m_pColList;
		m_pColList=new COLORREF[m_ItemCount];
		for (i=0; i<m_ItemCount; i++)
			m_pColList[i]=m_pClusterCols[m_pClassID[i]-1];

		if (m_NumClassesFound>12)
			AfxMessageBox("Found >12 classes, some classes will share colours. Check with list box.");

		SetGraphData();

		// keep track of how many times this number of clusters has been found
		bGotEntry=m_NumClustersCountMap.Lookup(m_NumClassesFound,count);
		if (bGotEntry==FALSE)
		{
			count=1;
			m_NumClustersCountMap.SetAt(m_NumClassesFound,count);
			sumScore=m_Score;
			m_SumScoreMap.SetAt(m_NumClassesFound,sumScore);
		}
		else
		{
			count++;
			m_NumClustersCountMap.SetAt(m_NumClassesFound,count);
			VERIFY(m_SumScoreMap.Lookup(m_NumClassesFound,sumScore));
			sumScore+=m_Score;
			m_SumScoreMap.SetAt(m_NumClassesFound,sumScore);
		}
	}
	// save best scores for each cluster number found
	if (m_bSaveBest)
	{
	// check previous best score, if any, for this number of clusters
		bGotEntry=m_ScoreMap.Lookup(m_NumClassesFound,score);
		if (bGotEntry==FALSE || m_Score>score)
		{
			// no previous score for this number of clusters, or this one better
			m_ScoreMap.SetAt(m_NumClassesFound,m_Score);

			// save best op file for this number of clusters
			CString outName=m_FileName;
			CString op="_Best";
			CString numClass;
			numClass.Format("_%d_classes",m_NumClassesFound);
			op+=numClass;
			i=m_FileName.ReverseFind('.');
			if (i==-1)	// no extension
				outName+=op;
			else
			{
				outName=m_FileName.Left(i);
				outName+=op;
				outName+=m_FileName.Right(m_FileName.GetLength()-i);
			}
			TRY
			{
				CStdioFile F(outName,CFile::modeCreate|CFile::modeWrite|CFile::typeText);
				F.WriteString("Klustawin output\n");
				str.Format("Number of classes found = %d\n", m_NumClassesFound);	// number of classes found
				F.WriteString(str);
				str.Format("Score = %d\n",m_Score);
				F.WriteString(str);
				for (i=0; i<m_ItemCount; i++)
				{
		#if SAVE_CLASS_ID
					// this saves just the partition number
					// NORMAL OUTPUT
					str.Format("%d\n", m_pClassID[i]);	// which class item p belongs to 
		#else
					// this saves 1st 3 dimensions plus colour
					// JUST FOR PROVIDING SOURCE FOR SCATTERPLOT
					str.Format("%f\t%f\t%f\t%d\n",m_ppData[0][i],
					m_ppData[1][i],m_ppData[2][i],m_pColList[i]);
		#endif
					F.WriteString(str);
				}
				F.Close();
			}
			CATCH( CFileException, e )
			{
				#ifdef _DEBUG
				afxDump << "File could not be opened "
				<< e->m_cause << "\n";
				#endif
			}
			END_CATCH
		}
	}

	if (m_Score>m_BestScore)
	{
		m_BestScore=m_Score;
		m_BestNumClusters=m_NumClassesFound;
	}

	UpdateData(FALSE);
	UpdateWindow();


	GetDlgItem(IDC_SAVE)->EnableWindow();
	m_cClusterList.ResetContent();
	m_cClusterList.AddString("noise: 1");
	for (i=1; i<m_NumClassesFound; i++)
	{
		str.Format("class: %d",i+1);
		m_cClusterList.AddString(str);
	}
	m_cClusterList.SetCurSel(0);
	UpdateData();

	delete pK1;

#ifdef _DEBUG
	newMemState.Checkpoint();
	if( diffMemState.Difference( oldMemState, newMemState ) )
	{
	TRACE( "Memory leaked!\n" );
	diffMemState.DumpStatistics();
	}
#endif


#endif
}


void CKlustaWinDlg::SetClusterCols()
{
	int i;
	COLORREF old1=m_pClusterCols[0];
	ASSERT(m_pClusterCols!=NULL);
	delete [] m_pClusterCols;
	m_pClusterCols=new COLORREF[m_NumClassesFound];
	m_pClusterCols[0]=old1;
	for (i=1; i<m_NumClassesFound; i++)		// already got noise class colour
		m_pClusterCols[i]=m_DefClassCol[i%12];

	if (m_pColList!=NULL)
		delete [] m_pColList;
	m_pColList=new COLORREF[m_ItemCount];
	for (i=0; i<m_ItemCount; i++)
		m_pColList[i]=m_pClusterCols[m_pClassID[i]-1];
}

void CKlustaWinDlg::ResetOutput()
{
	int i;
	m_SaveNum=1;	// start new save filename series
	m_BestScore=0;	// reset best score when load file
	m_BestNumClusters=0;
	m_NumClassesFound=0;
	m_Score=0;
	m_RunsDone=m_TotalRuns=m_MaxClassFound=0;
	m_ScoreMap.RemoveAll();
	m_NumClustersCountMap.RemoveAll();
	m_SumScoreMap.RemoveAll();

	if (m_cClusterCountList.GetCount()>0)
		m_cClusterCountList.ResetContent();

	CClusterDetails *pClusterDetails;
	POSITION pos=m_ClusterDetailsMap.GetStartPosition();
	while (pos!=NULL)
	{
		m_ClusterDetailsMap.GetNextAssoc(pos,i,pClusterDetails);
		delete pClusterDetails;
	}
	m_ClusterDetailsMap.RemoveAll();

// delete previous stuff in preparation
	if (m_ppData!=NULL)	// need to delete before change m_DimCount with new data file
	{
		for (i=0; i<m_DimCount; i++)
			delete [] m_ppData[i];
		delete m_ppData;
		m_ppData=NULL;
	}
	if (m_pClassID!=NULL)
	{
		delete [] m_pClassID;
		m_pClassID=NULL;
	}
	if (m_pColList!=NULL)
	{
		delete [] m_pColList;
		m_pColList=NULL;
	}
	if (m_pData!=NULL)		// holds floats to pass to graph
	{
		delete [] m_pData;
		m_pData=NULL;
	}

	GetDlgItem(IDC_SAVE)->EnableWindow(FALSE);
	GetDlgItem(IDC_COPY_DATA)->EnableWindow(FALSE);
	GetDlgItem(IDC_SUMMARY)->EnableWindow(FALSE);
	GetDlgItem(IDC_SHOW_BEST)->EnableWindow(FALSE);	
}


void CKlustaWinDlg::OnSelendokClusterCountList() 
{
	int i;
	CString str;
	CClusterDetails *pClusterDetails;
	UpdateData();
	int clusterCount=m_cClusterCountList.GetItemData(m_ClusterCountList);
	TRACE("In OnSelendokClusterCountList, val = %d, item data = %d\n",m_ClusterCountList,clusterCount);


	m_ClusterDetailsMap.Lookup(clusterCount,pClusterDetails);
	m_Score=pClusterDetails->m_BestScore;
	m_NumClassesFound=pClusterDetails->m_NumClusters;
	for (i=0; i<m_ItemCount; i++)
		m_pClassID[i]=pClusterDetails->m_pList[i];

	SetClusterCols();
	UpdateData(FALSE);
	SetGraphData();


	m_cClusterList.ResetContent();
	m_cClusterList.AddString(_T("noise: 1"));
	for (i=1; i<m_NumClassesFound; i++)
	{
		str.Format(_T("class: %d"),i+1);
		m_cClusterList.AddString(str);
	}
	m_cClusterList.SetCurSel(0);
	UpdateData();
	GetDlgItem(IDC_COLOUR)->Invalidate();

}

void CKlustaWinDlg::OnShowBest() 
{
	int i;
	CClusterDetails *pClusterDetails;
	BOOL bGotEntry;
	float bestScore=0;
	int bestIdx=0;
	for (i=1; i<CCluster::s_MaxPossibleClusters; i++)
	{
		bGotEntry=m_ClusterDetailsMap.Lookup(i,pClusterDetails);
		if (bGotEntry)
		{
			ASSERT(i==pClusterDetails->m_NumClusters);	// key 0 is most recent
			if (pClusterDetails->m_BestScore>bestScore)
			{
				bestScore=pClusterDetails->m_BestScore;
				bestIdx=i;
			}
		}
	}
	CString str;
	str.Format(_T("%d: %d"),bestIdx,int(bestScore));

	m_cClusterCountList.SelectString(0,str);
	OnSelendokClusterCountList();
}

void CKlustaWinDlg::OnSummary() 
{
	CString str;
	COutput op;
	BOOL bGotEntry;

	int i,j,k,n;
	CClusterDetails *pCD;
	float avg,sd;


// do most recent run (key = 0)
	bGotEntry=m_ClusterDetailsMap.Lookup(0,pCD);
	ASSERT(bGotEntry);	// should always be a most recent run
	op.m_Output=_T("Most recent run:\r\n");
	str.Format(_T("number clusters: %d, score: %.1f\r\n"),pCD->m_NumClusters,pCD->m_BestScore);
	op.m_Output+=str;
	op.m_Output+=_T("cluster\tn\t");
	for (i=0; i<m_DimCount; i++)
	{
		str.Format(_T("mean d%d\t\ts.d. d%d\t\t"),i+1,i+1);
		op.m_Output+=str;
	}
	op.m_Output+=_T("\r\n");

	for (j=0; j<pCD->m_NumClusters; j++)
	{
		for (i=0; i<m_DimCount; i++)
		{
			GetStats(j+1,pCD,i,avg,sd,n);
			if (i==0)	// write cluster, n
			{
				str.Format(_T("cl %d\t%d\t%.4f\t\t%.4f\t\t"),j+1,n,avg,sd);
				op.m_Output+=str;
			}
			else
			{
				str.Format(_T("%.4f\t\t%.4f\t\t"),avg,sd);
				op.m_Output+=str;
			}
		}
		op.m_Output+=_T("\r\n");
	}	
	
	
	op.m_Output+="\r\n";
	for (k=1; k<CCluster::s_MaxPossibleClusters; k++)
	{
		bGotEntry=m_ClusterDetailsMap.Lookup(k,pCD);
		if (bGotEntry)
		{
			ASSERT(k==pCD->m_NumClusters);	// key 0 is most recent
			op.m_Output+=_T("Best of set:\r\n");
			str.Format(_T("number clusters: %d, number occurrences %d, best score: %.1f, avg score = %.1f\r\n"),
				pCD->m_NumClusters,pCD->m_NumOccurrences, pCD->m_BestScore, pCD->m_SumScore/pCD->m_NumOccurrences);
			op.m_Output+=str;


			op.m_Output+=_T("cluster\tn\t");
			for (i=0; i<m_DimCount; i++)
			{
				str.Format(_T("mean d%d\t\ts.d. d%d\t\t"),i+1,i+1);
				op.m_Output+=str;
			}
			op.m_Output+=_T("\r\n");

			for (j=0; j<pCD->m_NumClusters; j++)
			{
				for (i=0; i<m_DimCount; i++)
				{
					GetStats(j+1,pCD,i,avg,sd,n);
					if (i==0)	// write cluster, n
					{
						str.Format(_T("cl %d\t%d\t%.4f\t\t%.4f\t\t"),j+1,n,avg,sd);
						op.m_Output+=str;
					}
					else
					{
						str.Format(_T("%.4f\t\t%.4f\t\t"),avg,sd);
						op.m_Output+=str;
					}
				}
				op.m_Output+=_T("\r\n");
			}	
	

			
			op.m_Output+=_T("\r\n");















		}
	}

	op.DoModal();
}


void CKlustaWinDlg::GetStats(int cluster, CClusterDetails *pCD,int dim, float& avg,float& sd,int& n)
{
	int i;
	float sumX2=0.f, sumX=0.f;
	ASSERT(dim<=m_DimCount);

	n=0;

	for (i=0; i<m_ItemCount; i++)
	{
		if (pCD->m_pList[i]==cluster)
		{
			sumX+=m_ppData[dim][i];
			sumX2+=m_ppData[dim][i]*m_ppData[dim][i];
			n++;
		}
	}
	avg=sumX/n;
	sd=sqrt((n*sumX2-sumX*sumX)/(n*(n-1)));
}

BOOL CKlustaWinDlg::PreTranslateMessage(MSG* pMsg)
{
	if(m_pToolTip != NULL)
		m_pToolTip->RelayEvent(pMsg);
	return CDialogEx::PreTranslateMessage(pMsg);
}

