#pragma once

#include "GLScatterGraph.h"
#include <afxtempl.h>

// CGLSelectableScatterGraph

class CGLSelectableScatterGraph : public CGLScatterGraph
{
	DECLARE_DYNAMIC(CGLSelectableScatterGraph)

public:
	CGLSelectableScatterGraph();
	virtual ~CGLSelectableScatterGraph();

public:
	BOOL ZoomSel();
	void CancelSel();
	void StartMakeSel();
	virtual void OnDrawGL(); // override to issue drawing functions

protected:
	int m_OldRotationType;
	BOOL m_bMakeSel;
	CPoint m_PrevPt;	
	CArray<CPoint, CPoint> m_SelPts;

#if USE_GDI
	virtual void OnDrawGDI(CPaintDC *pDC); // override to issue GDI drawing functions
#endif

protected:
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);

	DECLARE_MESSAGE_MAP()
};


