#pragma once
#include "RotatableGLWnd.h"

extern float NextAbove(float val,int sig);
extern float NextBelow(float val,int sig);

// CGLScatterGraph

class CGLScatterGraph : public CRotatableGLWnd
{
	DECLARE_DYNAMIC(CGLScatterGraph)

public:
	CGLScatterGraph();
	virtual ~CGLScatterGraph();

// Operations
public:
	void SetPtCol(COLORREF col) {m_Colour=col; Invalidate();}
	CGLDispList m_GraphBox;

/* 
count = number of points
col = colour of points, used if pColList=NULL
pCoords = x,y,z coords of each point, lenght = count*3
pColList = pointer to count COLORREFs, each point has that colour if not NULL
*/
	void SetData(int count,COLORREF col,float *pCoords, COLORREF *pColList=NULL);
	void SetMaxX(float x) {m_MaxX=x; Invalidate();}
	void SetMaxY(float y) {m_MaxY=y;Invalidate();}
	void SetMaxZ(float z) {m_MaxZ=z;Invalidate();}
	void SetMinX(float x) {m_MinX=x;Invalidate();}
	void SetMinY(float y) {m_MinY=y;Invalidate();}
	void SetMinZ(float z) {m_MinZ=z;Invalidate();}
	float GetMaxX() {return m_MaxX;}
	float GetMaxY() {return m_MaxY;}
	float GetMaxZ() {return m_MaxZ;}
	float GetMinX() {return m_MinX;}
	float GetMinY() {return m_MinY;}
	float GetMinZ() {return m_MinZ;}
	void SetAutoScaleX(BOOL scl) {m_bAutoScaleX=scl; AutoScale();}
	void SetAutoScaleY(BOOL scl) {m_bAutoScaleY=scl; AutoScale();}
	void SetAutoScaleZ(BOOL scl) {m_bAutoScaleZ=scl; AutoScale();}

	void RenderData();

	void SetProjection(int type);
	void SetSymbolSize(float size) {m_SymbolSize=size; Invalidate();}

	virtual void OnCreateGL(); // override to set bg color, activate z-buffer, and other global settings
	virtual void OnSizeGL(int cx, int cy); // override to adapt the viewport to the window
	virtual void OnDrawGL(); // override to issue drawing functions
#if USE_GDI
	virtual void OnDrawGDI(CPaintDC *pDC); // override to issue GDI drawing functions
#endif

protected:
	int m_ProjType;	// 0 = ortho, 1 = perspective

	float m_MaxX;
	float m_MaxY;
	float m_MaxZ;
	float m_MinX;
	float m_MinY;
	float m_MinZ;
	BOOL m_bAutoScaleX;
	BOOL m_bAutoScaleY;
	BOOL m_bAutoScaleZ;

	int m_Count;
	float *m_pDat;
	COLORREF m_Colour;
	COLORREF *m_pColList;

	BOOL PtWithinAxes(float x,float y,float z);
	void AutoScale(int *pDoList=NULL);
	float m_SymbolSize;

	DECLARE_MESSAGE_MAP()
};


