#pragma once

#include <vfw.h>
#include <memory.h>
#include <mmsystem.h>
class CConstructVideo
{
public:
// receives bitmap (use when copying from screen with GDI
	BOOL WriteFrame(CBitmap& bm,long FrameNum, BYTE *audioDat=NULL);
	BOOL Create(CBitmap& bm, CSize size,DWORD frameRate,int audioType=0,DWORD Hz=11025,int audioBits=0,int palletteDepth=8);	// pass in ref to 1st image

// receives DIB-type header plus pixel data. Use with OpenGL
	BOOL Create(LPBITMAPINFOHEADER pBmInfoHdr, CSize size,DWORD frameRate,int audioType=0,DWORD Hz=11025,int audioBits=0,int palletteDepth=8);	// pass in ref to 1st image
	BOOL WriteFrame(LPBITMAPINFOHEADER pBmInfoHdr, unsigned char *pPixelData ,long FrameNum, BYTE *audioDat=NULL);

	CConstructVideo(void);
	~CConstructVideo(void);

protected:
	int m_PalletteDepth;
	LPBITMAPINFOHEADER m_alpbi;
	WAVEFORMATEX waveFormat;
	AVISTREAMINFO strhdr;
	PAVIFILE pfile;
	PAVISTREAM ps;
	PAVISTREAM psCompressed;
	PAVISTREAM psAudio;
	AVICOMPRESSOPTIONS opts;
	AVICOMPRESSOPTIONS * aopts[1];
	HRESULT hr;
	int m_AudioType;
	int m_AudioBufSize;
	int m_AudioRate;	// Hz
	int m_AudioFrameCount;	// number of audio samples in one channle in a video frame
private:
	HANDLE MakeDib(HBITMAP,UINT);
};
