#include "StdAfx.h"
#include "ConstructVideo.h"

CConstructVideo::CConstructVideo(void)
{
	m_alpbi=NULL;
	pfile = NULL;
	ps = NULL;
	psCompressed = NULL;
	psAudio=NULL;
	aopts[0] = &opts;
}

CConstructVideo::~CConstructVideo(void)
{
	if (ps)
		AVIStreamClose(ps);

	if (psCompressed)
		AVIStreamClose(psCompressed);

	if (psAudio)
		AVIStreamClose(psAudio);

	if (pfile)
		AVIFileClose(pfile);

	AVIFileExit();

	if (m_alpbi!=NULL)
		GlobalFree(m_alpbi);
}

// audioType =0=none, 1=mono, 2=stereo
// audioBits = 0 = 8 bit, 1 = 16 bit (16 not supported yet)
BOOL CConstructVideo::Create(CBitmap& bm, CSize size, DWORD frameRate,int audioType,DWORD Hz,int audioBits, int palletteDepth)
{
	/* first let's make sure we are running on 1.1 */
	WORD wVer = HIWORD(VideoForWindowsVersion());
	if (wVer < 0x010a){
		 /* oops, we are too old, blow out of here */
		AfxMessageBox(_T("Video for Windows version too old"), MB_OK|MB_ICONSTOP);
		return FALSE;
	}

	m_PalletteDepth=palletteDepth;
// get filename for avi
	CString filter("AVI Files (*.avi)|*.avi||"); 
	CFileDialog	fD(FALSE,_T(".avi"),NULL,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,filter);
	if (fD.DoModal()!=IDOK)
		return FALSE;

	m_alpbi = (LPBITMAPINFOHEADER)GlobalLock(MakeDib(HBITMAP(bm), palletteDepth));
	
// initialise all the AVI file stuff
	AVIFileInit();

// Open the movie file for writing....
// open the avi file
	hr = AVIFileOpen(&pfile,		    // returned file pointer
		       fD.GetPathName(),		            // file name
		       OF_WRITE | OF_CREATE,	    // mode to open file with
		       NULL);			    // use handler determined
						    // from file extension....
	if (hr != AVIERR_OK)
		goto error;

	// Fill in the header for the video stream....

	memset(&strhdr, 0, sizeof(strhdr));
	strhdr.fccType                = streamtypeVIDEO;// stream type
	strhdr.fccHandler             = 0;
	strhdr.dwScale                = 1;
	strhdr.dwRate                 = frameRate;		    // 15 fps
	strhdr.dwSuggestedBufferSize  = m_alpbi->biSizeImage;
	SetRect(&strhdr.rcFrame, 0, 0,		    // rectangle for stream
	    size.cx,
	    size.cy);

	// And create the (uncompressed video) stream;
	hr = AVIFileCreateStream(pfile,		    // file pointer
			         &ps,		    // returned stream pointer
			         &strhdr);	    // stream header
	if (hr != AVIERR_OK) {
		goto error;
	}

	memset(&opts, 0, sizeof(opts));

// display compression options, and get choices
	if (!AVISaveOptions(NULL, 0, 1, &ps, (LPAVICOMPRESSOPTIONS FAR *) &aopts))
	    goto error;

	// make compressed stream from uncompressed stream
	hr = AVIMakeCompressedStream(&psCompressed, ps, &opts, NULL);
	if (hr != AVIERR_OK) {
		goto error;
	}

// sets the format of the specified stream
	hr = AVIStreamSetFormat(psCompressed, 0,	// which stream, position
			       m_alpbi,	    // address of structure containing stream format
			       m_alpbi->biSize +   // size of structure containing format
			       m_alpbi->biClrUsed * sizeof(RGBQUAD));
	if (hr != AVIERR_OK) {
	goto error;
	}

	GlobalFree(m_alpbi);
	m_alpbi=NULL;
	
	m_AudioType=audioType;
	if (m_AudioType!=0)
	{
		m_AudioRate=Hz;
		m_AudioFrameCount=m_AudioRate/frameRate;
		if (m_AudioType==1) //mono
			m_AudioBufSize=m_AudioRate/frameRate;
		else
			m_AudioBufSize=2*(m_AudioRate/frameRate);	// need brackets
//		audioDat=new BYTE[bufSize];
//		memset(audioDat,0,bufSize);

		
		// Fill in the header for the audio stream....
		memset(&strhdr, 0, sizeof(strhdr));
		strhdr.fccType = streamtypeAUDIO;// stream type
	//	strhdr.fccHandler             = 0; // not used for audio

		strhdr.dwScale = 1;
		strhdr.dwRate  = m_AudioRate;		    // 
	// For audio streams, this rate should correspond to the audio block 
	// size (the nBlockAlign member of the WAVEFORMAT or PCMWAVEFORMAT structure), 
	// which for PCM (Pulse Code Modulation) audio reduces to the sample rate. 
		// ABOVE SUGGESTS 1??
		strhdr.dwSuggestedBufferSize = 0;	// 11025?? 11025/15??

	//	strhdr.dwLength=11025; //???? not used in text/video example
		if (audioType==1)
			strhdr.dwSampleSize=1;	// not used in text/video MS example, but help says should be same as nBlockAlign in WAVEFORMATEX
		else
			strhdr.dwSampleSize=2;

		// And create the stream;
		hr = AVIFileCreateStream(pfile,		    // file pointer
						 &psAudio,		    // returned stream pointer
						 &strhdr);	    // stream header
		if (hr != AVIERR_OK) {
			goto error;
		}

		waveFormat.wFormatTag=WAVE_FORMAT_PCM;
		waveFormat.nSamplesPerSec=m_AudioRate;	// GOOD
//		waveFormat.nSamplesPerSec=11025;	// TEST
		waveFormat.wBitsPerSample=8;	// 8 or 16?? 32
		waveFormat.cbSize=0;
		if (audioType==1)
		{
			waveFormat.nChannels=1;	// 2 for stereo
			waveFormat.nAvgBytesPerSec=m_AudioRate;	//176400L = nSamplesPerSec*nBlockAlign
//			waveFormat.nAvgBytesPerSec=11025;	//176400L = nSamplesPerSec*nBlockAlign
			waveFormat.nBlockAlign=1;	//4
		}
		else
		{
			waveFormat.nChannels=2;	// 2 for stereo
			waveFormat.nAvgBytesPerSec=m_AudioRate*2;	//176400L
			waveFormat.nBlockAlign=2;	//4
		}


	// sets the format of the specified stream
		hr = AVIStreamSetFormat(psAudio, 0,	// which stream, position
					   &waveFormat,	    // address of structure containing stream format
					   sizeof(WAVEFORMATEX));
		if (hr != AVIERR_OK) {
		goto error;
		}
	}

	return TRUE;

error:
	AfxMessageBox(_T("Got an error in ConstructVideo::Create"));
	return FALSE;
}

/*
** MakeDib(hbitmap)
**
** Take the given bitmap and transform it into a DIB with parameters:
**
** BitsPerPixel:    8
** Colors:          palette
**
*/
HANDLE CConstructVideo::MakeDib( HBITMAP hbitmap, UINT bits )
{
	HANDLE              hdib ;
	HDC                 hdc ;
	BITMAP              bitmap ;
	UINT                wLineLen ;
	DWORD               dwSize ;
	DWORD               wColSize ;
	LPBITMAPINFOHEADER  lpbi ;
	LPBYTE              lpBits ;
	
	::GetObject(hbitmap,sizeof(BITMAP),&bitmap) ;

	//
	// DWORD align the width of the DIB
	// Figure out the size of the colour table
	// Calculate the size of the DIB
	//
	wLineLen = (bitmap.bmWidth*bits+31)/32 * 4;
	wColSize = sizeof(RGBQUAD)*((bits <= 8) ? 1<<bits : 0);
	dwSize = sizeof(BITMAPINFOHEADER) + wColSize +
		(DWORD)(UINT)wLineLen*(DWORD)(UINT)bitmap.bmHeight;

	//
	// Allocate room for a DIB and set the LPBI fields
	//
	hdib = ::GlobalAlloc(GHND,dwSize);
	if (!hdib)
		return hdib ;

	lpbi = (LPBITMAPINFOHEADER)::GlobalLock(hdib) ;

	lpbi->biSize = sizeof(BITMAPINFOHEADER) ;
	lpbi->biWidth = bitmap.bmWidth ;
	lpbi->biHeight = bitmap.bmHeight ;
	lpbi->biPlanes = 1 ;
	lpbi->biBitCount = (WORD) bits ;
	lpbi->biCompression = BI_RGB ;
	lpbi->biSizeImage = dwSize - sizeof(BITMAPINFOHEADER) - wColSize ;
	lpbi->biXPelsPerMeter = 0 ;
	lpbi->biYPelsPerMeter = 0 ;
	lpbi->biClrUsed = (bits <= 8) ? 1<<bits : 0;
	lpbi->biClrImportant = 0 ;

	//
	// Get the bits from the bitmap and stuff them after the LPBI
	//
	lpBits = (LPBYTE)(lpbi+1)+wColSize ;

	hdc = ::CreateCompatibleDC(NULL) ;

	::GetDIBits(hdc,hbitmap,0,bitmap.bmHeight,lpBits,(LPBITMAPINFO)lpbi, DIB_RGB_COLORS);

	// Fix this if GetDIBits messed it up....
	lpbi->biClrUsed = (bits <= 8) ? 1<<bits : 0;

	::DeleteDC(hdc) ;

	return hdib ;
}

BOOL CConstructVideo::WriteFrame(CBitmap & bm, long FrameNum,BYTE *audioDat)
{
	ASSERT(m_alpbi==NULL);
	m_alpbi = (LPBITMAPINFOHEADER)GlobalLock(MakeDib(HBITMAP(bm), m_PalletteDepth));
// NOTE: if the picture only changed eg every second, we would use i*FrameRate for time
	hr = AVIStreamWrite(psCompressed,	// stream pointer
		FrameNum,				// time of this frame
		1,				// number to write
		(LPBYTE) m_alpbi +		// pointer to data
			m_alpbi->biSize +
			m_alpbi->biClrUsed * sizeof(RGBQUAD),
			m_alpbi->biSizeImage,	// size of this frame
		AVIIF_KEYFRAME,			 // flags....
		NULL,
		NULL);
		// delete previous dib
	if (m_alpbi!=NULL)
	{
		GlobalFree(m_alpbi);
		m_alpbi=NULL;
	}
	if (hr != AVIERR_OK)
		return FALSE;

	if (m_AudioType!=0)
	{
		hr = AVIStreamWrite(psAudio,	// stream pointer
			FrameNum*m_AudioFrameCount,				// time of this frame
			m_AudioFrameCount,				// number to write
			audioDat,
			m_AudioBufSize,	// size of buffer
			0,			 // flags....
			NULL,
			NULL);
		if (hr != AVIERR_OK)
			return FALSE;	
	}

	return TRUE;
}

// OpenGL routine
// audioType =0=none, 1=mono, 2=stereo
// audioBits = 0 = 8 bit, 1 = 16 bit (16 not supported yet)
BOOL CConstructVideo::Create(LPBITMAPINFOHEADER pBmInfoHdr, CSize size, DWORD frameRate,int audioType,DWORD Hz,int audioBits, int palletteDepth)
{
	/* first let's make sure we are running on 1.1 */
	WORD wVer = HIWORD(VideoForWindowsVersion());
	if (wVer < 0x010a){
		 /* oops, we are too old, blow out of here */
		AfxMessageBox(_T("Video for Windows version too old"), MB_OK|MB_ICONSTOP);
		return FALSE;
	}

	m_PalletteDepth=palletteDepth;
// get filename for avi
	CString filter("AVI Files (*.avi)|*.avi||"); 
	CFileDialog	fD(FALSE,_T(".avi"),NULL,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,filter);
	if (fD.DoModal()!=IDOK)
		return FALSE;

// initialise all the AVI file stuff
	AVIFileInit();

// Open the movie file for writing....
// open the avi file
	hr = AVIFileOpen(&pfile,		    // returned file pointer
		       fD.GetPathName(),		            // file name
		       OF_WRITE | OF_CREATE,	    // mode to open file with
		       NULL);			    // use handler determined
						    // from file extension....
	if (hr != AVIERR_OK)
		goto error;

	// Fill in the header for the video stream....

	memset(&strhdr, 0, sizeof(strhdr));
	strhdr.fccType                = streamtypeVIDEO;// stream type
	strhdr.fccHandler             = 0;
	strhdr.dwScale                = 1;
	strhdr.dwRate                 = frameRate;		    // 15 fps
	strhdr.dwSuggestedBufferSize  = pBmInfoHdr->biSizeImage;
	SetRect(&strhdr.rcFrame, 0, 0,		    // rectangle for stream
	    size.cx,
	    size.cy);

	// And create the (uncompressed video) stream;
	hr = AVIFileCreateStream(pfile,		    // file pointer
			         &ps,		    // returned stream pointer
			         &strhdr);	    // stream header
	if (hr != AVIERR_OK) {
		goto error;
	}

	memset(&opts, 0, sizeof(opts));

// display compression options, and get choices
	if (!AVISaveOptions(NULL, 0, 1, &ps, (LPAVICOMPRESSOPTIONS FAR *) &aopts))
	    goto error;

	// make compressed stream from uncompressed stream
	hr = AVIMakeCompressedStream(&psCompressed, ps, &opts, NULL);
	if (hr != AVIERR_OK) {
		goto error;
	}

// sets the format of the specified stream
	hr = AVIStreamSetFormat(psCompressed, 0,	// which stream, position
			       pBmInfoHdr,	    // address of structure containing stream format
			       pBmInfoHdr->biSize +   // size of structure containing format
			       pBmInfoHdr->biClrUsed * sizeof(RGBQUAD));
	if (hr != AVIERR_OK) {
	goto error;
	}

	
	m_AudioType=audioType;
	if (m_AudioType!=0)
	{
		m_AudioRate=Hz;
		m_AudioFrameCount=m_AudioRate/frameRate;
		if (m_AudioType==1) //mono
			m_AudioBufSize=m_AudioRate/frameRate;
		else
			m_AudioBufSize=2*(m_AudioRate/frameRate);	// need brackets
//		audioDat=new BYTE[bufSize];
//		memset(audioDat,0,bufSize);

		
		// Fill in the header for the audio stream....
		memset(&strhdr, 0, sizeof(strhdr));
		strhdr.fccType = streamtypeAUDIO;// stream type
	//	strhdr.fccHandler             = 0; // not used for audio

		strhdr.dwScale = 1;
		strhdr.dwRate  = m_AudioRate;		    // 
	// For audio streams, this rate should correspond to the audio block 
	// size (the nBlockAlign member of the WAVEFORMAT or PCMWAVEFORMAT structure), 
	// which for PCM (Pulse Code Modulation) audio reduces to the sample rate. 
		// ABOVE SUGGESTS 1??
		strhdr.dwSuggestedBufferSize = 0;	// 11025?? 11025/15??

	//	strhdr.dwLength=11025; //???? not used in text/video example
		if (audioType==1)
			strhdr.dwSampleSize=1;	// not used in text/video MS example, but help says should be same as nBlockAlign in WAVEFORMATEX
		else
			strhdr.dwSampleSize=2;

		// And create the stream;
		hr = AVIFileCreateStream(pfile,		    // file pointer
						 &psAudio,		    // returned stream pointer
						 &strhdr);	    // stream header
		if (hr != AVIERR_OK) {
			goto error;
		}

		waveFormat.wFormatTag=WAVE_FORMAT_PCM;
		waveFormat.nSamplesPerSec=m_AudioRate;	// GOOD
//		waveFormat.nSamplesPerSec=11025;	// TEST
		waveFormat.wBitsPerSample=8;	// 8 or 16?? 32
		waveFormat.cbSize=0;
		if (audioType==1)
		{
			waveFormat.nChannels=1;	// 2 for stereo
			waveFormat.nAvgBytesPerSec=m_AudioRate;	//176400L = nSamplesPerSec*nBlockAlign
//			waveFormat.nAvgBytesPerSec=11025;	//176400L = nSamplesPerSec*nBlockAlign
			waveFormat.nBlockAlign=1;	//4
		}
		else
		{
			waveFormat.nChannels=2;	// 2 for stereo
			waveFormat.nAvgBytesPerSec=m_AudioRate*2;	//176400L
			waveFormat.nBlockAlign=2;	//4
		}


	// sets the format of the specified stream
		hr = AVIStreamSetFormat(psAudio, 0,	// which stream, position
					   &waveFormat,	    // address of structure containing stream format
					   sizeof(WAVEFORMATEX));
		if (hr != AVIERR_OK) {
		goto error;
		}
	}

	return TRUE;

error:
	AfxMessageBox(_T("Got an error in ConstructVideo::Create"));
	return FALSE;
}


BOOL CConstructVideo::WriteFrame(LPBITMAPINFOHEADER pBmInfoHdr, unsigned char *pPixelData , long FrameNum,BYTE *audioDat)
{
// NOTE: if the picture only changed eg every second, we would use i*FrameRate for time
	hr = AVIStreamWrite(psCompressed,	// stream pointer
		FrameNum,				// time of this frame
		1,				// number to write
		(LPBYTE) pPixelData,
			pBmInfoHdr->biSizeImage,	// size of this frame
		AVIIF_KEYFRAME,			 // flags....
		NULL,
		NULL);
		// delete previous dib
	if (hr != AVIERR_OK)
		return FALSE;

	if (m_AudioType!=0)
	{
		hr = AVIStreamWrite(psAudio,	// stream pointer
			FrameNum*m_AudioFrameCount,				// time of this frame
			m_AudioFrameCount,				// number to write
			audioDat,
			m_AudioBufSize,	// size of buffer
			0,			 // flags....
			NULL,
			NULL);
		if (hr != AVIERR_OK)
			return FALSE;	
	}

	return TRUE;
}
