// ClusterParams.cpp : implementation file
//

#include "stdafx.h"
#include "KlustaWin.h"
#include "ClusterParams.h"


// CClusterParams dialog

IMPLEMENT_DYNAMIC(CClusterParams, CDialog)

CClusterParams::CClusterParams(CWnd* pParent /*=NULL*/)
	: CDialog(CClusterParams::IDD, pParent)
{
	m_FullStepEvery = 0;
	m_MinClusters = 0;
	m_MaxClusters = 0;
	m_MaxIter = 0;
	m_DistThresh = 0.0;
	m_ChangedThresh = 0.0;
	m_RandSeed = 0;
	m_BIC_AIC = 0.0;
	m_MaxPossibleClusters = 100;
	m_SplitEvery = 50;
}

CClusterParams::~CClusterParams()
{
}

void CClusterParams::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_FULL_STEP, m_FullStepEvery);
	DDV_MinMaxInt(pDX, m_FullStepEvery, 1, 1000);
	DDX_Text(pDX, IDC_MAX_ITER, m_MaxIter);
	DDV_MinMaxInt(pDX, m_MaxIter, 5, 1000);
	DDX_Text(pDX, IDC_DIST_THRESH, m_DistThresh);
	DDX_Text(pDX, IDC_CHANGE_FRAC, m_ChangedThresh);
	DDX_Radio(pDX, IDC_SEED0, m_RandSeed);
	DDX_Text(pDX, IDC_BIC_AIC, m_BIC_AIC);
	DDV_MinMaxDouble(pDX, m_BIC_AIC, 0., 1.);
	DDX_Text(pDX, IDC_MAX_POSS_CLUSTERS, m_MaxPossibleClusters);
	DDV_MinMaxInt(pDX, m_MaxPossibleClusters, 2, 200);
	DDX_Text(pDX, IDC_SPLIT_STEPS, m_SplitEvery);
	DDV_MinMaxInt(pDX, m_SplitEvery, 0, 1000);

	DDX_Text(pDX, IDC_MAX_CLUST, m_MaxClusters);
	DDV_MinMaxInt(pDX, m_MaxClusters, m_MinClusters+1, 100);
	DDX_Text(pDX, IDC_MIN_CLUST, m_MinClusters);
	DDV_MinMaxInt(pDX, m_MinClusters, 2, m_MaxClusters-1);
}


BEGIN_MESSAGE_MAP(CClusterParams, CDialog)
END_MESSAGE_MAP()


// CClusterParams message handlers
