/*  Copyright 2016, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
*/

(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var angleInput=0;var angleMagnetic=0;var nTot=0;var nPlus=0;var pPlus=0;var n=0;var nTots=new Array(300+1).join('0').split('').map(parseFloat);var nPluss=new Array(300+1).join('0').split('').map(parseFloat);var accuracys=new Array(300+1).join('0').split('').map(parseFloat);var streaming=false;var multiple=false;var accuracy=0;var challenges=true;var blockUp=false;function rotateInput(){sym=AdobeEdge.getComposition(compId).getStage();sym.getSymbol('#Stage_sgaInput').stop(angleInput+(blockUp?'_1':''));rotateMagnetic();if(!blockUp){if(angleInput==0){var l=0;var t=0};if(angleInput==22.5){var l=2;var t=2};if(angleInput==45){var l=3;var t=4};if(angleInput==67.5){var l=4;var t=7};if(angleInput==90){var l=5;var t=11};}
else{if(angleInput==0){var l=0;var t=21};if(angleInput==22.5){var l=-2;var t=20};if(angleInput==45){var l=-4;var t=17};if(angleInput==67.5){var l=-4;var t=14};if(angleInput==90){var l=-5;var t=10};}
$('#Stage_sgaRight').css({'left':l+'px','top':t+'px'});$('#Stage_screen').css({'left':l+810+'px','top':t+56+'px'});sym.getSymbol('#Stage_sgaRight').stop(angleInput+'');changeTexts();setupNumber();resetValues();updateValues()}
function rotateMagnetic(){sym=AdobeEdge.getComposition(compId).getStage();sym.getSymbol('#Stage_magneticField').stop(angleMagnetic+'');sym.getSymbol('#Stage_cone').stop((angleInput!=0?angleInput+'_'+((blockUp)?(angleMagnetic/45+4)%8:angleMagnetic/45):'0'));if(blockUp){sym.getSymbol('#Stage_cone').$('container1Copy').css({'-ms-transform':'rotate(180deg)','-webkit-transform':'rotate(180deg)','transform':'rotate(180deg)'});sym.getSymbol('#Stage_cone').$('container2Copy').css({'-ms-transform':'rotate(180deg)','-webkit-transform':'rotate(180deg)','transform':'rotate(180deg)'});sym.getSymbol('#Stage_cone').$('container1Copy').css('top','-106px');sym.getSymbol('#Stage_cone').$('container2Copy').css('top','-106px');sym.getSymbol('#Stage_cone').$('cone'+angleInput/22.5).hide();sym.getSymbol('#Stage_cone').$('coneFlipped'+angleInput/22.5).show();sym.getSymbol('#Stage_cone').$('container1Copy').show();sym.getSymbol('#Stage_cone').$('container2Copy').show();sym.getSymbol('#Stage_cone').$('container1').hide();sym.getSymbol('#Stage_cone').$('container2').hide();sym.$('xyAxis').css('top',131-140+'px');sym.$('Text3').css('top','29px');}
else{sym.$('xyAxis').css('top','121px');sym.$('Text3').css('top','29px');sym.getSymbol('#Stage_cone').$('cone'+angleInput/22.5).show();sym.getSymbol('#Stage_cone').$('coneFlipped'+angleInput/22.5).hide();sym.getSymbol('#Stage_cone').$('container1Copy').hide();sym.getSymbol('#Stage_cone').$('container2Copy').hide();sym.getSymbol('#Stage_cone').$('container1').show();sym.getSymbol('#Stage_cone').$('container2').show();}}
function probabilityPlus(){var angleInputRad=(angleInput*Math.PI/180);var angleMagneticRad=(angleMagnetic*Math.PI/180);if(blockUp)return(1-(Math.pow(Math.cos(angleInputRad/2)*Math.cos(angleInputRad/2),2)+Math.pow(Math.sin(angleInputRad/2)*Math.sin(angleInputRad/2),2)+2*Math.cos(angleInputRad/2)*Math.sin(angleInputRad/2)*Math.cos(angleInputRad/2)*Math.sin(angleInputRad/2)*Math.cos(angleMagneticRad)))
else return(Math.pow(Math.cos(angleInputRad/2)*Math.cos(angleInputRad/2),2)+Math.pow(Math.sin(angleInputRad/2)*Math.sin(angleInputRad/2),2)+2*Math.cos(angleInputRad/2)*Math.sin(angleInputRad/2)*Math.cos(angleInputRad/2)*Math.sin(angleInputRad/2)*Math.cos(angleMagneticRad))}
function changeTexts(){var sub='';if(angleInput==0)sub='z&nbsp;';else if(angleInput==90)sub='x&nbsp;'
else sub=angleInput+''
$('#Stage_outcomePlus').html('Outcome S<sub>'+sub+'</sub> = +&#295;/2:');$('#Stage_outcomeMinus').html('Outcome S<sub>'+sub+'</sub> = &#8722;&#295;/2:');$('#Stage_ObservedS').html('Observed S<sub>'+sub+'</sub>');$('#Stage_probabilityPositive').html('+&#295;/2 : P<sub>+</sub> = N<sub>+</sub>/N<sub>tot</sub> = ');$('#Stage_probabilityNegative').html('&#8722;&#295;/2 : P<sub>&#8722;</sub> = N<sub>&#8722;</sub>/N<sub>tot</sub> = ');$('#Stage_totalMeasurements').html('N<sub>tot</sub> = ');sym1=AdobeEdge.getComposition(compId).getStage().getSymbol('sgaInput');sym2=AdobeEdge.getComposition(compId).getStage().getSymbol('sgaRight');sym1.$('up').html('|&#8593;<sub>'+sub+'</sub>&#x232A;');sym1.$('down').html('|&#8595;<sub>'+sub+'</sub>&#x232A;');sym2.$('up').html('|&#8593;<sub>'+sub+'</sub>&#x232A;');sym2.$('down').html('|&#8595;<sub>'+sub+'</sub>&#x232A;');if(blockUp){$('#Stage_probabilityNegativeCopy').html('P<sub>+</sub>: spin flip probability');$('#Stage_probabilityNegativeCopy').css('top','83px')}
else{$('#Stage_probabilityNegativeCopy').html('P<sub>&#8722;</sub>: spin flip probability');$('#Stage_probabilityNegativeCopy').css('top','120px')}}
function sendParticle(){sym=AdobeEdge.getComposition(compId).getStage();if(multiple==false)freezeFlashes()
if(Math.random()<0.5){if(multiple==false){sym.getSymbol('sgaInput').getSymbol('redFlash').play(0);sym.getSymbol('sgaInput').$((blockUp?'up':'down')).fadeIn(200)};}
else{nTot++;if(probabilityPlus()>Math.random()){nPlus++
if(multiple==false){sym.getSymbol('sgaRight').getSymbol('green').play(0)
sym.getSymbol('greenFlash').play(0);sym.getSymbol('sgaRight').$('up').fadeIn(200);}}
else{if(multiple==false){sym.getSymbol('sgaRight').getSymbol('blue').play(0)
sym.getSymbol('blueFlash').play(0)
sym.getSymbol('sgaRight').$('down').fadeIn(200);}}
if(multiple==false){updateValues();sym.getSymbol('sgaInput').$((blockUp?'down':'up')).fadeIn(200)}
else checkAccuracy()}}
function sendContinuous(){if(streaming){clearInterval(streaming);streaming=false;sym_enable($('#Stage_singleButton'))
$('#Stage_continousButtonLabel').text("Continuous");return;}
sym_disable($('#Stage_singleButton'));$('#Stage_continousButtonLabel').text("Stop");sendParticle();streaming=setInterval(function(){sendParticle()},700);}
function freezeFlashes(){sym=AdobeEdge.getComposition(compId).getStage();sym.getSymbol('sgaInput').getSymbol('redFlash').stop(0);sym.getSymbol('sgaRight').getSymbol('green').stop(0);sym.getSymbol('sgaRight').getSymbol('blue').stop(0);sym.getSymbol('greenFlash').stop(0);sym.getSymbol('blueFlash').stop(0);sym1=AdobeEdge.getComposition(compId).getStage().getSymbol('sgaInput');sym2=AdobeEdge.getComposition(compId).getStage().getSymbol('sgaRight');sym1.$('up').hide();sym1.$('down').hide();sym2.$('up').hide();sym2.$('down').hide();}
function updateValues(){nTots[n]=nTot;nPluss[n]=nPlus;accuracys[n]=accuracy;if(nTot>0){pPlus=nPlus/nTot;$('#Stage_totalMeasurementText').html(nTot);$('#Stage_positiveMeasurementText').html(nPlus);$('#Stage_negativeMeasurementText').html(nTot-nPlus);$('#Stage_observedProbabilityPositive').html(pPlus.toFixed(3));$('#Stage_observedProbabilityNegative').html((1-pPlus).toFixed(3));}
else{$('#Stage_totalMeasurementText').html(0);$('#Stage_positiveMeasurementText').html(0);$('#Stage_negativeMeasurementText').html(0);$('#Stage_observedProbabilityPositive').html('');$('#Stage_observedProbabilityNegative').html('');}
updateTheoretical()
updateHistogram()
checkAccuracy()}
function updateTheoretical(){$('#Stage_theoreticalProbabilityPositive').html(probabilityPlus().toFixed(3));$('#Stage_theoreticalProbabilityNegative').html((1-probabilityPlus()).toFixed(3));}
function resetValues(){freezeFlashes();nTot=nTots[n];nPlus=nPluss[n];accuracy=accuracys[n]}
function setupNumber(){n=angleInput/22.5+angleMagnetic/45*10+(challenges?100:0)+(blockUp?5:0)}
function clearMeasurements(){nTot=0;nPlus=0;pPlus=0;accuracy=0
nTots=new Array(300+1).join('0').split('').map(parseFloat);nPluss=new Array(300+1).join('0').split('').map(parseFloat);accuracys=new Array(300+1).join('0').split('').map(parseFloat);updateValues();freezeFlashes();}
function updateHistogram(){if(nTot!=0){var positivePercentage=nPlus/nTot;var positiveLength=positivePercentage*200;$('#Stage_positiveBar').css({'width':(nTot==0?0:positiveLength)});var negativePercentage=1-nPlus/nTot;var negativeLength=negativePercentage*200;$('#Stage_negativeBar').css({'width':(nTot==0?0:negativeLength)});$('#Stage_positiveHistogramText').text((nPlus/nTot).toFixed(3));$('#Stage_negativeHistogramText').text((1-nPlus/nTot).toFixed(3));$('#Stage_dottedLineTop').show();$('#Stage_dottedLineBottom').show();$('#Stage_dottedLineTop').css('left',36+Math.round(probabilityPlus()*200)+'px');$('#Stage_dottedLineBottom').css('left',36+Math.round((1-probabilityPlus())*200)+'px');}else{$('#Stage_positiveBar').css({'width':0});$('#Stage_negativeBar').css({'width':0});$('#Stage_positiveHistogramText').text('');$('#Stage_negativeHistogramText').text('');$('#Stage_dottedLineTop').hide();$('#Stage_dottedLineBottom').hide();}}
function checkAccuracy(){if(nTot>0){if(accuracy<6){if((Math.abs(nPlus/nTot-probabilityPlus())<0.02&&nTot>400)||(probabilityPlus().toFixed(2)==1||probabilityPlus().toFixed(2)==0))accuracy++;else accuracy=0;$('#Stage_moreMeasurementsText').show();}
else{$('#Stage_moreMeasurementsText').hide();}}
else{$('#Stage_moreMeasurementsText').show();}}
function showBoxes(){if($('#Stage_showProbabilitiesCheckbox').hasClass('selected'))$('#Stage_probabilities').show();else $('#Stage_probabilities').hide();if($('#Stage_showExpectationsCheckbox').hasClass('selected'))$('#Stage_expectationBox').show();else $('#Stage_expectationBox').hide();if($('#Stage_showHistCheckbox').hasClass('selected'))$('#Stage_outcomeHistogram').show();else $('#Stage_outcomeHistogram').hide();}
function debug(value){$('#Stage_debug').text(value);}
function hideCheckboxes(a){if(a){$('#Stage .checkbox_answer').each(function(){$(this).hide();});$('#Stage_buttonSubmit').css('top',148);$('#Stage_feedback').css('top',191);}
else{$('#Stage .checkbox_answer').each(function(){$(this).show();sym_deselect($(this));});$('#Stage_buttonSubmit').css('top',182)
$('#Stage_feedback').css('top',225)}}
var currentChallenge=1;function step_functions(step){clearTimeout(AdobeEdge.step_animation);currentChallenge=step;var question='';sym=AdobeEdge.getComposition(compId).getStage()
challenges=true;$('#Stage_feedback').html('');$('#Stage .star').hide();switch(step){case 1:sym_val('#Stage_slider',0);sym_val('#Stage_slider2',0);angleInput=0;angleMagnetic=0;hideCheckboxes(true)
question='Using both sliders, set up an experiment where only particles deflected in the +x direction pass Stern-Gerlach apparatus (SGA)&nbsp;1, and all particles are deflected in the –x direction after passing SGA&nbsp;2.'
break;case 2:sym_val('#Stage_slider',0);sym_val('#Stage_slider2',0);angleInput=0;angleMagnetic=0;hideCheckboxes(true)
question='Using both sliders, set up an experiment where only particles deflected in the +x direction pass Stern-Gerlach apparatus (SGA)&nbsp;1, and on average half of particles each are deflected in the +x and –x directions after passing SGA&nbsp;2.'
break;case 3:sym_val('#Stage_slider',0);sym_val('#Stage_slider2',0);angleInput=0;angleMagnetic=0;hideCheckboxes(true)
question='Using both sliders, set up a configuration where only particles deflected in the <span style=" white-space: nowrap;">θ = +45</span> direction pass Stern-Gerlach apparatus (SGA)&nbsp;1, and and as many particles as possible are deflected in the –45 direction after passing SGA&nbsp;2.';break;case 4:sym_val('#Stage_slider',0);sym_val('#Stage_slider2',0);angleInput=0;angleMagnetic=0;hideCheckboxes(false)
question='For which angles θ of SGA&nbsp;1 can you cause all particles passing both SGAs to flip from a spin-up eigenstate into a spin-down eigenstate given the uniform magnetic field aligned with the z-axis? ';break;}
$('#Stage_question').html(question);rotateInput();rotateMagnetic();}
var correct=false;function submit(){var sym=AdobeEdge.getComposition(compId).getStage().getSymbol('#Stage_steps');var feedbackText='';correct=false;var currentScore=totalScore;switch(currentChallenge){case 1:if(angleInput==90&&angleMagnetic==180)correct=true;if(correct){feedbackText='Correct, congratulations! The uniform magnetic field oriented along the z-axis causes the spin eigenstate |&#8593;<sub>x</sub>&#x232A; passing the first SGA to precess into the spin eigenstate |&#8595;<sub>x</sub>&#x232A; before entering the second SGA. Thus, all particles are deflected in the –x direction after passing SGA&nbsp;2. '
if(!$('#Stage_Tick1').hasClass('showing'))totalScore+=20;$('#Stage_Tick1').show();$('#Stage_Tick1').addClass('showing');}
else if(angleInput!=90)feedbackText='This is not yet correct. Consider which orientation of the SGAs you need to select particles in the eigenstate |&#8593;<sub>x</sub>&#x232A;  after passing SGA&nbsp;1.';else feedbackText='This is not yet correct. Consider what length of uniform magnetic field region you need for all particles in the eigenstate |&#8593;<sub>x</sub>&#x232A; to precess into the eigenstate |&#8595;<sub>x</sub>&#x232A;.';break;case 2:if(angleInput==90&&(angleMagnetic==90||angleMagnetic==270))correct=true;if(correct){feedbackText='Correct, congratulations! The uniform magnetic field oriented along the z-axis causes the spin eigenstate |&#8593;<sub>x</sub>&#x232A; passing the first SGA to precess into the spin eigenstate '+(angleMagnetic==90?'|&#8593;<sub>y</sub>&#x232A;':'|&#8595;<sub>y</sub>&#x232A;')+' before entering the second SGA . The state '+(angleMagnetic==90?'|&#8593;<sub>y</sub>&#x232A;':'|&#8595;<sub>y</sub>&#x232A;')+' is an equally weighted superposition with respect to |&#8593;<sub>x</sub>&#x232A; and |&#8595;<sub>x</sub>&#x232A;. '
if(!$('#Stage_Tick2').hasClass('showing'))totalScore+=25;$('#Stage_Tick2').show();$('#Stage_Tick2').addClass('showing');}
else if(angleInput!=90)feedbackText='This is not yet correct. Consider which orientation of the SGAs you need to select particles in the eigenstate |&#8593;<sub>x</sub>&#x232A;  after passing SGA&nbsp;1.';else feedbackText='This is not yet correct. Consider what length of uniform magnetic field region you need for all particles in the eigenstate |&#8593;<sub>x</sub>&#x232A; to precess into the eigenstate |&#8593;<sub>y</sub>&#x232A; or |&#8595;<sub>x</sub>&#x232A;.';break;case 3:if(angleInput==45&&angleMagnetic==180)correct=true;if(correct){feedbackText='Correct, congratulations! The uniform magnetic field oriented along the +45°-axis causes the spin eigenstate |&#8593;<sub>45</sub>&#x232A; passing the first SGA to precess into the spin eigenstate |&#8595;<sub>135</sub>&#x232A; before entering the second SGA . The state |&#8595;<sub>135</sub>&#x232A; is an equally weighted superposition with respect to |&#8593;<sub>45</sub>&#x232A; and |&#8595;<sub>45</sub>&#x232A;.  '
if(!$('#Stage_Tick3').hasClass('showing'))totalScore+=25;$('#Stage_Tick3').show();$('#Stage_Tick3').addClass('showing');}
else if(angleInput!=45)feedbackText='This is not yet correct. Consider which orientation of the SGAs you need to select particles in the eigenstate |&#8593;<sub>45</sub>&#x232A;  after passing SGA&nbsp;1.';else feedbackText='This is not yet correct. Consider what length of uniform magnetic field region you need for all particles in the eigenstate |&#8593;<sub>45</sub>&#x232A; to precess into a state that is an equally weighted superposition of |&#8593;<sub>45</sub>&#x232A; or |&#8595;<sub>45</sub>&#x232A;.';break;case 4:if($('#Stage_answer5').hasClass('selected')&&!$('#Stage_answer4').hasClass('selected')&&!$('#Stage_answer1').hasClass('selected')&&!$('#Stage_answer2').hasClass('selected')&&!$('#Stage_answer3').hasClass('selected')){correct=true;feedbackText='Correct, congratulations! A uniform magnetic field oriented along the z axis can only cause all spins to flip along the x-axis. For other angles θ, the spin flip probability is less than 1, and along the z-axis the spin flip probability is zero.'
if(!$('#Stage_Tick4').hasClass('showing'))totalScore+=30;$('#Stage_Tick4').show();$('#Stage_Tick4').addClass('showing');}
else feedbackText='This is not yet correct.  Consider the maximal spin flip probability for the different orientations of the SGAs. The maximal spin flip probability is achieved when the spin precession angle is 180°';break;}
if(correct)feedbackText=('<span style="color:green">'+feedbackText+'</span>')
else feedbackText=('<span style="color:red">'+feedbackText+'</span>')
if($('#Stage_feedback').text()!=''){$('#Stage_feedback').fadeOut(250)};write=setTimeout(function(){$('#Stage_feedback').html(feedbackText)},250);$('#Stage_feedback').fadeIn(250);addedFeedback(currentScore);}
function fireworks(){var number=6;var spread=75;var delay_const=500;var speed_const=700;var speed_const_offset=500;var x0=438,y0=400;var totalDelay=0;$('#Stage .star').hide();$('#Stage .star').css({'left':x0+'px','top':y0+'px','opacity':1});$('#Stage .star').fadeIn(500);for(var i=0;i<number;i++){var left=Math.round(Math.random()*spread);if(Math.random()<0.5)
left='-='+left+'px';else
left='+='+left+'px';var delay1=Math.round((Math.random()+.25)*delay_const);totalDelay+=delay1;var speed=Math.round((Math.random()+.5)*speed_const)+speed_const_offset;$('#Stage_stars'+i).delay(delay1).animate({'left':left,'top':'-=500px','opacity':0},speed);}
$('#Stage .star').delay(1000).fadeOut();}
function startScoreAnimation(a,b){var startValue=a;var endValue=b;var delayScore=150;var delayScoreCountdown=delayScore;if(b>a)
{function recursiveFunction(){clearInterval(scoreIncrementer);startValue++;$('#Stage_textScore').text(+startValue+'/100');if(startValue==endValue)
return;delayScoreCountdown=delayScoreCountdown-8;scoreIncrementer=setInterval(function(){recursiveFunction()},delayScoreCountdown);}
var scoreIncrementer=setInterval(function(){recursiveFunction()},delayScoreCountdown);$('#Stage_textScore').fadeOut(500);$('#Stage_textScore').fadeIn(500);}}
var totalScore=0;var feedbackProb=1;function addedFeedback(score){if(totalScore<100){startScoreAnimation(score,totalScore);if(totalScore>score&&Math.random()<feedbackProb){fireworks();feedbackProb=0.25;}else
feedbackProb=2*feedbackProb;}else
$('#Stage_textScore').text('100/100');if(totalScore==100){AdobeEdge.getComposition(compId).getStage().getSymbol('fancyExcellent').play();totalScore=101;}}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);$(element).data('timeout_val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();sym.$('probabilityNegativeCopy').html('P<sub>&#8211;</sub> : spin flip probability');sym.$('checkbox_label').html('Spin expectation value  &#x2329;<b>S</b>&#x232A;');sym.$('arrow').html('&#8407;');sym.$('arrow2').html('&#8407;');sym.$('arrow').hide();sym.$('arrow2').hide();sym.$('box_labelCopy2').html('Spin expectation value  &#x2329;<b>S</b>&#x232A; as vector');sym.getSymbol('sgaRight').$('TextCopy6').html('&#8211;');sym.$('textSlider3').html('SGA 2 angle &theta;<sub>2</sub>');sym.$('outcomePlusCopy').html('N<sub>+</sub>&nbsp;&nbsp;= ');sym.$('outcomeMinusCopy').html('N<sub>&#8211;</sub>&nbsp;&nbsp;=');sym.stop('intro');$('#Stage .tick').hide();$('#Stage_intro_text1').html('<span style="line-height:1.3;">In this simulation, you can send the particles through a Stern-Gerlach apparatus (SGA), '+'which consists of a region of <i>non-uniform</i> magnetic field aligned along a given axis. '+'An SGA allows you to measure the component of spin angular momentum along this axis. '+'For spin &#189; particles, the particles separate into two discrete streams, one with spin component +&#295;/2, the other with spin component -&#295;/2 along this axis. '+'The particles pass through two subsequent SGAs that can be jointly rotated. Without any other components inserted, all particles that pass the first SGA pass the second with the same deflection. '+'<br><br>You can insert a region of <i>uniform</i> magnetic field in between the two SGAs and change its length, i.e. the time that the particles spend in this region. '+'Due to its spin, the spin &#189; particle acts like a small bar magnet when in an external magnetic field. This gives rise to two different energy states, depending on whether '+'the spin component S<sub>z</sub> is parallel or antiparallel to the magnetic field.</span>');$('#Stage_intro_text2').html('<span style="line-height:1.3;">The two spin components evolve in time with different time-dependent phase terms. '+'This gives rise to a so-called spin precession, where the probability of measuring a particular spin component changes with time.'+'<br><br>The simulation also shows you the expectation value of the z-component of spin using the semi-classical vector model of angular momentum. '+'The vector depicting this expectation value rotates around the uniform magnetic field axis by an angle that depends on the time spent in the uniform magnetic field and its field strength. '+'In the simulation, the spin &#189; particles are assumed to have negative charge, which leads to a counterclockwise precession of the spin vector.'+'<br><br><b>Press the Controls button to send particles through the SGAs and change their orientation.</b> Then try some of the challenges in the Challenges tab!</span>');$('#Stage .back_arrow').each(function(){$(this).css({'background-color':'rgba(0,0,255,1.00)','opacity':0.5,'width':2});console.log($(this))});$('#Stage .front_arrow').each(function(){$(this).css({'background-color':'rgba(0,0,255,1.00)','opacity':1,'width':2});});sym.$('negativeBar').css({'background':'#7db9e8','background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzdkYjllOCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjUyJSIgc3RvcC1jb2xvcj0iIzFlNTc5OSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM3ZGI5ZTgiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)','background':'-moz-linear-gradient(top,  #7db9e8 0%, #1e5799 52%, #7db9e8 100%)','background':'-webkit-gradient(linear, left top, left bottom, color-stop(0%,#7db9e8), color-stop(52%,#1e5799), color-stop(100%,#7db9e8))','background':'-webkit-linear-gradient(top,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','background':'-o-linear-gradient(top,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','background':'-ms-linear-gradient(top,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','background':'linear-gradient(to bottom,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','filter':'progid:DXImageTransform.Microsoft.gradient( startColorstr=#7db9e8, endColorstr=#7db9e8,GradientType=0 )',});sym.$('positiveBar').css({'background':'#88ea91','background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzg4ZWE5MSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjUwJSIgc3RvcC1jb2xvcj0iIzAwZDMwMCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjUzJSIgc3RvcC1jb2xvcj0iIzAwZDMwMCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM4OGVhOTEiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)','background':'-moz-linear-gradient(top,  #88ea91 0%, #00d300 50%, #00d300 53%, #88ea91 100%)','background':'-webkit-gradient(linear, left top, left bottom, color-stop(0%,#88ea91), color-stop(50%,#00d300), color-stop(53%,#00d300), color-stop(100%,#88ea91))','background':'-webkit-linear-gradient(top,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','background':'-o-linear-gradient(top,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','background':'-ms-linear-gradient(top,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','background':'linear-gradient(to bottom,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','filter':'progid:DXImageTransform.Microsoft.gradient( startColorstr=#88ea91, endColorstr=#88ea91,GradientType=0 )',});changeTexts()
clearMeasurements()
rotateMagnetic()
sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});yepnope({load:"normalize.css"});$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));angleInput=slider.data('val')/2;rotateInput();},20));}});$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider2');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));angleMagnetic=slider.data('val');rotateMagnetic()
setupNumber();resetValues();updateValues()},20));}});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){challenges=false;sym.stop('simulation');sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);showBoxes()
rotateInput();rotateMagnetic();sym_enable(sym.$('downRadio'));sym_enable(sym.$('upRadio'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_explanation}","click",function(sym,e){sym.stop('explanation');blockUp=false;sym_features();if(streaming)sendContinuous();sym_step(1);sym_select(sym.$('downRadio'));sym_disable(sym.$('downRadio'));sym_disable(sym.$('upRadio'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio0}","click",function(sym,e){angleRight=0;rotateRight()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_singleButton}","click",function(sym,e){sendParticle();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_fastForwardButton}","click",function(sym,e){multiple=true
for(var i=0;i<99;i++){sendParticle();}
multiple=false
sendParticle();updateValues()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_clearMeasurements}","click",function(sym,e){clearMeasurements()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_continousButton}","click",function(sym,e){sendContinuous();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_controlsButton}","click",function(sym,e){sym.stop('simulation');showBoxes()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_introButton}","click",function(sym,e){sym.stop('intro');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_showProbabilitiesCheckbox}","click",function(sym,e){showBoxes()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_showHistCheckbox}","click",function(sym,e){showBoxes()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_showExpectationsCheckbox}","click",function(sym,e){showBoxes()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_upRadio}","click",function(sym,e){blockUp=true;rotateInput()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_downRadio}","click",function(sym,e){blockUp=false;rotateInput()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonSubmit}","click",function(sym,e){submit();});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'highlight_1'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight_1");
//Edge symbol end:'highlight_1'

//=========================================================

//Edge symbol: 'blueFlashGap'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
})("blueFlashGap");
//Edge symbol end:'blueFlashGap'

//=========================================================

//Edge symbol: 'greenFlashGap'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
})("greenFlashGap");
//Edge symbol end:'greenFlashGap'

//=========================================================

//Edge symbol: 'Untitled'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",490,function(sym,e){sym.play(0);});
//Edge binding end
})("sgasRight");
//Edge symbol end:'sgasRight'

//=========================================================

//Edge symbol: 'redFlash'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
})("redFlash");
//Edge symbol end:'redFlash'

//=========================================================

//Edge symbol: 'sgaInput'
(function(symbolName){})("sgaInput");
//Edge symbol end:'sgaInput'

//=========================================================

//Edge symbol: 'sgaRight'
(function(symbolName){})("sgaRight");
//Edge symbol end:'sgaRight'

//=========================================================

//Edge symbol: 'greenFlash'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
})("greenFlash");
//Edge symbol end:'greenFlash'

//=========================================================

//Edge symbol: 'blueFlash'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
})("blueFlash");
//Edge symbol end:'blueFlash'

//=========================================================

//Edge symbol: 'cone'
(function(symbolName){})("cone");
//Edge symbol end:'cone'

//=========================================================

//Edge symbol: 'magneticField'
(function(symbolName){})("magneticField");
//Edge symbol end:'magneticField'

//=========================================================

//Edge symbol: 'fancyExcellent'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.stop(0);});
//Edge binding end
})("fancyExcellent");
//Edge symbol end:'fancyExcellent'

//=========================================================

//Edge symbol: 'steps_1'
(function(symbolName){})("steps_1");
//Edge symbol end:'steps_1'
})(jQuery,AdobeEdge,"EDGE-19890435");