/*  Copyright 2017, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
Chart.js http://chartjs.org/ Version: 1.0.2 Copyright 2015 Nick Downie Released under the MIT license https://github.com/nnnick/Chart.js/blob/master/LICENSE.md

*/

(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;function initSim(){drawGraph();}
var pi=Math.PI;var energy=1;var e=[[4.9329,18.0683,-100,-100],[5.94223,22.97675,46.49749,-100],[6.477203,25.40857,54,5109,54.5109],[6.82714,26.95144,58.90455,96.2869],[9.86960,39.4784,88.82644,157.9136]];var depthE1=[2.53,5.06,7.60,10.13];var quantum_number=1;var potential=1;var show_fraction=false;var show_energy=false;var is_valid_state=true;var simulation_quantum_number,simulation_potential,simulation_show_fraction,simulation_is_valid_state,simulation_show_energy,simulation_energy;var graph_left=null;var graph_middle=null;var graph_right=null;var graph2_left=null;var graph2_middle=null;var graph2_right=null;var graph_energy_left=null;var graph_energy_right=null;var graph_color=["#A5DF00","#01DF3A","#01DFD7","#01A9DB","#0174DF"];var frac=[[0.0609039,0.312008,0,0],[0.027518,0.127677,0.480409,0],[0.0168056,0.074934,0.222727,0],[0.0117178,0.0511081,0.140073,0.490392],[0,0,0,0]];var wellBottominf,scalefactor;var helpTexts=new Array();helpTexts["simulation"]="The graphs show you the ground state and first few excited state wavefunctions and probability densities for a one-dimensional finite well and an infinite well. <strong>How does the well depth effect the shape of the probability density, the number of energy levels and the energy values?</strong> Use the “?” buttons for more information. Then try the Challenges! ";helpTexts["potential"]="You can change the depth of the finite well and also choose a well that is infinitely deep. For the finite wells, only a finite number of bound state energy levels <nobr>(E < V)</nobr> exist and the graphs show you all the possible states. In contrast, the infinite well has an infinite number of energy levels, so only the first few states are displayed. How does the well depth effect the number of possible bound state energy levels? ";helpTexts["energy"]="The de Broglie momentum p=h/&lambda;, where h is <br>Planck’s constant and &lambda; is wavelength. The finite well wavefunctions penetrate beyond the edges of the well. This leads to an increase in their average wavelength (decrease in average momentum) compared with the infinite well wavefunctions, and thus a decrease in total energy. The energy and well depth V shown are in units of the infinite well ground state energy, h<sup>2</sup>/8mL<sup>2</sup>. ";helpTexts["fraction"]="You can display the fraction beyond the edges of<br> the well, defined as the area under the probability density curve for x < 0 and x > L. Recall that the total area under the probability density curve equals one. The greater the difference V &ndash; E between the well depth and the energy level, the more rapidly the probability density decays to zero beyond the edges of the well. ";helpTexts["graph"]="For an infinite well, the quantum particle is <br>completely confined within the well. For a finite well, in contrast to a classical particle the wavefunction penetrates beyond the edges of the well, where it decays exponentially to zero. The total area under the probability density curve equals one. This leads to the amplitudes of the finite well wavefunctions being lower than the corresponding infinite well wavefunctions. ";var challenge_text=[];challenge_text[1]='For which of the following well depths does the ground state have the lowest energy? ';challenge_text[2]='Assume the well depth is 4V<sub>0</sub>. For which of the following states will the energy difference between '+'the finite well energy and the corresponding infinite well energy be greatest? ';challenge_text[3]='Which of the following statements is/are true concerning the <i>energy levels in a finite well of fixed depth</i>? '+'Choose one or more. ';challenge_text[4]='Which of the following statements is/are true concerning the <i>wavefunctions for a finite well of fixed depth</i>? '+'Choose one or more. ';challenge_text[4]='Which of the following statements is/are true concerning the <i>wavefunctions for a finite well of fixed depth</i>? '+'Choose one or more. ';challenge_text[5]='Which of the following is/are true concerning the <i>first excited state wavefunction '+'for finite wells of different depths</i>? Choose one or more.';function showHelp(key){$("#Stage_help_content").toggle(key!=undefined);$("#Stage_help_text").html(helpTexts[key])
$('.help').each(function(){$(this).removeClass('disabled');sym_enable($(this));});if(key=="graph")
sym_disable($('#Stage_buttonHelpGraph'));else if(key=="potential")
sym_disable($('#Stage_buttonHelpPotential'));else if(key=="energy")
sym_disable($('#Stage_buttonHelpEnergy'));else if(key=="fraction")
sym_disable($('#Stage_buttonHelpFraction'));else
sym_disable($('#Stage_buttonHelpMain'));}
function updateEnergyPanel(){$("#Stage_energy_panel").toggle();show_energy=$('#Stage_checkbox_show_energy').hasClass('selected');}
function initializePositions(){wellBottominf=$('#Stage_well_bottom').css("top");wellBottominf=parseInt(wellBottominf,10);var e4inf=$('#Stage_e4').css("top");e4inf=parseInt(e4inf,10);var e1inf=$('#Stage_e1').css("top");e1inf=parseInt(e1inf,10);scalefactor=(e1inf-e4inf)/(4*4*pi*pi-pi*pi);}
function elevels(w){potential=w;var i;for(i=1;i<5;i++)
{$('#Stage_e'+i).css("top",wellBottominf-e[potential-1][i-1]*scalefactor);}
if(potential<5)
{$('#Stage_well_left').css("top",wellBottominf-potential*25*scalefactor).css("height",potential*25*scalefactor);$('#Stage_well_right').css("top",wellBottominf-potential*25*scalefactor).css("height",potential*25*scalefactor);$('#Stage_well_edge1').show().css("top",wellBottominf-potential*25*scalefactor);$('#Stage_well_edge2').show().css("top",wellBottominf-potential*25*scalefactor);$('#Stage_inf1').hide();$('#Stage_inf2').hide();}
else
{$('#Stage_well_left').css("top",wellBottominf-7*25*scalefactor).css("height",7*25*scalefactor);$('#Stage_well_right').css("top",wellBottominf-7*25*scalefactor).css("height",7*25*scalefactor);$('#Stage_inf1').show();$('#Stage_inf2').show();$('#Stage_well_edge1').hide();$('#Stage_well_edge2').hide();}}
function updateQuantumNumber(n){quantum_number=n;is_valid_state=((potential==1&&quantum_number>2)||(potential==2&&quantum_number>3)||(potential==3&&quantum_number>3))?false:true;if(show_fraction)
{updateFraction();}
drawGraph();}
function updatePotential(w){potential=w;is_valid_state=((potential==1&&quantum_number>2)||(potential==2&&quantum_number>3)||(potential==3&&quantum_number>3))?false:true;if(show_fraction)
{updateFraction();}
drawGraph();elevels(potential);}
function updateFraction(){show_fraction=$('#Stage_checkbox_show_fraction').hasClass('selected');if(show_fraction&&is_valid_state)
{$("#Stage_fraction_value").html("fraction beyond edges of well = "+frac[potential-1][quantum_number-1].toFixed(3)).fadeIn(300);}
else if(show_fraction&&(!is_valid_state))
{$("#Stage_fraction_value").html("fraction beyond edges of well").fadeIn(300);}
else
{$("#Stage_fraction_value").hide();}}
function drawGraph(){$('#Stage_e_selected').css("top",wellBottominf+7-e[potential-1][quantum_number-1]*scalefactor).css("background-color",graph_color[quantum_number]);if(potential<5)
{$("#Stage_depth_text").html("V = "+depthE1[potential-1].toFixed(2)+" (h<sup>2</sup>/8mL<sup>2</sup>)");}
else
{$("#Stage_depth_text").html("V = &infin;");}
var funcWave=[function(x){return wavefunction(quantum_number,potential,x,0);}];var funcWave2=[function(x){return wavefunction(quantum_number,potential,x,1);}];var funcWave3=[function(x){return wavefunction(quantum_number,potential,x,2);}];var funcProb=[function(x){var t=wavefunction(quantum_number,potential,x,0);return t*t;}];var funcProb2=[function(x){var t=wavefunction(quantum_number,potential,x,1);return t*t;}];var funcProb3=[function(x){var t=wavefunction(quantum_number,potential,x,2);return t*t;}];var xaxis_right={minX:0.5,maxX:1.25,step:0.05}
var xaxis_middle={minX:-0.5,maxX:0.5,step:0.04}
var xaxis_middle2={minX:-0.5,maxX:0.5,step:0.02}
var xaxis_left={minX:-1.25,maxX:-0.5,step:0.05}
var color=[{strokeColor:"#000000"}]
var configWave={datasetStrokeWidth:1,scaleOverride:true,scaleSteps:20,scaleStepWidth:0.15,scaleStartValue:-1.5,scaleShowGridLines:true,scaleShowHorizontalLines:true,scaleShowVerticalLines:false,bezierCurve:true,showScale:false}
var configProb={datasetStrokeWidth:1,scaleOverride:true,scaleSteps:20,scaleStepWidth:0.1,scaleStartValue:0,scaleShowGridLines:true,scaleShowHorizontalLines:true,scaleShowVerticalLines:false,bezierCurve:true,showScale:false}
var color=[{strokeColor:graph_color[quantum_number]}];if(graph_left!=null){graph_left.destroy()};if(graph_middle!=null){graph_middle.destroy()};if(graph_right!=null){graph_right.destroy()};if(graph2_left!=null){graph2_left.destroy()};if(graph2_middle!=null){graph2_middle.destroy()};if(graph2_right!=null){graph2_right.destroy()};if(potential==1)
{$("#Stage_slider_number_label2").html("<font color='#B5B8BA'>2<sup>nd</sup> excited <br>state</font>");$("#Stage_slider_number_label3").html("<font color='#B5B8BA'>3<sup>rd</sup> excited <br>state</font>");}
else if(potential==2||potential==3)
{$("#Stage_slider_number_label2").html("<font color='#000000'>2<sup>nd</sup> excited <br>state</font>");$("#Stage_slider_number_label3").html("<font color='#B5B8BA'>3<sup>rd</sup> excited <br>state</font>");}
else
{$("#Stage_slider_number_label2").html("<font color='#000000'>2<sup>nd</sup> excited <br>state</font>");$("#Stage_slider_number_label3").html("<font color='#000000'>3<sup>rd</sup> excited <br>state</font>");}
if(is_valid_state)
{$("#Stage_warningInvalidState").hide();$("#Stage_warningWhiteBox").hide();graph_left=new FunctionGraph($('#Stage_graph_curve_left'),funcWave,xaxis_left,color,configWave);graph_middle=new FunctionGraph($('#Stage_graph_curve_middle'),funcWave2,xaxis_middle,color,configWave);graph_right=new FunctionGraph($('#Stage_graph_curve_right'),funcWave3,xaxis_right,color,configWave);graph2_left=new FunctionGraph($('#Stage_graph_curve2_left'),funcProb,xaxis_left,color,configProb);if(quantum_number>2)
{graph2_middle=new FunctionGraph($('#Stage_graph_curve2_middle'),funcProb2,xaxis_middle2,color,configProb);}
else
{graph2_middle=new FunctionGraph($('#Stage_graph_curve2_middle'),funcProb2,xaxis_middle,color,configProb);}
graph2_right=new FunctionGraph($('#Stage_graph_curve2_right'),funcProb3,xaxis_right,color,configProb);if(show_fraction)
{$("#Stage_fraction_value").html("fraction beyond edges of well = "+frac[potential-1][quantum_number-1].toFixed(3)).fadeIn(300);}
$("#Stage_energy_text").show().html("E<sub>"+quantum_number+"</sub> = "+energy.toFixed(2)+" (h<sup>2</sup>/8mL<sup>2</sup>)");}
else
{$("#Stage_fraction_value").html("fraction beyond edges of well");$("#Stage_energy_text").hide();var warningState=(quantum_number==3)?"second":"third";$("#Stage_warningInvalidState").html("No "+warningState+" <br>excited state - <br>potential well <br>not deep enough").show();$("#Stage_warningWhiteBox").show();}}
function wavefunction(n,V,x,indexGraph){var wavenumber;var func0,func1,func2;var normalization;if(V==1)
{switch(n){case 1:normalization=0.522328;wavenumber=2.2210210071622242579;func0=normalization*9.391583591825928779*Math.exp(4.47962785125551461*x);func1=normalization*2.2512168880331522280*Math.cos(wavenumber*x);func2=normalization*9.391583591825928779*Math.exp(-4.47962785125551461*x);break;case 2:normalization=0.906341;wavenumber=4.2506903827749386110;func0=(-1)*normalization*-3.72996766989926308*Math.exp(2.6327991320616629744*x);func1=(-1)*normalization*1.176279509855972283*Math.sin(wavenumber*x);func2=(-1)*normalization*3.72996766989926308*Math.exp(-2.6327991320616629744*x);break;}}
else if(V==2)
{switch(n){case 1:normalization=0.42738;wavenumber=2.4376715818662337093;func0=normalization*27.62720249732838964*Math.exp(6.63760177013970715713*x);func1=normalization*2.900746706187551302*Math.cos(wavenumber*x);func2=normalization*27.62720249732838964*Math.exp(-6.63760177013970715713*x);break;case 2:normalization=0.814688;wavenumber=4.7934074037269774588;func0=(-1)*normalization*-13.45289559222604628*Math.exp(5.1983887370891566793*x);func1=(-1)*normalization*1.475165204269423830*Math.sin(wavenumber*x);func2=(-1)*normalization*13.45289559222604628*Math.exp(-5.1983887370891566793*x);break;case 3:normalization=0.9482;wavenumber=6.8189077099333823122;func0=normalization*2.54911961059511173*Math.exp(1.871496097621118640*x);func1=normalization*-1.036979544621899044*Math.cos(wavenumber*x);func2=normalization*2.54911961059511173*Math.exp(-1.871496097621118640*x);break;}}
else if(V==3)
{switch(n){case 1:normalization=0.37298;wavenumber=2.5450352388083270741;func0=normalization*62.73533523834255023*Math.exp(8.27784969863694985781*x);func1=normalization*3.402803193365375524*Math.cos(wavenumber*x);func2=normalization*62.73533523834255023*Math.exp(-8.27784969863694985781*x);break;case 2:normalization=0.726426;wavenumber=5.0406926831710938111;func0=(-1)*normalization*-33.82021473651517334*Math.exp(7.0421173856891507278*x);func1=(-1)*normalization*1.718068246207033372*Math.sin(wavenumber*x);func2=(-1)*normalization*33.82021473651517334*Math.exp(-7.0421173856891507278*x);break;case 3:normalization=1.00408;wavenumber=7.3831527102486230946;func0=normalization*9.61420724389868581*Math.exp(4.5264838514180530930*x);func1=normalization*-1.172975066034189854*Math.cos(wavenumber*x);func2=normalization*9.61420724389868581*Math.exp(-4.5264838514180530930*x);break;}}
else if(V==4)
{switch(n){case 1:normalization=0.336314;wavenumber=2.6128800167390219196;func0=normalization*124.7490894418802529*Math.exp(9.65260887108381122213*x);func1=normalization*3.827194488815601008*Math.cos(wavenumber*x);func2=normalization*124.7490894418802529*Math.exp(-9.65260887108381122213*x);break;case 2:normalization=0.660918;wavenumber=5.1914781592995985635;func0=(-1)*normalization*-71.7668274255521587*Math.exp(8.5468447114426533215*x);func1=(-1)*normalization*1.926233664700447632*Math.sin(wavenumber*x);func2=(-1)*normalization*71.7668274255521587*Math.exp(-8.5468447114426533215*x);break;case 3:normalization=0.9476;wavenumber=7.6749342129980974396;func0=normalization*24.66250581156164815*Math.exp(6.4105682139847224843*x);func1=normalization*-1.302942764390634514*Math.cos(wavenumber*x);func2=normalization*24.66250581156164815*Math.exp(-6.4105682139847224843*x);break;case 4:normalization=0.972087;wavenumber=9.8125903017127513600;func0=(-1)*normalization*-2.62076589593773715*Math.exp(1.926933203495350856*x);func1=(-1)*normalization*-1.01909890177056888*Math.sin(wavenumber*x);func2=(-1)*normalization*2.62076589593773715*Math.exp(-1.926933203495350856*x);break;}}
else
{wavenumber=n*pi;func0=0*x;func2=0*x;normalization=1.41421356;if(n==1)
func1=normalization*Math.cos(wavenumber*x);else if(n==2)
func1=(-1)*normalization*Math.sin(wavenumber*x);else if(n==3)
func1=(-1)*normalization*Math.cos(wavenumber*x);else
func1=normalization*Math.sin(wavenumber*x);}
energy=wavenumber*wavenumber/(pi*pi);if(indexGraph==0)
return func0;else if(indexGraph==1)
return func1;else
return func2;}
var correct_answer,correct=false,current_challenge=1,score_for_challenge=[20,20,20,20,20],challenge_complete=[false,false,false,false,false],totalScore=0,randomlabel=[0,0,0],randomcorrect=[0,0,0],fireworkProb=1;function challengeReset(){$('#Stage_feedback_text').hide();};function step_functions(step){clearTimeout(AdobeEdge.step_animation);current_challenge=step;challengeReset();switch(step){case 1:quantum_number=1;potential=1;show_fraction=false;show_energy=true;is_valid_state=true;sym_select($('#Stage_checkbox_show_energy'));$("#Stage_energy_panel").show();updateQuantumNumber(quantum_number);updatePotential(potential);drawGraph();$('#Stage .group_answer').each(function(){$(this).show();sym_deselect($(this));});$('#Stage .group_tick_answer').each(function(){$(this).hide();sym_deselect($(this));});$('#Stage .radio_text').css('top',16);$('#Stage_radio_label_answer0').html('V<sub>0</sub>');$('#Stage_radio_label_answer1').html('2V<sub>0</sub>');$('#Stage_radio_label_answer2').html('3V<sub>0</sub>');$('#Stage_radio_label_answer3').html('4V<sub>0</sub>');correct_answer=0;break;case 2:quantum_number=4;potential=4;show_fraction=false;show_energy=true;is_valid_state=true;sym_select($('#Stage_checkbox_show_energy'));$("#Stage_energy_panel").show();updateQuantumNumber(quantum_number);updatePotential(potential);drawGraph();$('#Stage .group_answer').each(function(){$(this).show();sym_deselect($(this));});$('#Stage .group_tick_answer').each(function(){$(this).hide();sym_deselect($(this));});$('#Stage .radio_text').css('top',16);$('#Stage_radio_label_answer0').html('ground state');$('#Stage_radio_label_answer1').html('first excited state');$('#Stage_radio_label_answer2').html('second excited state');$('#Stage_radio_label_answer3').html('third excited state');correct_answer=3;break;case 3:quantum_number=4;potential=4;show_fraction=false;show_energy=true;is_valid_state=true;sym_select($('#Stage_checkbox_show_energy'));$("#Stage_energy_panel").show();updateQuantumNumber(quantum_number);updatePotential(potential);drawGraph();$('#Stage .group_answer').each(function(){$(this).hide();sym_deselect($(this));});for(i=0;i<4;i++)
{$('#Stage_checkbox_answer'+i).show();sym_deselect($('#Stage_checkbox_answer'+i));}
$('#Stage .radio_text').css('top',16);randomlabel[0]=Math.random();randomcorrect[0]=(randomlabel[0]<0.5)?1:0;randomlabel[0]=(randomlabel[0]<0.5)?"smaller":"larger";randomlabel[1]=Math.random();randomcorrect[1]=(randomlabel[1]<0.5)?1:0;randomlabel[1]=(randomlabel[1]<0.5)?"higher":"lower";if(randomcorrect[0]==0&&randomcorrect[1]==0)
{randomlabel[2]="Only a finite number of bound state energy levels exist. "
randomcorrect[2]=1;}
else
{randomlabel[2]=Math.random();randomcorrect[2]=(randomlabel[2]<0.5)?1:0;randomlabel[2]=(randomlabel[2]<0.5)?"Only a finite number of bound state energy levels exist. ":"An infinite number of bound state energy levels exist. ";}
$('#Stage_checkbox_label_answer0').html('The '+randomlabel[0]+' <nobr>V - E</nobr> (well depth - energy), the lower the energy compared with the infinite well. ');$('#Stage_checkbox_label_answer1').html('The '+randomlabel[1]+' the excited state, the lower the energy compared with the infinite well.');$('#Stage_checkbox_label_answer2').html(randomlabel[2]);break;case 4:quantum_number=4;potential=4;show_fraction=false;show_energy=false;is_valid_state=true;sym_deselect($('#Stage_checkbox_show_energy'));$("#Stage_energy_panel").hide();updateQuantumNumber(quantum_number);updatePotential(potential);drawGraph();$('#Stage .group_answer').each(function(){$(this).hide();sym_deselect($(this));});for(i=0;i<4;i++)
{$('#Stage_checkbox_answer'+i).show();sym_deselect($('#Stage_checkbox_answer'+i));}
$('#Stage .radio_text').css('top',16);randomlabel[0]=Math.random();randomcorrect[0]=(randomlabel[0]<0.5)?0:1;randomlabel[0]=(randomlabel[0]<0.5)?"higher":"lower";randomlabel[1]=Math.random();randomcorrect[1]=(randomlabel[1]<0.5)?1:0;randomlabel[1]=(randomlabel[1]<0.5)?"higher":"lower";if(randomcorrect[0]==0&&randomcorrect[1]==0)
{randomlabel[2]="Only a finite number of bound state wavefunctions exist. "
randomcorrect[2]=1;}
else
{randomlabel[2]=Math.random();randomcorrect[2]=(randomlabel[2]<0.5)?1:0;randomlabel[2]=(randomlabel[2]<0.5)?"Only a finite number of bound state wavefunctions exist. ":"An infinite number of bound state wavefunctions exist. ";}
$('#Stage_checkbox_label_answer0').html('The '+randomlabel[0]+' the excited state, the lower the probability density fraction for <nobr>x < 0</nobr> and <nobr>x > L</nobr>.');$('#Stage_checkbox_label_answer1').html('The '+randomlabel[1]+' the excited state, the lower the amplitude of the wavefunction.');$('#Stage_checkbox_label_answer2').html(randomlabel[2]);break;case 5:quantum_number=4;potential=4;show_fraction=false;show_energy=true;is_valid_state=true;sym_deselect($('#Stage_checkbox_show_energy'));$("#Stage_energy_panel").hide();updateQuantumNumber(quantum_number);updatePotential(potential);drawGraph();$('#Stage .group_answer').each(function(){$(this).hide();sym_deselect($(this));});for(i=0;i<4;i++)
{$('#Stage_checkbox_answer'+i).show();sym_deselect($('#Stage_checkbox_answer'+i));}
$('#Stage .radio_text').css('top',16);randomlabel[0]=Math.random();randomcorrect[0]=(randomlabel[0]<0.5)?0:1;randomlabel[0]=(randomlabel[0]<0.5)?"greater":"smaller";randomlabel[1]=Math.random();randomcorrect[1]=(randomlabel[1]<0.5)?1:0;randomlabel[1]=(randomlabel[1]<0.5)?"greater":"smaller";if(randomcorrect[0]==0&&randomcorrect[1]==0)
{randomlabel[2]="smaller"
randomcorrect[2]=1;}
else
{randomlabel[2]=Math.random();randomcorrect[2]=(randomlabel[2]<0.5)?0:1;randomlabel[2]=(randomlabel[2]<0.5)?"greater":"smaller";}
$('#Stage_checkbox_label_answer0').html('The '+randomlabel[0]+' the well depth, the greater the average wavelength of the wavefunction. ');$('#Stage_checkbox_label_answer1').html('The '+randomlabel[1]+' the well depth, the higher the amplitude of the wavefunction. ');$('#Stage_checkbox_label_answer2').html('The '+randomlabel[2]+' the well depth, the greater the probability density fraction for <nobr>x < 0</nobr> and <nobr>x > L</nobr>.');break;}
var text=$('#Stage_challenge_text');text.html(challenge_text[step]);}
function challengeSubmit(){var feedback=$('#Stage_feedback_text'),arrayselected=[0,0,0],none_selected=true,feedback_str;correct=false;switch(current_challenge){case 1:$('.group_answer').each(function(index){if($(this).hasClass('selected')){none_selected=false;};});if($('#Stage_radio_answer'+correct_answer).hasClass('selected')){correct=true;feedback_str="Correct, congratulations! The smaller the well depth, the further the ground state wavefunction penetrates beyond the edges of the well. "+"This leads to a larger average wavelength of the wavefunction and thus a lower ground state energy.  ";}
else{correct=false;feedback_str="This is not yet correct. The further the ground state wavefunction penetrates beyond the edges of the well, "+"the larger the average wavelength of the wavefunction and thus the lower the ground state energy. ";}
if(none_selected){feedback_str="Please select an option.";};break;case 2:$('.group_answer').each(function(index){if($(this).hasClass('selected')){none_selected=false;};});if($('#Stage_radio_answer'+correct_answer).hasClass('selected')){correct=true;feedback_str="Correct, congratulations! The smaller the well depth, the further the wavefunction of a given state "+"penetrates beyond the edges of the well. This leads to a larger average wavelength of this state compared "+"with the infinite well wavefunction, and thus a lower corresponding energy. ";}
else{correct=false;feedback_str="This is not yet correct. The further the wavefunction of a given state penetrates beyond the edges of the well, "+"the larger the average wavelength of this state compared with the infinite well wavefunction, "+"and thus the lower the corresponding energy.  ";}
if(none_selected){feedback_str="Please select an option.";};break;case 3:$('.group_tick_answer').each(function(index){if($(this).hasClass('selected')){none_selected=false;};});arrayselected[0]=($('#Stage_checkbox_answer0').hasClass('selected')==true)?1:0;arrayselected[1]=($('#Stage_checkbox_answer1').hasClass('selected')==true)?1:0;arrayselected[2]=($('#Stage_checkbox_answer2').hasClass('selected')==true)?1:0;if(arrayselected[0]!=randomcorrect[0]){correct=false;feedback_str="This is not yet correct. The smaller the difference <nobr>V – E</nobr> between the well depth and the energy, "+"the further the wavefunction penetrates beyond the edges of the well. This implies a larger average wavelength "+"compared with the corresponding infinite well wavefunction, and thus a lower energy. ";}
else if(arrayselected[1]!=randomcorrect[1])
{correct=false;feedback_str="This is not yet correct. The smaller the difference <nobr>V – E</nobr> between the well depth and the energy, "+"the further the wavefunction penetrates beyond the edges of the well. This implies a larger average wavelength "+"compared with the corresponding infinite well wavefunction, and thus a lower energy. ";}
else if(arrayselected[2]!=randomcorrect[2])
{correct=false;feedback_str="This is not yet correct. For a finite well, only a finite number of bound state energy levels <nobr>(E < V)</nobr> exist "+"as the particle can have an energy greater than the well depth. ";}
else{correct=true;feedback_str="Correct, congratulations! "+"The smaller the difference <nobr>V – E</nobr> (i.e. the higher the excited state), "+"the further the wavefunction penetrates beyond the edges of the well. This implies a larger average wavelength compared with "+"the corresponding infinite well wavefunction, and thus a lower energy. ";}
if(none_selected){feedback_str="Please select an option.";};break;case 4:$('.group_tick_answer').each(function(index){if($(this).hasClass('selected')){none_selected=false;};});arrayselected[0]=($('#Stage_checkbox_answer0').hasClass('selected')==true)?1:0;arrayselected[1]=($('#Stage_checkbox_answer1').hasClass('selected')==true)?1:0;arrayselected[2]=($('#Stage_checkbox_answer2').hasClass('selected')==true)?1:0;if(arrayselected[0]!=randomcorrect[0]){correct=false;feedback_str="This is not yet correct. The smaller the difference <nobr>V – E</nobr> between the well depth and the energy, "+"the further the wavefunction penetrates beyond the edges of the well. ";}
else if(arrayselected[1]!=randomcorrect[1])
{correct=false;feedback_str="This is not yet correct. Recall that the total area under the probability density curve equals one, "+"and thus the total area under the wavefunction graph is constant. The smaller the difference V – E between the well depth "+"and the energy, the further the wavefunction penetrates beyond the edges of the well. ";}
else if(arrayselected[2]!=randomcorrect[2])
{correct=false;feedback_str="This is not yet correct. For a finite well, only a finite number of bound state energy levels <nobr>(E < V)</nobr> "+"exist as the particle can have an energy greater than the well depth. ";}
else{correct=true;feedback_str="Correct, congratulations! "+"The smaller the difference <nobr>V – E</nobr> between the well depth and the energy "+"(i.e. the higher the excited state), the further the wavefunction penetrates beyond the edges of the well. "+"Due to normalization, this implies that the amplitude of the wavefunction decreases. ";}
if(none_selected){feedback_str="Please select an option.";};break;case 5:$('.group_tick_answer').each(function(index){if($(this).hasClass('selected')){none_selected=false;};});arrayselected[0]=($('#Stage_checkbox_answer0').hasClass('selected')==true)?1:0;arrayselected[1]=($('#Stage_checkbox_answer1').hasClass('selected')==true)?1:0;arrayselected[2]=($('#Stage_checkbox_answer2').hasClass('selected')==true)?1:0;if(arrayselected[0]!=randomcorrect[0]){correct=false;feedback_str="This is not yet correct. The smaller the well depth, the further the first excited state wavefunction "+"penetrates beyond the edges of the well, and thus the greater the average wavelength. ";}
else if(arrayselected[1]!=randomcorrect[1])
{correct=false;feedback_str="This is not yet correct. The smaller the well depth, the further the first excited state wavefunction "+"penetrates beyond the edges of the well. Normalization requires that the total area under the probability curve equals one. ";}
else if(arrayselected[2]!=randomcorrect[2])
{correct=false;feedback_str="This is not yet correct. The smaller the well depth, the further the first excited state wavefunction "+"penetrates beyond the edges of the well. ";}
else{correct=true;feedback_str="Correct, congratulations! "+"The smaller the well depth, the further the first excited state wavefunction penetrates beyond the edges of the well. "+"Due to normalization, this implies an increase in the average wavelength and decrease in the amplitude of the "+"first excited state wavefunction. ";}
if(none_selected){feedback_str="Please select an option.";};break;}
feedback.fadeOut("fast",function(){if(correct){feedback.css('color','#008f00');$('#Stage_steps_tick'+current_challenge).show();}else{feedback.css('color','#960000');}
feedback.html(feedback_str);feedback.fadeIn("fast");});if(correct&&!challenge_complete[current_challenge-1]){challenge_complete[current_challenge-1]=true;addScore(score_for_challenge[current_challenge-1]);}}
function addScore(score){var currentScore=totalScore;totalScore+=score;startScoreAnimation(currentScore,totalScore);if(Math.random()<fireworkProb&&totalScore!=100){fireworks();fireworkProb=0.25;}else
fireworkProb=2*fireworkProb;if(totalScore==100)
AdobeEdge.getComposition(compId).getStage().getSymbol('fancyExcellent').play();};function fireworks(){var star_id='#Stage_stars';var stick_ele=$('#Stage_stick');var number=6;var spread=75;var delay_const=500;var speed_const=700;var speed_const_offset=500;var x0=stick_ele.css('left'),y0=stick_ele.css('top');var totalDelay=0;$('#Stage .star').hide();$('#Stage .star').css({'left':x0,'top':y0,'opacity':1});$('#Stage .star').fadeIn(500);for(var i=0;i<number;i++){var left=Math.round(Math.random()*spread);if(Math.random()<0.5)
left='-='+left+'px';else
left='+='+left+'px';var delay1=Math.round((Math.random()+.25)*delay_const);totalDelay+=delay1;var speed=Math.round((Math.random()+.5)*speed_const)+speed_const_offset;$('#Stage_stars'+i).delay(delay1).animate({'left':left,'top':'-=500px','opacity':0},speed);}
$('#Stage .star').delay(1000).fadeOut();};function startScoreAnimation(startValue,endValue){var text_score=$('#Stage_text_score');var duration=800;var currentValue=startValue;var interval=duration/(endValue-startValue);if(endValue>startValue){function recursiveFunc(){text_score.text(++currentValue+'/100');if(currentValue==endValue)
return;setTimeout(recursiveFunc,interval);}
recursiveFunc();}else throw'startValue is larger than endValue';};function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();showHelp("simulation");sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});yepnope({load:"normalize.css"});$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider_number');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));updateQuantumNumber(slider.data('val'));},20));}});$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider_potential');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));updatePotential(slider.data('val'));},20));}});$("#Stage_energy_panel").hide();$("#Stage_fraction_value").hide();$("#Stage_graph_curve_yaxis_2_label").html("&psi;");$("#Stage_graph_curve2_yaxis_2_label").html("|&psi;|<sup>2</sup>");$("#Stage_slider_omega_label0").html("V<sub>0</sub>");$("#Stage_slider_omega_label1").html("2V<sub>0</sub>");$("#Stage_slider_omega_label2").html("3V<sub>0</sub>");$("#Stage_slider_omega_label3").html("4V<sub>0</sub>");$("#Stage_slider_omega_label4").html("infinite");$("#Stage_slider_number_label1").html("1<sup>st</sup> excited <br>state");$("#Stage_slider_number_label2").html("2<sup>nd</sup> excited <br>state");$("#Stage_slider_number_label3").html("3<sup>rd</sup> excited <br>state");$("#Stage_inf1").html("&#8734;");$("#Stage_inf2").html("&#8734;");$("#Stage_text_e1").html("E<sub>1</sub>");$("#Stage_text_e2").html("E<sub>2</sub>");$("#Stage_text_e3").html("E<sub>3</sub>");$("#Stage_text_e4").html("E<sub>4</sub>");sym_disable($('#Stage_buttonHelpMain'));$(".dashed").css("background-repeat","repeat");$(".dashed").css("background-size","auto");initSim();initializePositions();elevels(1);$('.tick').hide();$('#Stage_feedback_text').hide();$('#Stage .star').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){sym.stop('simulation');sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);simulation=true;quantum_number=simulation_quantum_number;potential=simulation_potential;show_fraction=simulation_show_fraction;is_valid_state=simulation_is_valid_state;show_energy=simulation_show_energy;energy=simulation_energy;sym_val('#Stage_slider_number',quantum_number);sym_val('#Stage_slider_potential',potential);if(show_fraction)
{sym_select('#Stage_checkbox_show_fraction');}
else
{sym_deselect('#Stage_checkbox_show_fraction');}
updateFraction();if(show_energy)
{sym_select('#Stage_checkbox_show_energy');$("#Stage_energy_panel").show();}
else
{sym_deselect('#Stage_checkbox_show_energy');$("#Stage_energy_panel").hide();}
drawGraph();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_explanation}","click",function(sym,e){simulation=false;simulation_quantum_number=quantum_number;simulation_potential=potential;simulation_show_fraction=show_fraction;simulation_is_valid_state=is_valid_state;simulation_show_energy=show_energy;simulation_energy=energy;sym.stop('challenges');sym_features();sym_step(current_challenge);$('#Stage').data('step',true);clearTimeout(AdobeEdge.step_animation);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelpMain}","click",function(sym,e){showHelp("simulation");});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelpEnergy}","click",function(sym,e){showHelp("energy");});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelpFraction}","click",function(sym,e){showHelp("fraction");});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelpPotential}","click",function(sym,e){showHelp("potential");});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_show_fraction}","click",function(sym,e){updateFraction();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_show_energy}","click",function(sym,e){updateEnergyPanel();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelpGraph}","click",function(sym,e){showHelp("graph");});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_submit}","click",function(sym,e){challengeSubmit();});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'highlight_1'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight_1");
//Edge symbol end:'highlight_1'

//=========================================================

//Edge symbol: 'fancyExcellent'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.stop(0);});
//Edge binding end
})("fancyExcellent");
//Edge symbol end:'fancyExcellent'
})(jQuery,AdobeEdge,"EDGE-19890435");