/*  Copyright 2016, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
Chart.js http://chartjs.org/ Version: 1.0.2 Copyright 2015 Nick Downie Released under the MIT license https://github.com/nnnick/Chart.js/blob/master/LICENSE.md

*/

(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var frame_rate=50,refresh_period=1000/frame_rate;var t=0,start_t=0;var E=30,m=1,g=9.8;var position_x=true;var intervalBlock;var line1Y=98,line2Y=98,dashed_position=196;var line1_width=195,line2_width=195;var left_pos=22,direction='left',end_time=113.20754716981132;var angled_line_angle=80,len_remove=0,y_diff=0;var stop=true;show_theor_prob=false;var time_dilation_factor=36.2;var grey='',snapshot_done=false,snapshot_time=Math.random()*end_time,snapshot_animation_playing=false;var simulation=true;var sim_histogram_array,sim_theor_probs_on,sim_show_theor_prob,sim_frequency_mode,sim_stop,sim_line1_index,sim_line2_index,sim_dashed_index;var line1_index=0,line2_index=0,dashed_index=2;var q_dashed_index;var h=[0,0,0,0,0,0];var frequency_mode=true,theor_probs_on=false;var pixel_per_m=30,left0=21,left_max=381,dashed0=76;var histogram_array=[];function debug(value){$('#Stage_debug').text(value);}
var help_text=[];help_text["Stage_help_title"]="The simulation shows you a block of mass 1kg and total <br>energy 30J moving on a frictionless track. A photographer takes snapshots at <i>random</i> times of the block’s position. "+"How can the snapshots be used to find the corresponding probability density? What is the difference between a probability and a probability density? "+"You can change the track by dragging the regions up/down and sideways. Press the \"?\" buttons for information. They try the Challenges!";help_text["Stage_help_snapshot"]="The snapshot number histogram is divided into intervals <br>(called bins) of 2m. The histogram shows you the number of times per interval the block has been found. "+"Qualitatively, how does the block’s speed affect the number of snapshots in a given bin? For all measurements, make sure the total number of snapshots N<sub>tot</sub> is large before drawing conclusions! ";help_text["Stage_help_prob_density_hist"]="The function giving the probability per unit length to find <br>the block (in units of 1/m) at each point is called the probability density. "+"The experimentally determined probability density <nobr>P(x)=N<sub>bin</sub>/N<sub>tot</sub> &Delta;x</nobr> for each region equals the number of snapshots in this region N<sub>bin</sub> "+"divided by the total number of snapshots N<sub>tot</sub> and the length of the region &Delta;x. The more snapshots you take, the closer on average the experimentally determined value approaches the theoretical value.";help_text["Stage_help_overlay_theor"]="The block is moving with constant speed in each region. <br>Thus, each position is equally likely, and the theoretical probability density P(x) is a constant function over this region. "+"The theoretical probability of finding the block in a region &Delta;x is given by P(x)&Delta;x=&Delta;t/&tau; where &Delta;t is the time the block spends in the region and &tau; is the total time needed for one traversal of the entire track. "+"Using &Delta;t=&Delta;x/v(x), where v(x) is the oscillator speed in the region, you can show that P(x)=1/v(x) &tau;. ";help_text["Stage_help_show_theor"]="The probability density P(x) is a function that at each point <br>gives the probability per unit length to find the block. "+"As the theoretical probability density is a constant function in a given region, the theoretical probability for that  region can be found by multiplying the theoretical probability density by the length of the region. "+"If the probability density is greater in a given region, does this mean that the probability of finding the block in this region must also be greater?";help_text["Stage_help_speeds"]="The block has a mass of m=1kg, and its total energy is <br>E=30J. The speed of the block v in each region can be found from the conservation of total energy, mgh+&frac12;mv<sup>2</sup>=E, where h is the height of the region, E its total energy and v the block’s speed in that region.";function showHelpText(sym,e){var help_button;if(e===undefined){help_button=$("#Stage_help_title");}else{help_button=$(e.target).parent();}
sym_enable(sym.$('.disabled.help'));sym_disable(help_button);sym.$('help_text').html(help_text[help_button.attr("id")]);sym.$("help_content").show();}
function showTheoreticalProbability(){if(show_theor_prob){$('#Stage_box_theoretical').show();}
else{$('#Stage_box_theoretical').hide();}};var total_counts=0,scale_height=30,scale_factor=30;function plotHistogram(){setScale();total_counts=0;for(j=0;j<current_histogram_array.length;j++){total_counts+=current_histogram_array[j]};for(var i=0;i<6;i++){if(frequency_mode){h[i]=scale_factor*current_histogram_array[i];}
else{if(current_histogram_array[i]!=0){h[i]=50*2/3*scale_height*current_histogram_array[i]/total_counts/(2);}else{h[i]=0};}
if(h[i]==0){$('#Stage_histo'+i).hide();$('#Stage_histo_high'+i).hide();}
if(h[i]>150){$('#Stage_histo'+i).hide();$('#Stage_histo_high'+i).show();}
else{$('#Stage_histo'+i).show();$('#Stage_histo_high'+i).hide();}
$('#Stage_histo'+i).outerHeight(h[i]);}
if(simulation){$('#Stage_n_total_text').show()
$('#Stage_n_total_text').html('N<sub>tot</sub> = '+total_counts);if(total_counts<100){$('#Stage_n_total_text').css({'color':'rgba(255,0,0,1)'});$('#Stage_more_counts_text').show();}
else{$('#Stage_n_total_text').css({'color':'rgba(0,0,102,1)'});$('#Stage_more_counts_text').hide();}}
else{$('#Stage_n_total_text').hide();$('#Stage_more_counts_text').hide();}}
function setScale(){if(frequency_mode){$('#Stage_y_axis_histo_label').html('<br>Number of snapshots');scale_max=5;scale_factor=30;var j=1;while(getMaxCount()>=scale_max){var scale_max_array=[5,10,25];var factor=Math.pow(10,Math.floor(j/3))
scale_max_array[0]*=factor;scale_max_array[1]*=factor;scale_max_array[2]*=factor;scale_max=scale_max_array[j%3];scale_factor=scale_height*5/scale_max;j++}
for(var i=0;i<5;i++){$('#Stage_y_axis_label'+i).text((i+1)*scale_max/5);}}
else{$('#Stage_y_axis_histo_label').html('Probability density (m<sup>-1</sup>)')
scale_factor=30;for(var i=0;i<5;i++){$('#Stage_y_axis_label'+i).text((i+1)*0.03);}}}
function getMaxCount(){var max=0;for(var i=0;i<6;i++)
max=Math.max(current_histogram_array[i],max);return max;}
var v1=7.75,v2=7.75;function calculateV(){h1=Math.abs(line1Y-98)/pixel_per_m;h2=Math.abs(line2Y-98)/pixel_per_m;v1=Math.sqrt(2*E/m-2*g*h1);v2=Math.sqrt(2*E/m-2*g*h2);}
function updateSpeedText(){calculateV();$('#Stage_text_speed1').html('v<sub>1</sub> = '+v1.toFixed(2)+'ms<sup>-1</sup>');$('#Stage_text_speed2').html('v<sub>2</sub> = '+v2.toFixed(2)+'ms<sup>-1</sup>');$('#Stage_text_height1').html('h<sub>1</sub> = '+(line1_index/5).toFixed(1)+'m');$('#Stage_text_height2').html('h<sub>2</sub> = '+(line2_index/5).toFixed(1)+'m');}
function setStartTime(){var d=new Date();start_t=d.getSeconds()*1000+d.getMilliseconds();start_t-=t*time_dilation_factor}
function getTime(){var d=new Date();var now=d.getSeconds()*1000+d.getMilliseconds();t=now-start_t;t=(t>=0)?t:60000+t;t/=time_dilation_factor;}
function positionBlock(){var d_pos=(dashed_position)+5,d_time=(d_pos-left0)/v1,d_time2=d_time+((left_max-d_pos)*2)/v2;end_time=d_time2+d_time
if(position_x){if(t<d_time){left_pos=left0+v1*t;direction='right';}
else if(t<end_time/2){left_pos=d_pos+v2*(t-d_time);direction='right'}
else if(t<d_time2){left_pos=(left_max*2)-d_pos-v2*(t-d_time);direction='left';}
else if(t<end_time){left_pos=d_pos-v1*(t-d_time2);direction='left';}
else{t=0;setStartTime();snapshot_done=false;snapshot_time=Math.random()*end_time;}}
y_position=left_pos<(dashed_position+5)?parseFloat(line1Y):parseFloat(line2Y);y_position-=5;$('#Stage .block_img').each(function(){$(this).hide();});if((Math.abs(t-d_time)<0.5*y_diff/60||Math.abs(t-d_time2)<0.5)&&line1Y>line2Y){$('#Stage_block_rotate_up'+grey).show();$('#Stage_block_rotate_up'+grey).css({'left':d_pos-17,'top':(parseFloat(line1Y)+parseFloat(line2Y))/2});}else if((Math.abs(t-d_time)<0.5*y_diff/60||Math.abs(t-d_time2)<0.5)&&line1Y<line2Y){$('#Stage_block_rotate_down'+grey).show();$('#Stage_block_rotate_down'+grey).css({'left':d_pos+12,'top':(parseFloat(line1Y)+parseFloat(line2Y))/2});}
else{$('#Stage_block'+grey).show();}
$('#Stage_block'+grey).css({'left':left_pos,'top':y_position});if(simulation){snapshot();};}
function snapshot(){if((snapshot_time<t)&&!snapshot_done&&!snapshot_animation_playing){snapshot_done=true;snapshot_animation_playing=true;var position=(left_pos-left0)/(left_max-left0)*12;grey='_grey';if(frequency_mode){$('#Stage_cameraflash').show();$('#Stage_cameraflash').fadeOut();$('#Stage_block_snapshot').css({'left':left_pos,'top':y_position});$('#Stage_block_snapshot').show();$('#Stage_block_snapshot').delay(500);$('#Stage_block_snapshot').fadeOut(500);$('#Stage_snapshot_line').css({'left':left_pos+14,'bottom':40,'height':169+h[Math.floor(position/2)]});$('#Stage_snapshot_line').show();$('#Stage_snapshot_line').delay(500);$('#Stage_snapshot_line').fadeOut(500);$('#Stage_blob').css({'left':0+Math.floor(position/2)*60,'bottom':h[Math.floor(position/2)],'width':60,'height':2});$('#Stage_blob').show();$('#Stage_blob').delay(500);$('#Stage_blob').animate({'height':scale_factor},500,function(){current_histogram_array[Math.floor(position/2)]++
plotHistogram();grey='';});$('#Stage_blob').fadeOut(200,function(){snapshot_animation_playing=false;});}
else{$('#Stage_cameraflash').show();$('#Stage_cameraflash').fadeOut();$('#Stage_block_snapshot').css({'left':left_pos,'top':y_position});$('#Stage_block_snapshot').show();$('#Stage_block_snapshot').delay(500);$('#Stage_block_snapshot').fadeOut(500);$('#Stage_snapshot_line').css({'left':15+left_pos,'bottom':40,'height':169+Math.min(h[Math.floor(position/2)],150)});$('#Stage_snapshot_line').show();$('#Stage_snapshot_line').delay(500);$('#Stage_snapshot_line').fadeOut(500,function(){});$('#Stage_blob').css({'left':0+Math.floor(position/2)*60,'bottom':h[Math.floor(position/2)],'width':60,'height':2});if(50*2/3*scale_height*(current_histogram_array[Math.floor(position/2)]+1)/(total_counts+1)/(2)<150){$('#Stage_blob').show();}
$('#Stage_blob').delay(500);$('#Stage_blob').animate({'height':Math.min(50*2/3*scale_factor/(total_counts+1)/2,250-h[Math.floor(position/2)])},500,function(){current_histogram_array[Math.floor(position/2)]++
plotHistogram();grey='';});$('#Stage_blob').fadeOut(200,function(){snapshot_animation_playing=false;});}}}
function calculateTime(){var d_pos=(dashed_position+5),d_time=(d_pos-left0)/v1,d_time2=d_time+((left_max-d_pos)*2)/v2
end_time=d_time2+d_time;if(left_pos<d_pos&&direction==='right'){t=(left_pos-left0)/v1}else if(left_pos>d_pos&&direction==='right'){t=(left_pos-d_pos)/v2+d_time;}else if(left_pos>d_pos&&direction==='left'){t=(left_max-left_pos)/v2+end_time/2;}else if(left_pos<d_pos&&direction==='left'){t=(d_pos-left_pos)/v1+d_time2;}else{t=0;}
setStartTime();}
function randomPosition(){var d_pos=(dashed_position+5),d_time=(d_pos-left0)/v1,d_time2=d_time+((left_max-d_pos)*2)/v2;var r_time=Math.random()*end_time,r_pos;if(r_time<d_time){r_pos=left0+v1*r_time;}
else if(r_time<end_time/2){r_pos=d_pos+v2*(r_time-d_time);}
else if(r_time<d_time2){r_pos=(left_max*2)-d_pos-v2*(r_time-d_time);}
else if(r_time<end_time){r_pos=d_pos-v1*(r_time-d_time2)
r_pos=d_pos-v1*(r_time-d_time2)}
r_pos=(r_pos-left0)/(left_max-left0)*12;return r_pos;}
function setLines(){line1_width=(dashed_position-1);line2_width=390-(dashed_position-1);y_diff=Math.abs(line1Y-line2Y);len_remove=y_diff/Math.tan(angled_line_angle*Math.PI/180)/2;var line1_w=line1_width-len_remove;var line2_w=line2_width-len_remove;var line=$('#Stage_line1_box');$(line).css('width',line1_w+'px');line.removeClass(line.attr('class').match(/minX_(\d+)/)[0])
line.removeClass(line.attr('class').match(/maxX_(\d+)/)[0])
line.addClass('maxX_'+(21+line1_w));line.addClass('minX_'+(21+line1_w-line.width()));line.data('minX',21+line1_w-line.width());line.data('maxX',21+line1_w);var line=$('#Stage_line2_box');$(line).css({'left':dashed_position+19+parseInt(len_remove),'width':line2_w+'px'});line.removeClass(line.attr('class').match(/minX_(\d+)/)[0])
line.removeClass(line.attr('class').match(/maxX_(\d+)/)[0])
line.addClass('minX_'+Math.round(dashed_position+19+len_remove));line.addClass('maxX_'+Math.round(dashed_position+19+len_remove)+line.width());line.data('minX',Math.round(dashed_position+19+len_remove));line.data('maxX',Math.round(dashed_position+19+len_remove)+line.width());var angled_top=line1Y+25;var angled_width=y_diff/Math.sin(angled_line_angle*Math.PI/180);var angled_left=dashed_position+21-y_diff/Math.tan(angled_line_angle*Math.PI/180)/2;$('#Stage_angled_line_up').hide();$('#Stage_angled_line_down').hide();if(line1Y<line2Y){$('#Stage_angled_line_down').show();$('#Stage_angled_line_down').css({'top':angled_top,'left':angled_left,'width':angled_width});}else if(line1Y>line2Y){$('#Stage_angled_line_up').show();$('#Stage_angled_line_up').css({'top':angled_top+2,'left':angled_left-2,'width':angled_width});}}
function calculateProbability(){prob_dens1=1/(v1*(((dashed_index*2)+2)/v1+(10-(dashed_index*2))/v2));prob_dens2=1/(v2*(((dashed_index*2)+2)/v1+(10-(dashed_index*2))/v2));prob1=prob_dens1*(line1_width-15)/pixel_per_m
prob2=prob_dens2*(line2_width-15)/pixel_per_m}
function updateProbabilityText(){calculateProbability();var prob_dens_max=0.12678,prob_dens_min=0.05268,prob_max=0.89465,prob_min=0.10535,text_min=0.81,text_max=1.38;$('#Stage_probability1').css({'font-size':text_min+(prob1-prob_min)/(prob_max-prob_min)*(text_max-text_min)+'em'});$('#Stage_probability2').css({'font-size':text_min+(prob2-prob_min)/(prob_max-prob_min)*(text_max-text_min)+'em'});$('#Stage_prob_density1').css({'font-size':text_min+(prob_dens1-prob_dens_min)/(prob_dens_max-prob_dens_min)*(text_max-text_min)+'em'});$('#Stage_prob_density2').css({'font-size':text_min+(prob_dens2-prob_dens_min)/(prob_dens_max-prob_dens_min)*(text_max-text_min)+'em'});$('#Stage_probability1').html('Prob<sub>1</sub> = '+prob1.toFixed(2));$('#Stage_probability2').html('Prob<sub>2</sub> = '+prob2.toFixed(2));$('#Stage_prob_density1').html('P<sub>1</sub>(x) = '+prob_dens1.toFixed(3)+'m<sup>-1</sup>');$('#Stage_prob_density2').html('P<sub>2</sub>(x) = '+prob_dens2.toFixed(3)+'m<sup>-1</sup>');if(prob_dens1>prob_dens2){$('#Stage_prob_density_inequality').html('>');}else if(prob_dens1<prob_dens2){$('#Stage_prob_density_inequality').html('<');}else if(prob_dens1==prob_dens2){$('#Stage_prob_density_inequality').html('=');}
if(prob1>prob2){$('#Stage_probability_inequality').html('>');}else if(prob1<prob2){$('#Stage_probability_inequality').html('<');}if(prob1==prob2){$('#Stage_probability_inequality').html('=');}
positionTheoryLines();}
function positionTheoryLines(){if(theor_probs_on&&!frequency_mode){$('#Stage_theor_line1').show();$('#Stage_theor_line2').show();$('#Stage_theor_line1').css({'width':dashed_position-16,'bottom':(prob_dens1/0.15*150)+19});$('#Stage_theor_line2').css({'width':360-(dashed_position-16),'bottom':(prob_dens2/0.15*150)+19});}else{$('#Stage_theor_line1').hide();$('#Stage_theor_line2').hide();}}
function blockMotion(){if(!stop){clearInterval(intervalBlock);setStartTime();grey='';intervalBlock=setInterval(function(){getTime();positionBlock()},refresh_period);}
else{clearInterval(intervalBlock);positionBlock();}}
function setStage(){updateSpeedText();plotHistogram();blockMotion();updateProbabilityText();showTheoreticalProbability();}
var correct_answer=[false,false,false,false],correct=false,current_challenge=1,score_for_challenge=[10,10,20,20,20,20],challenge_complete=[false,false,false,false,false,false],totalScore=0,fireworkProb=1;function challengeReset(){$('#Stage_feedback_text').hide();}
function shuffle(array){var currentIndex=array.length,temporaryValue,randomIndex;while(0!==currentIndex){randomIndex=Math.floor(Math.random()*currentIndex);currentIndex-=1;temporaryValue=array[currentIndex];array[currentIndex]=array[randomIndex];array[randomIndex]=temporaryValue;}
return array;}
function step_functions(step){clearTimeout(AdobeEdge.step_animation);current_challenge=step;challengeReset();var text=$('#Stage_challenge_text');switch(current_challenge){case 1:$('#Stage_histogram').hide();show_theor_prob=false;$('#Stage .movable').each(function(){sym_enable($(this))});$('#Stage_q5_line_left').hide();$('#Stage_q5_line_right').hide();text.html('How is the speed of the block at a certain position related to the probability density of the block at that position?');setStage();$('#Stage .group_answer').each(function(){$(this).show();sym_deselect($(this));});$('#Stage_radio_answer3').hide();for(i=0;i<3;i++){$('#Stage_radio_answer'+i).css({'top':90+50*i,'left':25,'width':370});$('#Stage_radio_label_answer'+i).css({'width':330,'top':10});}
$('#Stage_button_submit').css({'top':240,'left':150});$('#Stage_feedback_text').css({'top':285});var choices=[{str:"The greater the block’s speed, the larger the probability density.",correct:false},{str:"The greater the block’s speed, the smaller the probability density.",correct:true},{str:"The probability density does not depend on the block’s speed.",correct:false}];shuffle(choices);$.each(choices,function(index,value){$('#Stage_radio_label_answer'+index).html(value.str);correct_answer[index]=value.correct;});break;case 2:$('#Stage_histogram').hide();show_theor_prob=false;$('#Stage .movable').each(function(){sym_enable($(this))});$('#Stage_q5_line_left').hide();$('#Stage_q5_line_right').hide();text.html('How is the potential energy mgh of the block (where h is the height of the track) at a certain position related to the probability density of the block at that position?');setStage();$('#Stage .group_answer').each(function(){$(this).show();sym_deselect($(this));});$('#Stage_radio_answer3').hide();for(i=0;i<3;i++){$('#Stage_radio_answer'+i).css({'top':90+50*i,'left':25,'width':370});$('#Stage_radio_label_answer'+i).css({'width':330,'top':10});}
$('#Stage_button_submit').css({'top':240,'left':150});$('#Stage_feedback_text').css({'top':285});var choices=[{str:"The greater the block’s potential energy, the larger the probability density.",correct:true},{str:"The greater the block’s potential energy, the smaller the probability density",correct:false},{str:"The probability density does not depend on the block’s potential energy.",correct:false}];shuffle(choices);$.each(choices,function(index,value){$('#Stage_radio_label_answer'+index).html(value.str);correct_answer[index]=value.correct;});break;case 3:$('#Stage_histogram').hide();show_theor_prob=false;$('#Stage .movable').each(function(){sym_enable($(this))});$('#Stage_q5_line_left').hide();$('#Stage_q5_line_right').hide();text.html('Set up a track for which the <b>probability</b> of finding the block is as small as possible in the left region and as large as possible in the right region. Then press Submit.');setStage();$('#Stage .group_answer').hide();$('#Stage_button_submit').css({'top':180,'left':150});$('#Stage_feedback_text').css({'top':240});break;case 4:$('#Stage_histogram').show();show_theor_prob=false;theor_probs_on=true;frequency_mode=false;$('#Stage .movable').each(function(){sym_enable($(this))});$('#Stage_q5_line_left').hide();$('#Stage_q5_line_right').hide();text.html('Set up a track for which the theoretical probability density in the left region is greater than in the right region <nobr>P<sub>1</sub> > P<sub>2</sub>,</nobr> '+'but the probability of the block being found in the left region is smaller than in the right region <nobr>Prob<sub>1</sub> < Prob<sub>2</sub>.</nobr> Then press Submit.');position_x=false;setStage();position_x=true;$('#Stage .group_answer').hide();$('#Stage_button_submit').css({'top':180,'left':150});$('#Stage_feedback_text').css({'top':240});break;case 5:$('#Stage_histogram').show();show_theor_prob=true;theor_probs_on=true;frequency_mode=false;$('#Stage_q5_line_left').show();$('#Stage_q5_line_right').show();$('#Stage .init_drag').hide();line1_index=Math.floor(Math.random()*11);$('#Stage_line1_box').css('top',98-line1_index*6);line1Y=98-line1_index*6;line2_index=Math.floor(Math.random()*11);while((Math.abs(line1_index-line2_index))<4){line2_index=Math.floor(Math.random()*11);}
$('#Stage_line2_box').css('top',98-line2_index*6);line2Y=98-line2_index*6;q_dashed_index=Math.floor(Math.random()*5)*2+2;$('#Stage_dashline_vert_box').css('left',dashed0+(q_dashed_index-2)*pixel_per_m);dashed_position=Math.round((dashed0+(q_dashed_index-2)*pixel_per_m));setLines();left_line_index=1+Math.floor(Math.random()*(q_dashed_index-1));right_line_index=1+q_dashed_index+Math.floor(Math.random()*(11-q_dashed_index));while(((right_line_index-q_dashed_index)==(q_dashed_index-left_line_index))||(right_line_index-left_line_index)>6){left_line_index=1+Math.floor(Math.random()*(q_dashed_index-1));right_line_index=1+q_dashed_index+Math.floor(Math.random()*(11-q_dashed_index));}
$('#Stage_q5_line_left').css('left',left_line_index*pixel_per_m+35);$('#Stage_q5_line_right').css('left',right_line_index*pixel_per_m+35);text.html('Consider the <b>fixed</b> track shown at the left. What is the probability, upon taking a measurement of the position of the block at a random time, '+'of finding it in the interval from '+left_line_index+'m to '+right_line_index+'m? You may need a calculator! ');setLines();position_x=false;setStage();position_x=true;var choices=[{str:((prob_dens1.toFixed(3)*(q_dashed_index-left_line_index))+(prob_dens2.toFixed(3)*(right_line_index-q_dashed_index))).toFixed(3),correct:true},{str:(prob_dens1.toFixed(3)*(right_line_index-left_line_index)).toFixed(3),correct:false},{str:(prob_dens2.toFixed(3)*(right_line_index-left_line_index)).toFixed(3),correct:false},{str:((prob_dens1+prob_dens2).toFixed(3)/2*(right_line_index-left_line_index)).toFixed(3),correct:false}];shuffle(choices);$.each(choices,function(index,value){$('#Stage_radio_label_answer'+index).html(value.str);correct_answer[index]=value.correct;})
$('#Stage .group_answer').show();for(i=0;i<4;i++){$('#Stage_radio_answer'+i).css({'top':120,'left':10+100*i,'width':100});$('#Stage_radio_label_answer'+i).css({'width':65,'top':15});sym_deselect($('#Stage_radio_answer'+i));}
$('#Stage_button_submit').css({'top':180,'left':150});$('#Stage_feedback_text').css({'top':240});$('#Stage .movable').each(function(){sym_disable($(this))});break;case 6:$('#Stage_histogram').hide();show_theor_prob=false;theor_probs_on=false;frequency_mode=false;$('#Stage .init_drag').hide();$('#Stage_q5_line_left').hide();$('#Stage_q5_line_right').hide();line1_index=Math.floor(Math.random()*11);$('#Stage_line1_box').css('top',98-line1_index*6);line1Y=98-line1_index*6;line2_index=Math.floor(Math.random()*11);while((Math.abs(line1_index-line2_index))<4){line2_index=Math.floor(Math.random()*11);}
$('#Stage_line2_box').css('top',98-line2_index*6);line2Y=98-line2_index*6;q_dashed_index=Math.floor(Math.random()*5)*2+2;while(q_dashed_index==6){q_dashed_index=Math.floor(Math.random()*5)*2+2;}
$('#Stage_dashline_vert_box').css('left',dashed0+(q_dashed_index-2)*pixel_per_m);dashed_position=Math.round((dashed0+(q_dashed_index-2)*pixel_per_m));setLines();text.html('Consider the <b>fixed</b> track shown at the left. The speed of the block in the two regions is given.  What is the value of the theoretical probability density at each point of the left region? You may need a calculator!');position_x=false;setStage();position_x=true;debug((1/v1/(dashed_index/(v1.toFixed(2))+(12-dashed_index)/(v2.toFixed(2)))).toFixed(3));var choices=[{str:(1/v1/(q_dashed_index/(v1.toFixed(2))+(12-q_dashed_index)/(v2.toFixed(2)))).toFixed(3)+'m<sup>-1</sup>',correct:true},{str:(1/v1/(q_dashed_index/(v2.toFixed(2))+(12-q_dashed_index)/(v1.toFixed(2)))).toFixed(3)+'m<sup>-1</sup>',correct:false},{str:prob1.toFixed(3)+'m<sup>-1</sup>',correct:false},{str:prob_dens2.toFixed(3)+'m<sup>-1</sup>',correct:false}];shuffle(choices);$.each(choices,function(index,value){$('#Stage_radio_label_answer'+index).html(value.str);correct_answer[index]=value.correct;})
$('#Stage .group_answer').show();for(i=0;i<4;i++){$('#Stage_radio_answer'+i).css({'top':120,'left':10+100*i,'width':100});$('#Stage_radio_label_answer'+i).css({'width':65,'top':15});sym_deselect($('#Stage_radio_answer'+i));}
$('#Stage_button_submit').css({'top':180,'left':150});$('#Stage_feedback_text').css({'top':240});$('#Stage .movable').each(function(){sym_disable($(this))});;break;}}
function submit(){var feedback=$('#Stage_feedback_text'),feedback_str;correct=false;switch(current_challenge){case 1:var no_selected=true;$('.group_answer').each(function(index){var id=$(this).attr('id');id=id.substr(id.length-1);id=parseInt(id);if($(this).hasClass('selected')){no_selected=false;}
if($(this).hasClass('selected')&&correct_answer[id]){correct=true;}});if(no_selected){feedback_str='Please select an option.';}
else if(correct){feedback_str='Correct, congratulations! The probability per unit length to find the block is small when the speed of the block is large. '+'Snapshots made at random times are less likely to find the block at points where it is moving quickly.';}else{feedback_str='This is not yet correct. Are snapshots made at random times more or less likely to find the block at points where it is moving quickly? '+'What does this imply for the probability per unit length (the probability density) at points where the block is moving quickly?'}
break
case 2:var no_selected=true;$('.group_answer').each(function(index){var id=$(this).attr('id');id=id.substr(id.length-1);id=parseInt(id);if($(this).hasClass('selected')){no_selected=false;}
if($(this).hasClass('selected')&&correct_answer[id]){correct=true;}});if(no_selected){feedback_str='Please select an option.';}
else if(correct){feedback_str='Correct, congratulations! The probability per unit length to find the block is small when the speed of the block is large. The total energy of the block is constant. '+'The greater the height of the track, the greater the potential energy mgh and hence the smaller its kinetic energy and speed.';}else{feedback_str='This is not yet correct. Are snapshots made at random times more or less likely to find the block at points where it is moving quickly and hence has large kinetic energy? '+'The total energy of the block is constant. Thus, if the kinetic energy is large, the potential energy is small.'}
break
case 3:if(dashed_index==0&&line1_index==0&&line2_index==10){correct=true;}
if(correct){feedback_str='Correct, congratulations! The probability of finding the block in a given region will be as small as possible if the cart spends as little time as possible in this region. '+'This is the case if the region is as narrow as possible and the cart has maximal kinetic energy (so zero potential energy). ';}else{feedback_str='This is not yet correct. The probability of finding the block in a given region will be as small as possible if the cart spends as little time as possible in this region. '+'Consider how the time spent in the left region depends on the length of the region and on the speed of the cart in this region.'}
break
case 4:if((prob1<prob2)&&(prob_dens1>prob_dens2)){correct=true;feedback_str='Correct, congratulations. As the block is moving more slowly in the left half of the track, the probability density in the left region will be larger. '+'As the left region is much shorter than the right region, the probability of finding the particle in the left region is smaller than in the right region.';}else if(!(prob_dens1>prob_dens2)){feedback_str='This is not yet correct. Consider the theoretical probability density curve as shown in the graph at the left, '+'and set up a track for which the theoretical probability density in the left region is greater than in the right region.';}else if(!(prob1<prob2)&&(prob_dens1>prob_dens2)){feedback_str='This is not yet correct. The theoretical probability density is shown in the graph. As this is a constant function in each region, '+'the theoretical probability for that region can be found by multiplying the theoretical probability density by the length of the region.';}
break
case 5:var no_selected=true;$('.group_answer').each(function(index){var id=$(this).attr('id');id=id.substr(id.length-1);id=parseInt(id);if($(this).hasClass('selected')){no_selected=false;}
if($(this).hasClass('selected')&&correct_answer[id]){correct=true;}});if(no_selected){feedback_str='Please select an option.';}
else if(correct){feedback_str='Correct, congratulations! The probability of finding the block between '+left_line_index+'m and '+q_dashed_index+'m (the left-hand region) is <nobr>'+prob_dens1.toFixed(3)+' m<sup>-1</sup>×'+(q_dashed_index-left_line_index)+'m='+((q_dashed_index-left_line_index)*prob_dens1).toFixed(3)+'.</nobr> '+'The probability of finding the block between '+q_dashed_index+'m and '+right_line_index+'m (the right-hand region) is <nobr>'+prob_dens2.toFixed(3)+' m<sup>-1</sup>×'+(right_line_index-q_dashed_index)+'m='+((right_line_index-q_dashed_index)*prob_dens2).toFixed(3)+'.</nobr> '+'Thus, the total probability of finding the block between '+left_line_index+'m and '+right_line_index+'m is <nobr>'+((prob_dens1.toFixed(3)*(q_dashed_index-left_line_index))+(prob_dens2.toFixed(3)*(right_line_index-q_dashed_index))).toFixed(3)+'.</nobr> ';}else{feedback_str='This is not yet correct. If the probability density in a region is constant, one can find the probability by multiplying the probability density by the length of the region. '+'Here, one needs to consider the two different regions separately, and add their respective probabilities. '}
break
case 6:var no_selected=true;$('.group_answer').each(function(index){var id=$(this).attr('id');id=id.substr(id.length-1);id=parseInt(id);if($(this).hasClass('selected')){no_selected=false;}
if($(this).hasClass('selected')&&correct_answer[id]){correct=true;}});if(no_selected){feedback_str='Please select an option.';}
else if(correct){feedback_str='Correct, congratulations! The time needed for the block to traverse the entire track is <nobr>&tau; = L<sub>1</sub>/v<sub>1</sub>+L<sub>2</sub>/v<sub>2</sub> = '+(q_dashed_index/(v1.toFixed(2))+(12-q_dashed_index)/(v2.toFixed(2))).toFixed(2)+'s.</nobr> '+'The theoretical probability of finding the block in the left region of length L<sub>1</sub> is given by <nobr>P(x) L<sub>1</sub> = &Delta;t/&tau;</nobr>, where <nobr>&Delta;t = L<sub>1</sub>/v<sub1</sub>.</nobr> '+'Thus, the theoretical probability density <nobr>P(x) = 1/(v(x)&tau;) = 1/'+(v1.toFixed(2)*(q_dashed_index/(v1.toFixed(2))+(12-q_dashed_index)/(v2.toFixed(2))).toFixed(2)).toFixed(2)+' = '+(1/v1/(q_dashed_index/(v1.toFixed(2))+(12-q_dashed_index)/(v2.toFixed(2)))).toFixed(3)+'m<sup>-1</sup></nobr>.';}else{feedback_str='This is not yet correct. From the speeds and lengths of the two regions given, you can calculate the time &tau; needed for the block to traverse the entire track. '+'The theoretical probability of finding the block in the left region of length L<sub>1</sub> is given by <nobr>P(x) L<sub>1</sub> = &Delta;t/&tau;, where &Delta;t = L<sub>1</sub>/v<sub>1</sub>.</nobr> '+'Thus, the theoretical probability density <nobr>P(x) = 1/(v(x)&tau;).</nobr> Here, v is the speed of the block in the left region.'}
break}
feedback.fadeOut("fast",function(){if(correct){feedback.css('color','#008f00');$('#Stage_steps_tick'+current_challenge).show();}else{feedback.css('color','#960000');}
feedback.html(feedback_str);feedback.fadeIn("fast");});if(correct&&!challenge_complete[current_challenge-1]){challenge_complete[current_challenge-1]=true;addScore(score_for_challenge[current_challenge-1]);}}
function addScore(score){var currentScore=totalScore;totalScore+=score;startScoreAnimation(currentScore,totalScore);if(Math.random()<fireworkProb&&totalScore!=100){fireworks();fireworkProb=0.25;}else
fireworkProb=2*fireworkProb;if(totalScore==100)
AdobeEdge.getComposition(compId).getStage().getSymbol('fancyExcellent').play();}
function fireworks(){var star_id='#Stage_stars';var stick_ele=$('#Stage_stick');var number=6;var spread=75;var delay_const=500;var speed_const=700;var speed_const_offset=500;var x0=stick_ele.css('left'),y0=stick_ele.css('top');var totalDelay=0;$('#Stage .star').hide();$('#Stage .star').css({'left':x0,'top':y0,'opacity':1});$('#Stage .star').fadeIn(500);for(var i=0;i<number;i++){var left=Math.round(Math.random()*spread);if(Math.random()<0.5)
left='-='+left+'px';else
left='+='+left+'px';var delay1=Math.round((Math.random()+.25)*delay_const);totalDelay+=delay1;var speed=Math.round((Math.random()+.5)*speed_const)+speed_const_offset;$('#Stage_stars'+i).delay(delay1).animate({'left':left,'top':'-=500px','opacity':0},speed);}
$('#Stage .star').delay(1000).fadeOut();}
function startScoreAnimation(startValue,endValue){var text_score=$('#Stage_text_score');var duration=800;var currentValue=startValue;var interval=duration/(endValue-startValue);if(endValue>startValue){function recursiveFunc(){text_score.text(++currentValue+'/100');if(currentValue==endValue)
return;setTimeout(recursiveFunc,interval);}
recursiveFunc();}else throw'startValue is larger than endValue';}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());if(movable.hasClass('dashed_movable')){newX=Math.round(newX/60)*60;newX+=16;}else if(movable.hasClass('line')){newY=Math.round(newY/6)*6;newY+=2;}
movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if($(element).hasClass('disabled')&&$(element).hasClass('movable')){sym_enable($(element));}
if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);$(element).data('timeout_val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();setStartTime();var color1='rgba(0,153,0,1)',color2='rgba(153,0,102,1)';$('#Stage_help_text').html(help_text["Stage_help_title"]);$('#Stage_probability1').css({'color':color1,'position':'relative','height':'30px','line-height':'25px'});$('#Stage_probability2').css({'color':color2,'position':'relative','height':'30px','line-height':'25px'});$('#Stage_prob_density1').css({'color':color1,'position':'relative','height':'30px','line-height':'20px'});$('#Stage_prob_density2').css({'color':color2,'position':'relative','height':'30px','line-height':'20px'});$('#Stage_left_text').css({'color':color1});$('#Stage_right_text').css({'color':color2});updateProbabilityText();$('#Stage_text_speed1').css({'color':color1})
$('#Stage_text_speed2').css({'color':color2})
$('#Stage_text_height1').css({'color':color1})
$('#Stage_text_height2').css({'color':color2})
updateSpeedText();$('#Stage_theor_line1').css({'background-color':color1});$('#Stage_theor_line2').css({'background-color':color2});$('#Stage_line1').css({'background-color':color1});$('#Stage_line2').css({'background-color':color2});$('#Stage_angled_line_up').css({'background-color':'rgba(164,164,164,1.00)'});$('#Stage_angled_line_down').css({'background-color':'rgba(164,164,164,1.00)'});$('#Stage_block_grey').hide();$('#Stage_angled_line_up').hide();$('#Stage_angled_line_down').hide();histogram_array=[]
for(i=0;i<11*11*5;i++){histogram_array.push([0,0,0,0,0,0]);}
current_histogram_array=histogram_array[(dashed_index*11*11)+(line1_index*11)+line2_index]
setStage();sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});yepnope({load:"normalize.css"});$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage').find('.movable.active');if(movable.hasClass('active')&&!movable.data('timeout')){movable.data('timeout',setTimeout(function(){movable.data('timeout',false);if(movable.data('xtimeout_val')===movable.data('xPos')&&movable.data('ytimeout_val')===movable.data('yPos')){return;}
movable.data('xtimeout_val',movable.data('xPos'));movable.data('ytimeout_val',movable.data('yPos'));clearInterval(intervalBlock);histogram_array[dashed_index*11*11+line1_index*11+line2_index]=current_histogram_array;grey='_grey';if(movable.hasClass('line1')){line1Y=movable.css('top');line1Y=parseInt(line1Y.slice(0,line1Y.indexOf('px')));line1_index=(98-line1Y)/6;$('#Stage_arrow_line1').hide();}
if(movable.hasClass('line2')){line2Y=movable.css('top');line2Y=parseInt(line2Y.slice(0,line2Y.indexOf('px')));line2_index=(98-line2Y)/6;$('#Stage_arrow_line2').hide();}
if(movable.hasClass('dashed_movable')){dashed_position=movable.css('left');dashed_position=parseInt(dashed_position.slice(0,dashed_position.indexOf('px')));dashed_index=(dashed_position-dashed0)/60;$('#Stage_arrow_dashed_line').hide();}
$('#Stage_drag_text').hide();current_histogram_array=histogram_array[dashed_index*11*11+line1_index*11+line2_index]
setLines();updateSpeedText();position_x=false;positionBlock();position_x=true;updateProbabilityText();calculateTime();plotHistogram();},20));}});$(document).on('mouseup touchend',function(e){var movable=$('#Stage').find('.movable');if(movable.hasClass('unActive')){movable.removeClass('unActive');calculateTime();clearInterval(intervalBlock);setStartTime();grey='';if(!stop){intervalBlock=setInterval(function(){getTime()
positionBlock()},refresh_period)}else{getTime();positionBlock();}}});$('.tick').hide();$('#Stage_feedback_text').hide();$('#Stage .star').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_overlay_theor}","click",function(sym,e){if($('#Stage_checkbox_overlay_theor').hasClass('selected')){theor_probs_on=true;}else{theor_probs_on=false;}
setStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){sym.stop('simulation');sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);simulation=true;line1_index=sim_line1_index;line1Y=98-6*line1_index;$('#Stage_line1_box').css('top',line1Y);line2_index=sim_line2_index;line2Y=98-6*line2_index;$('#Stage_line2_box').css('top',line2Y);dashed_index=sim_dashed_index;dashed_position=dashed_index*60+dashed0;$('#Stage_dashline_vert_box').css('left',dashed_position);histogram_array=sim_histogram_array;current_histogram_array=histogram_array[(dashed_index*11*11)+(line1_index*11)+line2_index];show_theor_prob=sim_show_theor_prob;theor_probs_on=sim_theor_probs_on;frequency_mode=sim_frequency_mode;stop=sim_stop;$('#Stage_histogram').show();sym_enable($('#Stage .movable'));t=0;setStartTime();setLines();setStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_challenge}","click",function(sym,e){simulation=false;histogram_array[(dashed_index*11*11)+(line1_index*11)+line2_index]=current_histogram_array;sim_histogram_array=histogram_array;sim_theor_probs_on=theor_probs_on;sim_show_theor_prob=show_theor_prob;sim_frequency_mode=frequency_mode;sim_line1_index=line1_index;sim_line2_index=line2_index;sim_dashed_index=dashed_index;sim_stop=stop;stop=true;t=0;setStartTime();histogram_array=[];for(i=0;i<11*11*5;i++){histogram_array.push([0,0,0,0,0,0]);}
current_histogram_array=histogram_array[(dashed_index*11*11)+(line1_index*11)+line2_index];sym.stop('challenge');sym_features();sym_step(current_challenge);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_title}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_snapshot}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_show_therory}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_prob_density_hist}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_overlay_theor}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_speeds}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_theory}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_show_theor}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_prob_density_hist}","click",function(sym,e){sym_enable($('#Stage_checkbox_overlay_theor'));sym_enable($('#Stage_checkbox_show_theor'));frequency_mode=false;setStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_show_theor}","click",function(sym,e){show_theor_prob=($('#Stage_checkbox_show_theor').hasClass('selected')?true:false)
setStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_help_close}","click",function(sym,e){$('#Stage_help_content').hide();$('#Stage .help').each(function(){sym_enable(this);});});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",0,function(sym,e){});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonClear}","click",function(sym,e){current_histogram_array=[0,0,0,0,0,0];plotHistogram();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonGO}","click",function(sym,e){sym_enable($('#Stage_buttonSTOP'));sym_disable($('#Stage_buttonGO'));stop=false;setStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonFF}","click",function(sym,e){for(i=0;i<500;i++){var r_num=Math.floor(randomPosition()/2)
current_histogram_array[r_num]++};plotHistogram();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonSTOP}","click",function(sym,e){sym_disable($('#Stage_buttonSTOP'));sym_enable($('#Stage_buttonGO'));stop=true;setStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_freq}","click",function(sym,e){sym_disable($('#Stage_checkbox_overlay_theor'));sym_disable($('#Stage_checkbox_show_theor'));frequency_mode=true;setStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_play}","click",function(sym,e){if(stop){stop=false;$('#Stage_button_label_play').html('Stop')
calculateTime();}
else{stop=true;$('#Stage_button_label_play').html('Play')}
setStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_submit}","click",function(sym,e){submit();});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'highlight_1'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight_1");
//Edge symbol end:'highlight_1'

//=========================================================

//Edge symbol: 'fancyExcellent'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.stop(0);});
//Edge binding end
})("fancyExcellent");
//Edge symbol end:'fancyExcellent'
})(jQuery,AdobeEdge,"EDGE-19890435");