/*  Copyright 2017, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
*/
(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var vel=0;var state=1;var interval;var images=[];function preloadImages(){var prefixes=['','2'],length=prefixes.length;for(var i=0;i<length;i++){_preloadImages(prefixes[i]);}}
function _preloadImages(prefix){for(var i=1;i<120;i++){var name='sphere'+prefix+'Plot'+i,image=new Image();image.onload=function(){};image.onerror=function(){console.error("Error occur while preloading image: "+name);};image.src='./images/Graphs2/'+name+'.gif';images.push(image);}}
var cycle_time=6;var start_t;var t=0;var time_step=cycle_time*1000/120;function setStartTime(){var d=new Date();start_t=d.getSeconds()*1000+d.getMilliseconds();start_t-=t}
function getTime(){var d=new Date();var now=d.getSeconds()*1000+d.getMilliseconds();t=now-start_t;t=(t>=0)?t:60000+t;}
var sphereInterval
function updateSphere(sphere_name){var images_per_s=120/cycle_time;src0='./images/Graphs2/'+sphere_name+Math.round(images_per_s*t/1000)%120+'.gif';var graph1=$("#Stage_sphere_plot");graph1.attr("src",src0);}
function startAnimation(azimuth){clearInterval(sphereInterval);if(vel==1){switch(azimuth){case 0:clearInterval(interval);t=0;updateSphere('plotup')
showProbability(0,1);showQuantumState(1);break;case 10:clearInterval(interval);t=0;updateSphere('plotdown')
showProbability(0,10);break;case 3:clearInterval(interval);t=0;setStartTime();sphereInterval=setInterval(function(){getTime();updateSphere('sphere2Plot');},50);showProbabilityTime(3);break;case 5:clearInterval(interval);t=0;setStartTime();sphereInterval=setInterval(function(){getTime();updateSphere('spherePlot');},50);showProbabilityTime(5);break;case 7:clearInterval(interval);t=0;setStartTime();sphereInterval=setInterval(function(){getTime();updateSphere('sphere3Plot');},50);showProbabilityTime(7);break;}}
else{switch(azimuth){case 0:clearInterval(interval);t=0;updateSphere('plotup')
showProbability(0,1);showQuantumState(0);break;case 10:clearInterval(interval);t=0;updateSphere('plotdown')
showProbability(0,10);showProbability(0,10);showQuantumState(10);break;case 3:clearInterval(interval);t=0;updateSphere('sphere2Plot')
showQuantumState(3);showProbability(0,3);break;case 5:clearInterval(interval);t=0;updateSphere('spherePlot')
showQuantumState(5);showProbability(0,5);break;case 7:clearInterval(interval);t=0;updateSphere('sphere3Plot')
showQuantumState(7);showProbability(0,7);break;}}}
function showProbabilityTime(polarAngle){var azimuth;var imageID;showProbability(0,(polarAngle/10)*Math.PI,polarAngle);clearInterval(interval);interval=setInterval(function(){getTime();images_per_s=120/cycle_time;imageID=Math.round(images_per_s*t/1000)%120
azimuth=((imageID)/60)*Math.PI;showProbability(azimuth,polarAngle);showQuantumState(polarAngle);},150);}
function showProbability(azimuth,quantumState){switch(quantumState){case 1:$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(1.0).toFixed(1));$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.0).toFixed(1));$('#Stage_probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.5).toFixed(1));$('#Stage_probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.5).toFixed(1));break;case 10:$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.0).toFixed(1));$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(1.0).toFixed(1));$('#Stage_probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.5).toFixed(1));$('#Stage_probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.5).toFixed(1));break;case 3:$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+0.8);$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+0.2);$('#Stage_probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.5+0.4*Math.cos(azimuth)).toFixed(1));$('#Stage_probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.5-0.4*Math.cos(azimuth)).toFixed(1));break;case 5:$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+0.5);$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+0.5);$('#Stage_probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.5+0.5*Math.cos(azimuth)).toFixed(1));$('#Stage_probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.5-0.5*Math.cos(azimuth)).toFixed(1));break;case 7:$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+0.2);$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+0.8);$('#Stage_probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.5+0.4*Math.cos(azimuth)).toFixed(1));$('#Stage_probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.5-0.4*Math.cos(azimuth)).toFixed(1));break;}}
function showQuantumState(quantumState){var images_per_s=120/cycle_time;var number=Math.round(images_per_s*t/1000)%120;switch(quantumState){case 0:$('#Stage_quantumState2').html('|&psi;&#x232A; = |&uarr;&#x232A;');break;case 10:$('#Stage_quantumState2').html('|&psi;&#x232A; = exp(i&nbsp;'+(number/60).toFixed(1)+'&nbsp;&pi;) |&darr;&#x232A;');break;case 5:$('#Stage_quantumState2').html('|&psi;&#x232A; = 1/&radic;<span style="text-decoration: overline">2</span>(|&uarr;&#x232A; + exp(i&nbsp;'+(number/60).toFixed(1)+'&nbsp;&pi;) |&darr;&#x232A;)');break;case 3:$('#Stage_quantumState2').html('|&psi;&#x232A; = 1/&radic;<span style="text-decoration: overline">5</span>(2 |&uarr;&#x232A; + exp(i&nbsp;'+(number/60).toFixed(1)+'&nbsp;&pi;) |&darr;&#x232A;)');break;case 7:$('#Stage_quantumState2').html('|&psi;&#x232A; = 1/&radic;<span style="text-decoration: overline">5</span>(|&uarr;&#x232A; + 2 exp(i&nbsp;'+(number/60).toFixed(1)+'&nbsp;&pi;) |&darr;&#x232A;)');break;}}
function step_functions(step){clearTimeout(AdobeEdge.step_animation);clearInterval(sphereInterval);switch(step){case 1:clearTimeout(interval);t=1000;updateSphere('sphere2Plot');$('#Stage .radio').each(function(){sym_disable($(this));});$('#Stage .checkbox').each(function(){sym_disable($(this));});$('#Stage_quantumStateBox').hide();$('#Stage_probabilitiesBox').hide();sym_deselect($('#Stage_showProbabilities'));sym_deselect($('#Stage_showQuantumState'));sym_select($('#Stage_inputState4'));sym_select($('#Stage_radioFieldStrength'));break;case 2:clearTimeout(interval);t=1000;setStartTime();sphereInterval=setInterval(function(){getTime();updateSphere('sphere2Plot');},50);$('#Stage_probabilitiesBox').hide();$('#Stage_quantumStateBox').hide();sym_select($('#Stage_inputState4'));state=3;sym_select($('#Stage_radioFieldStrength2'));sym_deselect($('#Stage_showQuantumState'));sym_deselect($('#Stage_showProbabilities'));break;case 3:sphereInterval=setInterval(function(){getTime();updateSphere('sphere2Plot');},50);showProbabilityTime(3);$('#Stage_probabilitiesBox').show();$('#Stage_quantumStateBox').hide();sym_select($('#Stage_showProbabilities'));sym_select($('#Stage_inputState4'));sym_deselect($('#Stage_showQuantumState'));break;case 4:clearTimeout(interval);$('#Stage_quantumState2').html('|&psi;&#x232A; = |&uarr;&#x232A;');sym_select($('#Stage_inputState1'));$('#Stage_probabilitiesBox').show();$('#Stage_quantumStateBox').show();sym_select($('#Stage_showProbabilities'));sym_select($('#Stage_showQuantumState'));$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2: &nbsp;&nbsp;&nbsp;&nbsp;1.0');$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.0');$('#Stage_probSpinUpX').html('S<sub>x</sub> = +&#295;/2: &nbsp;&nbsp;&nbsp;&nbsp;0.5');$('#Stage_probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.5');t=0;updateSphere('plotup');break;}}
function clearAnimation(){clearTimeout(interval);state=0;vel=0;startAnimation(state);$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.0');$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.0');}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);$(element).data('timeout_val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();preloadImages();setStartTime();yepnope({load:"normalize.css"});sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});yepnope({load:"normalize.css"});sym.$('title').html('Time development of two-level quantum states in the Bloch sphere');sym.$('mainText').html('<span style="line-height: 1.3;">Consider a spin &#189; particle of charge &#8211;e and mass m (such as an electron) in a uniform magnetic field of strength B oriented along the z&#8209;axis. Due to its spin, the particle acts like a small bar magnet when in an external magnetic field. This gives rise to two different energy states, depending on whether the spin component S<sub>z</sub> (which can only take the values +&#295;/2 or &#8211;&#295;/2)  is parallel or antiparallel to the magnetic field.  The spin-down state |&darr;&#x232A;  with S<sub>z</sub>=&#8211;&#295;/2 has the lower energy E<sub>1</sub>, the spin-up state |&uarr;&#x232A;  with S<sub>z</sub>=+&#295;/2 the higher energy E<sub>2</sub>. The two energies are separated by </span>');sym.$('mainText2').html('<span style="line-height: 1.3;">The image on the left shows you the time-development of the spin quantum state in the Bloch sphere representation. The North and South poles correspond to the states |&uarr;&#x232A; and |&darr;&#x232A; respectively.  You can use the buttons to choose different initial states at time t&nbsp;=&nbsp;0.</span>');sym.$('probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.0');sym.$('probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.0');sym.$('probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.5');sym.$('probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.5');sym.$('quantumStateTitle').html('Quantum state |&psi;(t)&#x232A;');sym.$('inputTitle').html('Input state |&psi;(0)&#x232A;');sym.$('inputText1').html('<span style="line-height: 1.3;">|&uarr;&#x232A;</span>');sym.$('inputText2').html('<span style="line-height: 1.3;">|&darr;&#x232A;</span>');sym.$('inputText3').html('<span style="line-height: 1.3;"><nobr>1/&radic;<span style="text-decoration: overline">2</span>&nbsp;(|&uarr;&#x232A; + |&darr;&#x232A;)</nobr></span>');sym.$('inputText4').html('<span style="line-height: 1.3;"><nobr>1/&radic;<span style="text-decoration: overline">5</span>&nbsp;(2 |&uarr;&#x232A; + |&darr;&#x232A;)</nobr></span>');sym.$('inputText5').html('<span style="line-height: 1.3;"><nobr>1/&radic;<span style="text-decoration: overline">5</span>&nbsp;(|&uarr;&#x232A; + 2 |&darr;&#x232A;)</nobr></span>');sym.$('quantumState1').html('|&psi;&#x232A; = cos(&theta;/2) |&uarr;&#x232A; + sin(&theta;/2) exp(i &omega;t) |&darr;&#x232A;');sym.$('quantumState2').html('|&psi;&#x232A; = |&uarr;&#x232A;');sym.getSymbol('steps').$('phi').html('&#981;');sym.getSymbol('steps').$('theta').html('&theta;');sym.getSymbol('steps').$('step_text1').html('The Bloch sphere representation gives a one-to-one correspondence between points on a sphere and the quantum state ');sym.getSymbol('steps').$('step_text11').html('of the spin &#189; particle. You can see that the angles &theta; and &#981; can be interpreted as the azimuthal and polar angles (in spherical polar coordinates) of the points on the sphere. ');sym.getSymbol('steps').$('step_text2').html('If &#981;&nbsp;=&nbsp;0 at time t&nbsp;=&nbsp;0, then ');sym.getSymbol('steps').$('step_text22').html('We can rewrite this as ');sym.getSymbol('steps').$('step_text23').html('We can neglect the global phase factor exp( &#8211;i&omega;<sub>2</sub>t) as it has no physical consequences since |exp(&#8211;i&omega;<sub>2</sub>t)|<sup>2</sup>&nbsp;=&nbsp;1. Setting &omega;&nbsp;=&nbsp;&omega;<sub>2</sub>&nbsp;&#8211;&nbsp;&omega;<sub>1</sub>,');sym.getSymbol('steps').$('step_text24').html('Thus, the azimuthal angle &#981;=&omega;t changes with time. In the Bloch sphere representation, this implies that the spin state rotates around the z&#8209;axis with angular frequency &omega;. ');sym.getSymbol('steps').$('step_text3').html('As the angle &theta; is unchanged by the rotation, you can see that the probabilities for measurement outcomes of the spin projection S<sub>z</sub> along the z&#8209;axis do not change with time. In contrast, the probabilities for measurement outcomes of S<sub>x</sub> are time-dependent. For what points on the Bloch sphere is the probability of  measuring S<sub>x</sub>=+&#295;/2 maximal and minimal? ');sym.getSymbol('steps').$('step_text4').html('<span style="line-height: 1.3;">If the initial state is an energy eigenstate (|&uarr;&#x232A; or |&darr;&#x232A;), you can see that the quantum state then does not change with time. This is why energy eigenstates are also called stationary states.</span> ');state=0;startAnimation(state);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_showQuantumState}","click",function(sym,e){(sym.$('showQuantumState').hasClass('selected'))?sym.$('quantumStateBox').show():sym.$('quantumStateBox').hide()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_showProbabilities}","click",function(sym,e){(sym.$('showProbabilities').hasClass('selected'))?sym.$('probabilitiesBox').show():sym.$('probabilitiesBox').hide()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_inputState3}","click",function(sym,e){state=5;startAnimation(state);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_inputState4}","click",function(sym,e){state=3;startAnimation(state);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_inputState5}","click",function(sym,e){state=7;startAnimation(state);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_inputState2}","click",function(sym,e){state=10;startAnimation(state);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){sym.stop('simulation');sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);sym.$('quantumStateBox').show();sym.$('probabilitiesBox').show();sym_select($('#Stage_showProbabilities'));sym_select($('#Stage_showQuantumState'));sym_select($('#Stage_inputState1'));sym_select($('#Stage_radioFieldStrength'));$('#Stage .radio').each(function(){sym_enable($(this));});$('#Stage .checkbox').each(function(){sym_enable($(this));});sym.$('probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.5');sym.$('probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.5');state=0;vel=0;clearAnimation();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_explanation}","click",function(sym,e){sym.stop('explanation');sym_features();sym_step(1);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_inputState1}","click",function(sym,e){state=0;startAnimation(state);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radioFieldStrength}","click",function(sym,e){vel=0;startAnimation(state);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radioFieldStrength2}","click",function(sym,e){vel=1;startAnimation(state);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrewsCopy}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_quantumphysics}","click",function(sym,e){window.open('http://quantumphysics.iop.org','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_iop}","click",function(sym,e){window.open('http://www.iop.org','_blank');});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'highlight'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight");
//Edge symbol end:'highlight'

//=========================================================

//=========================================================

//=========================================================

//=========================================================

//Edge symbol: 'highlight'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight_1_1");
//Edge symbol end:'highlight_1_1'
})(jQuery,AdobeEdge,"EDGE-19890435");