/*  Copyright 2017, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
Chart.js http://chartjs.org/ Version: 1.0.2 Copyright 2015 Nick Downie Released under the MIT license https://github.com/nnnick/Chart.js/blob/master/LICENSE.md

*/

(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var n=0;var images=[];var cycle_time=18;var frame_time=50;var time_step=cycle_time*1000/360;var graph=null;var intervalMag,intervalWave,interval_x0,arrowInterval,intervalArgand;var t=0;var start_t;var x0_pos=0.25;var amplitude=1,amplitude_psi1=1,amplitude_psi2=0,amplitude_sup=0.5;var show_mag_graph=false,show_x0=true,psi1_on=true,psi2_on=false,sup_on=false,show_rot_graph=false,simulation=true;var simulation_show_mag_graph,simulation_show_x0,simulation_stop,simulation_t=t,simulation_psi1_on,simulation_psi2_on,simulation_sup_on,simulation_show_rot_graph;var x_axis={minX:0,maxX:1.0,step:1/75,showXLabels:6,xDecimals:0};var line_colors=["rgba(0,0,225,1)","rgba(1,223,58,1)","rgba(0,139,136,1)"]
var data_strucs=[];var struc;var config={datasetStrokeWidth:2,scaleOverride:true,scaleSteps:0.1,scaleStepWidth:13,scaleStartValue:-0.1};var help_text=[];help_text["Stage_help_introduction"]='The time-dependence <br>of the one-dimensional infinite square well energy eigenstate '+'<nobr><i>&psi;<sub>n</sub></i>(<i>x,t</i>) = <i>&psi;<sub>n</sub></i>(<i>x</i>) <i>e<sup>&ndash;iE<sub>n</sub>t/&#295;</i></sup></nobr> corresponds to a rotation of <i>&psi;<sub>n</sub></i>(<i>x</i>) in the complex plane, '+'with angular frequency <nobr><i>&omega;<sub>n</sub>=E<sub>n</sub>/&#295;</nobr></i> where <nobr><i>E<sub>n</sub>=n<sup>2</sup>E<sub>1</sub></nobr></i> . '+'Use the "?" buttons for more information. Then try the Challenges!';help_text["Stage_help_show_point"]='The time-dependence <br>of the energy eigenstate <nobr><i>&psi;<sub>n</sub></i>(<i>x,t</i>) = <i>&psi;<sub>n</sub></i>(<i>x</i>) <i>e<sup>&ndash;iE<sub>n</sub>t/&#295;</i></sup></nobr> '+'corresponds to a rotation of <i>&psi;<sub>n</sub></i>(<i>x</i>) in the complex plane, with phase <i>E<sub>n</sub>t</i>/<i>&#295;</i>. The rotation period <i>T</i> is given by <i>E<sub>n</sub>T</i>/<i>&#295;</i>=2<i>&pi;</i> and thus <i>T</i>=<i>h/E<sub>n</sub></i>. '+'The time shown at the top left is in multiples of the rotation period <i>T</i>=<i>h/E<sub>1</sub></i> of the ground state. ';help_text["Stage_help_complex"]='At each point <i>x</i><sub>0</sub>, the <br>energy eigenstate <nobr><i>&psi;<sub>n</sub></i>(<i>x,t</i>) = <i>ψ<sub>n</sub></i>(<i>x</i>)<i> e<sup>&ndash;iE<sub>n</sub>t/&#295;</sup></i></nobr> '+'has a fixed magnitude, but the phase in the complex plane changes with time. If the quantum state is composed of more than one energy eigenstate, '+'the magnitude of <i>&psi;</i> at point <i>x</i><sub>0</sub> is found by adding the component wave functions in the complex plane.';help_text["Stage_help_magnitude"]='The probability density <br>|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> at point <i><br>x</i><sub>0</sub> '+'is the square of the magnitude at point <i><br>x</i><sub>0</sub>. '+'For the superposition of <i>&psi;</i><sub>1</sub> and <i>&psi;</i><sub>2</sub>, the oscillation period of <nobr>|<i>&psi;</i>(<i>x</i>)|<sup>2</sup></nobr> equals the time needed for both curves in the top left graph to line up again with a zero phase difference.';help_text["Stage_help_quantum_state"]='The energy eigenstates <i><nobr>&psi;<sub>n</sub></i>(<i>x,t</i>) = <i>&psi;<sub>n</sub></i>(<i>x</i>)<i> e<sup>&ndash;iE<sub>n</sub>t/&#295;</sup></nobr></i> with <nobr><i>&psi;<sub>n</sub></i>(<i>x</i>) = <i>&radic;<span style="text-decoration: overline">2/L</span> sin</i>(<i>n&pi;x/L</i>)</nobr> '+'each have a different time-dependence, as the energy <i>E<sub>n</sub></i> is different for each. The energy <nobr><i>E</i><sub>2</sub> = 4<i>E</i><sub>1</sub>.</nobr> '+'Thus, the angular frequency of the time-development of the first-excited state is four times greater than that of the ground state.';var challenge_text=[];challenge_text[1]='The graph shows you the time-development of the ground state <i>&psi;</i><sub>1</sub> and the first-excited state <i>&psi;</i><sub>2</sub> in the complex plane. '+'Consider the state <i>&psi;</i> = 1/&radic;<span style="text-decoration: overline">2</span> </i>(<i>&psi;</i><sub>1</sub>+<i>&psi;</i><sub>2</sub>) at time <i>t</i> = 0 shown. '+'Set up the state which corresponds to a <b>single</b> oscillation period of the probability density <nobr>|<i>&psi;</i>|<sup>2</sup></nobr> curve (which is not shown!). Then press submit.';challenge_text[2]='The graphs shows you the time-development of the superposition state <nobr><i>&psi;</i> = 1/&radic;<span style="text-decoration: overline">2</span> (<i>&psi;</i><sub>1</sub>+<i>&psi;</i><sub>2</sub>)</nobr>. '+'The ground state and first excited state rotate with frequencies <nobr><i>&omega;</i><sub>1</sub> = <i>E</i><sub>1</sub>/<i>&#295;</i></nobr> and <nobr><i>&omega;</i><sub>2</sub> = 4<i>E</i><sub>1</sub>/<i>&#295;</i></nobr> respectively in the top graph. '+'What is the oscillation frequency <i>&omega;</i> of the associated <nobr>|<i>&psi;</i>|<sup>2</sup></nobr> curve shown in the lower graph?';challenge_text[3]='The graph shows you the ground state <i>&psi;</i><sub>1</sub> and the <b>second</b>-excited state <i>&psi;</i><sub>3</sub> (not the first-excited state!) at one instant in time in the complex plane. '+'How much more quickly will the second-excited state <i>&psi;</i><sub>3</sub> rotate with time in the complex plane compared with <i>&psi;</i><sub>1</sub>? '+'Use the fact that <nobr><i>E</i><sub>n</sub> = <i>n</i><sup>2</sup> <i>E</i><sub>1</sub>!</nobr>';function preloadImages(){var prefixes=['n1','n2','sup'],numberImages=[360,90,360],length=prefixes.length;for(var i=0;i<length;i++){_preloadImages(prefixes[i],numberImages[i]);}};function _preloadImages(prefix,number){for(var i=0;i<number;i++){var name=prefix+'WaveFunctiont'+i,image=new Image();image.onload=function(){};image.onerror=function(){console.error("Error occur while preloading image: "+name);};image.src='./images/Mathematica Plots/'+name+'.gif';images.push(image);};};function showHelpText(sym,e){var help_button;if(e===undefined){help_button=$("#Stage_help_default");}else{help_button=$(e.target).parent();};sym_enable(sym.$('.disabled.help'));sym_disable(help_button);sym.$('help_text').html(help_text[help_button.attr("id")]);sym.$("help_content").show();};function enableAllHelpButtons(){$('#Stage .help').each(function(){sym_enable(this);});};function updateStage(){setStartTime();plotWave();plotMagnitude();showX0();argandMove();};function setStartTime(){var d=new Date();start_t=d.getSeconds()*1000+d.getMilliseconds();start_t-=t};function plotWave(){if(!show_rot_graph){$('#Stage_complex_plane_graph').hide();}
if(show_rot_graph){$('#Stage_complex_plane_graph').show();}
if(!stop){clearInterval(intervalWave);intervalWave=setInterval(updateWave,frame_time);}
else{clearInterval(intervalWave);updateWave();};}
function updateWave(){getTime();var images_per_s=360/cycle_time;if(sup_on){src0='./images/Mathematica Plots/supWaveFunctiont'+Math.round(images_per_s*t/1000)%360+'.gif';}
else if(psi1_on){src0='./images/Mathematica Plots/n1WaveFunctiont'+Math.round(images_per_s*t/1000)%360+'.gif';}
else if(psi2_on){src0='./images/Mathematica Plots/n2WaveFunctiont'+Math.round(images_per_s*t/1000)%90+'.gif';};var graph0=$("#Stage_wavefunction_graph");graph0.attr("src",src0);updatePhaseText();};function getTime(){var d=new Date();var now=d.getSeconds()*1000+d.getMilliseconds();t=now-start_t;t=(t>=0)?t:60000+t;t=Math.round(t/time_step)*time_step;updateTimeText();}
function updateTimeText(){var periods=Math.floor(t/(1000*cycle_time));if(!stop){$('#Stage_time_text').html('Time <i>t</i> = ('+periods+' + '+((t/(1000*cycle_time))%1).toFixed(2)+') <i>h</i>/<i>E</i><sub>1</sub>');}else{$('#Stage_time_text').html('Time <i>t</i> = ('+periods+' + '+((t/(1000*cycle_time))%1).toFixed(3)+') <i>h</i>/<i>E</i><sub>1</sub>');};};function magnitude(x){var cf=0.85;if(sup_on){var time=2*Math.PI*t/(cycle_time*1000);return cf*(0.5*Math.pow(Math.sin(Math.PI*x),2)+0.5*Math.pow(Math.sin(2*Math.PI*x),2)+1*Math.sin(Math.PI*x)*Math.sin(2*Math.PI*x)*Math.cos(3*time));}
else if(psi1_on){return cf*Math.pow(Math.sin(Math.PI*x),2);}
else if(psi2_on){return cf*Math.pow(Math.sin(2*Math.PI*x),2);};};function plotMagnitude(){var element=$('#Stage_magnitude_graph_canvas');clearInterval(intervalMag);if(graph!=null){graph.destroy();};if(show_mag_graph){$('#Stage_magnitude_graph').show();if(sup_on){struc={strokeColor:line_colors[2]};data_strucs=[];data_strucs.push(struc);if(!stop){intervalMag=setInterval(animateMagGraph,frame_time);}
else{animateMagGraph();};}
else if(psi1_on){struc={strokeColor:line_colors[0]};data_strucs=[];data_strucs.push(struc);graph=new FunctionGraph(element,[magnitude],x_axis,data_strucs,config);}
else if(psi2_on){struc={strokeColor:line_colors[1]};data_strucs=[];data_strucs.push(struc);graph=new FunctionGraph(element,[magnitude],x_axis,data_strucs,config);}}else{$('#Stage_magnitude_graph').hide();};};function animateMagGraph(){var element=$('#Stage_magnitude_graph_canvas');graph=new FunctionGraph(element,[magnitude],x_axis,data_strucs,config);}
function showX0(){if(show_x0){setX0();$('#Stage_argand_graph').show();$('#Stage_x0_dot').show();$('#Stage_amplitude_text').show();if(show_mag_graph){$('#Stage_x0_mag').show();}else{$('#Stage_x0_mag').hide();};sym_enable($('#Stage_slider_x0'));updateLegend();clearInterval(intervalArgand);if(!stop){intervalArgand=setInterval(argandMove,frame_time);}}
else{clearInterval(intervalArgand);$('#Stage_argand_graph').hide();$('#Stage_amplitude_text').hide();sym_disable($('#Stage_slider_x0'));$('#Stage_x0_mag').hide();$('#Stage_x0_dot').hide();}}
var stop=false;function playToggle(){if(stop){stop=false;$("#Stage_button_stop_label").html("Stop");sym_disable($('#Stage_backButton'));sym_disable($('#Stage_forwardButton'));updateStage();}else{stop=true;$("#Stage_button_stop_label").html("Resume");sym_enable($('#Stage_backButton'));sym_enable($('#Stage_forwardButton'));updateStage();}}
function setX0(){if(show_x0){clearInterval(interval_x0);amplitude_psi1=Math.abs(Math.sin(Math.PI*(x0_pos)));amplitude_psi2=Math.sin(2*Math.PI*(x0_pos));if(sup_on){amplitude_psi1/=Math.sqrt(2);amplitude_psi2/=Math.sqrt(2);if(!stop){interval_x0=setInterval(superpositionX0,frame_time);};superpositionX0();}else if(psi1_on){amplitude=amplitude_psi1;}
else if(psi2_on){amplitude=Math.abs(amplitude_psi2);};updatePositionX0Line(amplitude);$('#Stage_amplitude_text').html('<font color="#c00000"> |<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup>\ = '+(Math.pow(amplitude,2)).toFixed(2)+' (2/<i>L</i>) (red line)');$('#Stage_argand_title').html('Complex plane at point <i>x</i><sub>0</sub> = '+x0_pos.toFixed(2)+'<i>L</i>');};};function superpositionX0(){var time=2*Math.PI*t/(cycle_time*1000);amplitude_sup=Math.pow(0.5*Math.pow(Math.sin(Math.PI*x0_pos),2)+0.5*Math.pow(Math.sin(2*Math.PI*x0_pos),2)+1*Math.sin(Math.PI*x0_pos)*Math.sin(2*Math.PI*x0_pos)*Math.cos(3*time),0.5);amplitude=amplitude_sup;updatePositionX0Line(amplitude);$('#Stage_amplitude_text').html('<font color="#c00000"> |<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup>\ = '+(Math.pow(amplitude,2)).toFixed(2)+' (2/<i>L</i>) (red line)');}
function updatePositionX0Line(amplitude){var cf=0.85;var slider=$('#Stage_slider_x0');var y_axis_left=20,L_left=376,norm_height=96;$('#Stage_x0_mag').css('left',y_axis_left+x0_pos*(L_left-y_axis_left));$('#Stage_x0_line').css('height',cf*norm_height*Math.pow(amplitude,2));var pow=1.06;$('#Stage_x0_dot').css({'left':40+Math.pow(x0_pos,pow)*(402-40),'top':137+Math.pow(x0_pos,pow)*(182-137)});}
function argandMove(){var time=2*Math.PI*t/(cycle_time*1000),angle,pos_end=[],norm_length=90,left_centre=122,top_centre=116;if(psi1_on||sup_on){if(sup_on){}
pos_end[0]=[(norm_length*amplitude_psi1)*Math.cos(time),(norm_length*amplitude_psi1)*Math.sin(time)];angle=Math.atan(pos_end[0][1]/pos_end[0][0]);angle=(pos_end[0][0]>0)?angle:angle-Math.PI;$('#Stage_psi1_line').show();$('#Stage_psi1_line').css({'width':norm_length*amplitude_psi1,'left':left_centre-(norm_length*amplitude_psi1/2)+pos_end[0][0]/2,'top':top_centre+pos_end[0][1]/2,'-webkit-transform':'rotate('+angle+'rad)','-ms-transform':'rotate('+angle+'rad)','-moz-transform':'rotate('+angle+'rad)','-o-transform':'rotate('+angle+'rad)','transform':'rotate('+angle+'rad)','background-color':sup_on?'rgba(0,0,255,1.00)':'rgba(192,0,0,1.00)'});}else{$('#Stage_psi1_line').hide();}
if(psi2_on||sup_on){pos_end[1]=[(norm_length*amplitude_psi2)*Math.cos(4*time),(norm_length*amplitude_psi2)*Math.sin(4*time)];angle=Math.atan(pos_end[1][1]/pos_end[1][0]);angle=(pos_end[1][0]>0)?angle:angle-Math.PI;$('#Stage_psi2_line').show();$('#Stage_psi2_line').css({'width':norm_length*Math.abs(amplitude_psi2),'left':left_centre-(norm_length*Math.abs(amplitude_psi2)/2)+pos_end[1][0]/2,'top':top_centre+pos_end[1][1]/2,'-webkit-transform':'rotate('+angle+'rad)','-ms-transform':'rotate('+angle+'rad)','-moz-transform':'rotate('+angle+'rad)','-o-transform':'rotate('+angle+'rad)','transform':'rotate('+angle+'rad)','background-color':sup_on?'rgba(1,223,58,1.00)':'rgba(192,0,0,1.00)'});}else{$('#Stage_psi2_line').hide();}
if(sup_on){superpositionX0();pos_end[2]=[(norm_length*amplitude_psi1)*Math.cos(time)+(norm_length*amplitude_psi2)*Math.cos(4*time),(norm_length*amplitude_psi1)*Math.sin(time)+(norm_length*amplitude_psi2)*Math.sin(4*time)];angle=Math.atan(pos_end[2][1]/pos_end[2][0]);angle=(pos_end[2][0]>0)?angle:angle-Math.PI;$('#Stage_superposition_line').show();$('#Stage_superposition_line').css({'width':norm_length*amplitude_sup,'left':left_centre-(norm_length*amplitude_sup/2)+pos_end[2][0]/2,'top':top_centre+pos_end[2][1]/2,'-webkit-transform':'rotate('+angle+'rad)','-ms-transform':'rotate('+angle+'rad)','-moz-transform':'rotate('+angle+'rad)','-o-transform':'rotate('+angle+'rad)','transform':'rotate('+angle+'rad)',});angle=Math.atan(pos_end[0][1]/pos_end[0][0]);angle=(pos_end[0][0]>0)?angle:angle-Math.PI;$('#Stage_dashed_psi1_line').show();$('#Stage_dashed_psi1_line').css({'width':norm_length*amplitude_psi1,'left':left_centre+pos_end[1][0]-(norm_length*amplitude_psi1/2)+pos_end[0][0]/2,'top':top_centre+pos_end[1][1]+pos_end[0][1]/2,'-webkit-transform':'rotate('+angle+'rad)','-ms-transform':'rotate('+angle+'rad)','-moz-transform':'rotate('+angle+'rad)','-o-transform':'rotate('+angle+'rad)','transform':'rotate('+angle+'rad)',});angle=Math.atan(pos_end[1][1]/pos_end[1][0]);angle=(pos_end[1][0]>0)?angle:angle-Math.PI;$('#Stage_dashed_psi2_line').show();$('#Stage_dashed_psi2_line').css({'width':norm_length*Math.abs(amplitude_psi2),'left':left_centre+pos_end[0][0]-(norm_length*Math.abs(amplitude_psi2)/2)+pos_end[1][0]/2,'top':top_centre+pos_end[0][1]+pos_end[1][1]/2,'-webkit-transform':'rotate('+angle+'rad)','-ms-transform':'rotate('+angle+'rad)','-moz-transform':'rotate('+angle+'rad)','-o-transform':'rotate('+angle+'rad)','transform':'rotate('+angle+'rad)',});}
else{$('#Stage_superposition_line').hide();$('#Stage_dashed_psi1_line').hide();$('#Stage_dashed_psi2_line').hide();}}
function updatePhaseText(){var angle=360*t/(cycle_time*1000);var cycle=2*Math.floor(angle/360.);var cycle2=2*Math.floor(angle/90.);if(psi1_on||sup_on){$('#Stage_phase_text_phi1_angle').show();}
else{$('#Stage_phase_text_phi1_angle').hide();}
if(psi1_on){$('#Stage_phase_text_phi1_angle').html('<i>&psi;<sub>1</sub></i>(<i>x</i>)<i>e<sup>&thinsp;&ndash;&thinsp;i&thinsp;</i></sup>'+'<sup>(</sup>'+
cycle.toFixed(0).sup()+'<sup>&pi;+</sup>'+
(angle%360./180).toFixed(2).sup()+'<sup><i>&pi;</i>)</sup>');}
if(sup_on){$('#Stage_phase_text_phi1_angle').html('1/&radic;<span style="text-decoration: overline">2</span>(<i>&psi;<sub>1</sub></i>(<i>x</i>)<i>e<sup>&thinsp;&ndash;&thinsp;i&thinsp;</i></sup>'+'<sup>(</sup>'+
cycle.toFixed(0).sup()+'<sup>&pi;+</sup>'+
(angle%360./180).toFixed(2).sup()+'<sup><i>&pi;</i>)</sup>');}
if(psi2_on||sup_on){$('#Stage_phase_text_phi2_angle').show();}
else{$('#Stage_phase_text_phi2_angle').hide();}
if(psi2_on){$('#Stage_phase_text_phi2_angle').html('<i>&psi;<sub>2</sub></i>(<i>x</i>)<i>e<sup>&thinsp;&ndash;&thinsp;i&thinsp;</i></sup>'+'<sup>(</sup>'+
cycle2.toFixed(0).sup()+'<sup>&pi;+</sup>'+
((4*angle)%360./180).toFixed(2).sup()+'<sup><i>&pi;</i>)</sup>');}
if(sup_on){$('#Stage_phase_text_phi2_angle').html('<i>&psi;<sub>2</sub></i>(<i>x</i>)<i>e<sup>&thinsp;&ndash;&thinsp;i&thinsp;</i></sup>'+'<sup>(</sup>'+
cycle2.toFixed(0).sup()+'<sup>&pi;+</sup>'+
((4*angle)%360./180).toFixed(2).sup()+'<sup><i>&pi;</i>)</sup>)');var d_angle=Math.abs((4*angle-angle)%360);$('#Stage_phase_text_phi_diff').show();$('#Stage_phase_text_phi_diff_angle').show();$('#Stage_phase_text_phi_diff_angle').html(Math.round(d_angle)+'&deg;')}
else{$('#Stage_phase_text_phi_diff').hide();$('#Stage_phase_text_phi_diff_angle').hide();}}
function updateLegend(){$('#Stage .leg').each(function(){$(this).hide();});$('#Stage_sup_leg').show();$('#Stage_sup_col').show();if(psi1_on){$('#Stage_sup_leg').html('<i>&psi;</i><sub>1</sub></i>(<i>x</i><sub>0</sub>)');};if(psi2_on){$('#Stage_sup_leg').html('<i>&psi;</i><sub>2</sub></i>(<i>x</i><sub>0</sub>)');};if(sup_on){$('#Stage_psi1_leg').show();$('#Stage_psi1_col').show();$('#Stage_psi1_leg').html('1/&radic;<span style="text-decoration: overline">2</span> <i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>)');$('#Stage_psi2_leg').show();$('#Stage_psi2_col').show();$('#Stage_psi2_leg').html('1/&radic;<span style="text-decoration: overline">2</span> <i>&psi;</i><sub>2</sub>(<i>x</i><sub>0</sub>)');$('#Stage_sup_leg').html('1/&radic;<span style="text-decoration: overline">2</span>(<i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>)+<i>&psi;</i><sub>2</sub>(<i>x</i><sub>0</sub>))');$('#Stage_sup_leg').css('left',-31);$('#Stage_sup_col').css('left',-56);}else{$('#Stage_sup_leg').css('left',20);$('#Stage_sup_col').css('left',-5);};};var correct_answer,correct=false,current_challenge=1,score_for_challenge=[20,20,20,20,20],challenge_complete=[false,false,false,false,false],totalScore=0,fireworkProb=1;function challengeReset(){$('#Stage_feedback_text').hide();};function shuffle(array){var currentIndex=array.length,temporaryValue,randomIndex;while(0!==currentIndex){randomIndex=Math.floor(Math.random()*currentIndex);currentIndex-=1;temporaryValue=array[currentIndex];array[currentIndex]=array[randomIndex];array[randomIndex]=temporaryValue;}
return array;}
function step_functions(step){clearTimeout(AdobeEdge.step_animation);current_challenge=step;challengeReset();switch(step){case 1:show_mag_graph=false;psi1_on=false;psi2_on=false;sup_on=true;$('#Stage_time_text').hide();$('#Stage_phase_text').show();stop=true;$("#Stage_button_stop_label").html("Resume");$('#Stage_graph_control').show();sym_enable($('#Stage_backButton'));sym_enable($('#Stage_forwardButton'));t=0;$('#Stage .group_answer').each(function(){$(this).hide();})
updateStage();break;case 2:show_mag_graph=true;psi1_on=false;psi2_on=false;sup_on=true;$('#Stage_time_text').hide();$('#Stage_phase_text').show();stop=true;$("#Stage_button_stop_label").html("Resume");$('#Stage_graph_control').show();sym_enable($('#Stage_backButton'));sym_enable($('#Stage_forwardButton'));;t=0;$('#Stage .group_answer').each(function(){$(this).show();var id=$(this).attr('id');id=id.substr(id.length-1);$('#Stage_radio_label_answer'+id).html(parseInt(id)+2+'<i>&omega;</i><sub>1<sub>');sym_deselect($(this));})
correct_answer=1;$('#Stage .radio_text').css('top',16);updateStage();break;case 3:show_mag_graph=false;psi1_on=false;psi2_on=false;sup_on=true;$('#Stage_time_text').hide();$('#Stage_phase_text').hide();stop=true;$('#Stage_graph_control').hide();t=0;$('#Stage .group_answer').each(function(){$(this).show();sym_deselect($(this));});$('#Stage .radio_text').css('top',16);$('#Stage_radio_label_answer0').html('3 times faster');$('#Stage_radio_label_answer1').html('4 times faster');$('#Stage_radio_label_answer2').html('8 times faster');$('#Stage_radio_label_answer3').html('9 times faster');correct_answer=3;updateStage();var angles=[75,86,127,236,296];var q3_angle=angles[Math.floor(Math.random()*angles.length)];$("#Stage_wavefunction_graph").attr("src",'./images/Mathematica Plots/Questions/sup2WaveFunctiont'+q3_angle+'.gif');break;case 4:show_mag_graph=false;psi1_on=false;psi2_on=false;sup_on=true;$('#Stage_time_text').hide();$('#Stage_phase_text').hide();stop=true;$('#Stage_graph_control').hide();t=0;$('#Stage .group_answer').each(function(){$(this).show();sym_deselect($(this));})
choices=[{str:'|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> currently has its maximal value',correct:false},{str:'|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> > 0, but currently has its minimal value',correct:true},{str:'|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> is in between its maximum and minimum',correct:false},{str:'|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> = 0 and currently has its minimal value',correct:false}];shuffle(choices);$.each(choices,function(index,value){$('#Stage_radio_label_answer'+index).html(value.str);if(value.correct){correct_answer=index;};});x0_pos=Math.random();while(((x0_pos<0.38)||(0.45<x0_pos)&&(x0_pos<0.55))||(0.62<x0_pos)){x0_pos=Math.random();};challenge_text[4]='The graph shows you a superposition <i>&psi;</i> = 1/&radic;<span style="text-decoration: overline">2</span> (<i>&psi;</i><sub>1</sub>+<i>&psi;</i><sub>3</sub></i>) '+'of the ground state <i>&psi;</i><sub>1</sub> and the <b>second</b>-excited state <i>&psi;</i><sub>3</sub> (not the first-excited state!) at one instant in time. '+'For the indicated point <nobr><i>x</i><sub>0</sub> = '+x0_pos.toFixed(2)+'<i>L</i></nobr> (red dot), '+'how does the probability density <nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>='+x0_pos.toFixed(2)+'<i>L</i>)|<sup>2</sup></nobr> '+'at the given time compare with '+'<nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>='+x0_pos.toFixed(2)+'<i>L</i>)|<sup>2</sup></nobr> at other times? ';updateStage();$('#Stage_x0_dot').show();var angles=[90,270];var q4_angle=angles[Math.floor(Math.random()*angles.length)];$("#Stage_wavefunction_graph").attr("src",'./images/Mathematica Plots/Questions/sup2WaveFunctiont'+q4_angle+'.gif');break
case 5:show_mag_graph=false;$('#Stage_time_text').hide();$('#Stage_phase_text').hide();stop=true;$('#Stage_graph_control').hide();t=0;$('#Stage .group_answer').each(function(){$(this).show();sym_deselect($(this));});choices=[{str:'|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> currrently has its maximal value',correct:false},{str:'|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> > 0, but currently has its minimal value',correct:false},{str:'|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> is in between its maximum and minimum',correct:true},{str:'|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> = 0 and currently has its minimal value',correct:false}];shuffle(choices);$.each(choices,function(index,value){$('#Stage_radio_label_answer'+index).html(value.str);if(value.correct){correct_answer=index;};});x0_pos=Math.random();while(((x0_pos<0.05)||(0.28<x0_pos)&&(x0_pos<0.72))||(0.95<x0_pos)){x0_pos=Math.random();};challenge_text[5]='The graph shows you a superposition <nobr><i>&psi;</i> = 1/&radic;<span style="text-decoration: overline">2</span> (<i>&psi;</i><sub>1</sub>+<i>&psi;</i><sub>3</sub>)</nobr> '+'of the ground state <i>&psi;</i><sub>1</sub> and the <b>second</b>-excited state <i>&psi;</i><sub>3</sub> at one instant in time. '+'The phase difference between <i>&psi;</i><sub>1</sub> and <i>&psi;</i><sub>3</sub> is 90 degrees. '+'For the indicated point <nobr><i>x</i><sub>0</sub> = '+x0_pos.toFixed(2)+'<i>L</i></nobr> (red dot), '+'how does the probability density <nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>='+x0_pos.toFixed(2)+'<i>L</i>)|<sup>2</sup></nobr> '+'at the given time compare with '+'<nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>='+x0_pos.toFixed(2)+'<i>L</i>)|<sup>2</sup></nobr> at other times? ';updateStage();$('#Stage_x0_dot').show();var angles=[78.75,146.25,168.75,258.75];var q4_angle=angles[Math.floor(Math.random()*angles.length)];$("#Stage_wavefunction_graph").attr("src",'./images/Mathematica Plots/Questions/sup2WaveFunctiont'+q4_angle+'.gif');break}
var text=$('#Stage_challenge_text');text.html(challenge_text[step]);};function challengeSubmit(){var feedback=$('#Stage_feedback_text'),none_selected=true,feedback_str;correct=false;switch(current_challenge){case 1:if(t==0){feedback_str="Use the Resume and step controls to set up the state which corresponds to a single oscillation period of the probability density <nobr>|<i>&psi;</i>(<i>x,t</i>)|<sup>2</sup></nobr> curve."}else if(Math.round(t)%(cycle_time*1000)==Math.round((cycle_time*1000)/3)){correct=true;feedback_str="Correct congratulations! For the superposition of <nobr><i>&psi;</i><sub>1</sub></nobr> and <nobr><i>&psi;</i><sub>2</sub></nobr>, the oscillation period of <nobr>|<i>&psi;</i>(<i>x,t</i>)|<sup>2</sup></nobr> "+"equals the time needed for both curves in the graph to line up again with a zero phase difference.";}
else if((Math.round(t)%(cycle_time*1000)==2*(cycle_time*1000)/3)){feedback_str="This is not yet correct. This shows the state after two oscillation periods, not a single oscillation period.";}
else if((Math.round(t)%(cycle_time*1000)==1*(cycle_time*1000)/6)||(Math.round(t)%(cycle_time*1000)==3*(cycle_time*1000)/6)||(Math.round(t)%(cycle_time*1000)==5*(cycle_time*1000)/6)){feedback_str="This is not yet correct. This shows the state after a half-integer number of oscillation periods, not a single oscillation period.";}
else if((Math.round(t)%(cycle_time*1000)==0)){feedback_str="This is not yet correct. This shows the state after three oscillation periods, not a single oscillation period.";}
else{feedback_str="This is not yet correct. For the superposition of <nobr><i>&psi;</i><sub>1</sub></nobr> and <nobr><i>&psi;</i><sub>2</sub></nobr>, the oscillation period of <nobr>|<i>&psi;</i>(<i>x,t</i>)|<sup>2</sup></nobr> "+"equals the time needed for both curves in the graph to line up again with a zero phase difference.";};break
case 2:$('.group_answer').each(function(index){if($(this).hasClass('selected')){none_selected=false;};});if($('#Stage_radio_answer'+correct_answer).hasClass('selected')){correct=true;feedback_str="Correct, congratulations! One oscillation period of the |<i>&psi;</i>|<sup>2</sup> curve (bottom graph) corresponds to the minimal time needed for both "+"curves in the top graph to line up again with a zero phase difference.  This is the time <i>T</i> for which "+"<nobr><i>&omega;</i><sub>2</sub><i>T</i> = <i>&omega;</i><sub>1</sub><i>T</i>+2<i>&pi;</i></nobr>. "+"This gives <nobr>4<i>&omega;</i><sub>1</sub><i>T</i> = <i>&omega;</i><sub>1</sub><i>T</i>+2<i>&pi;</i></nobr> or <nobr><i>T</i> = 2<i>&pi;</i>/3<i>&omega;</i><sub>1</sub>.</nobr> "+"Using <nobr><i>T</i> = 2<i>&pi;</i>/<i>&omega;</i> gives <i>&omega;</i> = 3<i>&omega;</i><sub>1</sub>.</nobr>";}
else{correct=false;feedback_str="This is not yet correct. One oscillation period of the |<i>&psi;</i>|<sup>2</sup> curve (bottom graph) corresponds to the minimal time needed for both "+"curves in the top graph to line up again with a zero phase difference.  This is the time <i>T</i> for which "+"<nobr><i>&omega;</i><sub>2</sub><i>T</i> = <i>&omega;</i><sub>1</sub><i>T</i>+2<i>&pi;</i></nobr>, "+"i.e. the phase of the first-excited state equals the phase of the ground state <nobr>+ 2<i>&pi;</i>.</nobr> "+"Use the fact that <nobr><i>&omega;</i><sub>2</sub> = 4<nobr><i>&omega;</i><sub>1</sub>."}
if(none_selected){feedback_str="Please select an option.";};break
case 3:$('.group_answer').each(function(index){if($(this).hasClass('selected')){none_selected=false;}});if($('#Stage_radio_answer'+correct_answer).hasClass('selected')){correct=true;feedback_str="Correct, congratulations! The time-dependence of the energy eigenstate <nobr><i>&psi;<sub>n</sub></i>(<i>x,t</i>) = <i>&psi;<sub>n</sub></i>(<i>x</i>) <i>e<sup>&ndash;iE<sub>n</sub>t/&#295;</i></sup></nobr> corresponds to a rotation of "+"<nobr><i>&psi;<sub>n</sub></i>(<i>x</i>)</nobr> in the complex plane, with phase <nobr><i>&#981;</i> = <i>&omega;t</i> = <i>E<sub>n</sub>t</i>/<i>&#295;</i></nobr> and angular frequency <i>&omega;</i> = <i>E<sub>n</sub></i>/<i>&#295;</i>. "+"Thus, the angular frequency is proportional to <i>E<sub>n</sub></i>. As <nobr><i>E</i><sub>3</sub> = 9<i>E</i><sub>1</sub></nobr>, the second-excited state will rotate 9 times faster than the ground state in the complex plane.";}
else{correct=false;feedback_str="This is not yet correct. The time-dependence of the energy eigenstate <nobr><i>&psi;<sub>n</sub></i>(<i>x,t</i>) = <i>&psi;<sub>n</sub></i>(<i>x</i>) <i>e<sup>&ndash;iE<sub>n</sub>t/&#295;</i></sup></nobr> corresponds to a rotation of "+"<nobr><i>&psi;<sub>n</sub></i>(<i>x</i>)</nobr> in the complex plane, with phase <nobr><i>&#981;</i> = <i>&omega;t</i> = <i>E<sub>n</sub>t</i>/<i>&#295;</i></nobr> and angular frequency <i>&omega;</i> = <i>E<sub>n</sub>/&#295;</i>. "+"Thus, the angular frequency is proportional to <i>E<sub>n</sub></i>. Use the fact that <i>E<sub>n</sub></i> = <i>n</i><sup>2</sup><i>E</i><sub>1</sub>!"};if(none_selected){feedback_str="Please select an option.";};break
case 4:$('.group_answer').each(function(index){if($(this).hasClass('selected')){none_selected=false;}});if($('#Stage_radio_answer'+correct_answer).hasClass('selected')){correct=true;feedback_str="Correct, congratulations! At the time shown, the complex phases of the ground state and second-excited state are the same. "+"Thus, <nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> = |<i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>) + <i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)|<sup>2</sup></nobr> will just be the square of the sum (not the sum of the squares!) of the two values. "+"As <nobr><i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>)</nobr> and <nobr><i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)</nobr> point in opposite directions (but are not equal), <nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup></nobr> will be non-zero but have its minimal value.";}
else{correct=false;feedback_str="This is not yet correct. At the time shown, the complex phases of the ground state and second-excited state are the same. Thus, "+"<nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> = |<i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>) + <i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)|<sup>2</sup></nobr> will just be the square of the sum (not the sum of the squares!) of the two values. "+"Note that <nobr><i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>)</nobr> and <nobr><i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)</nobr> point in opposite directions but are not equal.";};if(none_selected){feedback_str="Please select an option.";};break
case 5:$('.group_answer').each(function(index){if($(this).hasClass('selected')){none_selected=false;}});if($('#Stage_radio_answer'+correct_answer).hasClass('selected')){correct=true;feedback_str="Correct, congratulations! At the time shown, the phase difference is 90&deg;. "+"If the two phases were aligned, <nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> = |<i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>) + <i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)|<sup>2</sup></nobr> would just be the square of the sum of <nobr><i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>)</nobr> and <nobr><i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)</nobr>. "+"If the two phases would differ by 180&deg;, <nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> = |<i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>) &ndash; <i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)|<sup>2</sup></nobr>  would just be the square of the difference of <nobr><i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>)</nobr> and <nobr><i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)</nobr>. "+"Thus, for the case shown <nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup></nobr> lies between its maximal and minimal value.";}
else{correct=false;feedback_str="This is not yet correct. At the time shown, the phase difference is 90&deg;. "+"If the two phases were aligned, <nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> = |<i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>) + <i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)|<sup>2</sup></nobr> would just be the square of the sum of <nobr><i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>)</nobr> and <nobr><i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)</nobr>. "+"If the two phases would differ by 180&deg;, <nobr>|<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> = |<i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>) &ndash; <i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)|<sup>2</sup></nobr> would just be the square of the difference of <nobr><i>&psi;</i><sub>1</sub>(<i>x</i><sub>0</sub>)</nobr> and <nobr><i>&psi;</i><sub>3</sub>(<i>x</i><sub>0</sub>)</nobr>. ";};if(none_selected){feedback_str="Please select an option.";};break}
feedback.fadeOut("fast",function(){if(correct){feedback.css('color','#008f00');$('#Stage_steps_tick'+current_challenge).show();}else{feedback.css('color','#960000');}
feedback.html(feedback_str);feedback.fadeIn("fast");});if(correct&&!challenge_complete[current_challenge-1]){challenge_complete[current_challenge-1]=true;addScore(score_for_challenge[current_challenge-1]);}}
function addScore(score){var currentScore=totalScore;totalScore+=score;startScoreAnimation(currentScore,totalScore);if(Math.random()<fireworkProb&&totalScore!=100){fireworks();fireworkProb=0.25;}else
fireworkProb=2*fireworkProb;if(totalScore==100)
AdobeEdge.getComposition(compId).getStage().getSymbol('fancyExcellent').play();};function fireworks(){var star_id='#Stage_stars';var stick_ele=$('#Stage_stick');var number=6;var spread=75;var delay_const=500;var speed_const=700;var speed_const_offset=500;var x0=stick_ele.css('left'),y0=stick_ele.css('top');var totalDelay=0;$('#Stage .star').hide();$('#Stage .star').css({'left':x0,'top':y0,'opacity':1});$('#Stage .star').fadeIn(500);for(var i=0;i<number;i++){var left=Math.round(Math.random()*spread);if(Math.random()<0.5)
left='-='+left+'px';else
left='+='+left+'px';var delay1=Math.round((Math.random()+.25)*delay_const);totalDelay+=delay1;var speed=Math.round((Math.random()+.5)*speed_const)+speed_const_offset;$('#Stage_stars'+i).delay(delay1).animate({'left':left,'top':'-=500px','opacity':0},speed);}
$('#Stage .star').delay(1000).fadeOut();};function startScoreAnimation(startValue,endValue){var text_score=$('#Stage_text_score');var duration=800;var currentValue=startValue;var interval=duration/(endValue-startValue);if(endValue>startValue){function recursiveFunc(){text_score.text(++currentValue+'/100');if(currentValue==endValue)
return;setTimeout(recursiveFunc,interval);}
recursiveFunc();}else throw'startValue is larger than endValue';};function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);$(element).data('timeout_val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();$('#Stage_debug').hide();$('#Stage_help_text').html(help_text["Stage_help_introduction"]);$('#Stage_checkbox_label_lines').html('Show <i>&psi;</i>(<i>x,t</i>)');$('#Stage_checkbox_label_classical').html('Show probability density |<i>&psi;</i>(<i>x,t</i>)|<sup>2</sup> graph');$('#Stage_radio_psi1_label').html('<i>&psi;</i><sub>1</sub>');$('#Stage_radio_psi2_label').html('<i>&psi;</i><sub>2</sub>');$('#Stage_radio_sup_label').html('1/&radic;<span style="text-decoration: overline">2</span> (<i>&psi;</i><sub>1</sub>+<i>&psi;</i><sub>2</sub>)');$('#Stage_x0_text').html('Point <i>x</i><sub>0</sub> = '+($('#Stage_slider_x0').data('val')/100).toFixed(2)+'<i>L</i>');$('#Stage_slider_width_label0').html('0.05<i>L</i>');$('#Stage_slider_width_label1').html('0.95<i>L</i>');$('#Stage_phase_text_phi_diff').html('+');$('#Stage_phase_text_phi1_angle').html('000&deg;');$('#Stage_phase_text_phi2_angle').html('000&deg;');$('#Stage_phase_text_phi_diff_angle').html('000&deg;');$('#Stage_x_axis_label_argand').html('Re <i>&psi;</i>(<i>x</i><sub>0</sub>)');$('#Stage_y_axis_label_argand').html('Im <i>&psi;</i>(<i>x</i><sub>0</sub>)');$('#Stage_x_axis_label0_argand').html('&ndash;&radic;<span style="text-decoration: overline">2/<i>L</i></span>');$('#Stage_x_axis_label1_argand').html(' &radic;<span style="text-decoration: overline">2/<i>L</i></span>');$('#Stage_y_axis_label0_argand').html('&ndash;&radic;<span style="text-decoration: overline">2/<i>L</i></span>');$('#Stage_y_axis_label1_argand').html('&radic;<span style="text-decoration: overline">2/<i>L</i></span>');$('#Stage_psi1_leg').html('<i>&psi;</i><sub>1</sub>');$('#Stage_psi2_leg').html('<i>&psi;</i><sub>2</sub>');$('#Stage_sup_leg').html('1/&radic;<span style="text-decoration: overline">2</span>(<i>&psi;</i><sub>1</sub>+<i>&psi;</i><sub>2</sub>)');$('#Stage_x0_label_mag').html('<i>x</i><sub>0</sub>');$('#Stage_x_label_mag').html('<i>L</i>');$('#Stage_y_axis_label2_mag').html('2/<i>L</i>');$('#Stage_y_axis_title_mag').html('Probability density |<i>&psi;</i>|<sup>2</sup>');$('#Stage_im_axis_title_complex').html('Im <i>&psi;</i>');$('#Stage_re_axis_title_complex').html('Re <i>&psi;</i>');$('#Stage_im_axis_label0').html('&ndash;&radic;<span style="text-decoration: overline">2/<i>L</i></span>');$('#Stage_im_axis_label1').html('&radic;<span style="text-decoration: overline">2/<i>L</i></span>');$('#Stage_x_axis_title_complex').html('<i>L</i>');$('#Stage_x0_label_complex').html('<i>x</i><sub>0</sub>');$('#Stage_amplitude_text').html('<font color="#c00000"> |<i>&psi;</i>(<i>x</i><sub>0</sub>)|<sup>2</sup> = 0.00 (2/<i>L</i>)(red line)');$('#Stage_time_text').html('Time <i>t</i> = 0.00 <i>h/E</i><sub>1</sub>');$('#Stage_button_reset_label').html('Reset to <br><i>t</i> =  0');sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});yepnope({load:"normalize.css"});preloadImages();setStartTime();setX0();updateStage();$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider_x0');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));x0_pos=(slider.data('val')/100);$('#Stage_x0_text').html('Point <i>x</i><sub>0</sub> = '+x0_pos.toFixed(2)+'<i>L</i>');setX0();argandMove();},20));}});$('.tick').hide();$('#Stage_feedback_text').hide();$('#Stage .star').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){if(!simulation){show_mag_graph=simulation_show_mag_graph;show_x0=simulation_show_x0;stop=simulation_stop;t=simulation_t;psi1_on=simulation_psi1_on;psi2_on=simulation_psi2_on;sup_on=simulation_sup_on;show_rot_graph=simulation_show_rot_graph;}
$('#Stage_time_text').show();$('#Stage_phase_text').show();$('#Stage_graph_control').show();sym.stop('simulation');sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);simulation=true;if(!stop){$("#Stage_button_stop_label").html("Stop");sym_disable($('#Stage_backButton'));sym_disable($('#Stage_forwardButton'));}else{$("#Stage_button_stop_label").html("Resume");sym_enable($('#Stage_backButton'));sym_enable($('#Stage_forwardButton'));};$('#Stage_debug').hide();updateStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_challenges}","click",function(sym,e){if(simulation){simulation_show_mag_graph=show_mag_graph;simulation_show_x0=show_x0;simulation_stop=stop;simulation_t=t;simulation_psi1_on=psi1_on;simulation_psi2_on=psi2_on;simulation_sup_on=sup_on;simulation_show_rot_graph=show_rot_graph;};show_x0=false;show_rot_graph=true;stop=true;simulation=false;updateStage();sym.stop('challenges');sym_features();sym_step(current_challenge);$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_complex}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_magnitude}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_quantum_state}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_default}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_introduction}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_show_point}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_help_close}","click",function(sym,e){$('#Stage_help_content').hide();$('#Stage .help').each(function(){sym_enable(this);});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_x0}","click",function(sym,e){if($('#Stage_checkbox_x0').hasClass('selected')){show_rot_graph=true;}
else{show_rot_graph=false;}
updateStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_sup}","click",function(sym,e){psi1_on=false;psi2_on=false;sup_on=true;updateStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_magnitude_graph}","click",function(sym,e){if($('#Stage_checkbox_magnitude_graph').hasClass('selected')){show_mag_graph=true;}
else{show_mag_graph=false;}
updateStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_psi2}","click",function(sym,e){psi1_on=false;psi2_on=true;sup_on=false;updateStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_psi1}","click",function(sym,e){psi1_on=true;psi2_on=false;sup_on=false;updateStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_stop}","click",function(sym,e){playToggle();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_forwardButton}","click",function(sym,e){t+=time_step;updateStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_backButton}","click",function(sym,e){t-=time_step;updateStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_submit}","click",function(sym,e){challengeSubmit();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_reset}","click",function(sym,e){t=0;setStartTime();updateStage();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_backButton}","mousedown",function(sym,e){});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_backButton}","mouseup",function(sym,e){});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_backButton}","mouseout",function(sym,e){});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_backButton}","touchend",function(sym,e){});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_backButton}","touchstart",function(sym,e){});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_forwardButton}","mousedown",function(sym,e){});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_forwardButton}","touchstart",function(sym,e){});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_forwardButton}","mouseup",function(sym,e){});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_forwardButton}","mouseout",function(sym,e){});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_forwardButton}","touchend",function(sym,e){});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'highlight_1'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight_1");
//Edge symbol end:'highlight_1'

//=========================================================

//Edge symbol: 'fancyExcellent'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.stop(0);});
//Edge binding end
})("fancyExcellent");
//Edge symbol end:'fancyExcellent'

//=========================================================

//Edge symbol: 'steps'
(function(symbolName){})("steps");
//Edge symbol end:'steps'
})(jQuery,AdobeEdge,"EDGE-19890435");