
(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var graph=null,graph2=null,intervalId=null,current_challenge=1,c=[10,0],c_n=[],frame_rate=50,state=[0,1];var tab=0;var help_text=[];help_text["Stage_help_default"]='Consider a quantum particle confined to move in one <br>'+'dimension in an infinite square well with walls at x=0 and x=L. The graph shows you the probability density |&Psi;|<sup>2</sup> of the '+'particle. Use the buttons and slider to choose different quantum states including energy eigenstates (&Psi;=&Psi;<sub>n</sub>) and '+'superposition states (&Psi;= c<sub>n</\sub>&Psi;<sub>n</sub>+c<sub>m</\sub>&Psi;<sub>m</sub>). Press the "?" buttons '+'for information. <b>For which quantum states does the probability density change with time? How does '+'the oscillation frequency relate to the energies in the superposition?</b> Then try the challenges in the '+'Challenges tab!';help_text["Stage_help_quantum_state"]='Use the buttons and slider to create different quantum '+'states <br>of the particle. &Psi;<sub>1</sub> is the ground state energy eigenfunction with energy E<sub>1</sub>, '+'&Psi;<sub>2</sub> the first excited state energy eigenfunction with energy E<sub>2</sub> = 4E<sub>1</sub>, '+'etc. The energies E<sub>n</sub>&nbsp;=&nbsp;n<sup>2</sup>E<sub>1</sub> rise '+'quadratically with quantum number n. '+'Each energy eigenfunction &Psi;<sub>n</sub>(x,t) of the infinite square well is the product of the spatial part '+'<span style=" white-space: nowrap;">u<sub>n</sub>(x)&nbsp;=&nbsp;&radic;<span style="text-decoration: overline">2/L</span>&nbsp;sin(n&pi;x/L)</span> '+'and the temporal part, the complex exponential <span style=" white-space: nowrap;">exp(&#8211; iE<sub>n</sub>t/&#295;)</span>. If the quantum state '+'includes two different energy eigenfunction, it is a superposition state with respect to energy.';help_text["Stage_help_graph"]='The graph shows you the quantum particle\'s probability <br>density '+'|&Psi;|<sup>2</sup>=&Psi;<sup>*</sup>&Psi;, where &Psi;<sup>*</sup> is the complex conjugate '+'of &Psi;. For which type of states does the probability density depend on time? For these '+'states, the motion of the probability density is oscillatory, with the probability density '+'returning to exactly the same form after one oscillation period T. This oscillation frequency '+'is determined by the energy difference of the two states in the superposition:<br>'+'f = (E<sub>n</sub> - E<sub>m</sub>)/h for a superposition including energies E<sub>n</sub> and E<sub>m</sub> '+'(where h is Planck\'s constant).';help_text["Stage_help_show_expression"]='Consider the superposition state '+'c<sub>n</sub>&Psi;<sub>n</sub> + c<sub>m</sub>&Psi;<sub>m</sub> with <br>coefficients '+'c<sub>n</sub> and c<sub>m</sub>. This state has the probability density <br><br>'+'|&Psi;|<sup>2</sup> = &Psi;&Psi;<sup>*</sup> = (c<sub>n</sub>u<sub>n</sub> exp(&#8211; iE<sub>n</sub>t/&#295;) + '+'c<sub>m</sub>u<sub>m</sub> exp(&#8211; iE<sub>m</sub>t/&#295;)) &#215; <br>'+'(c<sub>n</sub>u<sub>n</sub> exp(+iE<sub>n</sub>t/&#295;) + '+'c<sub>m</sub>u<sub>m</sub> exp(+iE<sub>m</sub>t/&#295;)),<br><br> where the u<sub>n</sub>(x) are the spatial parts of the energy eigenfunctions. '+'Multiplying out terms and using <br>cos(x) = 0.5(exp(ix) + exp(&#8211;ix)) leads to <br><br>'+'|&Psi;|<sup>2</sup> = '+"c<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px; font-size:70%; bottom:-0.5em'>n</sub>"+"u<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px; font-size:70%; bottom:-0.5em'>n</sub>+ "+"c<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px; font-size:70%; bottom:-0.5em'>m</sub>"+"u<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px; font-size:70%; bottom:-0.5em'>m</sub>+ "+"2c<sub>n</sub>c<sub>m</sub>u<sub>n</sub>u<sub>m</sub>"+"cos((E<sub>m</sub> &#8211; E<sub>n</sub>)t/&#295;).<br>";help_text["Stage_help_prob_density"]='The probability density |&Psi;|<sup>2</sup> for a '+'superposition state<br> c<sub>n</sub>&Psi;<sub>n</sub> + c<sub>m</sub>&Psi;<sub>m</sub> '+'with coefficients c<sub>n</sub> and c<sub>m</sub> '+'includes a time-dependent term 2c<sub>n</sub>c<sub>m</sub>u<sub>n</sub>u<sub>m</sub>'+'cos((E<sub>m</sub> - E<sub>n</sub>)t/&#295;) called the interference term. This term leads to the '+'oscillatory change in shape of the probability density. The oscillation frequency is '+'proportional to the energy difference |E<sub>m</sub> - E<sub>n</sub>| between the two states in the superposition. For the '+'infinite square well, the energies E<sub>n</sub>&nbsp;=&nbsp;n<sup>2</sup>E<sub>1</sub> rise '+'quadratically with quantum number n. Using this fact, can you set up the quantum state or '+'states with the shortest oscillation period?';help_text["Stage_help_show_expectation"]='The expectation value of position divides the probability<br> density '+'graph into two equal areas underneath the curve. '+'Observationally, the expectation value of position with respect to '+'&Psi; at a fixed time is the average position resulting from taking a single '+'measurement of position at this time on a large number of identical quantum systems '+'all in the same state &Psi;. For some (but not all! which ones?) of the '+'superposition states shown, the expectation value of position moves back and forth between '+'the left and right sides of the well, similar to the trajectory of a classical particle. ';help_text["Stage_help_show_uncertainty"]='The position uncertainty &Delta;x is the standard '+'deviation of the probability density distribution around the expectation value of position. '+'The greater &Delta;x, the more uncertain you are prior to a measurement of position what the '+'outcome will be. Mathematically, &Delta;x = &radic;<span style="text-decoration: overline">'+'<span>&#x2329;x<sup style="top:-0.4em;font-size:70%;">2</sup>&#x232A;</span> &#8211; &#x2329;x&#x232A;<sup style="top:-0.4em;font-size:70%;">2</sup></span>, '+'where &#x2329;x&#x232A; and &#x2329;x<sup>2</sup>&#x232A; are the expectation values of position and the '+'square of position respectively. If you were to make a measurement of position, you would '+'obtain a value within the shaded region shown in the graph roughly two-thirds of the time.';function showHelpText(sym,e){var help_button;if(e===undefined){help_button=$("#Stage_help_default");}else{help_button=$(e.target).parent();}
sym_enable(sym.$('.disabled.help'));sym_disable(help_button);sym.$('help_text').html(help_text[help_button.attr("id")]);sym.$("help_content").show();}
function updateState(weight){resetGraph();checkUncertaintyDisplay();checkExpressionDisplay();checkExpectationDisplay();updateEigenstate();calculateCAndE(weight);updateText();drawGraph();}
function updateEigenstate(){$('#Stage .group_q_state').each(function(){if($(this).hasClass('selected')){var id=$(this).attr('id');id=id.substr(id.length-1);id=parseInt(id);switch(id){case 0:state[0]=0;state[1]=1;break;case 1:state[0]=0;state[1]=2;break;case 2:state[0]=1;state[1]=2;break;}}});}
function calculateCAndE(weight){var second_coefficient;if(weight!=undefined){second_coefficient=weight-10;}else{second_coefficient=$("#Stage_slider").data('val')-10;}
c[1]=second_coefficient;c[0]=10-Math.abs(second_coefficient);c_n[0]=Math.sqrt(c[0]/10);c_n[1]=Math.sqrt(Math.abs(c[1])/10);if(c[1]<0){c_n[1]*=-1;}
if(c[0]==0||c[1]==0){e_diff=0;}else{e_diff=Math.abs(Math.pow(state[0],2)-Math.pow(state[1],2));}}
function updateText(){var str="&Psi; = ";if(c[0]!=0){if(c[0]!=10)
str+="&radic;<span style='text-decoration: overline'>"+c[0]+"/10</span> ";str+="&Psi;<sub>"+(state[0]+1)+"</sub> ";}
if(c[1]<0||c[0]!=0&&c[0]!=10)str+=((c[1]<0)?"&#8211;":"+");if(c[1]!=0){if(Math.abs(c[1])!=10)
str+=" &radic;<span style='text-decoration: overline'>"+Math.abs(c[1])+"/10</span> ";str+="&Psi;<sub>"+(state[1]+1)+"</sub>";}
$("#Stage_state_exp").html(str);$("#Stage_slider_label").html("Contribution of &Psi;<sub>"+(state[1]+1)+"</sub>");str="|&Psi;|<sup>2</sup> = ";if(c[0]==10){str="<br><br>"+str;(state[0]+1)+"</sub>";if((state[0]+1)!=1){str+="u<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px; font-size:70%; bottom:-0.5em'>"+
(state[0]+1)+"</sub>= 2/L sin<sup style='font-size:70%;top:-0.8em';>2</sup>("+(state[0]+1)+"&pi;x/L)";}
else{str+="u<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px; font-size:70%; bottom:-0.5em'>"+
(state[0]+1)+"</sub>= 2/L sin<sup style='font-size:70%;top:-0.8em';>2</sup>(&pi;x/L)";}}else if(Math.abs(c[1])==10){str="<br><br>"+str;(state[1]+1)+"</sub>";str+="u<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px; font-size:70%; bottom:-0.5em'>"+
(state[1]+1)+"</sub>= 2/L sin<sup style='font-size:70%;top:-0.8em';>2</sup>("+(state[1]+1)+"&pi;x/L)";}else{var n1=state[0]+1,n2=state[1]+1;str+="c<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px;font-size:70%;bottom:-0.5em;margin-right:-3px;'>"+n1+"</sub>"+"u<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px;font-size:70%;bottom:-0.5em;margin-right:-3px;'>"+n1+"</sub>+&thinsp;"+"c<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px;font-size:70%;bottom:-0.5em;margin-right:-3px;'>"+n2+"</sub>"+"u<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px;font-size:70%;bottom:-0.5em;margin-right:-3px;'>"+n2+"</sub>+&thinsp;"+"2&thinsp;c<sub>"+n1+"</sub>&thinsp;c<sub>"+n2+"</sub>&thinsp;u<sub>"+n1+"</sub>&thinsp;u<sub>"+n2+"</sub>&thinsp;"+"cos((E<sub>"+(n1>n2?n1:n2)+"</sub> &#8211; E<sub>"+(n1<n2?n1:n2)+"</sub>)t/&#295;) <br><br>"+"c<sub>"+n1+"</sub> = &radic;<span style='text-decoration: overline'>"+c[0]+"/10</span> and "+"c<sub>"+n2+"</sub> = "+(c[1]<0?"&#8211;":"")+"&radic;<span style='text-decoration: overline'>"+
Math.abs(c[1])+"/10</span>";}
$("#Stage_prob_density_text").html(str);if(e_diff==0)
$("#Stage_prob_density_text2").html("");}
var e_diff=0,t=0;function eqn(x){return Math.pow((c_n[0]*u[state[0]](x)),2)+
Math.pow((c_n[1]*u[state[1]](x)),2)+
2*c_n[0]*c_n[1]*u[state[0]](x)*u[state[1]](x)*Math.cos(e_diff*t);}
function iswU1(x){return Math.sin(Math.PI*x);}
function iswU2(x){return Math.sin(2*Math.PI*x);}
function iswU3(x){return Math.sin(3*Math.PI*x);}
var u=[iswU1,iswU2,iswU3];function drawGraph(){clearInterval(intervalId);t=0;calculateExpectAndUncertain();setTimeout(drawStaticGraph,0);setTimeout(drawStaticOverlayGraph,0);setTimeout(drawExpectLine,0);setTimeout(drawUncertainLine,0);if(e_diff>0){start_t=new Date();intervalId=setInterval(animateGraph,frame_rate);}}
var config={bezierCurve:true,bezierCurveTension:0.4,datasetStrokeWidth:1,scaleOverride:true,scaleSteps:1,scaleStepWidth:2,scaleStartValue:0,scaleShowLabels:true,scaleFontColor:"rgba(0, 0, 0, 0)",responsive:false}
var x_axis_config={minX:0,maxX:1,step:0.025,showXLabels:6,labelDecimal:2}
var data_strucs=[{strokeColor:"rgba(1,223,58,1)"},{strokeColor:"rgba(1,169,219,1)"},{strokeColor:"rgba(1,58,223,1)"}];function drawStaticGraph(){var element=$('#Stage_canvas_graph');if(e_diff>0&&tab==0){t=t%1000;$('#Stage_timer').show().html('time: '+t.toFixed(1));}
else{$('#Stage_timer').hide();}
if(e_diff>0&&$('#Stage_prob_density').is(":visible")){var val=t*e_diff/Math.PI;val=val%2;$('#Stage_prob_density_text2').html(probDensityStr2(val));}
if(graph!=null){graph.destroy()};graph=new FunctionGraph(element,[eqn],x_axis_config,[data_strucs[state[0]+state[1]-1]],config);}
function probDensityStr2(val){var n1=state[0]+1,n2=state[1]+1,c3=2*c_n[0]*c_n[1];str="|&Psi;|<sup>2</sup> = "+
(c[0]/10).toFixed(1)+"u<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px; font-size:70%; bottom:-0.5em'>"+n1+"</sub>+ "+
(Math.abs(c[1])/10).toFixed(1)+"u<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px; font-size:70%; bottom:-0.5em'>"+n2+"</sub>"+
(c3<0?"&#8211; ":"+ ")+Math.abs(c3).toFixed(2)+" u<sub>"+n1+"</sub>u<sub>"+n2+"</sub>"+"cos("+val.toFixed(1)+"&pi;)";return str;}
var t_scale=0.8;function animateGraph(){var now=new Date();t=now-start_t;t/=1000;t*=t_scale;calculateExpectAndUncertain();setTimeout(drawStaticGraph,0);setTimeout(drawStaticOverlayGraph,0);setTimeout(drawExpectLine,0);setTimeout(drawUncertainLine,0);}
function checkExpressionDisplay(){if($('#Stage_checkbox_show_expression').hasClass('selected')){$('#Stage_prob_density').show();}else{$('#Stage_prob_density').hide();}}
function checkExpectationDisplay(){if($('#Stage_checkbox_show_expectation').hasClass('selected')){$("#Stage_exp_val_line").show();}else{$("#Stage_exp_val_line").hide();}
calculateExpectAndUncertain();setTimeout(drawStaticOverlayGraph,0);setTimeout(drawExpectLine,0);}
function checkUncertaintyDisplay(){if($('#Stage_checkbox_show_uncertainty').hasClass('selected')){$("#Stage_plus_uncertainty_line").show();$("#Stage_minus_uncertainty_line").show();$('#Stage_canvas_overlay_graph').show();}else{$("#Stage_plus_uncertainty_line").hide();$("#Stage_minus_uncertainty_line").hide();$('#Stage_canvas_overlay_graph').hide();}
calculateExpectAndUncertain();setTimeout(drawStaticOverlayGraph,0);setTimeout(drawUncertainLine,0);}
var stop=false;function graphToggle(){if(stop){if(e_diff!=0){start_t=new Date();start_t-=t/t_scale*1000;intervalId=setInterval(animateGraph,frame_rate);}
$("#Stage_button_label_graph").html("Stop");stop=false;}else{clearInterval(intervalId);$("#Stage_button_label_graph").html("Resume");stop=true;}}
function prevFrame(){if(e_diff==0||!stop)return;t-=frame_rate/1000*t_scale;calculateExpectAndUncertain();setTimeout(drawStaticGraph,0);setTimeout(drawStaticOverlayGraph,0);setTimeout(drawExpectLine,0);setTimeout(drawUncertainLine,0);}
function nextFrame(){if(e_diff==0||!stop)return;t+=frame_rate/1000*t_scale;calculateExpectAndUncertain();setTimeout(drawStaticGraph,0);setTimeout(drawStaticOverlayGraph,0);setTimeout(drawExpectLine,0);setTimeout(drawUncertainLine,0);}
function expectation_a(){if(state[0]==0&&state[1]==1)return-0.1801;else if(state[0]==0&&state[1]==2)return 0;else if(state[0]==1&&state[1]==2)return-0.1945;}
function expectationValue(){return 1/2+2*c_n[0]*c_n[1]*expectation_a()*Math.cos(e_diff*t);}
function expectation_c(n){if(state[n]==0)return 0.2827;else if(state[n]==1)return 0.3207;else if(state[n]==2)return 0.3277;}
function expectation_b(){if(state[0]==0&&state[1]==1)return-0.1801;else if(state[0]==0&&state[1]==2)return 0.0380;else if(state[0]==1&&state[1]==2)return-0.1945;}
function expectationSquared(){return Math.pow(c_n[0],2)*expectation_c(0)+
Math.pow(c_n[1],2)*expectation_c(1)+
2*c_n[0]*c_n[1]*expectation_b()*Math.cos(e_diff*t)}
function uncertainty(){return Math.sqrt(expectationSquared()-Math.pow(exp_val,2));}
function uncertaintyArea(x){if(x>(exp_val-uncertain)&&x<(exp_val+uncertain)){return eqn(x);}else{return 0;}}
function calculateExpectAndUncertain(){exp_val=expectationValue();uncertain=uncertainty();}
var overlay_config={bezierCurve:false,bezierCurveTension:0.5,datasetFill:true,datasetStrokeWidth:1,scaleOverride:true,scaleSteps:1,scaleStepWidth:2,scaleStartValue:0,scaleShowLabels:true,scaleFontColor:"rgba(0, 0, 0, 0)",responsive:false}
var overlay_x_axis_config={minX:0,maxX:1,step:0.0125,showXLabels:6,labelDecimal:2}
var overlay_data_strucs=[{fillColor:"rgba(220,220,220,0.5)",strokeColor:"rgba(0,0,255,0)"}];var exp_val,uncertain,color=["#01df3a","#01a9db","#013adf"];function drawStaticOverlayGraph(){var element=$('#Stage_canvas_overlay_graph');if(element.is(":hidden"))return;if(graph2!=null){graph2.destroy()};graph2=new FunctionGraph(element,[uncertaintyArea],overlay_x_axis_config,overlay_data_strucs,overlay_config);}
function drawExpectLine(){if($("#Stage_exp_val_line").is(":hidden"))return;var height=eqn(exp_val)*50;if(height>1)height-=1;$("#Stage_exp_val_line").css({left:(exp_val*100)+'%',height:height+"%","border-left-color":color[state[0]+state[1]-1],});}
function drawUncertainLine(){if($("#Stage_plus_uncertainty_line").is(":hidden"))return;$("#Stage_plus_uncertainty_line").css({left:((exp_val+uncertain)*100)+'%',bottom:"0%",height:(eqn(exp_val+uncertain)*50)+"%",top:"auto"});$("#Stage_minus_uncertainty_line").css({left:((exp_val-uncertain)*100)+'%',bottom:"0%",height:(eqn(exp_val-uncertain)*50)+"%",top:"auto"});}
function resetGraph(){clearInterval(intervalId);stop=false;$("#Stage_button_label_graph").html("Stop");}
var correct_answer=[false,false,false,false],correct=false,score_for_challenge=[20,20,20,20,20],challenge_complete=[false,false,false,false,false],totalScore=0,fireworkProb=1,index_eigenstate;function shuffle(array){var currentIndex=array.length,temporaryValue,randomIndex;while(0!==currentIndex){randomIndex=Math.floor(Math.random()*currentIndex);currentIndex-=1;temporaryValue=array[currentIndex];array[currentIndex]=array[randomIndex];array[randomIndex]=temporaryValue;}
return array;}
function initChallenge(){$('#Stage_prob_density').hide();$("#Stage_exp_val_line").hide();$("#Stage_plus_uncertainty_line").hide();$("#Stage_minus_uncertainty_line").hide();$('#Stage_canvas_overlay_graph').hide();}
function challengeSubmit(){var feedback=$('#Stage_feedback_text');var feedback_str;correct=false;switch(current_challenge){case 1:var incorrect=false;var no_tick=true;correct=true;$('.checkbox_answer').each(function(index){var id=$(this).attr('id');id=id.substr(id.length-1);id=parseInt(id);if($(this).hasClass('selected')){no_tick=false;}
if($(this).hasClass('selected')!=correct_answer[id]){correct=false;if(!correct_answer[id]){incorrect=true;}}});if(correct){feedback_str="Correct, congratulations! The probability density is time-independent for energy eigenstates, and time-dependent for superposition states with respect to energy.";}else if(no_tick){feedback_str="Please select an option."}else if(incorrect){feedback_str="This is not yet correct. Each energy eigenfunction &Psi;<sub>n</sub>(x,t) "+"is the product of the spatial part of the energy eigenfunction u<sub>n</sub>(x) of the "+"infinite square well and the temporal part, the complex exponential "+"exp(&#8211; iE<sub>n</sub>t/&#295;). For energy eigenstates, the probability density is "+"time-independent, as <br>|&Psi;<sub>n</sub>|<sup>2</sup> = u<sub>n</sub>exp(&#8211; iE<sub>n</sub>t/&#295;) u<sub>n</sub>exp(+iE<sub>n</sub>t/&#295;)=u<sup style='font-size:70%;top:-0.8em;'>2</sup><sub style='left:-5px;font-size:70%;bottom:-0.5em;margin-right:-3px;'>n</sub>.";}else{feedback_str="This is not yet correct. For a superposition state c<sub>n</sub>&Psi;<sub>n</sub> + c<sub>m</sub>&Psi;<sub>m</sub> with respect to energy with coefficients c<sub>n</sub> and c<sub>m</sub>, the probability density includes a time-dependent term called the interference term.";}
break;case 2:if(e_diff>0){correct_answer=[false,true,false,false,false];}else{correct_answer=[true,false,false,false,false];}
$('.group_answer').each(function(index){if($(this).hasClass('selected')){var id=$(this).attr('id');id=id.substr(id.length-1);id=parseInt(id);if(correct_answer[id]){correct=true;}}});if(correct){feedback_str='Correct, congratulations! The probability density is time-independent for energy eigenstates, and time-dependent for superposition states with respect to energy.';}else{feedback_str='This is not yet correct. Consider whether or not the probability density changes with time. For energy eigenstates, the probability density is time-independent. For which states does the probability density depend on time?';}
break;case 3:var no_tick=true;var partial_correct=false;correct=true;$('.checkbox_answer').each(function(index){var id=$(this).attr('id');id=id.substr(id.length-1);id=parseInt(id);if($(this).hasClass('selected')){no_tick=false;}
if($(this).hasClass('selected')==correct_answer[id]){if(correct_answer[id])
partial_correct=true;}else{correct=false;}});if(correct){feedback_str="Correct, congratulations! The oscillation frequency is proportional to the energy difference between the two states in the superposition. The greater the energy difference, the shorter is the oscillation period. For the infinite square well, the energies E<sub>n</sub>=n<sup>2</sup> E<sub>1</sub> rise quadratically with quantum number n.";}else if(no_tick){feedback_str="Please select an option."}else if(partial_correct){feedback_str="This is not yet correct. The oscillation frequency is proportional to the energy difference between the two states in the superposition. The greater the energy difference, the shorter is the oscillation period. Thus, the coefficients c<sub>n</sub> and c<sub>m</sub> in a superposition state c<sub>n</sub>&Psi;<sub>n</sub> + c<sub>m</sub>&Psi;<sub>m</sub> have no influence on the oscillation period.";}else{feedback_str="This is not yet correct. The probability density for an energy superposition state includes a time-dependent term called the interference term. This term leads to the oscillatory change in shape of the probability density. The oscillation frequency is proportional to the energy difference between the two states in the superposition. The greater the energy difference, the shorter is the oscillation period. For the infinite square well, the energies E<sub>n</sub> = n<sup>2</sup>E<sub>1</sub> rise quadratically with quantum number n."}
break;case 4:if($("#Stage_radio_answer2").hasClass('selected')){correct=true;feedback_str="Correct, congratulations! The expectation value of position with respect to &Psi; at time t<sub>0</sub> is the average position resulting from taking a single measurement of position at time t<sub>0</sub> on a large number of identical quantum systems all in the same state &Psi;. The expectation value of position divides the probability density graph into two equal areas underneath the curve. ";}else{correct=false;feedback_str="This is not yet correct. The expectation value of position with respect to &Psi; at time t<sub>0</sub> is the average position resulting from taking a single measurement of position at time t<sub>0</sub> on a large number of identical quantum systems all in the same state &Psi;. The expectation value of position divides the probability density graph into two equal areas underneath the curve. ";}
break;case 5:var no_tick=true;var eigenstate_tick=false;correct=true;$('.checkbox_answer').each(function(index){var id=$(this).attr('id');id=id.substr(id.length-1);id=parseInt(id);if($(this).hasClass('selected'))
no_tick=false;if($(this).hasClass('selected')!=correct_answer[id]){correct=false;if(id==index_eigenstate)
eigenstate_tick=true;}});if(correct){feedback_str="Correct, congratulations! If the superposition state consists of two energy eigenstates that have the same symmetry with respect to the centre of the well, then the expectation value is independent of time, even though the probability density is time-dependent. For example, this is the case for a superposition of the ground state and the second excited state, which are both symmetric with respect to the middle of the well.";}else if(no_tick){feedback_str="Please select an option."}else if(eigenstate_tick){feedback_str="This is not yet correct. Does the probability density depend on time for energy eigenstates?";}else{feedback_str="This is not yet correct. If the superposition state consists of two energy eigenstates that have the same symmetry with respect to the centre of the well, then the expectation value is independent of time, even though the probability density is time-dependent. For example, this is the case for a superposition of the ground state and the second excited state, which are both symmetric with respect to the middle of the well.";}
break;}
feedback.fadeOut("fast",function(){if(correct){feedback.css('color','#008f00');$('#Stage_steps_tick'+current_challenge).show();}else{feedback.css('color','#960000');}
feedback.html(feedback_str);feedback.fadeIn("fast");});if(correct&&!challenge_complete[current_challenge-1]){challenge_complete[current_challenge-1]=true;addScore(score_for_challenge[current_challenge-1]);}}
function challengeReset(){correct=false;$('#Stage_feedback_text').hide();$('#Stage_grey_panel').hide();$('#Stage_y_axis').show();$('.challenge4').hide();sym_deselect($('.checkbox_answer'));sym_deselect($('.group_answer'));resetGraph();}
function step_functions(step){clearTimeout(AdobeEdge.step_animation);current_challenge=step;challengeReset();var text=$("#Stage_challenge_text");switch(step){case 1:$('.checkbox_answer').show();$('.group_answer').hide();$('#Stage_grey_panel').show();$('#Stage_y_axis').hide();text.html("For which of the following states of the particle in an infinite square well does the probability density explicitly depend on time? Choose one or more.");var choices=[{str:"&Psi;<sub>3</sub>",correct:false},{str:"&radic;<span style='text-decoration:overline;'>3/10</span> &Psi;<sub>1</sub> + &radic;<span style='text-decoration:overline;'>7/10</span> &Psi;<sub>5</sub>",correct:true},{str:"&radic;<span style='text-decoration:overline;'>2/10</span> &Psi;<sub>1</sub> &#8211; &radic;<span style='text-decoration:overline;'>8/10</span> &Psi;<sub>2</sub>",correct:true},{str:"1/&radic;<span style='text-decoration:overline;'>5</span>(2&Psi;<sub>1</sub> + &Psi;<sub>2</sub>)",correct:true}];shuffle(choices);$.each(choices,function(index,value){$("#Stage_checkbox_label_answer"+index).html(value.str);correct_answer[index]=value.correct;});break;case 2:$('.group_answer').show();$('.checkbox_answer').hide();$('#Stage_radio_answer3').hide();$('#Stage_radio_label_answer0').html('energy eigenstate');$('#Stage_radio_label_answer1').html('superposition state');$('#Stage_radio_label_answer2').html('impossible to tell from the graph alone');text.html("The graph shows you the probability density of an unknown state for the particle in the infinite square well. Is this state an energy eigenstate or a superposition state with respect to energy?");var random=Math.floor((Math.random()*3));if(random==0){state[0]=0;state[1]=1;}else if(random==1){state[0]=0;state[1]=2;}else if(random==2){state[0]=1;state[1]=2;}
random=Math.floor((Math.random()*21));calculateCAndE(random);drawGraph();break;case 3:$('.checkbox_answer').show();$('.group_answer').hide();$('#Stage_grey_panel').show();$('#Stage_y_axis').hide();text.html("Which of the states below will give the shortest oscillation period (highest oscillation frequency) of the probability density? Choose one or more in the case of a tie.");var random;var choices=[{str:"&radic;<span style='text-decoration:overline;'>"+(random=Math.floor(Math.random()*9)+1)+"/10</span> &Psi;<sub>2</sub> &#8211; &radic;<span style='text-decoration:overline;'>"+(10-random)+"/10</span> &Psi;<sub>3</sub>",correct:false},{str:"&radic;<span style='text-decoration:overline;'>"+(random=Math.floor(Math.random()*9)+1)+"/10</span> &Psi;<sub>2</sub> + &radic;<span style='text-decoration:overline;'>"+(10-random)+"/10</span> &Psi;<sub>3</sub>",correct:false},{str:"&radic;<span style='text-decoration:overline;'>"+(random=Math.floor(Math.random()*9)+1)+"/10</span> &Psi;<sub>1</sub> &#8211; &radic;<span style='text-decoration:overline;'>"+(10-random)+"/10</span> &Psi;<sub>3</sub>",correct:true},{str:"1/&radic;<span style='text-decoration:overline;'>5</span>(2&Psi;<sub>1</sub> + &Psi;<sub>2</sub>)",correct:false}];shuffle(choices);$.each(choices,function(index,value){$("#Stage_checkbox_label_answer"+index).html(value.str);correct_answer[index]=value.correct;});break;case 4:$('.group_answer').show();$('.checkbox_answer').hide();state[0]=0;state[1]=1;calculateCAndE(18);t=Math.PI/e_diff;drawStaticGraph();$('.challenge4').show();$('#Stage_radio_label_answer0').html('A');$('#Stage_radio_label_answer1').html('B');$('#Stage_radio_label_answer2').html('C');$('#Stage_radio_label_answer3').html('D');text.html("The graph shows you the probability density for a state in the infinite square well at a time t<sub>0</sub>. Which of the following positions represents the expectation value of position?");break;case 5:$('.checkbox_answer').show();$('.group_answer').hide();$('#Stage_grey_panel').show();$('#Stage_y_axis').hide();text.html("For which of the states below will the probability density be time-dependent, but the expectation value of position remain fixed at L/2, the middle of the well? Choose one or more.");var random;var choices=[{str:"&radic;<span style='text-decoration:overline;'>"+(random=Math.floor(Math.random()*9)+1)+"/10</span> &Psi;<sub>2</sub> &#8211; &radic;<span style='text-decoration:overline;'>"+(10-random)+"/10</span> &Psi;<sub>3</sub>",correct:false},{str:"&radic;<span style='text-decoration:overline;'>"+(random=Math.floor(Math.random()*9)+1)+"/10</span> &Psi;<sub>1</sub> + &radic;<span style='text-decoration:overline;'>"+(10-random)+"/10</span> &Psi;<sub>3</sub>",correct:true},{str:"&radic;<span style='text-decoration:overline;'>"+(random=Math.floor(Math.random()*9)+1)+"/10</span> &Psi;<sub>1</sub> &#8211; &radic;<span style='text-decoration:overline;'>"+(10-random)+"/10</span> &Psi;<sub>3</sub>",correct:true},{str:"&Psi;<sub>1</sub>",correct:false,eigenstate:true}];shuffle(choices);$.each(choices,function(index,value){$("#Stage_checkbox_label_answer"+index).html(value.str);correct_answer[index]=value.correct;if(value.eigenstate!=undefined&&value.eigenstate)index_eigenstate=index;});break;}}
function addScore(score){var currentScore=totalScore;totalScore+=score;startScoreAnimation(currentScore,totalScore);if(Math.random()<fireworkProb&&totalScore!=100){fireworks();fireworkProb=0.25;}else
fireworkProb=2*fireworkProb;if(totalScore==100)
AdobeEdge.getComposition(compId).getStage().getSymbol('fancyExcellent').play();}
function fireworks(){var star_id='#Stage_stars';var stick_ele=$('#Stage_stick');var number=6;var spread=75;var delay_const=500;var speed_const=700;var speed_const_offset=500;var x0=stick_ele.css('left'),y0=stick_ele.css('top');var totalDelay=0;$('#Stage .star').hide();$('#Stage .star').css({'left':x0,'top':y0,'opacity':1});$('#Stage .star').fadeIn(500);for(var i=0;i<number;i++){var left=Math.round(Math.random()*spread);if(Math.random()<0.5)
left='-='+left+'px';else
left='+='+left+'px';var delay1=Math.round((Math.random()+.25)*delay_const);totalDelay+=delay1;var speed=Math.round((Math.random()+.5)*speed_const)+speed_const_offset;$('#Stage_stars'+i).delay(delay1).animate({'left':left,'top':'-=500px','opacity':0},speed);}
$('#Stage .star').delay(1000).fadeOut();}
function startScoreAnimation(startValue,endValue){var text_score=$('#Stage_text_score');var duration=800;var currentValue=startValue;var interval=duration/(endValue-startValue);if(endValue>startValue){function recursiveFunc(){text_score.text(++currentValue+'/100');if(currentValue==endValue)
return;setTimeout(recursiveFunc,interval);}
recursiveFunc();}else throw'startValue is larger than endValue';}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});yepnope({load:"normalize.css"});sym.$('help_text').css('-webkit-backface-visibility','hidden');showHelpText(sym);sym.$('label_prob_density').html('Probability density |&Psi;|<sup>2</sup>');sym.$('checkbox_label_show_expression').html('Show expression for probability density |&Psi;|<sup>2</sup>');sym.$('radio_label_q_state0').html('&Psi;<sub>1</sub> and &Psi;<sub>2</sub>');sym.$('radio_label_q_state1').html('&Psi;<sub>1</sub> and &Psi;<sub>3</sub>');sym.$('radio_label_q_state2').html('&Psi;<sub>2</sub> and &Psi;<sub>3</sub>');sym.$('checkbox_label_show_uncertainty').html("Show position uncertainty (shaded region &plusmn;&Delta;x)");sym.$('y_label').html('|&Psi;|<sup>2</sup>');sym.$("exp_val_line").css({bottom:"0%",top:"auto",});sym.$('.vertical_dash').css({width:"1px","border-left-width":"1px","border-top-color":"rgba(0,0,0,0)","border-bottom-color":"rgba(0,0,0,0)","border-right-color":"rgba(0,0,0,0)","border-top-width":"0px","border-bottom-width":"0px","border-right-width":"0px"});updateState();$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));updateState(slider.data('val'));},20));}});$('.tick').hide();sym.getSymbol('steps').$('feedback_text').hide();$('#Stage .star').hide();$('.challenge4').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){sym.stop('simulation');tab=0;sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);challengeReset();resetGraph();updateState();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_challenge}","click",function(sym,e){sym.stop('challenge');tab=1;sym_features();resetGraph();initChallenge();sym_step(current_challenge);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_graph}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_quantum_state}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_help_close}","click",function(sym,e){sym_enable(sym.$('.disabled.help'));sym.$('help_content').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_default}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_q_state1}","click",function(sym,e){updateState();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_q_state2}","click",function(sym,e){updateState();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_q_state0}","click",function(sym,e){updateState();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_measure}","click",function(sym,e){measureEnergy();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_show_expression}","click",function(sym,e){checkExpressionDisplay();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_show_expression}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_show_expectation}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_show_expectation}","click",function(sym,e){checkExpectationDisplay();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_prob_density}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_backButton}","click",function(sym,e){prevFrame();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_forwardButton}","click",function(sym,e){nextFrame();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_graph}","click",function(sym,e){graphToggle();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_show_uncertainty}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_show_uncertainty}","click",function(sym,e){checkUncertaintyDisplay();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_submit}","click",function(sym,e){challengeSubmit();});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'highlight_1'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight_1");
//Edge symbol end:'highlight_1'

//=========================================================

//Edge symbol: 'fancyExcellent'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.stop(0);});
//Edge binding end
})("fancyExcellent");
//Edge symbol end:'fancyExcellent'
})(jQuery,AdobeEdge,"EDGE-19890435");