/*  Copyright 2016, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
*/
(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var detector1=[0,0,0,0],numOfPhotons=[0,0,0,0];var detector1_array=[[0,0,0,0,0],[0,0,0,0,0],[0,0,0,0,0],[0,0,0,0,0]];var opacityD1=0.5;var flashDet=1;var fixedPhase=true;var setIntervalObject;var current_challenge=1;var totalScore=0;var feedbackProb=1;var firstTimeTab2flag=true;var firstTimeTab3flag=true;var continuousFire=false;function fireworks(){var number=6;var spread=75;var delay_const=500;var speed_const=700;var speed_const_offset=500;var x0=98,y0=469;var totalDelay=0;$('#Stage .star').hide();$('#Stage .star').css({'left':x0+'px','top':y0+'px','opacity':1});$('#Stage .star').fadeIn(500);for(var i=0;i<number;i++){var left=Math.round(Math.random()*spread);if(Math.random()<0.5)
left='-='+left+'px';else
left='+='+left+'px';var delay1=Math.round((Math.random()+.25)*delay_const);totalDelay+=delay1;var speed=Math.round((Math.random()+.5)*speed_const)+speed_const_offset;$('#Stage_stars'+i).delay(delay1).animate({'left':left,'top':'-=500px','opacity':0},speed);}
$('#Stage .star').delay(1000).fadeOut();}
function startScoreAnimation(a,b){var startValue=a;var endValue=b;if(b>a)
{scoreIncrementer=setInterval(function(){startValue++;$('#Stage_textScore').text(+startValue+'/100');if(startValue==endValue)
clearInterval(scoreIncrementer);},60);$('#Stage_textScore').fadeOut(500);$('#Stage_textScore').fadeIn(500);}}
function addedFeedback(score){if(totalScore<100){startScoreAnimation(score,totalScore);if(totalScore>score&&Math.random()<feedbackProb){fireworks();feedbackProb=0.25;}else
feedbackProb=2*feedbackProb;}else
$('#Stage_textScore').text('100/100');if(totalScore==100){AdobeEdge.getComposition(compId).getStage().getSymbol('fancyExcellent').play();totalScore=101;}}
function step_functions(step){clearTimeout(AdobeEdge.step_animation);challenges(step);}
function challenges(num){current_challenge=num;$('#Stage_textFeedback').html('')
$('#Stage .PS.tab3').hide();$('#Stage .challengeText').hide();$('#Stage .challenge'+num).show();$('#Stage_challengeTitle').text('Challenge '+current_challenge);replaceBS(3);clearCounts();switch(current_challenge){case 1:case 2:case 3:fixedPhase=true;$('#Stage .PS.tab3').each(function(index){$(this).children('.PStext').html('1.00'+'&pi;');$(this).children('.PSbody').css({'width':'11px','left':'25px'});replacePhaseShifter(index+1,3);});break;case 4:case 5:fixedPhase=false;$('#Stage .PS.tab3').each(function(index){replacePhaseShifter(index+1,3);var newWidth=6;var value=(index+1)*25;$(this).children('.PStext').html('0.'+value+'&pi;')
newWidth=6+2*index;var newLeft=31-newWidth/2;newWidth+='px';newLeft+='px';$(this).children('.PSbody').css({'width':newWidth,'left':newLeft});});}
var psString='Phase shifter';if(current_challenge!=1)
psString+='s'
if(fixedPhase)
{$('#Stage_textPhaseShifters').text(psString+' (fixed)');}
else
{$('#Stage_textPhaseShifters').text(psString+' (tap to change value)');$('#Stage_textPhaseShifters').fadeOut(500);$('#Stage_textPhaseShifters').fadeIn(500);}}
function challengeSubmit(){var prob=getProbD1();var feedbackText='';var incorrect=true;var score=0;var currentScore=totalScore;switch(current_challenge){case 1:if(parseInt($('#Stage .BS.tab3').css('top'))>490||parseInt($('#Stage .PS.tab3:visible ').css('top'))>490){feedbackText='Please use all available components.';}else if(prob!=0){feedbackText='This is not yet correct.  With the second '+'beam splitter in place but no phase shifter inside the '+'experiment, all photons reach detector 2. Thus, place the '+'phase shifter so that the relative phase difference between '+'the upper and lower path is zero.'}else{feedbackText='Correct, congratulations!  The relative phase '+'difference between the lower and upper path of the interferometer '+'is zero. Thus all photons reach detector 2.';incorrect=false;if(!$('#Stage_Tick1').hasClass('showing')){totalScore+=15;$('#Stage_Tick1').show();$('#Stage_Tick1').addClass('showing');}}
break;case 2:if(parseInt($('#Stage .BS.tab3').css('top'))>490||parseInt($('#Stage_phaseShifter13').css('top'))>490||parseInt($('#Stage_phaseShifter23').css('top'))>490||parseInt($('#Stage_phaseShifter33').css('top'))>490){feedbackText='Please use all available components.';}else if(prob!=0){feedbackText='This is not yet correct.  With the second '+'beam splitter in place but no phase shifter inside the '+'experiment, all photons reach detector 2.Thus, place the '+'phase shifters so that the relative phase difference '+'between the lower and upper path is zero.'}else{feedbackText='Correct, congratulations!  The relative phase '+'difference between the lower and upper path of the interferometer '+'is zero, thus all photons reach detector 2.';incorrect=false;if(!$('#Stage_Tick2').hasClass('showing')){totalScore+=20;$('#Stage_Tick2').show();$('#Stage_Tick2').addClass('showing');}}
break;case 3:if(parseInt($('#Stage .BS.tab3').css('top'))>490||parseInt($('#Stage_phaseShifter13').css('top'))>490||parseInt($('#Stage_phaseShifter23').css('top'))>490||parseInt($('#Stage_phaseShifter33').css('top'))>490){feedbackText='Please use all available components.';}else if(prob!=1){feedbackText='This is not yet correct.  With the second '+'beam splitter in place but no phase shifter inside the '+'interferometer, all photons reach detector 2.  Thus place the '+'phase shifters so that the relative phase '+'difference between the lower and upper path is &pi;.';}else{feedbackText='Correct, congratulations!  The relative phase '+'difference between the lower and upper path of the interferometer '+'is &pi;. Thus all photons reach detector 1.';incorrect=false;if(!$('#Stage_Tick3').hasClass('showing')){totalScore+=20;$('#Stage_Tick3').show();$('#Stage_Tick3').addClass('showing');}}
break;case 4:if(parseInt($('#Stage .BS.tab3').css('top'))>490||parseInt($('#Stage_phaseShifter13').css('top'))>490||parseInt($('#Stage_phaseShifter23').css('top'))>490){feedbackText='Please use all available components.';}else if(prob<1){feedbackText='This is not yet correct.  With the second '+'beam splitter in place but no phase shifter inside the '+'experiment, all photons reach detector 2.  Thus, place the '+'phase shifters and set their values so that the relative phase '+'difference between the lower and upper paths is &pi;.';}else{feedbackText='Correct, congratulations!  The relative phase '+'difference between the lower and upper paths of the interferometer '+'is &pi;(180&deg;), thus all photons reach detector 1.';incorrect=false;if(!$('#Stage_Tick4').hasClass('showing')){totalScore+=20;$('#Stage_Tick4').show();$('#Stage_Tick4').addClass('showing');}}
break;case 5:if(parseInt($('#Stage .BS.tab3').css('top'))>490||parseInt($('#Stage_phaseShifter13').css('top'))>490||parseInt($('#Stage_phaseShifter23').css('top'))>490){feedbackText='Please use all available components.';}else if(Math.abs(prob-0.5)>0.05){feedbackText='This is not yet correct.  With the second '+'beam splitter in place but no phase shifter inside the '+'interferomter, all photons reach detector 2.  Where can you place the '+'phase shifters so as to introduce a relative phase '+'difference of &pi;/2?';}else{feedbackText='Correct, congratulations!  The relative phase '+'difference between the lower and upper path of the interferometer '+'is &pi;/2, thus on average 50% of the photons reach detector 1, '+'and 50% reach detector 2.';incorrect=false;if(!$('#Stage_Tick5').hasClass('showing')){totalScore+=25;$('#Stage_Tick5').show();$('#Stage_Tick5').addClass('showing');}}}
if(incorrect)
feedbackText='<p style="color:#960000">'+feedbackText+'</p>';else
feedbackText='<p style="color:#008f00">'+feedbackText+'</p>';$('#Stage_textFeedback').html(feedbackText)
addedFeedback(currentScore);}
function debug(t){$('#Stage_Text2').text(t);}
function rotateElement(element,angle){var A='rotate('+angle+'deg)';element.css({'-moz-transform':A,'-webkit-transform':A,'-o-transform':A,'-ms-transform':A,'transform':A});}
function getTab(){return parseInt($('#Stage .active.tab').attr('id').substr(14,1));}
function clearCounts(){var tabN=getTab();$('#Stage_warningText').text('Take more data!');$('#Stage_warningText').hide();detector1[tabN]=0;numOfPhotons[tabN]=0;endValue=100;for(var i=0;i<5;i++)
detector1_array[tabN][i]=0;displayCounts();}
function stopAllAnimations(){var element=AdobeEdge.getComposition(compId).getStage().getSymbol("path_2")
var time=element.getPosition();if(time<3400)
element.stop(0);$('#Stage .button.disabled').each(function(){sym_enable($(this));});$('#Stage .OTdisable').hide();$('#Stage_button_label_Cont').text('Continuous fire');if($('#Stage_buttonCont').hasClass('continuous'))
$('#Stage_buttonCont').removeClass('continuous');$('#Stage .flash').hide()}
function disableElements(){$('#Stage .OTdisable').show();$('#Stage .photon').each(function(){if(!$(this).hasClass('disabled'))
sym_disable($(this));});}
function enableElements(){$('#Stage .OTdisable').hide();$('#Stage .photon').each(function(){sym_enable($(this));});}
function initializeAllElements(){$('#Stage_textPhaseShifters').show();$('#Stage_textPhaseShiftersCopy').hide();$('#Stage_warningText').hide();$('#Stage .observed,.tableTitle,.star,.tick,.theory,.info,.flash,.OTdisable,.tab2,.tab3,.onChallengeShow').hide();$('#Stage_snapDot').hide();$('#Stage .tab').hide();$('#Stage .active.tab').show();$('#Stage_tab_mask').hide();displayInfo('instructionsTab1');sym_disable($('#Stage_infoStart'));enableElements();$('#Stage .PS').each(function(){if($(this).attr('id').substr(19,1)!=1)
replacePhaseShifter($(this).attr('id').substr(18,1),$(this).attr('id').substr(19,1));});$('#Stage .tab2').each(function(){$(this).children('.PStext').html('0.50&pi;')
var newWidth=8;var newLeft=31-newWidth/2;newWidth+='px';newLeft+='px';$(this).children('.PSbody').css({'width':newWidth,'left':newLeft});});$('#Stage .tab1,.tab3').each(function(index){$(this).children('.PStext').html('1.00'+'&pi;');$(this).children('.PSbody').css({'width':'12px','left':'25px'});});$('#Stage_phaseShifter13').hide();replaceBS(2);replaceBS(3);replacePhaseShifter(2,1);replacePhaseShifter(1,1);$('#Stage_BS1').hide();$('#Stage_BS1').fadeIn(2000,function(){$('#Stage_BS1').animate({'left':'575px','top':'495px'},800);replacePhaseShifter(3,1);});}
function resetAllElements(){clearCounts()
enableElements();var tabN=getTab()
$('#Stage .BS').each(function(){replaceBS(tabN)});$('#Stage .PS').each(function(){replacePhaseShifter($(this).attr('id').substr(18,1),tabN);});switch(getTab()){case 1:$('#Stage .tab1,.tab3').each(function(index){$(this).children('.PStext').html('1.00'+'&pi;');$(this).children('.PSbody').css({'width':'12px','left':'25px'});});break;case 3:challenges(current_challenge);break;case 2:$('#Stage .tab2').each(function(){$(this).children('.PStext').html('0.50&pi;')
var newWidth=8;var newLeft=31-newWidth/2;newWidth+='px';newLeft+='px';$(this).children('.PSbody').css({'width':newWidth,'left':newLeft});});break;}
getProbD1();displayCounts();}
function placeReleasedElement(movable){var arm='';var tabN=getTab();var psN=movable.attr('id').substr(18,1);if(movable.hasClass('PS')){if(movable.hasClass('upper'))movable.removeClass('upper');if(movable.hasClass('lower'))movable.removeClass('lower');if(movable.hasClass('1'))movable.removeClass('1');if(movable.hasClass('2'))movable.removeClass('2');if(movable.hasClass('3'))movable.removeClass('3');if(isWithIn(movable,250,180,370,430)){var newx=305-parseInt(movable.css('width'))/2;newx+='px'
var x=220+(psN-1)*50;movable.animate({'left':newx,'top':x+'px'},400,function(){getProbD1();displayCounts();});arm='upper';}else if(isWithIn(movable,500,200,600,460)){var newx=550-parseInt(movable.css('width'))/2;newx+='px'
var x=220+(psN-1)*50;movable.animate({'left':newx,'top':x+'px'},400,function(){getProbD1();displayCounts();});arm='lower';}else if(isWithIn(movable,304,130,543,270)){var x=323+(psN-1)*57;movable.animate({'top':'154px','left':x+'px'},400,function(){getProbD1();displayCounts();});arm='upper';}else if(isWithIn(movable,304,372,550,520)){var x=343+(psN-1)*57;movable.animate({'top':'398px','left':x+'px'},400,function(){getProbD1();displayCounts();});arm='lower';}else if(isWithIn(movable,534,129,632,270)){arm='3';movable.animate({'top':'153px','left':'570px'},400,function(){getProbD1();displayCounts();});}else if(isWithIn(movable,199,372,322,520)){movable.animate({'top':'399px','left':'230px'},400,function(){getProbD1();displayCounts();});arm='1';}else if(isWithIn(movable,500,100,600,250)){movable.animate({'top':'105px','left':'521px'},400,function(){getProbD1();displayCounts();});arm='2';}else
replacePhaseShifter(psN,tabN);if((parseInt(arm)==1||parseInt(arm)==2||parseInt(arm)==3)&&$('#Stage .PS.tab'+tabN).hasClass(arm)){replacePhaseShifter(psN,tabN)}else if(!movable.hasClass(arm))
movable.addClass(arm);var tempX=parseInt(movable.css('left'));var tempY=parseInt(movable.css('top'));if(Math.abs(tempX-movable.data('xStart'))<1&&Math.abs(tempY-movable.data('yStart'))<1){if(!fixedPhase)
setPhaseShifter(movable);}}else if(movable.hasClass('BS')){if(!isWithIn(movable,460,135,630,280)){replaceBS(getTab());}else{$('#Stage_snapDot').hide();movable.animate({'left':'485px','top':'155px'},200,function(){getProbD1();displayCounts();});}}}
function getOpacity(){return opacityD1;}
function fastForward(){disableElements();$('#Stage_disableOpticsElements').show();var tabN=getTab()
endValue=numOfPhotons[tabN]+100;if(endValue>numOfPhotons[tabN]){setIntervalObject=setInterval(function(){determineOutcome();displayCounts();if(numOfPhotons[tabN]==endValue){clearInterval(setIntervalObject);enableElements();sym_enable($('#Stage_buttonCont'));}},10);}}
function isWithIn(element,xMin,yMin,xMax,yMax){var response=parseInt(element.css('left'))>xMin;response=response&&parseInt(element.css('top'))>yMin;response=response&&(parseInt(element.css('left'))+parseInt(element.css('width')))<xMax;response=response&&(parseInt(element.css('top'))+parseInt(element.css('height')))<yMax;return response;}
function isPSinPath(element){return(isWithIn(element,260,220,350,440)||isWithIn(element,337,220,590,440)||isWithIn(element,340,110,440,280)||isWithIn(element,340,370,480,620));}
function thereIsEnoughData(th1){var var1=true,var2='';var tabN=getTab();for(var i=0;i<5;i++){var1=var1&&Math.abs(detector1_array[tabN][i]-th1)<=2;}
if(numOfPhotons[tabN]<5)
return false;else
return var1;}
function determineOutcome(){var tabN=getTab();numOfPhotons[tabN]++;var randomValue=Math.random();var probD1=getProbD1();if(randomValue<probD1){flashDet=1;detector1[tabN]++;detector1_array[tabN][numOfPhotons[tabN]%5]=100*detector1[tabN]/numOfPhotons[tabN];}else{flashDet=2;}}
function flashDetector(){if($('#Stage_buttonCont').hasClass('continuous')){if(flashDet==1)
$('#Stage .det1').fadeIn(200).fadeOut(200);else
$('#Stage .det2').fadeIn(200).fadeOut(200);}else{if(flashDet==1)
$('#Stage .det1').fadeIn(200);else
$('#Stage .det2').fadeIn(200);}}
function getProbD1(){var tabN=getTab();var bsIn=parseInt($('#Stage_BS'+tabN).css('top'))<495
var settings='';if(!bsIn)
opacityD1=0.5;else{var phi=0;$('#Stage .PS.tab'+tabN).each(function(){var value=($(this).children('.PSphase').text().substr(0,4));var xpos=parseInt($(this).css('left'))
var ypos=parseInt($(this).css('top'))
var width=parseInt($(this).css('width'))
if(xpos==275||ypos==154){phi+=value*Math.PI;settings+='+'+value+','}else if(xpos==520||ypos==398){phi-=value*Math.PI;settings+='+'+value+','}});opacityD1=(1-Math.cos(phi))/2.0;}
return opacityD1;}
function displayCounts(){var det1Percent,det2Percent;var tabN=getTab();$('#Stage_Cnts1').text(detector1[tabN]);$('#Stage_Cnts2').text(numOfPhotons[tabN]-detector1[tabN]);$('#Stage_totalCounts').text(numOfPhotons[tabN]);var det1Theory=Math.round(100*getOpacity());var det2Theory=100-det1Theory;if(numOfPhotons[tabN]>0){det1Percent=Math.round(100*detector1[tabN]/numOfPhotons[tabN]);det2Percent=100-det1Percent;if(det1Percent==100){$('#Stage_D1per').text('1.00');$('#Stage_D2per').text('0.00');}else if(det2Percent==100){$('#Stage_D1per').text('0.00');$('#Stage_D2per').text('1.00');}else{$('#Stage_D1per').text('0.'+det1Percent);$('#Stage_D2per').text('0.'+det2Percent);}}else{$('#Stage_D1per').text('-');$('#Stage_D2per').text('-');}
if(thereIsEnoughData(det1Theory)){$('#Stage_warningText').hide();$('#Stage_warningText').text('');}
if(numOfPhotons[tabN]==0){$('#Stage_warningText').hide();}else{$('#Stage_warningText').show();}
if(det1Theory==100){$('#Stage_D1th').text('1.00');$('#Stage_D2th').text('0.00');}else if(det2Theory==100){$('#Stage_D2th').text('1.00');$('#Stage_D1th').text('0.00');}else{$('#Stage_D1th').text('0.'+det1Theory);$('#Stage_D2th').text('0.'+det2Theory);}}
function displayInfo(element){$('#Stage .button.help.disabled').each(function(){sym_enable($(this));});$('#Stage .show').hide().removeClass('show');$('#Stage_'+element).addClass('show').show();$('#Stage_buttonClose').show();}
function replacePhaseShifter(number,tabN){element='#Stage_phaseShifter'+number;element+=tabN;element=$(element);var x=329+(number-1)*(375-323);x+='px'
if($(element).hasClass('rotated')){rotateElement($('#Stage_body'+number+tabN),0);$('#Stage_textPS'+number+tabN).css({'left':'19px','top':'73px'});$('#Stage_textPS'+number+'phase'+tabN).css({'left':'13px','top':'2px'});element.removeClass('rotated');}
element.animate({'left':x,'top':'495px'},500,function(){getProbD1();displayCounts();});if(element.hasClass('upper'))element.removeClass('upper');if(element.hasClass('lower'))element.removeClass('lower');if(element.hasClass('1'))element.removeClass('1');if(element.hasClass('2'))element.removeClass('2');if(element.hasClass('3'))element.removeClass('3');}
function replaceBS(tab){if($('#Stage_BS'+tab).hasClass('inPlay')){$('#Stage_BS'+tab).removeClass('inPlay');}
$('#Stage .BS.tab'+tab).animate({'left':'575px','top':'495px'},400,function(){getProbD1();displayCounts();});}
function setPhaseShifter(movable){var N=movable.text().substr(7,1);var ps=parseFloat(movable.text().substr(0,4))+0.25;movable.stop(true);if(getTab()==3){if(ps>0.75){movable.children('.PSphase').html('0.25'+'&pi;');ps=.25;}else{movable.children('.PSphase').html(ps.toFixed(2)+'&pi;');}}else{if(ps>1){movable.children('.PSphase').html('0.25'+'&pi;');ps=.25;}else{movable.children('.PSphase').html(ps.toFixed(2)+'&pi;');}}
ps=parseInt(4*(ps-.25));var newWidth=6+2*parseInt(ps);movable.children('.PSbody').css('width',newWidth+'px');var newLeft=31-newWidth/2;movable.children('.PSbody').css('left',newLeft+'px');getProbD1();displayCounts();}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=40;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){$('#Stage_Cnts2N').html('N<sub>2</sub>&nbsp;&nbsp;=');$('#Stage_Cnts1N').html('N<sub>1</sub>&nbsp;&nbsp;=');$('#Stage_totalCountsN').html('N<sub>tot</sub> =');$('#Stage_sourceText').html('You can send photons through '+'the experiment with a <b>single photon source</b>, so that '+'at a given time only a single photon is present in the '+'experiment - even in Fast forward mode.');$('#Stage_instructionsTab1').html('You can drag the optical components '+'below into the experiment. Press the "?" buttons for information. Phase shifters can be placed anywhere '+'on the photon paths (dotted lines). <b>How do these components '+'affect the count rates in the detectors?  Does the positioning of the '+'phase shifters play a role? </b> Then try Optics Table 2 '+'with variable phase shifters and the challenges '+'in the Challenges tab.');$('#Stage_instructionsTab2').html('Now you can set up experiments '+'with variable phase shifters - tap the phase shifter to set the value. '+'Press the "?" buttons for information. <b>How do the components affect the '+'count rates in the detectors?  Does the value of the phase shift '+'play a role?</b> Then try the challenges in the Challenges tab.');$('#Stage_detectorText').html('You will see the <b>detector</b> flash '+'whenever a photon enters the detector and is converted into an '+'electrical signal.  Thus, a detector flash means the detector '+'has registered a count.');$('#Stage_firstBSText').html('The <b>beam splitter</b> (BS1) converts an incident photon into a superposition '+'state of being in both the upper and lower paths simultaneously. '+'The photon is shown as semi-transparent when it is in a superposition state. '+'BS1 is silvered on the top side.  For a photon incident on BS1 '+'the reflected component is phase shifted by &pi;&nbsp;(180&deg;), due to the air-glass '+'interface, i.e. the change from small to large refractive index. '+'The transmitted component is not phase shifted.');$('#Stage_secBSText').html('Inserting a <b>second '+'beam splitter</b> (BS2) causes interference between '+'the upper and lower paths in the directions to both detectors. '+'BS2 is silvered on the bottom side. Thus, the component  '+'from the lower path reflected into Detector 2 is phase shifted by '+'&pi;&nbsp;(180&deg;). The component from the upper path reflected into Detector 1 is not phase shifted. '+'If only the second beam splitter and no '+'phase shifters are inserted, this leads to constructive interference to '+'Detector 2.');$('#Stage_psText').html('A <b>phase shifter</b> '+'is a transparent glass plate in which the speed of light is reduced.  '+'If inserted into one of the paths, the glass slightly increases the '+'time needed for the photon to traverse that path and thus leads to '+'a change in phase for this path.  Changing the thickness of the plate '+'changes the introduced phase shift.');$('#Stage_mirrorText').html('Two <b>mirrors</b> reflect '+'the photons toward the detectors. The mirrors are placed '+'such that the lower path and upper path are of identical length. '+'The mirrors introduce a phase shift of &pi;&nbsp;(180&deg;) into both paths due to the '+'air-glass interface, i.e. the change from small to large '+'refractive index.  However, the relative phase difference between '+'the two paths is zero, and thus the two mirrors have no '+'impact on the detection probabilities.');$('#Stage_challenge4').html('Using all the components, make '+'all the photons reach detector 1. Only phase shifts of 0.25&pi;, '+'0.50&pi; and 0.75&pi; are available.');$('#Stage_challenge5').html('Using all the components, make '+'on average 50% of the photons reach<br>detector 1. Only phase shifts of 0.25&pi;, '+'0.50&pi; and 0.75&pi; are available.');sym_features();sym_step(1);clearCounts();initializeAllElements();sym.$('Text2').hide();sym.$('OpticalElementsPanel').css('border-top-color','#ffffff');$(document).on('mouseup touchend',function(e){var movable=sym.$('.movable.active');if(movable.hasClass('movable')&&movable.hasClass('active')){sym.$('.movable.active').addClass('unActive');sym.$('.movable.active').removeClass('active');placeReleasedElement(movable);clearCounts();}});$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=sym.$('#Stage .movable.active');if(movable.hasClass('movable')&&movable.hasClass('active')&&!movable.data('timeout')){movable.data('timeout',setTimeout(function(){movable.data('timeout',false);if(movable.data('xtimeout_val')===movable.data('xPos')&&movable.data('ytimeout_val')===movable.data('yPos')){return;}
movable.data('xtimeout_val',movable.data('xPos'));movable.data('ytimeout_val',movable.data('yPos'));sym.$('.flash').hide();if(movable.hasClass('BS')){if(isWithIn(movable,460,135,630,280)){$('#Stage_snapDot').show();}else{$('#Stage_snapDot').hide();}}else if(movable.hasClass('PS')){movable.removeClass('1');movable.removeClass('2');movable.removeClass('3');movable.removeClass('upper');movable.removeClass('lower');var N=movable.attr('id').substr(18,1);var tabN=getTab();if(isWithIn(movable,230,180,370,430)||isWithIn(movable,500,200,600,460)||isWithIn(movable,500,100,600,250)){rotateElement(sym.$('body'+N+tabN),-90);sym.$('textPS'+N+tabN).css({'left':'63px','top':'37px'});sym.$('textPS'+N+'phase'+tabN).css({'left':'-40px','top':'37px'})
movable.addClass('rotated');}else{rotateElement(sym.$('body'+N+tabN),0);sym.$('textPS'+N+tabN).css({'left':'19px','top':'73px'});sym.$('textPS'+N+'phase'+tabN).css({'left':'13px','top':'2px'});movable.removeClass('rotated');}}},20));}});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonFire}","click",function(sym,e){sym.getComposition().getStage().getSymbol("path_2").play('start');disableElements();sym.$('.flash').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_Task1}","click",function(sym,e){sym.$('.active.tab').hide().removeClass('active');sym.$('tab_task1_active').show().addClass('active');stopAllAnimations();getProbD1();fixedPhase=true;sym.$('textPhaseShifters').text('Phase shifters (fixed)');displayCounts();sym.$('.hideOnChallenge,.checkbox, .infoDisplay, .help').show();sym.$('.onChallengeShow').hide();sym.$('warningText').hide();sym.$('.tab1').show();sym.$('.tab2,.tab3').hide();if(!sym.$('checkboxTheory').hasClass('selected'))
sym.$('.theory').hide();if(!sym.$('checkboxDetPercent').hasClass('selected'))
sym.$('.observed').hide();if(sym.$('.checkbox').hasClass('selected'))
sym.$('.tableTitle').show();else
sym.$('.tableTitle').hide();displayInfo('instructionsTab1');sym_disable(sym.$('infoStart'));$('#Stage_textPhaseShifters').show();$('#Stage_textPhaseShiftersCopy').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_Task2}","click",function(sym,e){sym.$('.active.tab').hide().removeClass('active');sym.$('tab_task2_active').show().addClass('active');stopAllAnimations();getProbD1();fixedPhase=false;sym.$('textPhaseShifters').text('Phase shifters (tap to change value)');sym.$('textPhaseShifters').fadeOut(500);sym.$('textPhaseShifters').fadeIn(500);displayCounts();sym.$('.tab2').show();sym.$('.tab1,.tab3').hide();sym.$('.hideOnChallenge,.checkbox, .infoDisplay, .help').show();sym.$('.onChallengeShow').hide();sym.$('warningText').hide();if(!sym.$('checkboxTheory').hasClass('selected'))
sym.$('.theory').hide();if(!sym.$('checkboxDetPercent').hasClass('selected'))
sym.$('.observed').hide();if(sym.$('.checkbox').hasClass('selected'))
sym.$('.tableTitle').show();else
sym.$('.tableTitle').hide();displayInfo('instructionsTab2')
sym_disable(sym.$('infoStart'));$('#Stage_textPhaseShifters').show();$('#Stage_textPhaseShiftersCopy').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_to_TRU}","click",function(sym,e){window.open('http://www.tru.ca','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonCont}","click",function(sym,e){sym.$('.flash').hide();continuousFire=!continuousFire;if(!continuousFire){sym.$('button_label_Cont').text('Continuous fire');sym.$('buttonCont').removeClass('continuous');enableElements();}else{sym.$('button_label_Cont').text('Stop continuous');sym.$('buttonCont').addClass('continuous');if(!sym.getComposition().getStage().getSymbol('path_2').isPlaying())
sym.getComposition().getStage().getSymbol('path_2').play('start');disableElements();}});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonClear}","click",function(sym,e){clearCounts();sym.$('.flash').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonFF}","click",function(sym,e){sym.getComposition().getStage().getSymbol("path_2").stop('start');fastForward();disableElements();sym_disable(sym.$('buttonCont'));sym.$('.flash').hide();if(sym.$('buttonCont').hasClass('continuous')){sym.$('button_label_Cont').text('Continuous fire');sym.$('buttonCont').removeClass('continuous');}});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkboxTheory}","click",function(sym,e){displayCounts();sym.$('.theory').toggle();if(sym.$('.checkbox').hasClass('selected'))
sym.$('.tableTitle').show();else
sym.$('.tableTitle').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkboxDetPercent}","click",function(sym,e){displayCounts();sym.$('.observed').toggle();if(sym.$('.checkbox').hasClass('selected'))
sym.$('.tableTitle').show();else
sym.$('.tableTitle').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_mirrorInfo}","click",function(sym,e){displayInfo('mirrorText');sym_disable(sym.$('mirrorInfo'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_beamSplitterInfo}","click",function(sym,e){displayInfo('secBSText');sym_disable(sym.$('beamSplitterInfo'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_detectorInfo}","click",function(sym,e){displayInfo('detectorText');sym_disable(sym.$('detectorInfo'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_psInfo}","click",function(sym,e){displayInfo('psText');sym_disable(sym.$('psInfo'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_Task3}","click",function(sym,e){sym.$('.active.tab').hide().removeClass('active');sym.$('tab_task3_active').show().addClass('active');stopAllAnimations();sym.$('.tab3').show();sym.$('.tab1,.tab2').hide();sym.$('.hideOnChallenge, .checkbox, .infoDisplay, .help').hide();sym.$('.onChallengeShow').show();if(current_challenge>3)
fixedPhase=false;else
fixedPhase=true;displayCounts();if(firstTimeTab3flag){challenges(1);firstTimeTab3flag=false;}else
challenges(current_challenge);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_beamSplitter1Info}","click",function(sym,e){displayInfo('firstBSText');sym_disable(sym.$('beamSplitter1Info'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonClose}","click",function(sym,e){sym.$('.info').hide();$('#Stage .button.help.disabled').each(function(){sym_enable($(this));});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_infoStart}","click",function(sym,e){var tabN=getTab()
displayInfo('instructionsTab'+tabN);sym_disable(sym.$('infoStart'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_infoSource}","click",function(sym,e){displayInfo('sourceText');sym_disable(sym.$('infoSource'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonReset}","click",function(sym,e){sym.getComposition().getStage().getSymbol("path_2").stop('start');resetAllElements();stopAllAnimations();if(sym.$('buttonCont').hasClass('continuous')){sym.$('button_label_Cont').text('Continuous fire');sym.$('buttonCont').removeClass('continuous');}});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonSubmit}","click",function(sym,e){challengeSubmit();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_quvis-logo-bg}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank');});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'pathSymbol_1'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",3400,function(sym,e){enableElements();displayCounts();if(sym.getComposition().getStage().$('buttonCont').hasClass('continuous')){sym.play();}
else{sym.stop('start');}});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",50,function(sym,e){disableElements();determineOutcome();});
//Edge binding end
})("pathSymbol_1");
//Edge symbol end:'pathSymbol_1'

//=========================================================

//Edge symbol: 'path_2'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",50,function(sym,e){disableElements();});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",3600,function(sym,e){flashDetector();displayCounts();if(sym.getComposition().getStage().$('buttonCont').hasClass('continuous')){sym.play('start');}
else{sym.stop('start');enableElements();}});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",3300,function(sym,e){determineOutcome();sym.$('photon1').css('opacity',getOpacity());sym.$('photon2').css('opacity',1-getOpacity());sym.$('cLine2').css('opacity',Math.min(getOpacity(),1-getOpacity()));});
//Edge binding end
})("path_2");
//Edge symbol end:'path_2'

//=========================================================

//Edge symbol: 'highlight'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight");
//Edge symbol end:'highlight'

//=========================================================

//Edge symbol: 'Challenges'
(function(symbolName){})("Challenges");
//Edge symbol end:'Challenges'

//=========================================================

//Edge symbol: 'steps'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'fancyExcellent'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.stop(0);});
//Edge binding end
})("fancyExcellent");
//Edge symbol end:'fancyExcellent'
})(jQuery,AdobeEdge,"EDGE-19890435");