/*  Copyright 2016, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
Chart.js http://chartjs.org/ Version: 1.0.2 Copyright 2015 Nick Downie Released under the MIT license https://github.com/nnnick/Chart.js/blob/master/LICENSE.md

*/

(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var graph=null,graph2=null,graph3=null,intervalId=null,current_challenge=1,frame_rate=50,show_next_time_step=false,show_slope=false;var help_text=[];help_text["Stage_help_default"]="The graphs show you the probability density and<br>associated probability current for a quantum particle in an equally-weighted superposition of the ground state and first-excited state in a one-dimensional infinite square well. Press the “?” buttons for information on the displayed quantities. Then try the challenges in the Challenges tab!";help_text["Stage_help_relation"]="The slope of the probability current and the probability<br>density are related by the following expression: <nobr>&part;j(x,t)/&part;x = &#8211;(&part;|&Psi;(x,t)|<sup>2</sup>)/&part;t</nobr><br>Thus, if the slope of j is positive at a given point and a given time, this implies that the probability density at that point is decreasing with time, and vice versa.";help_text["Stage_help_prob_dens"]="The top graph shows the time-dependent probability<br>density for a quantum particle in a one-dimensional infinite square well with walls at x=0 and  x=L. The particle is in an equally-weighted superposition of the ground state and first-excited state. The oscillation period of the probability density is proportional to the difference of the two energies in the superposition. ";help_text["Stage_help_prob_curr"]="The bottom graph shows you the time-dependent<br>probability current j(x,t) corresponding to the probability density shown. The probability current <nobr>j = (&#295;/2im)(&Psi;<sup>*</sup> &part;&Psi;/&part;x &#8211; (&part;&Psi;<sup>*</sup>/&part;x)&Psi;)</nobr> for the given equally-weighted superposition <nobr>&Psi; = 1/&radic;<span style='text-decoration:overline;'>2</span>(&Psi;<sub>1</sub> + &Psi;<sub>2</sub>)</nobr> of the ground state and first-excited state. In the expression for j, m is particle m and &Psi;<sup>*</sup> is the complex conjugate of &Psi;.";help_text["Stage_help_gradient"]="You can drag the dashed line anywhere within the well.<br>The slope of probability current at that point is then displayed. If the <i>slope of j is positive</i> at a given point and time, this implies that the probability density at that point is <i>decreasing</i> with time. If the <i>slope of j is negative</i> at a given point and time, this implies that the probability density at that point is <i>increasing</i> with time.";help_text["Stage_help_next_time_step"]="You can choose to display the probability density a short<br>time step later as a thin curve in the probability density graph. If the <i>slope of j is positive</i> at a given point and time, this implies that the probability density at that point is <i>decreasing</i> with time, and vice versa. You can relate regions where the slope of j is positive with regions where the probability density is decreasing in the next time step.";function showHelpText(sym,e){var help_button;if(e===undefined){help_button=$("#Stage_help_default");}else{help_button=$(e.target).parent();}
sym_enable(sym.$('.disabled.help'));sym_disable(help_button);sym.$('help_text').html(help_text[help_button.attr("id")]);sym.$("help_content").show();}
function initSim(){$("#Stage_graph_control").show();$(".sim_x_label").show();resetGraph();updateState();}
function updateState(){resetGraph();checkShowSlope();checkNextTimeStep();drawGraph();}
function resetGraph(){clearInterval(intervalId);stop=false;$("#Stage_button_label_graph").html("Stop");}
function drawGraph(){clearInterval(intervalId);t=0;setTimeout(drawStaticProbDensGraph,0);setTimeout(drawStaticProbCurrGraph,0);setTimeout(drawStaticOverlayProbDensGraph,0);setTimeout(drawSlope,0);start_t=new Date();intervalId=setInterval(animateGraph,frame_rate);$('#Stage .arrowButton').each(function(){if(!stop){sym_disable($(this));}
else{sym_enable($(this));}});}
function probDensEqn(x){return 0.5*Math.pow(Math.sin(Math.PI*x),2)+0.5*Math.pow(Math.sin(2*Math.PI*x),2)+Math.sin(Math.PI*x)*Math.sin(2*Math.PI*x)*Math.cos(3*t);}
var prob_dens_config={bezierCurve:true,bezierCurveTension:0.4,datasetStrokeWidth:2,scaleOverride:true,scaleSteps:1,scaleStepWidth:2,scaleStartValue:0,scaleShowLabels:false,scaleFontColor:"rgba(0, 0, 0, 0)",responsive:false}
var x_axis_config={minX:0,maxX:1,step:0.025,showXLabels:6,labelDecimal:2}
var prob_dens_data_strucs=[{strokeColor:"rgba(1,58,223,1)"}];function drawStaticProbDensGraph(){var element=$('#Stage_canvas_graph_dens');if(graph!=null){graph.destroy()};graph=new FunctionGraph(element,[probDensEqn],x_axis_config,prob_dens_data_strucs,prob_dens_config);}
var overlay_prob_dens_config={bezierCurve:true,bezierCurveTension:0.4,datasetStrokeWidth:1,scaleOverride:true,scaleSteps:1,scaleStepWidth:2,scaleStartValue:0,scaleShowLabels:false,scaleFontColor:"rgba(0, 0, 0, 0)",responsive:false}
var overlay_prob_dens_data_strucs=[{strokeColor:"rgba(1,58,223,0.5)"}];function drawStaticOverlayProbDensGraph(){if(graph2!=null){graph2.destroy()};if(!show_next_time_step)return;var t_temp=t,element=$('#Stage_canvas_overlay_graph_dens');t+=frame_rate/1000*t_scale*2;graph2=new FunctionGraph(element,[probDensEqn],x_axis_config,overlay_prob_dens_data_strucs,overlay_prob_dens_config);t=t_temp;}
function probCurrEqn(x){return(Math.sin(2*Math.PI*x)*Math.cos(Math.PI*x)-2*Math.sin(Math.PI*x)*Math.cos(2*Math.PI*x))*Math.sin(3*t);}
var prob_curr_config={bezierCurve:true,bezierCurveTension:0.4,datasetStrokeWidth:2,scaleOverride:true,scaleSteps:2,scaleStepWidth:2.25,scaleStartValue:-2.25,scaleShowLabels:false,scaleFontColor:"rgba(0, 0, 0, 0)",responsive:false}
var prob_curr_data_strucs=[{strokeColor:"rgba(1,223,58,1)"}];function drawStaticProbCurrGraph(){var element=$('#Stage_canvas_graph_curr');if(graph3!=null){graph3.destroy()};graph3=new FunctionGraph(element,[probCurrEqn],x_axis_config,prob_curr_data_strucs,prob_curr_config);}
var t_scale=0.5;function animateGraph(){var now=new Date();t=now-start_t;t/=1000;t*=t_scale;setTimeout(drawStaticProbDensGraph,0);setTimeout(drawStaticProbCurrGraph,0);setTimeout(drawStaticOverlayProbDensGraph,0);setTimeout(drawSlope,0);}
var slope_area_width,slope_area_height;function slopeAngle(x,t){var m=3*Math.PI*Math.sin(3*t)*Math.sin(Math.PI*x)*Math.sin(2*Math.PI*x);m*=slope_area_height/2.25/slope_area_width;return Math.atan(m)*-180/Math.PI;}
var slope_max_x=370,slope_min_x=-20,slope_x=(slope_max_x+slope_min_x)/2;function drawSlope(){if(!show_slope)return;var slope=$("#Stage_slope"),point=$("#Stage_intersect_point"),point2=$("#Stage_intersect_point2"),x=(slope_x-slope_min_x)/(slope_max_x-slope_min_x),line_x,line_y,angle=slopeAngle(x,t),point_x,point_y,point_y2;line_y=probCurrEqn(x);point_y=probDensEqn(x);line_x=x*100-(slope.width())/2/3.9;line_y=(line_y)/2.25*100;point_y2=line_y-250/slope_area_height;line_y-=100/slope_area_height;point_y=point_y/2*100;point_y=point_y-(2.5/178);point_x=x*100-2.5/3.9;angle=Math.round(angle);point.css({left:point_x+"%",top:"auto",bottom:point_y+"%"});point2.css({left:point_x+"%",top:"auto",bottom:point_y2+"%",});slope.css({left:line_x+"%",top:"auto",bottom:line_y+"%",'-webkit-transform':'rotate('+angle+'deg)','-ms-transform':'rotate('+angle+'deg)','-moz-transform':'rotate('+angle+'deg)','-o-transform':'rotate('+angle+'deg)','transform':'rotate('+angle+'deg)',});}
var stop=false;function graphToggle(){if(stop){start_t=new Date();start_t-=t/t_scale*1000;intervalId=setInterval(animateGraph,frame_rate);$("#Stage_button_label_graph").html("Stop");stop=false;$('#Stage .arrowButton').each(function(){sym_disable($(this));});}else{clearInterval(intervalId);$("#Stage_button_label_graph").html("Resume");stop=true;$('#Stage .arrowButton').each(function(){sym_enable($(this));});}}
function prevFrame(){if(!stop)return;t-=frame_rate/1000*t_scale;setTimeout(drawStaticProbDensGraph,0);setTimeout(drawStaticProbCurrGraph,0);setTimeout(drawStaticOverlayProbDensGraph,0);setTimeout(drawSlope,0);}
function nextFrame(){if(!stop)return;t+=frame_rate/1000*t_scale;setTimeout(drawStaticProbDensGraph,0);setTimeout(drawStaticProbCurrGraph,0);setTimeout(drawStaticOverlayProbDensGraph,0);setTimeout(drawSlope,0);}
function checkShowSlope(){if($("#Stage_checkbox_show_slope").hasClass('selected')){show_slope=true;drawSlope();$('.slope').show();}else{$('.slope').hide();show_slope=false;}}
function checkNextTimeStep(){if($("#Stage_checkbox_next_time_step").hasClass('selected')){show_next_time_step=true;}else{show_next_time_step=false;}}
var score_for_challenge=[25,25,25,25],challenge_complete=[false,false,false,false],totalScore=0,fireworkProb=1,challenge_text=[],challenge_config=[];challenge_text.push("The graph shows you the probability density and probability current at some fixed time t<sub>0</sub>. At which point or points will the probability density increase in the next time step? Choose one or more.");challenge_text.push("The graph shows you the probability density and probability current at some fixed time t<sub>0</sub>. At which point or points will the probability density decrease in the next time step? Choose one or more.");challenge_text.push("At which point or points is the slope of probability current always zero? You can drag the dashed line to display the slope of j at different points. Choose one or more.");challenge_text.push("At which point or points is the temporal rate of change of the probability density always zero? You can drag the dashed line to select a point to display. Choose one or more.");function rerenderCheckbox(e){if(!$(e.target).data('rerender')){sym_features();$(e.target).data('rerender',true);}}
function step_functions(step){clearTimeout(AdobeEdge.step_animation);current_challenge=step;resetGraph();$(".challenge").hide();$("#Stage_feedback_text").hide();$("#Stage_challenge_text").html(challenge_text[current_challenge-1]);$(".checkbox_answer").each(function(){sym_deselect($(this));});switch(current_challenge){case 1:$("#Stage_dashed_a").css({"left":"57px","top":"162px","clip":"rect(0px,1px,172px,0px)"});$("#Stage_dashed_b").css({"left":"98px","top":"148px","clip":"rect(0px,1px,186px,0px)"});$("#Stage_dashed_c").css({"left":"195px","top":"139px","clip":"rect(0px,1px,196px,0px)"});$("#Stage_dashed_d").css({"left":"275px","top":"79px","clip":"rect(0px,1px,255px,0px)"});$("#Stage_dashed_e").css({"left":"330px","top":"128px","clip":"rect(0px,1px,206px,0px)"});$("#Stage_challenge_label_a").css({"left":"52px"});$("#Stage_challenge_label_b").css({"left":"95px"});$("#Stage_challenge_label_d").css({"left":"270px"});$("#Stage_challenge_label_e").css({"left":"325px"});t=0.7;case 2:if(current_challenge==2){$("#Stage_dashed_a").css({"left":"36px","top":"153px","clip":"rect(0px,1px,180px,0px)"});$("#Stage_dashed_b").css({"left":"116px","top":"48px","clip":"rect(0px,1px,298px,0px)"});$("#Stage_dashed_c").css({"left":"195px","top":"140px","clip":"rect(0px,1px,220px,0px)"});$("#Stage_dashed_d").css({"left":"258px","top":"180px","clip":"rect(0px,1px,171px,0px)"});$("#Stage_dashed_e").css({"left":"313px","top":"175px","clip":"rect(0px,1px,163px,0px)"});$("#Stage_challenge_label_a").css({"left":"31px"});$("#Stage_challenge_label_b").css({"left":"111px"});$("#Stage_challenge_label_d").css({"left":"253px"});$("#Stage_challenge_label_e").css({"left":"308px"});t=1.98;}
$("#Stage_checkbox_label_answer0").html("A");$("#Stage_checkbox_label_answer1").html("B");$("#Stage_checkbox_label_answer2").html("C");$("#Stage_checkbox_label_answer3").html("D");$("#Stage_checkbox_label_answer4").html("E");$(".challenge").show();$(".sim_x_label").hide();show_slope=false;show_next_time_step=false;$('.slope').hide();$("#Stage_graph_control").hide();setTimeout(drawStaticProbDensGraph,0);setTimeout(drawStaticProbCurrGraph,0);setTimeout(drawStaticOverlayProbDensGraph,0);setTimeout(drawSlope,0);break;case 3:case 4:$("#Stage_checkbox_label_answer0").html("x = 0");$("#Stage_checkbox_label_answer1").html("x = L/4");$("#Stage_checkbox_label_answer2").html("x = L/2");$("#Stage_checkbox_label_answer3").html("x = 3L/4");$("#Stage_checkbox_label_answer4").html("x = L");$(".sim_x_label").show();show_slope=true;show_next_time_step=false;$('.slope').show();$("#Stage_graph_control").show();drawGraph();break;}}
function shuffle(array){var currentIndex=array.length,temporaryValue,randomIndex;while(0!==currentIndex){randomIndex=Math.floor(Math.random()*currentIndex);currentIndex-=1;temporaryValue=array[currentIndex];array[currentIndex]=array[randomIndex];array[randomIndex]=temporaryValue;}
return array;}
function challengeSubmit(){var feedback=$('#Stage_feedback_text'),result=checkAnswer();feedback.fadeOut("fast",function(){if(result.correct){feedback.css('color','#008f00');}else{feedback.css('color','#960000');}
feedback.html(result.feedback_str);feedback.fadeIn("fast");});if(result.correct&&!challenge_complete[current_challenge-1]){$('#Stage_steps_tick'+current_challenge).show();challenge_complete[current_challenge-1]=true;addScore(score_for_challenge[current_challenge-1]);}}
function checkAnswer(){var result={correct:false,feedback_str:"Something wrong"},all_zero=true,answer0=$("#Stage_checkbox_answer0"),answer1=$("#Stage_checkbox_answer1"),answer2=$("#Stage_checkbox_answer2"),answer3=$("#Stage_checkbox_answer3"),answer4=$("#Stage_checkbox_answer4");switch(current_challenge){case 1:if($(".checkbox_answer.selected").length==0){result.feedback_str="Please select an option.";result.correct=false;}else if(answer3.hasClass('selected')&&answer4.hasClass('selected')&&$(".checkbox_answer.selected").length==2){result.feedback_str="Correct, congratulations! The slope of j is negative at points D and E. This implies that the probability density is increasing with time at these points.";result.correct=true;}else if(answer0.hasClass('selected')&&answer1.hasClass('selected')&&$(".checkbox_answer.selected").length==2){result.feedback_str="This is not yet correct. Remember that the slope of the probability current is the <i>negative</i> of the temporal rate of change of the probability density.";result.correct=false;}else{result.feedback_str="This is not yet correct. Consider the slope of the probability current at the points given, not the value of j itself. Remember that the slope of probability current is the negative of the temporal rate of change of the probability density.";result.correct=false;}
break;case 2:if($(".checkbox_answer.selected").length==0){result.feedback_str="Please select an option.";result.correct=false;}else if(answer3.hasClass('selected')&&answer4.hasClass('selected')&&$(".checkbox_answer.selected").length==2){result.feedback_str="Correct, congratulations! The slope of j is positive at points D and E. This implies that the probability density is decreasing with time at these points.";result.correct=true;}else if(answer0.hasClass('selected')&&answer1.hasClass('selected')&&$(".checkbox_answer.selected").length==2){result.feedback_str="This is not yet correct. Remember that the slope of the probability current is the <i>negative</i> of the temporal rate of change of the probability density. ";result.correct=false;}else{result.feedback_str="This is not yet correct. Consider the slope of the probability current at the points given, not the value of j itself. Remember that the slope of probability current is the negative of the temporal rate of change of the probability density.";result.correct=false;}
break;case 3:if($(".checkbox_answer.selected").length==0){result.feedback_str="Please select an option.";result.correct=false;}else if(answer0.hasClass('selected')&&answer2.hasClass('selected')&&answer4.hasClass('selected')&&$(".checkbox_answer.selected").length==3){result.feedback_str="Correct, congratulations! The slope of j is always zero at the ends of the well and in the middle of the well. This implies that the probability density does not change with time at these points.";result.correct=true;}else{result.feedback_str="This is not yet correct. Consider the slope of the probability current at the five points given, not the value of j itself.";result.correct=false;}
break;case 4:if($(".checkbox_answer.selected").length==0){result.feedback_str="Please select an option.";result.correct=false;}else if(answer0.hasClass('selected')&&answer2.hasClass('selected')&&answer4.hasClass('selected')&&$(".checkbox_answer.selected").length==3){result.feedback_str="Correct, congratulations! The probability density does not change with time at the ends of the well and in the middle of the well. Thus, the temporal rate of change of the probability density and the slope of the probability current are zero at these points for all times.";result.correct=true;}else if(!answer2.hasClass('selected')){result.feedback_str="This is not yet correct. Consider that the slope of probability current is always zero at L/2. What does this imply for the the temporal rate of change of the probability density at this point?";result.correct=false;}else{result.feedback_str="This is not yet correct. If the the temporal rate of change of the probability density is always zero, this implies that the probability density does not change with time. At which points does the probability density not change with time?";result.correct=false;}
break;}
return result;}
function addScore(score){var currentScore=totalScore;totalScore+=score;startScoreAnimation(currentScore,totalScore);if(Math.random()<fireworkProb&&totalScore!=100){fireworks();fireworkProb=0.25;}else
fireworkProb=2*fireworkProb;if(totalScore==100){$("#Stage_fancyExcellent").show();AdobeEdge.getComposition(compId).getStage().getSymbol('fancyExcellent').play();}}
function fireworks(){var star_id='#Stage_stars';var stick_ele=$('#Stage_stick');var number=6;var spread=75;var delay_const=500;var speed_const=700;var speed_const_offset=500;var x0=stick_ele.css('left'),y0=stick_ele.css('top');var totalDelay=0;$('#Stage .star').hide();$('#Stage .star').css({'left':x0,'top':y0,'opacity':1});$('#Stage .star').fadeIn(500);for(var i=0;i<number;i++){var left=Math.round(Math.random()*spread);if(Math.random()<0.5)
left='-='+left+'px';else
left='+='+left+'px';var delay1=Math.round((Math.random()+.25)*delay_const);totalDelay+=delay1;var speed=Math.round((Math.random()+.5)*speed_const)+speed_const_offset;$('#Stage_stars'+i).delay(delay1).animate({'left':left,'top':'-=500px','opacity':0},speed);}
$('#Stage .star').delay(1000).fadeOut();}
function startScoreAnimation(startValue,endValue){var text_score=$('#Stage_text_score');var duration=800;var currentValue=startValue;var interval=duration/(endValue-startValue);if(endValue>startValue){function recursiveFunc(){text_score.text(++currentValue+'/100');if(currentValue==endValue)
return;setTimeout(recursiveFunc,interval);}
recursiveFunc();}else throw'startValue is larger than endValue';}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);$(element).data('timeout_val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});yepnope({load:"normalize.css"});sym.$('help_text').css('-webkit-backface-visibility','hidden');showHelpText(sym);sym.$('checkbox_label_show_slope').html('Show slope &part;j/&part;x (drag dashed line to select point)');sym.$('checkbox_label_next_time_step').html('Show next time step in |&Psi;|<sup>2</sup> graph');sym.$('relation_text').html('Slope of probability current = &#8211;');sym.$('relation_text3').html('&part;j(x, t)/&part;x = &#8211; &part;|&Psi;(x,t)|<sup>2</sup>/&part;t');sym.$('relation_text3').html('<table style="text-align: center; vertical-align: middle;margin-top:0.5em; margin-bottom:0.5em;" align="center" cellpadding="0" cellspacing="0">'+'    <tr>'+'        <td nowrap="nowrap">'+'            &part;j(x, t)'+'        </td>'+'        <td rowspan="2" nowrap="nowrap">'+'            &nbsp;= &#8211;&nbsp;'+'        </td>'+'        <td nowrap="nowrap">'+'            &part;|&Psi;(x,t)|<sup>2</sup>'+'        </td>'+'    </tr>'+'    <tr>'+'        <td style="border-top:solid 1px black;">'+'            &part;x'+'        </td>'+'        <td style="border-top:solid 1px black;">'+'            &part;t'+'        </td>'+'    </tr>'+'</table>');sym.$('prob_dens_y_label').html('|&Psi;(x, t)|<sup>2</sup>');sym.$('prob_curr_y_label').html('j(x, t)');slope_area_width=$("#Stage_slope_area").width();slope_area_height=$("#Stage_slope_area").height();$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=sym.$('movable_line');if(movable.hasClass('active')&&!movable.data('timeout')){movable.data('timeout',setTimeout(function(){movable.data('timeout',false);if(movable.data('xtimeout_val')===movable.data('xPos')&&movable.data('ytimeout_val')===movable.data('yPos')){return;}
movable.data('xtimeout_val',movable.data('xPos'));movable.data('ytimeout_val',movable.data('yPos'));slope_x=movable.data('xPos')-movable.width()/2;setTimeout(drawSlope,0);console.log('x:'+slope_x+' y:'+movable.data('yPos'));},20));}});initSim();$('.tick').hide();$('#Stage .star').hide();$('.challenge').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){sym.stop('simulation');sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);initSim();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_challenge}","click",function(sym,e){sym.stop('challenge');sym_features();resetGraph();sym_step(current_challenge);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_prob_curr}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_help_close}","click",function(sym,e){sym_enable(sym.$('.disabled.help'));sym.$('help_content').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_default}","click",function(sym,e){sym_features();showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_measure}","click",function(sym,e){measureEnergy();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_show_slope}","click",function(sym,e){checkShowSlope();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_gradient}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_next_time_step}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_next_time_step}","click",function(sym,e){checkNextTimeStep();drawStaticOverlayProbDensGraph();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_relation}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_backButton}","click",function(sym,e){prevFrame();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_forwardButton}","click",function(sym,e){nextFrame();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_graph}","click",function(sym,e){graphToggle();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_submit}","click",function(sym,e){challengeSubmit();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_help_prob_dens}","click",function(sym,e){showHelpText(sym,e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_answer3}","click",function(sym,e){rerenderCheckbox(e)});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_answer0}","click",function(sym,e){rerenderCheckbox(e)});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_answer1}","click",function(sym,e){rerenderCheckbox(e)});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_answer4}","click",function(sym,e){rerenderCheckbox(e)});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox_answer2}","click",function(sym,e){rerenderCheckbox(e)});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'fancyExcellent'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.stop(0);});
//Edge binding end
})("fancyExcellent");
//Edge symbol end:'fancyExcellent'
})(jQuery,AdobeEdge,"EDGE-19890435");