/*  Copyright 2015, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
*/
(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;function rotateSgas(){stage=AdobeEdge.getComposition(compId).getStage();if($('#Stage_RadioX').hasClass('selected'))stage.getSymbol('sgaCore').stop('X');else stage.getSymbol('sgaCore').stop('Z');}
var explanation=false;function initialize(){stage=AdobeEdge.getComposition(compId).getStage();if(!explanation)saveThings();sym_deselect(stage.$('.checkbox'));sym_select($('#Stage_RadioZ'));rotateSgas();showHide();clearAll();resetColors();}
function showHide(){stage=AdobeEdge.getComposition(compId).getStage().getSymbol('sgaCore');rotateSgas();if($('#Stage_CheckboxDisplay1').hasClass('selected'));else stage.$('.states').hide();if($('#Stage_CheckboxDisplay2').hasClass('selected'));else stage.$('.states_mixed').hide();if($('#Stage_CheckboxDisplay3').hasClass('selected'));else stage.$('.matrices_pure').hide();if($('#Stage_CheckboxDisplay4').hasClass('selected'));else stage.$('.matrices_mixed').hide();}
var radio='Z';var display=[];function saveThings(){display=[];for(var i=1;i<=4;i++){if($('#Stage_CheckboxDisplay'+i).hasClass('selected'))display.push(i);}
if($('#Stage_RadioX').hasClass('selected'))radio='X';else radio='Z';}
function resetThings(){debug(display);for(var i=0;i<display.length;i++){sym_select($('#Stage_CheckboxDisplay'+display[i]));}
sym_select($('#Stage_Radio'+radio));showHide();clearAll();resetColors();}
function debug(value){$('#Stage_debug').text(value);}
var blue;var red;var green;var grey;function toggleColors(){stage=AdobeEdge.getComposition(compId).getStage();i=0;blue=setInterval(function(){stage.getSymbol('sgaCore').$('.blue').css({'background-color':'rgba(204,204,228,'+(Math.abs(20-(i%40)))*0.05+')'}),i++},100);red=setInterval(function(){stage.getSymbol('sgaCore').$('.red').css({'background-color':'rgba(255,187,187,'+(Math.abs(20-(i%40)))*0.05+')'}),i},100);green=setInterval(function(){stage.getSymbol('sgaCore').$('.green').css({'background-color':'rgba(121,225,124,'+(Math.abs(20-(i%40)))*0.05+')'}),i},100);grey=setInterval(function(){stage.getSymbol('sgaCore').$('.grey').css({'background-color':'rgba(240,240,240,'+(Math.abs(20-(i%40)))*0.05+')'}),i},100);}
function resetColors(){stage=AdobeEdge.getComposition(compId).getStage();stage.getSymbol('sgaCore').$('.blue').css({'background-color':'rgba(204,204,228,1.0)'});stage.getSymbol('sgaCore').$('.red').css({'background-color':'rgba(255,187,187,1.0)'});stage.getSymbol('sgaCore').$('.green').css({'background-color':'rgba(121,225,124,1.0)'});stage.getSymbol('sgaCore').$('.grey').css({'background-color':'rgba(240,240,240,1.0)'});}
function clearAll(){clearInterval(blue);clearInterval(red);clearInterval(grey);clearInterval(green);}
function step_functions(step){clearTimeout(AdobeEdge.step_animation);stage=AdobeEdge.getComposition(compId).getStage();switch(step){case 1:initialize();sym_select($('#Stage_RadioZ'));showHide();stage.getSymbol('sgaCore').$('.step1').show();toggleColors();break;case 2:initialize();sym_select($('#Stage_RadioZ'));showHide();stage.getSymbol('sgaCore').$('.step2').show();toggleColors();break;case 3:initialize();sym_select($('#Stage_RadioZ'));showHide();stage.getSymbol('sgaCore').$('.step3').show();toggleColors();break;case 4:initialize();sym_select($('#Stage_RadioX'));showHide();stage.getSymbol('sgaCore').$('.step4').show();toggleColors();break;case 5:initialize();sym_select($('#Stage_RadioX'));showHide();stage.getSymbol('sgaCore').$('.step5').show();toggleColors();break;case 6:initialize();sym_select($('#Stage_RadioX'));showHide();stage.getSymbol('sgaCore').$('.step3').show();toggleColors();break;case 7:initialize();sym_select($('#Stage_RadioZ'));showHide();stage.getSymbol('sgaCore').$('.step7').show();toggleColors();break;}}
$(function(){FastClick.attach(document.body);});function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});yepnope({load:"normalize.css"});initialize();sym.$('debug').hide();sym.$('FurnaceScreenDescription').html('Screen:  The Stern-Gerlach apparatus (SGA) allows you to take a measurement of the component of spin angular momentum along a given axis, here the z axis. For spin 1/2 particles, the particles separate into two discrete streams, one with spin component +&#295;/2, the other with spin component &#8211;&#295;/2 along this axis. A detector (here a screen) measures the deflected particles.');sym.$('.popup_text').hide();sym.getSymbol('#Stage_sgaCore').$('zPlus').html('|z<sub>+</sub>&#x232A;');sym.getSymbol('#Stage_sgaCore').$('zMinus').html('|z<sub>&#8211;</sub>&#x232A;');sym.getSymbol('#Stage_sgaCore').$('xPlus').html('|x<sub>+</sub>&#x232A;');sym.getSymbol('#Stage_sgaCore').$('xMinus').html('|x<sub>&#8211;</sub>&#x232A;');sym.getSymbol('#Stage_steps').$('step_text1').html('If the SGA is oriented along z as shown, then each particle in the upper stream has spin component S<sub>z</sub> = +&#295;/2, in the lower stream S<sub>z</sub> = &#8211;&#295;/2.  Each particle in the upper stream is in the eigenstate |z<sub>+</sub>&#x232A; of the S<sub>z</sub>-operator. The density matrix is <br><br>&rho;<sub>z<sub>+</sub></sub> = |z<sub>+</sub>&#x232A;&#x2329;z<sub>+</sub>| = <br><br>This is a pure state, and the trace of the square of the density matrix <br>Tr(&rho;<sup>2</sup> ) = Tr(&rho;) = 1, as must be the case for a pure state.');sym.getSymbol('#Stage_steps').$('step_text2').html('Each particle in the lower stream is in the eigenstate |z<sub>&#8211;</sub>&#x232A; <br>of the S<sub>z</sub>-operator. The density matrix is <br><br>&rho;<sub>z<sub>&#8211;</sub></sub> = |z<sub>&#8211;</sub>&#x232A;&#x2329;z<sub>&#8211;</sub>| = <br><br> This is again a pure state.');sym.getSymbol('#Stage_steps').$('step_text3').html('If we consider both streams taken together, we have a mixed state consisting of an equal mixture of particles in eigenstates  |z<sub>+</sub>&#x232A; and |z<sub>&#8211;</sub>&#x232A;. As this is a mixed state, there is no state vector. The density matrix is <br><br> &rho; = 1/2|z<sub>+</sub>&#x232A;&#x2329;z<sub>+</sub>| + 1/2|z<sub>&#8211;</sub>&#x232A;&#x2329;z<sub>&#8211;</sub>| = &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;. Now, Tr(&rho;<sup>2</sup> ) = <br><br>as expected for a mixed state.');sym.getSymbol('#Stage_steps').$('step_text4').html('If the SGA is oriented along x as shown, then each particle deflected in +x direction has spin component S<sub>x</sub> = +&#295;/2, each deflected in the &#8211;x direction has  S<sub>x</sub> = &#8211;&#295;/2.  Each particle deflected in the +x direction is in the eigenstate <span style="white-space: nowrap;">|x<sub>+</sub>&#x232A; = 1/&radic;<span style="text-decoration: overline">2</span>(|z<sub>+</sub>&#x232A; + |z<sub>&#8211;</sub>&#x232A;)</span> of the S<sub>x</sub>-operator, and thus in a superposition state of |z<sub>+</sub>&#x232A; and |z<sub>&#8211;</sub>&#x232A;. The density matrix is <br><div style="line-height:60%;"><br></div>&rho;<sub>x<sub>+</sub></sub> = |x<sub>+</sub>&#x232A;&#x2329;x<sub>+</sub>| = 1/2 (|z<sub>+</sub>&#x232A; + |z<sub>&#8211;</sub>&#x232A;)(&#x2329;z<sub>+</sub>| + &#x2329;z<sub>&#8211;</sub>|) = <br><div style="line-height:60%;"><br></div> This is a pure state, and the trace of the square of the density matrix <br>Tr(&rho;<sup>2</sup> ) = Tr(&rho;) = 1, as must be the case for a pure state. ');sym.getSymbol('#Stage_steps').$('step_text5').html('Each particle deflected in the &#8211;x direction is in the eigenstate <span style="white-space: nowrap;">|x<sub>&#8211;</sub>&#x232A; = 1/&radic;<span style="text-decoration: overline">2</span>(|z<sub>+</sub>&#x232A; &#8211; |z<sub>&#8211;</sub>&#x232A;)</span>, with density matrix<br><br> &rho;<sub>z<sub>&#8211;</sub></sub> = <br><br> Again, this is a pure state (a superposition state of |z<sub>+</sub>&#x232A; and |z<sub>&#8211;</sub>&#x232A;) with  Tr(&rho;<sup>2</sup> ) = Tr(&rho;) = 1.');sym.getSymbol('#Stage_steps').$('step_text6').html('If we consider both streams taken together, we have a mixed state consisting of an equal mixture of particles in eigenstates  |x<sub>+</sub>&#x232A; and |x<sub>&#8211;</sub>&#x232A;. As this is a mixed state, there is no state vector. The density matrix is <br><br> &rho; = 1/2|x<sub>+</sub>&#x232A;&#x2329;x<sub>+</sub>| + 1/2|x<sub>&#8211;</sub>&#x232A;&#x2329;x<sub>&#8211;</sub>| = <br><br> This density matrix is identical to the one for the equal mixtures of |z<sub>+</sub>&#x232A; and |z<sub>&#8211;</sub>&#x232A;.  Different mixtures can lead to the same density matrix.');sym.getSymbol('#Stage_steps').$('step_text7').html('Prior to passing through the SGA, the spin of the particles can point in any direction of space, and all directions are equally probable. This is again a mixed state, so there is no state vector. Integrating over all possible directions, one finds that the density matrix is <br><br>&rho; = ');var text_ids=['Magnets','Screen','furnace','InVacuum'];for(var t in text_ids){$('#Stage_setup_'+text_ids[t]).click(popup_event);$('#Stage_setup_'+text_ids[t]).mouseover(popup_event);$('#Stage_setup_'+text_ids[t]).mouseout(popup_event);}
function popup_event(e){var text_id=e.currentTarget.id.replace('setup_','text_');if(!$('#'+text_id).length)text_id=text_id.replace(/[12]$/,'s');var fixed_id=$('.fixed_text').attr('id');if(e.type=='click'){$('.fixed_text').hide().removeClass('fixed_text');if(fixed_id!=text_id)$('#'+text_id).show().addClass('fixed_text');}
else{if(e.type=='mouseover'||fixed_id!=text_id)e.type=='mouseover'?$('#'+text_id).show():$('#'+text_id).hide();if(e.type=='mouseover'&&fixed_id&&fixed_id!=text_id){$('#'+fixed_id).hide()
fixed_id=false;}}}
$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));sym.$('test_label').text('#1 slider: '+slider.data('val'));},20));}});$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider2');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));sym.$('test_label').text('#2 slider: '+slider.data('val'));},20));}});$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=sym.$('movableRectangle');if(movable.hasClass('active')&&!movable.data('timeout')){movable.data('timeout',setTimeout(function(){movable.data('timeout',false);if(movable.data('xtimeout_val')===movable.data('xPos')&&movable.data('ytimeout_val')===movable.data('yPos')){sym.$('test_label').text('no movement required');return;}
movable.data('xtimeout_val',movable.data('xPos'));movable.data('ytimeout_val',movable.data('yPos'));sym.$('test_label').text('Vertical rectangle moved');},20));}});$(document).on('mouseup touchend',function(e){var movable=sym.$('movableSquare');if(movable.hasClass('unActive')){movable.removeClass('unActive');var currentXpos=movable.css('left');currentXpos=currentXpos.slice(0,currentXpos.indexOf('px'));var currentYpos=movable.css('top');currentYpos=currentYpos.slice(0,currentYpos.indexOf('px'));sym.$('test_label').text('Square released at ('+currentXpos+','+currentYpos+')');}});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){sym.stop('controls');sym.$('.radio').show();sym_select('#Stage_ControlsRadio');explanation=false;sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);resetThings();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_explanation}","click",function(sym,e){sym.stop('explanation');sym.$('.radio').hide();saveThings();explanation=true;sym_features();sym_step(1);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_IntroductionRadio}","click",function(sym,e){sym.stop('introduction');initialize();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_ControlsRadio}","click",function(sym,e){sym.stop('controls');resetThings();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_RadioZ}","click",function(sym,e){rotateSgas();showHide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_RadioX}","click",function(sym,e){rotateSgas();showHide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_CheckboxDisplay2}","click",function(sym,e){showHide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_CheckboxDisplay4}","click",function(sym,e){showHide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_CheckboxDisplay3}","click",function(sym,e){showHide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_CheckboxDisplay1}","click",function(sym,e){showHide();});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'highlight_1'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight_1");
//Edge symbol end:'highlight_1'

//=========================================================

//Edge symbol: 'sgaCore'
(function(symbolName){})("sgaCore");
//Edge symbol end:'sgaCore'
})(jQuery,AdobeEdge,"EDGE-19890435");