/*  Copyright 2017, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md

*/
(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var curVal;var productPrefixes=["Energy-corrA-","Product-unmixed-","Product-unmixed-","Energy-corrB-","H11-","Product-original-","Product-original-","H22-"];var prefixIndex=1;function debug(value){$('#Stage_debug').text(value);}
if(!Array.prototype.includes){Object.defineProperty(Array.prototype,'includes',{value:function(searchElement,fromIndex){if(this==null){throw new TypeError('"this" is null or not defined');}
var o=Object(this);var len=o.length>>>0;if(len===0){return false;}
var n=fromIndex|0;var k=Math.max(n>=0?n:len-Math.abs(n),0);function sameValueZero(x,y){return x===y||(typeof x==='number'&&typeof y==='number'&&isNaN(x)&&isNaN(y));}
while(k<len){if(sameValueZero(o[k],searchElement)){return true;}
k++;}
return false;}});}
var phia=writeExp('ϕ',undefined,'a');var phib=writeExp('ϕ',undefined,'b');var phi0a=writeExp('ϕ','(0)','a');var phi0b=writeExp('ϕ','(0)','b');var phi1a=writeExp('ϕ','(1)','a');var phi1b=writeExp('ϕ','(1)','b');var phi10=writeExp('ϕ',undefined,'10');var phi01=writeExp('ϕ',undefined,'01');var phi010=writeExp('ϕ','(0)','10');var phi001=writeExp('ϕ','(0)','01');var phi110=writeExp('ϕ','(1)','10');var phi101=writeExp('ϕ','(1)','01');var Ea=writeExp('E',undefined,'a');var Eb=writeExp('E',undefined,'b');var E0a=writeExp('E','(0)','a');var E0b=writeExp('E','(0)','b');var E1a=writeExp('E','(1)','a');var E1b=writeExp('E','(1)','b');var E10=writeExp('E',undefined,'10');var E01=writeExp('E',undefined,'01');var E010=writeExp('E','(0)','10');var E001=writeExp('E','(0)','01');var E110=writeExp('E','(1)','10');var E101=writeExp('E','(1)','01');var orig_html='Original basis: <br>'+phi010+', '+phi001;var good_html='Good basis: <br>'+phi0a+', '+phi0b;var energy_html=E010+' = &nbsp&nbsp'
+E001+' = &nbsp&nbsp'
+E0a+' = &nbsp&nbsp'
+E0b+' = &nbsp 2&#295&#969';var energy_help_html="The first-order energy corrections are<br>"
+E1a+"= &#x2329"+phi0a+"| H' | "+phi0a+"&#x232A <br>and "
+E1b+"= &#x2329"+phi0b+"| H' | "+phi0b+"&#x232A. Note these \
 are only defined for the good basis! You can determine the sign and \
 relative magnitude of these energy corrections: \
 compare the curves of <span style='white-space:nowrap;'>"
+phi0a+"H' "+phi0a+"</span> and <span style='white-space:nowrap;'>"+phi0b+"H' "+phi0b+"</span> \
 and consider which of them has a greater volume under the curve."
var default_help_html='Press the “?” buttons for <br>more information. \
   The top graphs show you degenerate unperturbed eigenfunctions of a 2D oscillator and a \
   perturbation '+"<br><span style='font-size: 30px !important; white-space:nowrap;'><i>\
    H' = ε mω<sup>2</sup> (x </i>cos<i>&theta;+y </i>sin<i>&theta;)<sup>2</sup></i></span>"+'.\
   <b>Can you see why the original degenerate basis '+'can not be used for\
   perturbation theory excepting for special angles of the perturbation?\
    </b>Then go on to the Perturbed States tab.';var radio_help_html="The good basis states "+phi0a
+" <br>and "+phi0b+" are constructed so that the volume under the "
+phi0a+"H' "+phi0b+" curve is zero. This implies that the matrix element \
  &#x2329"+phi0a+"| "+"H'"+" | "+phi0b+"&#x232A = 0 and thus\
   the corresponding mixing coefficient c<sub>ab</sub> is zero,\
    so that perturbation theory can be applied.";var graph0_help_html="The top left and right <br>graphs show you either the original basis states "
+phi010+"(x,y) and "+phi001+"(x,y) (the first excited state along x\
  and the ground state along y or vice versa) or the “good” basis states "
+phi0a+"and "+phi0b+"that are linear combinations of the original basis states.\
   The superscript “(0)” stands for unperturbed."
var graph1_help_html="The two-dimensional <br>harmonic oscillator potential is\
  perturbed by <br><span style='font-size: 30px !important; white-space:nowrap;'><i>\
  H' = ε mω<sup>2</sup> (x </i>cos<i>&theta;+y </i>sin<i>&theta;)<sup>2</sup></i></span> \
  with a small parameter ε, oscillator mass m and angular frequency ω .\
   Note that the size of the perturbation is here exaggerated for \
   first-order perturbation theory to make effects more visible."
var product_help_html="Excepting when the perturbation is aligned with\
  one of the two coordinate axes, for the original basis states\
  the matrix element &#x2329"+phi010+"| "+"H'"+" | "+phi001+"&#x232A &ne; 0. \
  This implies that the corresponding mixing \
  coefficient "+writeExp("c",undefined,"10,01")+" \
  is infinite (as you are dividing by the unperturbed energy difference which is zero) and thus perturbation theory can not be applied."
var graph0_good_html=phi0a+" = cos(0°) "+phi010+" + sin(0°) "+phi001+"= "+phi010;var graph0_orig_html=phi010;var graph1_html="Perturbation H'";var graph2_good_html=phi0b+" = &#8211 sin(0°) "+phi010+"+ cos(0°) "+phi001+"= "+phi001;var graph2_orig_html=phi001;var H11_html=writeExp("H'",undefined,"11");var H12_html=writeExp("H'",undefined,"12");var H21_html=writeExp("H'",undefined,"21");var H22_html=writeExp("H'",undefined,"22");var E11_html=E1a;var E12_html="0";var E21_html="0";var E22_html=E1b;var product_label_html="Graph of integrand "+phi0a+"H' "+phi0a;var aHa_html="&#x2329"+phi0a+"| H' | "+phi0a+"&#x232A = "+E1a;var graph3_good_html="&nbsp&nbsp Graph of integrand "+phi0a+"H' "+phi0b+"<br><br>&#x2329 "+phi0a+"| H' | "+phi0b+"&#x232A = 0";var graph3_orig_equal_html="&nbsp&nbsp Graph of integrand "+phi010+"H' "+phi001+"<br><br>&#x2329 "+phi010+"| H' | "+phi001+"&#x232A = 0";var graph3_orig_notEqual_html="&nbsp&nbsp Graph of integrand "+phi010+"H' "+phi001+"<br><br>&#x2329 "+phi010+"| H' | "+phi001+"&#x232A &#8800 0";var pert_default_html="Press the “?” buttons for <br>more information.\
 <b> Can you see why the perturbation “squeezes” the eigenfunctions along one direction\
  given its shape? Which coefficient in the expansion for the perturbed eigenfunctions\
   is with certainty zero?</b> Then go on to the Challenges!"
var phiA_expansion_html=writeExp("ϕ",undefined,"a")+"= "+phi0a
+"+ "+writeExp("0 ϕ","(0)","b")
+"+ "+writeExp("c",undefined,"a,00")+writeExp("ϕ","(0)","00")
+"+ "+writeExp("c",undefined,"a,11")+writeExp("ϕ","(0)","11")
+"+ ...";var phiB_expansion_html=writeExp("ϕ",undefined,"b")+"= "+phi0b
+"+ "+writeExp("0 ϕ","(0)","a")
+"+ "+writeExp("c",undefined,"b,00")+writeExp("ϕ","(0)","00")
+"+ "+writeExp("c",undefined,"b,11")+writeExp("ϕ","(0)","11")
+"+ ...";var impossible_expansion_html="Expansion is impossible to construct with "
+phi010+", "+phi001+"basis";var graph4_html="Perturbed "+phia+" ";var graph6_html="Perturbed "+phib+" ";var graph7_html="Unperturbed "+phi0a;var graph4_orig_html=phi10;var graph6_orig_html=phi01;var pert_energy_html=writeExp("E","(1)","b",undefined,-0.1)
+"&ne; "+writeExp("E","(1)","a",undefined,-0.1)+"&nbsp&nbsp&nbsp Degeneracy is lifted";var graph4_help_html="The states "+phi0a+"and "+phi0b+" <br>found in the\
  “Good Basis States” tab are still unperturbed. The top left and right graphs here show\
   the first-order perturbed energy eigenfunctions "+phia
+" and "+phib+". These are eigenfunctions of the full\
    Hamiltonian, i.e. the sum of the unperturbed Hamiltonian<br> \
    <span style='font-size: 30px !important; white-space:nowrap;'><i>"+writeExp("H",undefined,"0")+"</i></span> \
    and the perturbation <br>\
    <span style='font-size: 30px !important; white-space:nowrap;'><i>\
    H' = ε/2 mω<sup>2</sup> (x cos(&theta;)+y sin(&theta;))<sup>2</sup></i></span>.";var expansion_help_html="In first-order approximation, the perturbed eigenfunction \
 is given by a sum over the unperturbed eigenfunctions, each weighted by a coefficient. \
 The contribution of the unperturbed "+phi0b+"to the perturbed "+phia+" is zero \
 (coefficient "+writeExp("c",undefined,"ab")+" = 0) and vice versa. However, contributions from other states \
 such as "+writeExp("ϕ","(0)","00")+" and "+writeExp("ϕ","(0)","11")+"are in general non-zero. ";var pert_radio_help_html="Excepting when the perturbation is aligned along one \
 of the coordinate axes, we can not apply perturbation theory to the original \
 basis states "+phi010+"and "+phi001+"as the coefficient between these \
 states is infinite. The first-order energy corrections to "
+phi010+"and "+phi001+"and the perturbed eigenfunctions are not defined. ";var pert_radio_label_html="Original basis: <br>"+phi10+" , "+phi01;var good_pert_radio_label_html="Good basis: <br>"+phia+" , "+phib;var pert_energy_help_html="The corrections <br>"+
E1a+"= &#x2329"+phi0a+"| H' | "+phi0a+"&#x232A <br> and "
+E1b+"= &#x2329"+phi0b+"| H' | "+phi0b+"&#x232A are not \
  equal. The unperturbed eigenfunctions "+phi0a+"and "+phi0b+"are degenerate \
  (they have the same energy), but the perturbed eigenfunctions "
+phia+" and "+phib
+" are not, as the energy along the “squeezed” direction is higher. \
   Thus, the perturbation has lifted the degeneracy, so that "
+Ea+"≠ "+Eb+".";questions={question_1_html:"1) Which of the following energies are the same?\
   Assume the perturbation is <i>not</i> oriented along one of the coordinate axes. \
   Choose one or more. Feel free to revisit the simulation.",question_2_html:"2) Which of the following matrix elements is/are zero? \
   Assume the perturbation is <i>not</i> oriented along one of the coordinate axes. \
   Choose one or more.",question_3_html:"3) The general formula for the first-order coefficient is\
   <br><br><br><br> Which of the following first-order coefficients is/are zero? \
   Assume the perturbation is <i>not</i> oriented along one of the coordinate axes. \
   Choose one or more.",question_4_html:"4) Which of the following matrix elements is/are zero? \
   Assume the perturbation <i>is oriented along the y-axis</i>. Choose one or more.",question_5_html:"5) The general formula for the first-order coefficient is \
   <br><br><br><br>Which of the following first-order coefficients is/are \
   zero? Assume the perturbation <i>is oriented along the y-axis</i>. Choose one or more."}
answers={answer_1a_html:E0a+"and "+E0b+"- the unperturbed energies of the good \
        basis states "+phi0a+"and "+phi0b,answer_1b_html:E0a+"and "+E001+" - the unperturbed energies of "
+phi0a+"and the original basis state "+phi001,answer_1c_html:E1a+"and "+E1b+"- the first-order energy corrections\
         of the perturbed "+phia+" and "+phib,answer_1d_html:Ea+" and "+Eb+" - the first-order perturbed energies of "+
phia+" and "+phib,answer_2a_html:"&#x2329"+phi0a+"| H' | "+phi0a+"&#x232A of the unperturbed "+
phi0a+"and the perturbation H'",answer_2b_html:"&#x2329"+phi0a+"| H' | "+phi0b+"&#x232A of the unperturbed "+
phi0a+"and "+phi0b+"and the perturbation H'",answer_2c_html:"&#x2329"+phi010+"| H' | "+phi001+"&#x232A of the unperturbed "+
phi010+"and "+phi001+"and the perturbation H'",answer_2d_html:"&#x2329"+phi0b+"| H' | "+phi0a+"&#x232A of the unperturbed "+
phi0a+"and "+phi0b+"and the perturbation H'",answer_3a_html:writeExp("c",undefined,"a,b")+" contribution of the unperturbed "
+phi0b+"to the perturbed "+phia,answer_3b_html:writeExp("c",undefined,"10,01")+" contribution of the unperturbed "
+phi001+"to the perturbed "+phi10,answer_3c_html:writeExp("c",undefined,"01,10")+" contribution of the unperturbed "
+phi010+"to the perturbed "+phi01,answer_3d_html:writeExp("c",undefined,"b,a")+" contribution of the unperturbed "
+phi0a+"to the perturbed "+phib,answer_4a_html:"&#x2329"+phi0a+"| H' | "+phi0a+"&#x232A of the unperturbed "
+phi0a+"and the perturbation H'",answer_4b_html:"&#x2329"+phi0a+"| H' | "+phi0b+"&#x232A of the unperturbed "
+phi0a+"and "+phi0b+"and the perturbation H'",answer_4c_html:"&#x2329"+phi010+"| H' | "+phi001+"&#x232A of the unperturbed "
+phi010+"and "+phi001+"and the perturbation H'",answer_4d_html:"&#x2329"+phi0b+"| H' | "+phi0a+"&#x232A of the unperturbed "
+phi0a+"and "+phi0b+"and the perturbation H'",answer_5a_html:writeExp("c",undefined,"a,b")+" contribution of the unperturbed "
+phi0b+"to the perturbed "+phia,answer_5b_html:writeExp("c",undefined,"10,01")+" contribution of the unperturbed "
+phi001+"to the perturbed "+phi10,answer_5c_html:writeExp("c",undefined,"01,10")+" contribution of the unperturbed "
+phi010+"to the perturbed "+phi01,answer_5d_html:writeExp("c",undefined,"b,a")+" contribution of the unperturbed "
+phi0a+"to the perturbed "+phib}
correct_1_html="Correct, congratulations! The unperturbed energies are degenerate \
  no matter which basis states we use. However, the perturbation lifts the \
  degeneracy: the first-order energy corrections are different for the states "
+phia+" and "+phib+". Thus, the perturbed energies of "+phia+" and "+phib+" differ.";incorrect_1_ab_html="The unperturbed basis states "
+phi010+"and "+phi001+"are degenerate, meaning they have the same energy \
  <span style='white-space: nowrap;'>"
+E010+"= "+E001+"= E.</span> Any linear combination of these basis states is still \
  an eigenstate of the Hamiltonian with this same energy, as \
   <span style='font-size: 30px !important; white-space:nowrap;'><i> &#x124( a"
+phi010+"+ b"+phi001+") = E( a"+phi010+"+ b"+phi001+")</i></span>.<br><br>";incorrect_1_cd_html="The perturbation lifts the degeneracy, in that the first-order \
 energy corrections of "+phia+" and "+phib+" are not the same. The first-order \
 perturbed energies are the sum of the unperturbed energies and the first-order energy \
 corrections.<br><br>";incorrect_1_cd_short_html="The perturbation lifts the degeneracy, in that the first-order \
 energy corrections of "+phia+" and "+phib+" are not the same. <br><br>";incorrect_1_default_html="The superscript (0) stands for unperturbed, the \
 superscript (1) for first-order perturbed.";correct_2_html="Correct, congratulations! "+phi0a+"and "+phi0b+"form the good basis. This means that the volume under the product curve of \
 <span style='white-space: nowrap;'>"+
phi0a+"H' "+phi0b+"</span>equals zero, so that the matrix elements \
 <span style='white-space: nowrap;'> &#x2329"+
phi0a+"| H' | "+phi0b+"&#x232A</span> and <span style='white-space: nowrap;'> \
 &#x2329"+phi0b+"| H' | "
+phi0a+"&#x232A</span> are zero.";incorrect_2_a_html="The matrix element <span style='white-space: nowrap;'> \
 &#x2329"+phi0a+"| H' | "+phi0a+"&#x232A</span> is\
  the first-order energy correction of the perturbed "+phia+".  Is this energy correction equal to zero?<br><br>";incorrect_2_bd_html=phi0a+"and "+phi0b+"form the good basis that is not mixed by\
  the perturbation. This means that the volume under the product curve of \
  <span style='white-space:nowrap'>"+phi0a+"H' "+phi0b+"</span>equals zero.<br><br>";incorrect_2_c_html="Given the orientation of the perturbation, the original basis "
+phi010+"and "+phi001+"is not a good basis. This means that the volume under \
  the product curve of <span style='white-space: nowrap;'> \
  "+phi010+"H' "+phi001+"</span>is non-zero.";correct_3_html="Correct, congratulations! "+phi0a+"and "+phi0b+"form the good basis, \
  so that <br><span style='white-space: nowrap;'> \
  "+writeExp("c",undefined,"a,b")+" = "+writeExp("c",undefined,"b,a")+" = 0.</span> \
  Given the orientation of the perturbation, "+phi010+"and "+phi001+"are not a good basis. This means that the matrix elements <span style='white-space: nowrap;'>\
  &#x2329"+phi010+"| H' | "+phi001+"&#x232A</span> and \
  <span style='white-space: nowrap;'>\
  &#x2329"+phi001+"| H' | "+phi010+"&#x232A</span> are not zero, so that\
  <span style='white-space: nowrap;'>\
   "+writeExp("c",undefined,"10,01")+" = "+writeExp("c",undefined,"01,10")+"</span>\
   are infinite!";incorrect_3_ad_html=phi0a+"and "+phi0b+"form the good basis. This implies that \
 the matrix elements <span style='white-space: nowrap;'>\
 &#x2329"+phi0a+"| H' | "+phi0b+"&#x232A</span> and  \
 <span style='white-space:nowrap;'>&#x2329"+phi0b+"| H' | "+phi0a+"&#x232A </span>are zero. It turns out that this is sufficient \
 for the corresponding coefficients "+writeExp("c",undefined,"a,b")+" and "
+writeExp("c",undefined,"b,a")+" to also be zero.<br><br>";incorrect_3_bc_html="Given the orientation of the perturbation, the original basis "
+phi010+"and "+phi001+"is not a good basis. This means that the matrix element \
 <span style='white-space: nowrap;'>&#x2329"
+phi010+"| H' | "+phi001+"&#x232A</span> is not zero. What does this \
 imply for the mixing coefficient?";correct_4_html="Correct, congratulations! As the perturbation is oriented along one \
 of the coordinate axes, the original basis is already a good basis, so that the \
 original basis "+phi010+"and "+phi001+"is just (excepting a change in sign) \
 the good basis "+phi0a+"and "+phi0b+". Thus, for this special case <br>\
 <span style='white-space: nowrap;'>&#x2329"
+phi010+"| H' | "+phi001+"&#x232A</span> is zero.";incorrect_4_a_html="The matrix element <span style='white-space: nowrap;'>\
 &#x2329"+phi0a+"| H' | "+phi0a+"&#x232A</span> is \
 the first-order energy correction of the perturbed "+phia+". Is this energy correction \
 equal to zero?<br><br>";incorrect_4_bd_html=phi0a+"and "+phi0b+"form the good basis. This means \
 that the volume under the product curve of <span style='white-space: nowrap;'>\
 "+phi0a+"H' "+phi0b+"</span>equals zero.<br><br>";incorrect_4_c_html="As the perturbation is oriented along one of the coordinate \
 axes, the original basis is already a good basis, so that the original basis "
+phi010+"and "+phi001+"is just (excepting a change in sign) the good basis "
+phi0a+"and "+phi0b+". Thus the volume under the product curve of \
 <span style='white-space: nowrap;'>"+phi010+"H' "+phi001+"</span>equals zero.";correct_5_html="Correct, congratulations! As the ridge is oriented along one of \
 the coordinate axes, the good basis "+phi0a+"and "+phi0b+"IS just the original basis "
+phi010+"and "+phi001+".  As the perturbation is oriented along one of the \
 coordinate axes, the original basis is already a good basis, \
 so that the original basis "+phi010+"and "+phi001+"is just (excepting a change \
 in sign) "+phi0a+"and "+phi0b+". Thus, for this special case <br>\
 <span style='white-space: nowrap;'>"
+writeExp("c",undefined,"a,b")+" = "+writeExp("c",undefined,"b,a")+" = "
+writeExp("c",undefined,"10,01")+" = "+writeExp("c",undefined,"01,10")+" = 0.</span>";incorrect_5_ad_html=phi0a+"and "+phi0b+"form the good basis. This implies that \
 the matrix elements <span style='white-space: nowrap;'>\
 &#x2329"+phi0a+"| H' | "+phi0b+"&#x232A</span> and <span style='white-space: nowrap;'>\
 &#x2329"
+phi0b+"| H' | "+phi0a+"&#x232A</span> are zero. It turns out that this is \
 sufficient for the corresponding coefficients to also be zero.<br><br>";incorrect_5_bc_html="As the perturbation is oriented along one of the coordinate axes, \
 the original basis is already a good basis, so that the original basis "
+phi010+"and "+phi001+"is just (excepting a change in sign) the good basis "+
phi0a+"and "+phi0b+".";function initialiseText(){$('#Stage_orig_basis_radio_label').html(orig_html);$('#Stage_good_basis_radio_label').html(good_html);$('#Stage_energy_text').html(energy_html);$('#Stage_main_text').html(default_help_html);$('#Stage_graph0GoodText').html(graph0_good_html);$('#Stage_graph0OrigText').html(graph0_orig_html);$('#Stage_graph1Text').html(graph1_html);$('#Stage_graph2GoodText').html(graph2_good_html);$('#Stage_graph2OrigText').html(graph2_orig_html);$('#Stage_graph3Text').html(graph3_good_html);$('#Stage_pert_text').html(pert_default_html);$('#Stage_pertAText').html(phiA_expansion_html);$('#Stage_pertBText').html(phiB_expansion_html);$('#Stage_graph4Text').html(graph4_html);$('#Stage_graph6Text').html(graph6_html);$('#Stage_graph7Text').html(graph7_html);$('#Stage_pert_orig_basis_radio_label').html(pert_radio_label_html);$('#Stage_pert_good_basis_radio_label').html(good_pert_radio_label_html);$('#Stage_pert_energy_text').html(pert_energy_html);$('#Stage_impossible_text4').html(impossible_expansion_html);$('#Stage_impossible_text6').html(impossible_expansion_html);$('#Stage_H11').html(H11_html);$('#Stage_H12').html(H12_html);$('#Stage_H21').html(H21_html);$('#Stage_H22').html(H22_html);$('#Stage_E11').html(E11_html);$('#Stage_E12').html(E12_html);$('#Stage_E21').html(E21_html);$('#Stage_E22').html(E22_html);$('#Stage_matrix_element_text').html(aHa_html);$('#Stage_product_label').html(product_label_html);$('#Stage_slider_text').html("Orientation &theta; of the perturbation");$('#Stage_slider_textCopy').html("Orientation &theta; of the perturbation");}
function updatePertLabels(){var t4=$('#Stage_graph4Text');var t6=$('#Stage_graph6Text');var val=$('#Stage_sliderCopy').data("val");var radio=$('#Stage_pert_good_basis_radio');if(radio.hasClass("selected")||val==0||val==8||val==16){switch(val){case 0:t4.html(graph4_html+" = &nbsp"+writeExp("ϕ",undefined,"10"));t6.html(graph6_html+" = &nbsp"+writeExp("ϕ",undefined,"01"));break;case 8:t4.html(graph4_html+" = &nbsp"+writeExp("ϕ",undefined,"01"));t6.html(graph6_html+" = &nbsp&#8211 "+writeExp("ϕ",undefined,"10"));break;case 16:t4.html(graph4_html+" = &nbsp&#8211 "+writeExp("ϕ",undefined,"10"));t6.html(graph6_html+" = &nbsp&#8211 "+writeExp("ϕ",undefined,"01"));break;default:t4.html(graph4_html);t6.html(graph6_html);break;}}}
function updateGoodGraphs(){var val=$('#Stage_slider').data("val");var radio=$('#Stage_good_basis_radio');var src0;var src1="images/graphs/Potential-"+val+".png";var src2;var src3="images/graphs/"+productPrefixes[prefixIndex]+val+".png";if(radio.hasClass("selected")){src0="images/graphs/psiA-"+val+".png";src2="images/graphs/psiB-"+val+".png";}else{src0="images/graphs/psiA-0.png";src2="images/graphs/psiB-0.png";}
$('#Stage_graph0').attr("src",src0);$('#Stage_graph1').attr("src",src1);$('#Stage_graph2').attr("src",src2);$('#Stage_graph3').attr("src",src3);}
function updatePertGraphs(){var val=$('#Stage_sliderCopy').data("val");var radio=$('#Stage_pert_good_basis_radio');var src5="images/graphs/Potential-"+val+".png";var src7="images/graphs/psiA-"+val+".png";$('#Stage_graph5').attr("src",src5);$('#Stage_graph7').attr("src",src7);if(radio.hasClass("selected")||val==0||val==8||val==16){sym_enable($('#Stage_show_expansion_checkbox'));sym_enable($('#Stage_show_pert_energy_checkbox'));if($('#Stage_show_expansion_checkbox').hasClass('selected')){$('#Stage_pertAText').show();$('#Stage_pertBText').show();}
if($('#Stage_show_pert_energy_checkbox').hasClass('selected')){$('#Stage_pert_energy_text').show();}
var src4="images/graphs/psiAPert-"+val+".png";var src6="images/graphs/psiBPert-"+val+".png";$('#Stage_graph4').attr("src",src4).show();$('#Stage_graph6').attr("src",src6).show();$('#Stage_axes4').show();$('#Stage_axes6').show();$('#Stage_graph4Text').show();$('#Stage_graph6Text').show();$('#Stage_impossible_text4').hide();$('#Stage_impossible_text6').hide();$('#Stage .axistick').show();}else{sym_disable($('#Stage_show_expansion_checkbox'));sym_disable($('#Stage_show_pert_energy_checkbox'));$('#Stage_pertAText').hide();$('#Stage_pertBText').hide();$('#Stage_graph4').hide();$('#Stage_graph6').hide();$('#Stage_axes4').hide();$('#Stage_axes6').hide();$('#Stage_graph4Text').hide();$('#Stage_graph6Text').hide();$('#Stage_impossible_text4').show();$('#Stage_impossible_text6').show();$('#Stage .axistick').hide();$('#Stage_pert_energy_text').hide();}}
function updateMEP(){var m=$('#Stage_matrix_element_text');var p=$('#Stage_product_label');$('#Stage_not_correction_text').hide();$('#Stage_diag_text').hide();var val=$('#Stage_slider').data("val");var radio=$('#Stage_good_basis_radio');if(radio.hasClass('selected')||(val==0||val==8||val==16)){switch(prefixIndex){case 0:m.html("&#x2329"+phi0a+"| H' | "+phi0a+"&#x232A = "+writeExp("E","(1)","a"));p.html("Graph of integrand "+phi0a+"H' "+phi0a);break;case 1:m.html("&#x2329"+phi0a+"| H' | "+phi0b+"&#x232A = "+"0");p.html("Graph of integrand "+phi0a+"H' "+phi0b);break;case 2:m.html("&#x2329"+phi0b+"| H' | "+phi0a+"&#x232A = "+"0");p.html("Graph of integrand "+phi0b+"H' "+phi0a);break;case 3:m.html("&#x2329"+phi0b+"| H' | "+phi0b+"&#x232A = "+writeExp("E","(1)","b"));p.html("Graph of integrand "+phi0b+"H' "+phi0b);break;case 4:m.html("&#x2329"+phi010+"| H' | "+phi010+"&#x232A = "+writeExp("E","(1)","a"));p.html("Graph of integrand "+phi010+"H' "+phi010);break;case 5:m.html("&#x2329"+phi010+"| H' | "+phi001+"&#x232A = "+"0");p.html("Graph of integrand "+phi010+"H' "+phi001);break;case 6:m.html("&#x2329"+phi001+"| H' | "+phi010+"&#x232A = "+"0");p.html("Graph of integrand "+phi001+"H' "+phi010);break;case 7:m.html("&#x2329"+phi001+"| H' | "+phi001+"&#x232A = "+writeExp("E","(1)","b"));p.html("Graph of integrand "+phi001+"H' "+phi001);break;}}else{switch(prefixIndex){case 0:m.html("&#x2329"+phi0a+"| H' | "+phi0a+"&#x232A = "+writeExp("E","(1)","a"));p.html("Graph of integrand "+phi0a+"H' "+phi0a);break;case 1:m.html("&#x2329"+phi0a+"| H' | "+phi0b+"&#x232A = "+"0");p.html("Graph of integrand "+phi0a+"H' "+phi0b);break;case 2:m.html("&#x2329"+phi0b+"| H' | "+phi0a+"&#x232A = "+"0");p.html("Graph of integrand "+phi0b+"H' "+phi0a);break;case 3:m.html("&#x2329"+phi0b+"| H' | "+phi0b+"&#x232A = "+writeExp("E","(1)","b"));p.html("Graph of integrand "+phi0b+"H' "+phi0b);break;case 4:m.html("&#x2329"+phi010+"| H' | "+phi010+"&#x232A");p.html("Graph of integrand "+phi010+"H' "+phi010);$('#Stage_not_correction_text').show();break;case 5:m.html("&#x2329"+phi010+"| H' | "+phi001+"&#x232A <span style='color:rgb(199,26,26);'>&#8800 0</span>");p.html("Graph of integrand "+phi010+"H' "+phi001);break;case 6:m.html("&#x2329"+phi001+"| H' | "+phi010+"&#x232A <span style='color:rgb(199,26,26);'>&#8800 0</span>");p.html("Graph of integrand "+phi001+"H' "+phi010);break;case 7:m.html("&#x2329"+phi001+"| H' | "+phi001+"&#x232A");p.html("Graph of integrand "+phi001+"H' "+phi001);$('#Stage_not_correction_text').show();break;}}}
function updateMatrixPanel(){updateMEP();updateBrackets();var val=$('#Stage_slider').data("val");var good=($('#Stage_good_basis_radio').hasClass('selected')||(val==0||val==8||val==16));if(good){$('#Stage_E_matrix').show();$('#Stage_diag_text').hide();}else{$('#Stage_E_matrix').hide();$('#Stage_diag_text').show();}}
function updateBrackets(){switch(prefixIndex){case 0:case 4:$('#Stage_l_obracket0').show();$('#Stage_r_obracket0').show();$('#Stage_x_symbol0').show();$('#Stage_l_obracket1').hide();$('#Stage_r_obracket1').hide();$('#Stage_x_symbol1').hide();break;case 1:case 2:case 5:case 6:$('#Stage_l_obracket0').hide();$('#Stage_r_obracket0').hide();$('#Stage_x_symbol0').show();$('#Stage_l_obracket1').hide();$('#Stage_r_obracket1').hide();$('#Stage_x_symbol1').show();break;case 3:case 7:$('#Stage_l_obracket0').hide();$('#Stage_r_obracket0').hide();$('#Stage_x_symbol0').hide();$('#Stage_l_obracket1').show();$('#Stage_r_obracket1').show();$('#Stage_x_symbol1').show();break;}}
function writeExp(a,sup,sub,emTop,emBottom,emLeft){var mystring;var emTop=emTop;var emBottom=emBottom;var emLeft=emLeft;emTop==undefined?emTop=-1:emTop=emTop;emBottom==undefined?emBottom=-0.4:emBottom=emBottom;emLeft==undefined?emLeft=-1.2:emLeft=emLeft;if(sub==undefined){mystring="<span style='white-space:nowrap;'>"+a+"<sup style='top: -1em; font-size: 60%;'>"+sup+"</sup></span>"}
else if(sup==undefined){mystring="<span style='white-space:nowrap;'>"+a+"<sub style='position:relative; bottom:"+emBottom+"em;font-size:60%'>"+sub+"</sub></span>"}
else{mystring="<span style='white-space:nowrap;'>"+a+"<sup style='top: "+emTop+"em; font-size: 60%;'>"+sup+"</sup>"+"<sub style='position: relative; left: "+emLeft+"em; font-size: 60%; bottom: "+emBottom+"em;'>"+sub+"</sub></span>"}
return mystring;}
var images=[];var image;function preloadImages(){var prefixes=['Potential','Product-original','Product-unmixed','psiA','psiB','psiApert','psiBpert'],length=prefixes.length;for(var i=0;i<length;i++){_preloadImages(prefixes[i]);}}
function _preloadImages(prefix){for(var i=0;i<=16;i++){var name=prefix+"-"+i,image=new Image();image.onload=function(){};image.onerror=function(){console.error("Error occur while preloading image: "+name);};image.src='./images/graphs/'+name+'.png';images.push(image);}}
function rerender(e){if(!$(e.target).data('rerender')){sym_features();$(e.target).data('rerender',true);}}
function rerenderDynamicText(id){if(!$('#Stage_'+id).data('rerender')){sym_features();$('#Stage_'+id).data('rerender',true);}}
var challsComplete=false;var curChall;var score=[0,0,0,0,0];var fireworkProb=0.25;function step_functions(step){for(var i=0;i<score.length;i++){if(score[i]!=0){$('#Stage_steps_tick'+(i+1)).show();}}
if(curChall!=step){curChall=step;$('#Stage_feedback_text').html("");setupChallenge();switch(step){case 1:case 2:case 4:$('#Stage_box_answers').css("top","180px");break;case 3:case 5:$('#Stage_box_answers').css("top","304px");break;}}}
function setupChallenge(){if(curChall==3||curChall==5){$('#Stage_cnk-image').show();}else{$('#Stage_cnk-image').hide();}
$('#Stage_question_text').html(questions["question_"+curChall+"_html"]);$('#Stage_answer_checkbox_label0').html(answers["answer_"+curChall+"a_html"]);$('#Stage_answer_checkbox_label1').html(answers["answer_"+curChall+"b_html"]);$('#Stage_answer_checkbox_label2').html(answers["answer_"+curChall+"c_html"]);$('#Stage_answer_checkbox_label3').html(answers["answer_"+curChall+"d_html"]);$('.answer').each(function(){sym_deselect($(this));});}
function checkAnswer(){var ticked=[];$('.answer').each(function(){if($(this).hasClass("selected")){ticked.push($(this).attr("id").slice(-1));}});var feedback="";switch(curChall){case 1:if(ticked=="1,0"){feedback="<span style='color:rgb(0,143,0)'>"+correct_1_html+"</span>";score[0]=20;}else if((!ticked.includes("0")||!ticked.includes("1"))&&(ticked.includes("2")||ticked.includes("3"))){feedback="<span style='color:rgb(150,0,0)'>\
     This is not yet correct.<br><br>"+
incorrect_1_ab_html+
incorrect_1_cd_short_html+
incorrect_1_default_html+"</span>";}else{feedback+="<span style='color:rgb(150,0,0)'>\
     This is not yet correct.<br><br>";if(!ticked.includes("0")||!ticked.includes("1")){feedback+=incorrect_1_ab_html;}
if(ticked.includes("2")||ticked.includes("3")){feedback+=incorrect_1_cd_html;}
feedback+=incorrect_1_default_html;feedback+="</span>";}
break;case 2:if(ticked=="3,1"){feedback="<span style='color:rgb(0,143,0)'>"+correct_2_html+"</span>";score[1]=20;}else{feedback+="<span style ='color:rgb(150,0,0)'>\
     This is not yet correct.<br><br>";if(ticked.includes("0")){feedback+=incorrect_2_a_html;}
if(!ticked.includes("1")||!ticked.includes("3")){feedback+=incorrect_2_bd_html;}
if(ticked.includes("2")){feedback+=incorrect_2_c_html;}
feedback+="</span>";}
break;case 3:if(ticked=="3,0"){feedback="<span style='color:rgb(0,143,0)'>"+correct_3_html+"</span>";score[2]=20;}else{feedback+="<span style ='color:rgb(150,0,0)'>\
     This is not yet correct.<br><br>";if(!ticked.includes("0")||!ticked.includes("3")){feedback+=incorrect_3_ad_html;}
if(ticked.includes("1")||ticked.includes("2")){feedback+=incorrect_3_bc_html;}
feedback+="</span>";}
break;case 4:if(ticked=="3,2,1"){feedback="<span style='color:rgb(0,143,0)'>"+correct_4_html+"</span>";score[3]=20;}else if(ticked.includes("0")&&(!ticked.includes("1")||!ticked.includes("3"))&&!ticked.includes("2")){feedback="<span style ='color:rgb(150,0,0)'>\
     This is not yet correct.<br><br>"+
incorrect_4_a_html+
incorrect_4_c_html+"</span>";}else{feedback+="<span style ='color:rgb(150,0,0)'>\
     This is not yet correct.<br><br>";if(ticked.includes("0")){feedback+=incorrect_4_a_html;}
if(!ticked.includes("1")||!ticked.includes("3")){feedback+=incorrect_4_bd_html;}
if(!ticked.includes("2")){feedback+=incorrect_4_c_html;}
feedback+="</span>";}
break;case 5:if(ticked=="3,2,1,0"){feedback="<span style='color:rgb(0,143,0)'>"+correct_5_html+"</span>";score[4]=20;}else{feedback+="<span style ='color:rgb(150,0,0)'>\
    This is not yet correct.<br><br>";if(!ticked.includes("0")||!ticked.includes("3")){feedback+=incorrect_5_ad_html;}
if(!ticked.includes("1")||!ticked.includes("2")){feedback+=incorrect_5_bc_html;}
feedback+="</span>";}}
$('#Stage_feedback_text').html(feedback);updateScore();}
function updateScore(){function reducer(total,cur){return total+cur;}
var newScore=score.reduce(reducer,0);var score_text=$('#Stage_score_text');var oldScore=score_text.html().slice(0,score_text.html().indexOf("/"));if(newScore!=oldScore){startScoreAnimation(oldScore,newScore);$('#Stage_steps_tick'+curChall).show();if(newScore==100){$("#Stage_fancyExcellent").show();AdobeEdge.getComposition(compId).getStage().getSymbol('fancyExcellent').play();challsComplete=true;}else{if(Math.random()<fireworkProb){fireworks();fireworkProb=0.25;}else{fireworkProb=2*fireworkProb;}}}}
function fireworks(){var star_id='#Stage_stars';var stick_ele=$('#Stage_stick');var number=6;var spread=75;var delay_const=500;var speed_const=700;var speed_const_offset=500;var x0=stick_ele.css('left'),y0=stick_ele.css('top');var totalDelay=0;$('#Stage .star').hide();$('#Stage .star').css({'left':x0,'top':y0,'opacity':1});$('#Stage .star').fadeIn(500);for(var i=0;i<number;i++){var left=Math.round(Math.random()*spread);if(Math.random()<0.5)
left='-='+left+'px';else
left='+='+left+'px';var delay1=Math.round((Math.random()+.25)*delay_const);totalDelay+=delay1;var speed=Math.round((Math.random()+.5)*speed_const)+speed_const_offset;$('#Stage_stars'+i).delay(delay1).animate({'left':left,'top':'-=500px','opacity':0},speed);}
$('#Stage .star').delay(1000).fadeOut();}
function startScoreAnimation(startValue,endValue){var text_score=$('#Stage_score_text');var duration=800;var currentValue=startValue;var interval=duration/(endValue-startValue);if(endValue>startValue){function recursiveFunc(){text_score.text(++currentValue+'/100');if(currentValue==endValue)
return;setTimeout(recursiveFunc,interval);}
recursiveFunc();}else throw'startValue is larger than endValue';}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);slider.data('timeout_val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom,'transform':$(element)[0].style.transform});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();initialiseText();updateGoodGraphs();preloadImages();curChall=1;if(!Array.prototype.includes){Object.defineProperty(Array.prototype,'includes',{value:function(searchElement,fromIndex){if(this==null){throw new TypeError('"this" is null or not defined');}
var o=Object(this);var len=o.length>>>0;if(len===0){return false;}
var n=fromIndex|0;var k=Math.max(n>=0?n:len-Math.abs(n),0);function sameValueZero(x,y){return x===y||(typeof x==='number'&&typeof y==='number'&&isNaN(x)&&isNaN(y));}
while(k<len){if(sameValueZero(o[k],searchElement)){return true;}
k++;}
return false;}});}
$('#Stage_H12').css("background-color","rgb(255,175,0)");sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});$('#Stage .star').hide();$('.tick').hide();yepnope({load:"normalize.css"});$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);slider.data('timeout_val',slider.data('val'));var val=slider.data('val');if(val!=curVal){updateGoodGraphs();updateMatrixPanel();var deg;var text0;var text2;switch(val){case 0:var text0=phi0a+" = cos(0°) "+phi010+" + sin(0°) "+phi001+"= "+phi010;var text2=phi0b+" = &#8211 sin(0°) "+phi010+"+ cos(0°) "+phi001+"= "+phi001;break;case 8:var text0=phi0a+" = cos(90°) "+phi010+" + sin(90°) "+phi001+"= "+phi001;var text2=phi0b+" = &#8211 sin(90°) "+phi010+"+ cos(90°) "+phi001+"= &#8211 "+phi010;break;case 16:var text0=phi0a+" = cos(180°) "+phi010+" + sin(180°) "+phi001+"= &#8211"+phi010;var text2=phi0b+" = &#8211 sin(180°) "+phi010+"+ cos(180°) "+phi001+"= &#8211 "+phi001;break;default:deg=(val*11.25).toFixed(1);var text0=phi0a+" = cos("+deg+"°) "+phi010+" + sin("+deg+"°) "+phi001;var text2=phi0b+" = &#8211 sin("+deg+"°) "+phi010+"+ cos("+deg+"°) "+phi001;break;}
$('#Stage_graph0GoodText').html(text0);$('#Stage_graph2GoodText').html(text2);curVal=val;}},20));}});$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('sliderCopy');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);slider.data('timeout_val',slider.data('val'));var val=slider.data('val');if(val!=curVal){updatePertGraphs();updatePertLabels();curVal=val;}},20));}});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio}","click",function(sym,e){sym.$('.group_test1').each(function(){if(sym.$(this).hasClass('selected')){var text='';switch(sym.$(this).attr('id')){case'Stage_radio':text='radio 1.1';break;case'Stage_radio2':text='radio 1.2';break;case'Stage_radio3':text='radio 1.3';break;case'Stage_radio4':text='radio 1.4';break;}
sym.$('test_label').text(text);}});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio2}","click",function(sym,e){sym.$('.group_test1').each(function(){if(sym.$(this).hasClass('selected')){var text='';switch(sym.$(this).attr('id')){case'Stage_radio':text='radio 1.1';break;case'Stage_radio2':text='radio 1.2';break;case'Stage_radio3':text='radio 1.3';break;case'Stage_radio4':text='radio 1.4';break;}
sym.$('test_label').text(text);}});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio3}","click",function(sym,e){sym.$('.group_test1').each(function(){if(sym.$(this).hasClass('selected')){var text='';switch(sym.$(this).attr('id')){case'Stage_radio':text='radio 1.1';break;case'Stage_radio2':text='radio 1.2';break;case'Stage_radio3':text='radio 1.3';break;case'Stage_radio4':text='radio 1.4';break;}
sym.$('test_label').text(text);}});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio4}","click",function(sym,e){sym.$('.group_test1').each(function(){if(sym.$(this).hasClass('selected')){var text='';switch(sym.$(this).attr('id')){case'Stage_radio':text='radio 1.1';break;case'Stage_radio2':text='radio 1.2';break;case'Stage_radio3':text='radio 1.3';break;case'Stage_radio4':text='radio 1.4';break;}
sym.$('test_label').text(text);}});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_checkbox3}","click",function(sym,e){sym.$('test_label').text('#3 checkbox '+(sym.$('checkbox3').hasClass('selected')?'checked':'unchecked'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button}","click",function(sym,e){sym.$('test_label').text('button #1 pressed');if(sym.$('button2').hasClass('disabled')){sym_enable(sym.$('button2'));sym_enable(sym.$('checkbox3'));sym_enable(sym.$('radio4'));sym_enable(sym.$('slider2'));sym_enable(sym.$('movableSquare'));sym.$('button_label').text('Disable elements');}
else{sym_disable(sym.$('button2'));sym_disable(sym.$('checkbox3'));sym_disable(sym.$('radio4'));sym_disable(sym.$('slider2'));sym_disable(sym.$('movableSquare'));sym.$('button_label').text('Enable elements');}
rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button2}","click",function(sym,e){sym.$('test_label').text('button #2 pressed');sym_deselect(sym.$('checkbox'));sym_select(sym.$('checkbox2'));sym_deselect(sym.$('checkbox3'));sym_select(sym.$('radio2'));sym_val(sym.$('slider'),sym.$('slider').data('default'));sym_val(sym.$('slider2'),sym.$('slider2').data('default'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_title_help_button}","click",function(sym,e){$('#Stage_main_text').html(default_help_html);$('#Stage_close_button').show();sym_enable(sym.$('.disabled.help'));sym_disable($('#Stage_title_help_button'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_challenges_clickable_area}","click",function(sym,e){sym.stop('challenges');sym_features();sym_step(curChall);setupChallenge();rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_perturbed_clickable_area}","click",function(sym,e){sym.stop('perturbed');sym_features();updatePertGraphs();updatePertLabels()
$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_good_basis_radio}","click",function(sym,e){sym.$('.group_basis').each(function(){if(sym.$(this).hasClass('selected')){var good0=$('#Stage_graph0GoodText');var orig0=$('#Stage_graph0OrigText');var good2=$('#Stage_graph2GoodText');var orig2=$('#Stage_graph2OrigText');switch(sym.$(this).attr('id')){case"Stage_good_basis_radio":orig0.hide();orig2.hide();good0.fadeIn(300);good2.fadeIn(300);if(prefixIndex>3){prefixIndex-=4;}
updateGoodGraphs();if($('#Stage_show_product_checkbox').hasClass('selected')||(val==0||val==8||val==16)){$('#Stage_E_matrix').show();$('#Stage_diag_text').hide();}
break;case"Stage_orig_basis_radio":good0.hide();good2.hide();orig0.fadeIn(300);orig2.fadeIn(300);if(prefixIndex<4){prefixIndex+=4;}
updateGoodGraphs();var val=$('#Stage_slider').data("val");if($('#Stage_show_product_checkbox').hasClass('selected')&&!(val==0||val==8||val==16)){$('#Stage_E_matrix').hide();$('#Stage_diag_text').show();}
break;}
updateMatrixPanel();}});rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_show_product_checkbox}","click",function(sym,e){var product_check=$('#Stage_show_product_checkbox');var graph=$('#Stage_graph3Container');if(product_check.hasClass('selected')){updateMatrixPanel();graph.show();}else{graph.hide();}
rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_show_energy_checkbox}","click",function(sym,e){var energy_check=$('#Stage_show_energy_checkbox'),energy_text=$('#Stage_energy_text');if(energy_check.hasClass('selected')){energy_text.fadeIn(300,rerenderDynamicText("energy_text"));}else{energy_text.hide();}
rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_product_help_button}","click",function(sym,e){$('#Stage_main_text').html(product_help_html);$('#Stage_close_button').show();sym_enable(sym.$('.disabled.help'));sym_disable($('#Stage_product_help_button'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_orig_basis_radio}","click",function(sym,e){sym.$('.group_basis').each(function(){if(sym.$(this).hasClass('selected')){var good0=$('#Stage_graph0GoodText');var orig0=$('#Stage_graph0OrigText');var good2=$('#Stage_graph2GoodText');var orig2=$('#Stage_graph2OrigText');switch(sym.$(this).attr('id')){case"Stage_good_basis_radio":orig0.hide();orig2.hide();good0.fadeIn(300);good2.fadeIn(300);if(prefixIndex>3){prefixIndex-=4;}
updateGoodGraphs();if($('#Stage_show_product_checkbox').hasClass('selected')||(val==0||val==8||val==16)){$('#Stage_E_matrix').show();$('#Stage_diag_text').hide();}
break;case"Stage_orig_basis_radio":good0.hide();good2.hide();orig0.fadeIn(300);orig2.fadeIn(300);if(prefixIndex<4){prefixIndex+=4;}
updateGoodGraphs();var val=$('#Stage_slider').data("val");if($('#Stage_show_product_checkbox').hasClass('selected')&&!(val==0||val==8||val==16)){$('#Stage_E_matrix').hide();$('#Stage_diag_text').show();}
break;}
updateMatrixPanel();}});rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_goodstates_clickable_area}","click",function(sym,e){sym.stop('good');sym_features();updateGoodGraphs();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);if($('#Stage_show_energy_checkbox').hasClass("selected")){$('#Stage_energy_text').show();}
if($('#Stage_show_product_checkbox').hasClass("selected")){$('#Stage_graph3Container').show();}
if($('#Stage_orig_basis_radio').hasClass("selected")){$('#Stage_graph0OrigText').show();$('#Stage_graph2OrigText').show();}
rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_close_button}","click",function(sym,e){var text=$('#Stage_main_text');var close_button=$('#Stage_close_button');text.html("");close_button.hide();sym_enable(sym.$('.disabled.help'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_graph0_help_button}","click",function(sym,e){$('#Stage_main_text').html(graph0_help_html);$('#Stage_close_button').show();sym_enable(sym.$('.disabled.help'));sym_disable($('#Stage_graph0_help_button'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_graph1_help_button}","click",function(sym,e){$('#Stage_main_text').html(graph1_help_html);$('#Stage_close_button').show();sym_enable(sym.$('.disabled.help'));sym_disable($('#Stage_graph1_help_button'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_energy_help_button}","click",function(sym,e){$('#Stage_main_text').html(energy_help_html);$('#Stage_close_button').show();sym_enable(sym.$('.disabled.help'));sym_disable($('#Stage_energy_help_button'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_pert_good_basis_radio}","click",function(sym,e){sym.$('.group_pert_basis').each(function(){if(sym.$(this).hasClass('selected')){updatePertGraphs();updatePertLabels();var text4=$('#Stage_graph4Text');var text6=$('#Stage_graph6Text');switch(sym.$(this).attr('id')){case"Stage_pert_good_basis_radio":sym_enable($('#Stage_show_expansion_checkbox'));if($('#Stage_show_expansion_checkbox').hasClass('selected')){$('#Stage_pertAText').show();$('#Stage_pertBText').show();}
$('#Stage_impossible_text4').hide();$('#Stage_impossible_text6').hide();$('#Stage_graph4').show();$('#Stage_graph6').show();$('#Stage_axes4').show();$('#Stage_axes6').show();text4.show();text6.show();break;case"Stage_pert_orig_basis_radio":var val=$('#Stage_sliderCopy').data("val");if((val!=0)&&(val!=8)&&(val!=16)){sym_disable($('#Stage_show_expansion_checkbox'));$('#Stage_pertAText').hide();$('#Stage_pertBText').hide();$('#Stage_impossible_text4').show();$('#Stage_impossible_text6').show();$('#Stage_graph4').hide();$('#Stage_graph6').hide();$('#Stage_axes4').hide();$('#Stage_axes6').hide();text4.hide();text6.hide();}else{}
break;}}});rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_pert_orig_basis_radio}","click",function(sym,e){sym.$('.group_pert_basis').each(function(){if(sym.$(this).hasClass('selected')){updatePertGraphs();updatePertLabels();var text4=$('#Stage_graph4Text');var text6=$('#Stage_graph6Text');switch(sym.$(this).attr('id')){case"Stage_pert_good_basis_radio":sym_enable($('#Stage_show_expansion_checkbox'));if($('#Stage_show_expansion_checkbox').hasClass('selected')){$('#Stage_pertAText').show();$('#Stage_pertBText').show();}
$('#Stage_impossible_text4').hide();$('#Stage_impossible_text6').hide();$('#Stage_graph4').show();$('#Stage_graph6').show();$('#Stage_axes4').show();$('#Stage_axes6').show();text4.show();text6.show();break;case"Stage_pert_orig_basis_radio":var val=$('#Stage_sliderCopy').data("val");if((val!=0)&&(val!=8)&&(val!=16)){sym_disable($('#Stage_show_expansion_checkbox'));$('#Stage_pertAText').hide();$('#Stage_pertBText').hide();$('#Stage_impossible_text4').show();$('#Stage_impossible_text6').show();$('#Stage_graph4').hide();$('#Stage_graph6').hide();$('#Stage_axes4').hide();$('#Stage_axes6').hide();text4.hide();text6.hide();}else{}
break;}}});rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_show_expansion_checkbox}","click",function(sym,e){var check=$('#Stage_show_expansion_checkbox'),text0=$('#Stage_pertAText');text1=$('#Stage_pertBText');if(check.hasClass('selected')){text0.fadeIn(300);text1.fadeIn(300);}else{text0.hide();text1.hide();}
rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_show_pert_energy_checkbox}","click",function(sym,e){var energy_check=$('#Stage_show_pert_energy_checkbox'),energy_text=$('#Stage_pert_energy_text');if(energy_check.hasClass('selected')){energy_text.fadeIn(300,rerenderDynamicText("pert_energy_text"));}else{energy_text.hide();}
rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_graph4_help_button}","click",function(sym,e){$('#Stage_pert_text').html(graph4_help_html);$('#Stage_pert_close_button').show();sym_enable(sym.$('.disabled.help'));sym_disable($('#Stage_graph4_help_button'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_expansion_help_button}","click",function(sym,e){$('#Stage_pert_text').html(expansion_help_html);$('#Stage_pert_close_button').show();sym_enable(sym.$('.disabled.help'));sym_disable($('#Stage_expansion_help_button'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_pert_radio_help_button}","click",function(sym,e){$('#Stage_pert_text').html(pert_radio_help_html);$('#Stage_pert_close_button').show();sym_enable(sym.$('.disabled.help'));sym_disable($('#Stage_pert_radio_help_button'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_pert_energy_help_button}","click",function(sym,e){$('#Stage_pert_text').html(pert_energy_help_html);$('#Stage_pert_close_button').show();sym_enable(sym.$('.disabled.help'));sym_disable($('#Stage_pert_energy_help_button'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_pert_close_button}","click",function(sym,e){var text=$('#Stage_pert_text');var close_button=$('#Stage_pert_close_button');text.html("");close_button.hide();sym_enable(sym.$('.disabled.help'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_radio_help_button}","click",function(sym,e){$('#Stage_main_text').html(radio_help_html);$('#Stage_close_button').show();sym_enable(sym.$('.disabled.help'));sym_disable($('#Stage_radio_help_button'));rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_answer_checkbox0}","click",function(sym,e){rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_answer_checkbox1}","click",function(sym,e){rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_answer_checkbox2}","click",function(sym,e){rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_answer_checkbox3}","click",function(sym,e){rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_H11_cover}","click",function(sym,e){sym.$('.h_matrix').each(function(){$(this).css("background-color","rgba(255,255,255,0)");});$('#Stage_H11').css("background-color","rgba(255,175,0,1)");if($('#Stage_good_basis_radio').hasClass('selected')){if(prefixIndex!=0){prefixIndex=0;updateGoodGraphs();}}else{if(prefixIndex!=4){prefixIndex=4;updateGoodGraphs();}}
updateMatrixPanel();rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_H12_cover}","click",function(sym,e){sym.$('.h_matrix').each(function(){$(this).css("background-color","rgba(255,255,255,0)");});$('#Stage_H12').css("background-color","rgba(255,175,0,1)");if($('#Stage_good_basis_radio').hasClass('selected')){if(prefixIndex!=1){prefixIndex=1;updateGoodGraphs();}}else{if(prefixIndex!=5){prefixIndex=5;updateGoodGraphs();}}
updateMatrixPanel();rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_H21_cover}","click",function(sym,e){sym.$('.h_matrix').each(function(){$(this).css("background-color","rgba(255,255,255,0)");});$('#Stage_H21').css("background-color","rgba(255,175,0,1)");if($('#Stage_good_basis_radio').hasClass('selected')){if(prefixIndex!=2){prefixIndex=2;updateGoodGraphs();}}else{if(prefixIndex!=6){prefixIndex=6;updateGoodGraphs();}}
updateMatrixPanel();rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_H22_cover}","click",function(sym,e){sym.$('.h_matrix').each(function(){$(this).css("background-color","rgba(255,255,255,0)");});$('#Stage_H22').css("background-color","rgba(255,175,0,1)");if($('#Stage_good_basis_radio').hasClass('selected')){if(prefixIndex!=3){prefixIndex=3;updateGoodGraphs();}}else{if(prefixIndex!=7){prefixIndex=7;updateGoodGraphs();}}
updateMatrixPanel();rerender(e);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_submit_button}","click",function(sym,e){checkAnswer();$('#Stage_feedback_text').hide();$('#Stage_feedback_text').fadeIn(600);});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps_old");
//Edge symbol end:'steps_old'

//=========================================================

//Edge symbol: 'highlight_1'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight_1");
//Edge symbol end:'highlight_1'

//=========================================================

//Edge symbol: 'Axes'
(function(symbolName){})("Axes");
//Edge symbol end:'Axes'

//=========================================================

//Edge symbol: 'steps_1'
(function(symbolName){step_functions();})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'fancyExcellent'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){$("#Stage_fancyExcellent").hide();sym.stop(0);});
//Edge binding end
})("fancyExcellent");
//Edge symbol end:'fancyExcellent'
})(jQuery,AdobeEdge,"EDGE-19890435");