/*  Copyright 2016, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
*/

(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var number=0;var number2=0;var vel=2;var angle=0;var currentGraph=0;var current2Graph=0;var current3Graph=0;var firstm=0;var secondm=0;var sz=1;var control=1;var state=1;simulation=true;var cycle_time=6;var start_t;var t=0;var time_step=cycle_time*1000/120;var sphereInterval;var images=[];function preloadImages(){var prefixes=['','2'],length=prefixes.length;for(var i=0;i<length;i++){_preloadImages(prefixes[i]);}}
function _preloadImages(prefix){for(var i=1;i<120;i++){var name='sphere'+prefix+'Plot'+i,image=new Image();image.onload=function(){};image.onerror=function(){console.error("Error occur while preloading image: "+name);};image.src='./images/Graphs2/'+name+'.gif';images.push(image);}}
function setStartTime(){var d=new Date();start_t=d.getSeconds()*1000+d.getMilliseconds();start_t-=t}
function getTime(){var d=new Date();var now=d.getSeconds()*1000+d.getMilliseconds();t=now-start_t;t=(t>=0)?t:60000+t;}
function updateSphere(sphere_name){var images_per_s=120/cycle_time;src0='./images/Graphs2/'+sphere_name+Math.round(images_per_s*t/1000)%120+'.gif';var graph1=$("#Stage_sphere_plot");graph1.attr("src",src0);}
function showState(state){clearInterval(sphereInterval);switch(state){case 1:t=0;updateSphere('plotup');break;case 3:sphereInterval=setInterval(function(){getTime();updateSphere('sphere2Plot')},50);break;case 5:sphereInterval=setInterval(function(){getTime();updateSphere('spherePlot')},50);break;}}
function displaySymbol(number){if(number!=-1){$('#Stage_azimuth0').hide();$('#Stage_azimuth5').hide();$('#Stage_azimuth3').hide();}
else{$('#Stage_azimuth0').hide();$('#Stage_azimuth5').hide();$('#Stage_azimuth3').hide();}}
function show_outcomes(number){if(number==1){if(firstm==1){if(sz==-1){a='<b>E = E<sub>1</sub></b>'
b='<b>|&darr;&#x232A;</b>'}
else{a='<b>E = E<sub>2</sub></b>'
b='<b>|&uarr;&#x232A;</b>'}}
if(firstm==0){if(sz==-1){a='<b>S<sub>2</sub> = &#8211;&#295;/2</b>'
b='<b>|&darr;&#x232A;</b>'}
else{a='<b>S<sub>2</sub> = +&#295;/2</b>'
b='<b>|&uarr;&#x232A;</b>'}}
if(control!=1){$('#Stage_measurement'+number).html('First measurement: &nbsp;'+a+'<br> Has collapsed to '+b);}
else{$('#Stage_measurement'+number).html('First measurement: &nbsp;'+a+'<br> Remains in state '+b);}}
if(number==2){if(secondm==1){if(sz==-1){a='<b>E = E<sub>1</sub></b>'
b='<b>|&darr;&#x232A;</b>'}
else{a='<b>E = E<sub>2</sub></b>'
b='<b>|&uarr;&#x232A;</b>'}}
if(secondm==0){if(sz==-1){a='<b>S<sub>2</sub> = &#8211;&#295;/2</b>'
b='<b>|&darr;&#x232A;</b>'}
else{a='<b>S<sub>2</sub> = +&#295;/2</b>'
b='<b>|&uarr;&#x232A;<b/>'}}
$('#Stage_measurement'+number).html('Second measurement: &nbsp;'+a+'<br> Remains in state '+b);}}
function control_radio(){if($('#Stage_control2').hasClass('selected')){firstm=1;}
else{firstm=0;}
if($('#Stage_control3').hasClass('selected')){secondm=1;}
else{secondm=0;}}
function reset(){$('#Stage_measurement1').html('');$('#Stage_measurement2').html('');$('#Stage_reset').hide();$('#Stage_performMeasurement2').hide();showState(state);}
function show_random_state(probability){Math.random()>probability?sz=-1:sz=1;debug(control);clearInterval(sphereInterval);t=0;if(sz==1)updateSphere('plotup');if(sz==-1)updateSphere('plotdown');displaySymbol(0);}
function debug(value){$('#Stage_debug').text(value);}
function step_functions(step){clearInterval(sphereInterval);switch(step){case 1:control=0.5;t=1000;updateSphere('sphere2Plot');displaySymbol(3);$('#Stage .radio').each(function(){sym_disable($(this));});sym_disable($('#Stage_performMeasurement'));sym_select($('#Stage_inputState4'));sym_select($('#Stage_control2'));sym_select($('#Stage_control3'));break;case 2:setStartTime();displaySymbol(3);control=0.5;state=3;reset();sym_disable($('#Stage_performMeasurement'));sym_select($('#Stage_inputState4'));sym_select($('#Stage_control2'));sym_select($('#Stage_control3'));break;case 3:control=0.5;state=5;reset();sym_enable($('#Stage_performMeasurement'));sym_select($('#Stage_inputState3'));sym_select($('#Stage_control1'));sym_select($('#Stage_control4'));control_radio();break;case 4:displaySymbol(0);control=1;state=1;reset();sym_enable($('#Stage_performMeasurement'));sym_select($('#Stage_inputState1'));sym_select($('#Stage_control1'));sym_select($('#Stage_control4'));control_radio();break;case 5:displaySymbol(5);control=0.5;state=5;reset();$('#Stage_measurement1').html('');$('#Stage_measurement2').html('');$('#Stage_reset').hide();$('#Stage_performMeasurement2').hide();sym_enable($('#Stage_performMeasurement'));sym_select($('#Stage_inputState3'));sym_select($('#Stage_control2'));sym_select($('#Stage_control3'));control_radio();control_radio();break;}}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);$(element).data('timeout_val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();preloadImages();setStartTime();sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});yepnope({load:"normalize.css"});sym.$('measurement1').html('');sym.$('measurement2').html('');sym.$('title').html('Successive measurements in the Bloch sphere representation');sym.$('mainText').html('<span style="line-height:1.3;">Consider a spin &#189; particle of charge &#8211;e and mass m (such as an electron) in a uniform magnetic field of strength B oriented along the z&#8209;axis. Due to its spin, the particle acts like a small bar magnet when in an external magnetic field. This gives rise to two different energy states, depending on whether the spin component S<sub>z</sub> (which can only take the values +&#295;/2 or &#8211;&#295;/2)  is parallel or antiparallel to the magnetic field.  The spin-down state |&darr;&#x232A;  with S<sub>z</sub>=&#8211;&#295;/2 has the lower energy E<sub>1</sub>, the spin-up state |&uarr;&#x232A;  with S<sub>z</sub>=+&#295;/2 the higher energy E<sub>2</sub>. The two energies are separated by </span>');sym.$('mainText2').html('<span style="line-height: 1.3;">The image on the left shows you the spin quantum state in the Bloch sphere representation. The North and South poles correspond to the states |&uarr;&#x232A; and |&darr;&#x232A; respectively.  You can use the buttons to choose different initial states at time t&nbsp;=&nbsp;0.</span>');sym.$('inputTitle').html('Initial state <i>prior</i> to measurement');sym.$('inputText1').html('<span style="line-height:1.3;">|&uarr;&#x232A;</span>');sym.$('inputText2').html('<span style="line-height:1.3;">1/&radic;<span style="text-decoration: overline">2</span>&nbsp;(|&uarr;&#x232A; + exp(i&omega;t)&nbsp;|&darr;&#x232A;)</span>');sym.$('inputText3').html('<span style="line-height:1.3;">1/&radic;<span style="text-decoration: overline">5</span>&nbsp;(2 |&uarr;&#x232A; + exp(i&omega;t)&nbsp;|&darr;&#x232A;)</span>');sym.$('control1label').html('<b>S<sub>z</sub></b>');sym.$('control2label').html('<b>E</b>');sym.$('control4label').html('<b>S<sub>z</sub></b>');sym.$('control3label').html('<b>E</b>');sym.getSymbol('steps').$('phi').html('&#981;');sym.getSymbol('steps').$('theta').html('&theta;');sym.getSymbol('steps').$('step_text1').html('The Bloch sphere representation gives a one-to-one correspondence between points on a sphere and the quantum state ');sym.getSymbol('steps').$('step_text11').html('of the spin &#189; particle. You can see that the angles &theta; and &#981; can be interpreted as the azimuthal and polar angles (in spherical polar coordinates) of the points on the sphere. ');sym.getSymbol('steps').$('step_text2').html('If the initial state is not an eigenstate of S<sub>z</sub>, then ');sym.getSymbol('steps').$('step_text21').html('where &omega;=(E<sub>2</sub>-E<sub>1</sub>)/&#295;. Thus, the azimuthal angle &#981;=&omega;t changes with time. In the Bloch sphere representation, this implies that the spin state rotates around the z&#8209;axis with time.');sym.getSymbol('steps').$('step_text22').html('If the initial state is not an eigenstate of S<sub>z</sub>, then');sym.getSymbol('steps').$('step_text3').html('<span style="line-height:1.3;">If you perform a measurement of the spin component S<sub>z</sub> on a superposition state with respect to S<sub>z</sub>, the superposition state collapses either to |&uarr;&#x232A; or |&darr;&#x232A;. Thus, your measurement changes the quantum state. You can see that the only possible measurement outcomes are S<sub>z</sub>=+&#295;/2 (collapse to state |&uarr;&#x232A;) or S<sub>z</sub>=&#8211;&#295;/2 (collapse to state |&darr;&#x232A;). You can only predict probabilities for certain measurement outcomes, never the outcome of an individual measurement. <br><br>Perform a number of measurement sequences to see this.</span> ');sym.getSymbol('steps').$('step_text4').html('If you perform a measurement of the spin component S<sub>z</sub> on an eigenstate with respect to S<sub>z</sub>, your measurement does not change the state. As the particle is in an eigenstate of S<sub>z</sub> after a first measurement of S<sub>z</sub>, further measurements do not change the quantum state. <br><br>Perform a number of measurement sequences to see this. ');sym.getSymbol('steps').$('step_text5').html('<span style="line-height:1.3;">For this system of a spin &#189; particle in a uniform magnetic field oriented along the z&#8209;axis, the eigenstate |&uarr;&#x232A; has definite values of both S<sub>z</sub> and energy: it is an eigenstate of both S<sub>z</sub> (with S<sub>z</sub>=+&#295;/2) and  energy (with energy E<sub>2</sub>). Similarly, |&darr;&#x232A; is an eigenstate of both  S<sub>z</sub> (with S<sub>z</sub>=&#8211;&#295;/2) and  energy (with energy E<sub>1</sub>). Thus, if you perform a measurement of energy, this leads to a collapse into either <nobr>|&uarr;&#x232A; or |&darr;&#x232A;,</nobr> the same states as when you performed measurements of S<sub>z</sub>. For this system, the observables energy and S<sub>z</sub> are compatible. <br><br>Perform measurements of energy to see this.</span>');var isMac=navigator.platform.toUpperCase().indexOf('MAC')>=0;if(isMac){sym.$('mainText').html('<span style="line-height:1.3;">Consider a spin &#189; particle of charge &#8211;e and mass m (such as an electron) in a uniform magnetic field of strength B oriented along the z&#8209;axis. Due to its spin, the particle acts like a small bar magnet when in an external magnetic field. This gives rise to two different energy states, depending on whether the spin component S<sub>z</sub> (which can only take the values +&#295;/2 or &#8211;&#295;/2)  is parallel or antiparallel to the magnetic field.  The spin-down state |&darr;&#x232A; with S<sub>z</sub>=&#8211;&#295;/2 has the lower energy E<sub>1</sub>, the spin-up state |&uarr;&#x232A; with S<sub>z</sub>=+&#295;/2 the higher energy E<sub>2</sub>. The two energies are separated by </span>');sym.$('mainText2').html('<span style="line-height: 1.3;">The image on the left shows you the spin quantum state in the Bloch sphere representation. The North and South poles correspond to the states |&uarr;&#x232A;and |&darr;&#x232A;respectively.  You can use the buttons to choose different initial states at time t&nbsp;=&nbsp;0.</span>');sym.$('inputText2').html('<span style="line-height:1.3;">1/&radic;<span style="text-decoration: overline">2</span>&nbsp;(|&uarr;&#x232A;+ exp(i&omega;t)&nbsp;|&darr;&#x232A;)</span>');sym.$('inputText3').html('<span style="line-height:1.3;">1/&radic;<span style="text-decoration: overline">5</span>&nbsp;(2 |&uarr;&#x232A;+ exp(i&omega;t)&nbsp;|&darr;&#x232A;)</span>');sym.getSymbol('steps').$('step_text3').html('<span style="line-height:1.3;">If you perform a measurement of the spin component S<sub>z</sub> on a superposition state with respect to S<sub>z</sub>, the superposition state collapses either to |&uarr;&#x232A;or |&darr;&#x232A;. Thus, your measurement changes the quantum state. You can see that the only possible measurement outcomes are S<sub>z</sub>=+&#295;/2 (collapse to state |&uarr;&#x232A;) or S<sub>z</sub>=&#8211;&#295;/2 (collapse to state |&darr;&#x232A;). You can only predict probabilities for certain measurement outcomes, never the outcome of an individual measurement. <br><br>Perform a number of measurement sequences to see this.</span> ');sym.getSymbol('steps').$('step_text5').html('<span style="line-height:1.3;">For this system of a spin &#189; particle in a uniform magnetic field oriented along the z&#8209;axis, the eigenstate |&uarr;&#x232A;has definite values of both S<sub>z</sub> and energy: it is an eigenstate of both S<sub>z</sub> (with S<sub>z</sub>=+&#295;/2) and  energy (with energy E<sub>2</sub>). Similarly, |&darr;&#x232A;is an eigenstate of both  S<sub>z</sub> (with S<sub>z</sub>=&#8211;&#295;/2) and  energy (with energy E<sub>1</sub>). Thus, if you perform a measurement of energy, this leads to a collapse into either <nobr>|&uarr;&#x232A;or |&darr;&#x232A;,</nobr> the same states as when you performed measurements of S<sub>z</sub>. For this system, the observables energy and S<sub>z</sub> are compatible. <br><br>Perform measurements of energy to see this.</span>');}});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_inputState4}","click",function(sym,e){state=3;control=0.75;setStartTime();showState(state);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_inputState3}","click",function(sym,e){state=5;control=0.5;setStartTime();showState(state);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){sym.stop('simulation');sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);sym_enable($('#Stage_performMeasurement'));sym_select($('#Stage_inputState1'));sym_select($('#Stage_control1'));sym_select($('#Stage_control4'));control_radio();state=1;showState(state);displaySymbol(0);$('#Stage .radio').each(function(){sym_enable($(this));});$('#Stage .checkbox').each(function(){sym_enable($(this));});simulation=true;});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_explanation}","click",function(sym,e){sym.stop('explanation');sym_features();sym_step(1);simulation=false;});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_inputState1}","click",function(sym,e){state=1;control=1;showState(state);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_performMeasurement}","click",function(sym,e){$('#Stage .group_test1').each(function(){sym_disable($(this));});sym.$('inputStateBox').css("background-color","#d1d1d1");$('#Stage .group_test2').each(function(){sym_disable($(this));});sym.$('performMeasurement2').show();show_random_state(control);show_outcomes(1);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_performMeasurement2}","click",function(sym,e){sym.$('reset').show();$('#Stage .group_test3').each(function(){sym_disable($(this));});show_outcomes(2);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_reset}","click",function(sym,e){sym.$('inputStateBox').css("background-color","#ffe89a");if(simulation){$('#Stage .group_test1').each(function(){sym_enable($(this));});$('#Stage .group_test2').each(function(){sym_enable($(this));});$('#Stage .group_test3').each(function(){sym_enable($(this));});}
reset();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_control1}","click",function(sym,e){control_radio();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_control2}","click",function(sym,e){control_radio();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_control3}","click",function(sym,e){control_radio();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_control4}","click",function(sym,e){control_radio();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrewsCopy2}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_quantumphysicsCopy}","click",function(sym,e){window.open('http://quantumphysics.iop.org','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_iopCopy}","click",function(sym,e){window.open('http://www.iop.org','_blank');});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'highlight'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight");
//Edge symbol end:'highlight'

//=========================================================

//=========================================================

//Edge symbol: 'BlochSphere'
(function(symbolName){})("BlochSphere");
//Edge symbol end:'BlochSphere'

//=========================================================

//Edge symbol: 'InitialStates'
(function(symbolName){})("InitialStates");
//Edge symbol end:'InitialStates'

//=========================================================

//Edge symbol: 'initialPlots'
(function(symbolName){})("initialPlots");
//Edge symbol end:'initialPlots'

//=========================================================

//Edge symbol: 'simulation'
(function(symbolName){})("simulation");
//Edge symbol end:'simulation'

//=========================================================

//Edge symbol: 'simulation2'
(function(symbolName){})("simulation2");
//Edge symbol end:'simulation2'

//=========================================================

//Edge symbol: 'animation1'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);number++;angle=((number%120)/60)*Math.PI;if(state==1){$('#Stage_probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+0.50);$('#Stage_probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+0.50);$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.00');$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.00');$('#Stage_quantumState2').html('|&psi;&#x232A; = |&uarr;&#x232A;');sym.stop(0);}
if(state==2){$('#Stage_probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+0.50);$('#Stage_probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+0.50);$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.00');$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.00');$('#Stage_quantumState2').html('|&psi;&#x232A; = exp(i&nbsp;'+((number%1200)/60).toFixed(1)+'&nbsp;&pi;) |&darr;&#x232A;');}
if(state==3){$('#Stage_probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.50+0.5*Math.cos(angle)).toFixed(2));$('#Stage_probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.50-0.5*Math.cos(angle)).toFixed(2));$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.50');$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.50');$('#Stage_quantumState2').html('|&psi;&#x232A; = 1/&radic;<span style="text-decoration: overline">2</span>(|&uarr;&#x232A; + exp(i&nbsp;'+((number%1200)/60).toFixed(1)+'&nbsp;&pi;) |&darr;&#x232A;)');sym.getComposition().getStage().displayGraph("#spherePlot",number%120);sym.getComposition().getStage().display2Graph("#sphere2Plot",0);sym.$('#sphere2Plot0').hide();sym.getComposition().getStage().display3Graph("#sphere3Plot",0);sym.$('#sphere3Plot0').hide();}
if(state==4){$('#Stage_probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.50+0.4*Math.cos(angle)).toFixed(2));$('#Stage_probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.50-0.4*Math.cos(angle)).toFixed(2));$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.80');$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.20');$('#Stage_quantumState2').html('|&psi;&#x232A; = 1/&radic;<span style="text-decoration: overline">5</span>(2 |&uarr;&#x232A; + exp(i&nbsp;'+((number%1200)/60).toFixed(1)+'&nbsp;&pi;) |&darr;&#x232A;)');sym.getComposition().getStage().display2Graph("#sphere2Plot",number%120);sym.getComposition().getStage().displayGraph("#spherePlot",0);sym.$('#spherePlot0').hide();sym.getComposition().getStage().display3Graph("#sphere3Plot",0);sym.$('#sphere3Plot0').hide();}
if(state==5){$('#Stage_probSpinUpX').html('S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.50+0.4*Math.cos(angle)).toFixed(2));$('#Stage_probSpinDownX').html('S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+(0.50-0.4*Math.cos(angle)).toFixed(2));$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.20');$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.80');$('#Stage_quantumState2').html('|&psi;&#x232A; = 1/&radic;<span style="text-decoration: overline">5</span>(|&uarr;&#x232A; + 2 exp(i&nbsp;'+((number%1200)/60).toFixed(1)+'&nbsp;&pi;) |&darr;&#x232A;)');sym.getComposition().getStage().display3Graph("#sphere3Plot",number%120);sym.getComposition().getStage().displayGraph("#spherePlot",0);sym.$('#spherePlot0').hide();sym.getComposition().getStage().display2Graph("#sphere2Plot",0);sym.$('#sphere2Plot0').hide();}});
//Edge binding end
})("animation1");
//Edge symbol end:'animation1'

//=========================================================

//Edge symbol: 'animation2'
(function(symbolName){})("animation2");
//Edge symbol end:'animation2'

//=========================================================

//=========================================================

//=========================================================

//=========================================================

//Edge symbol: 'highlight'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight_1_1");
//Edge symbol end:'highlight_1_1'

//=========================================================

//Edge symbol: 'animation3'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",7000,function(sym,e){$('#Stage_quantumState2').html('|&psi;&#x232A; = |&uarr;&#x232A;');$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.00');$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.00');});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",0,function(sym,e){$('#Stage_quantumState2').html('|&psi;&#x232A; = |&uarr;&#x232A;');$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.00');$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.00');});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play('start');});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",4000,function(sym,e){$('#Stage_quantumState2').html('|&psi;&#x232A; = |&darr;&#x232A;');$('#Stage_probSpinUpZ').html('S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.00');$('#Stage_probSpinDownZ').html('S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.00');});
//Edge binding end
})("animation3");
//Edge symbol end:'animation3'
})(jQuery,AdobeEdge,"EDGE-19890435");