/*  Copyright 2016, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
*/


(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var startValue=0;var endValue=0;startScoreAnimation=function(a,b){startValue=a;endValue=b;scoreIncrementer=setInterval(function(){incrementScore(startValue,endValue)},40);}
incrementScore=function(lastValue,endValue){startValue++;$('#Stage_scoreText').text(startValue+'/100');if(startValue==endValue){clearInterval(scoreIncrementer);}}
var images=[];function preloadImages(){var prefixes=['rectangle'],length=prefixes.length;for(var i=0;i<length;i++){_preloadImages(prefixes[i]);}}
function _preloadImages(prefix){for(var i=1;i<=5;i++){for(var j=1;j<=5;j++){var name=prefix+'Nx'+i+'Ny'+j,image=new Image();image.onload=function(){};image.onerror=function(){console.error("Error occur while preloading image: "+name);};image.src='./images/NewGraphs/'+name+'.png';images.push(image);}}}
function enableButtons(button){for(i=1;i<6;i++){sym_enable($('#Stage_buttonHelp'+i));}
sym_disable($('#Stage_buttonHelp'+button));}
function step_functions(step){clearTimeout(AdobeEdge.step_animation);switch(step){case 1:break;}}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');if(slider.hasClass('inverted')){slider.find('.handle').css('top',(range-pos)+'px');}
var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').hide();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}}
function sym_disable(element){$(element).addClass('disabled');$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();if(!$('#'+$(element).attr('id')+'_mask').length){$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);$(element).data('timeout_val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();sym.stop(0);sym.$('mag_challenge_graph').hide();sym.$('psi_graph').show();sym.$('mag_graph').show();yepnope({load:"normalize.css"});sym.setVariable("nx",0);sym.setVariable("ny",0);sym.setVariable("frame",0);var pointerArray=[349+175,316+175,283+175,250+175,217+175,184+175];var tickArray=[false,false,false,false];var score=0;var questionScore=[20,20,30,30];var psi_graph=$('#Stage_psi_image');var src_psi='./images/croppedimages2/psi00.png';psi_graph.attr("src",src_psi);var mag_graph=$('#Stage_mag_image');var src_mag='./images/croppedImages2/mag00.png';mag_graph.attr("src",src_mag);sym.getSymbol('helpTexts').$('Text5').html('The graphs depict the energy eigenfunctions for a <br> two-dimensional quantum harmonic oscillator. Press the “?” buttons for more information. You can change the quantum state by clicking on an energy level or sliding through the energy levels. <b>Can you find different combinations of quantum numbers that give the same total energy?</b> After having done this, attempt the challenges in the Challenges tab!');sym.getSymbol('helpTexts').$('Text1').html('The top graph shows you the spatial part of the energy <br> eigenfunction &Psi;<sub>n<sub style="font-size: 100%;">x</sub></sub><sub>n<sub style="font-size: 100%;">y</sub></sub>(x,y) '+'of a particle confined to move in two dimensions with a harmonic oscillator '+'potential energy given by V=1/2 m&omega;<sup>2</sup> (x<sup>2</sup>+y<sup>2</sup>). '+'Here, m is the mass and &omega; is the angular frequency of the oscillator'+' and the eigenstate is defined by the quantum numbers n<sub>x</sub> and n<sub>y</sub>.');sym.getSymbol('helpTexts').$('Text2').html('The bottom graph shows you the probability density <br>|&Psi;<sub>n<sub style="font-size: 100%;">x</sub></sub><sub>n<sub style="font-size: 100%;">y</sub></sub>(x,y)|<sup>2</sup>  '+'of a particle confined to move in two dimensions with a harmonic '+'oscillator potential energy. How are the number of peaks along x and y in the probability density graph related to the quantum numbers n<sub>x</sub> and n<sub>y</sub>?');sym.getSymbol('helpTexts').$('Text4').html('The particle is in an energy eigenstate, so has definite energy.<br> The energy is quantized along both'+' x and y, and determined by the quantum numbers n<sub>x</sub> and n<sub>y</sub>. '+'The total energy is the sum of the one-dimensional energies along x and y. You can find different combinations of the quantum numbers '+'n<sub>x</sub> and n<sub>y</sub> that have the same total energy: such states are called degenerate. ');sym.getSymbol('helpTexts').$('Text3').html("You can change the particle's energy along the x and y <br> directions by clicking on an energy level or sliding through the energy levels. The ground state energy "+"E<sub>0</sub> = 1/2 &#295;&omega;."+"The energy levels along each coordinate are equidistant with spacing &#295;&omega;.");sym.$('e0').html('E<sub>0</sub>');sym.$('e1').html('E<sub>1</sub>');sym.$('e2').html('E<sub>2</sub>');sym.$('e3').html('E<sub>3</sub>');sym.$('e4').html('E<sub>4</sub>');sym.$('e5').html('E<sub>5</sub>');sym.$('ex').html('E<sub>x</sub>');sym.$('ey').html('E<sub>y</sub>');sym.$('textEnergies').html('Quantum numbers (<span style="color:rgb(0,64,159)">n<sub>x</sub></span>,<span style="color:rgb(0,181,28)">n<sub>y</sub></span>)&nbsp;=&nbsp;(<span style="color:rgb(0,64,159)">'+0+'</span>,<span style="color:rgb(0,181,28)">'+0+'</span>)');sym.getSymbol('energyFormulae').$('energyFormulaText4').html('E<sub>x</sub> = (n<sub>x</sub> + 0.5)&#295;&omega;');sym.getSymbol('energyFormulae').$('energyFormulaText5').html('E<sub>y</sub> = (n<sub>y</sub> + 0.5)&#295;&omega;');sym.getSymbol('energyFormulae').$('energyFormulaText2').html('E<sub>y</sub> = '+0.5+' &#295;&omega;');sym.getSymbol('energyFormulae').$('energyFormulaText1').html('E<sub>x</sub> = '+0.5+' &#295;&omega;');sym.getSymbol('energyFormulae').$('energyFormulaText3').html('E<sub>total</sub> = <span style="color:rgb(0,64,159)">E<sub>x</sub></span> + <span style="color:rgb(0,181,28)">E<sub>y</sub></span> = '+1+' &#295;&omega;');sym.getSymbol('challenges').$('challenge1').html('What are the quantum numbers n<sub>x</sub> and n<sub>y</sub> corresponding to the probability density shown?');sym.getSymbol('challenges').$('challenge2').html('What are the quantum numbers n<sub>x</sub> and n<sub>y</sub> corresponding to the energy eigenfunction shown?');sym.getSymbol('challenges').$('challenge4').html('By selecting the quantum numbers n<sub>x</sub> and n<sub>y</sub>, find a combination of quantum numbers that gives a state that is degenerate to the one shown, i.e., has the same the total energy but different quantum numbers. ');sym.$('psiFormula').html('&Psi;<sub>00</sub>(x,y)');sym.$('magFormula').html('|&Psi;<sub>00</sub>(x,y)|<sup>2</sup>');sym.$('nx').html('<span style="color:rgb(0,64,159)">n<sub>x</sub></span>');sym.$('ny').html('<span style="color:rgb(0,181,28)">n<sub>y</sub></span>');sym.setNx=function(x){sym.setVariable("nx",x);var formula=sym.getSymbol("energyFormulae");formula.$('energyFormulaText1').html('E<sub>x</sub> = '+(sym.getVariable("nx")+0.5)+' &#295;&omega;');formula.$('energyFormulaText3').html('E<sub>total</sub> = <span style="color:rgb(0,64,159)">E<sub>x</sub></span> + <span style="color:rgb(0,181,28)">E<sub>y</sub></span> = '+(sym.getVariable("nx")+sym.getVariable("ny")+1)+' &#295;&omega;');sym.$('nxMainControl').text("= "+sym.getVariable("nx"));sym.$('energyXPointer').css('top',pointerArray[sym.getVariable("nx")]);sym.$('textEnergies').html('n<sub>x</sub>,n<sub>y<sub>&nbsp;=$nbsp;('+x+',3)');sym.$('psiFormula').html('&Psi;<sub>'+sym.getVariable("nx")+sym.getVariable("ny")+'</sub>(x,y)');sym.$('magFormula').html('|&Psi;<sub>'+sym.getVariable("nx")+sym.getVariable("ny")+'</sub>(x,y)|<sup>2</sup>');var mag_graph=$('#Stage_mag_image');var src_mag='./images/croppedImages2/mag'+sym.getVariable("nx")+sym.getVariable("ny")+'.png';mag_graph.attr("src",src_mag);var psi_graph=$('#Stage_psi_image');var src_psi='./images/croppedimages2/psi'+sym.getVariable("nx")+sym.getVariable("ny")+'.png';psi_graph.attr("src",src_psi);sym.$('textEnergies').html('Quantum numbers (<span style="color:rgb(0,64,159)">n<sub>x</sub></span>,<span style="color:rgb(0,181,28)">n<sub>y</sub></span>)&nbsp;=&nbsp;(<span style="color:rgb(0,64,159)">'+sym.getVariable("nx")+'</span>,<span style="color:rgb(0,181,28)">'+sym.getVariable("ny")+'</span>)');}
sym.setNy=function(y){sym.setVariable("ny",y);var formula=sym.getSymbol("energyFormulae");formula.$('energyFormulaText2').html('E<sub>y</sub> = '+(sym.getVariable("ny")+0.5)+' &#295;&omega;');formula.$('energyFormulaText3').html('E<sub>total</sub> = <span style="color:rgb(0,64,159)">E<sub>x</sub></span> + <span style="color:rgb(0,181,21)">E<sub>y</sub></span> = '+(sym.getVariable("nx")+sym.getVariable("ny")+1)+' &#295;&omega;');sym.$('nyMainControl').text("= "+sym.getVariable("ny"));sym.$('energyYPointer').css('top',pointerArray[sym.getVariable("ny")]);sym.$('psiFormula').html('&Psi;<sub>'+sym.getVariable("nx")+sym.getVariable("ny")+'</sub>(x,y)');sym.$('magFormula').html('|&Psi;<sub>'+sym.getVariable("nx")+sym.getVariable("ny")+'</sub>(x,y)|<sup>2</sup>');var mag_graph=$('#Stage_mag_image');var src_mag='./images/croppedImages2/mag'+sym.getVariable("nx")+sym.getVariable("ny")+'.png';mag_graph.attr("src",src_mag);var psi_graph=$('#Stage_psi_image');var src_psi='./images/croppedimages2/psi'+sym.getVariable("nx")+sym.getVariable("ny")+'.png';psi_graph.attr("src",src_psi);sym.$('textEnergies').html('Quantum numbers (<span style="color:rgb(0,64,159)">n<sub>x</sub></span>,<span style="color:rgb(0,181,28)">n<sub>y</sub></span>)&nbsp;=&nbsp;(<span style="color:rgb(0,64,159)">'+sym.getVariable("nx")+'</span>,<span style="color:rgb(0,181,28)">'+sym.getVariable("ny")+'</span>)');}
sym.displayTicks=function(){for(var i=1;i<5;i++){if(tickArray[i-1]){sym.$('tick'+i).show();}}}
sym.resetChallenge=function(question){sym.getComposition().getStage().getSymbol("challenges").stop("q"+question);sym.getComposition().getStage().getSymbol("responses").stop("empty");sym_enable(sym.$('submitButton'));for(var i=0;i<6;i++){sym_enable(sym.$('nx'+i+'Radio'));sym_enable(sym.$('ny'+i+'Radio'));}
sym.deselectRadios();sym.setVariable("questionNo",question);if(question!=3){var questionNx=Math.floor(Math.random()*6);var questionNy=Math.floor(Math.random()*6);sym.setVariable("questionNx",questionNx);sym.setVariable("questionNy",questionNy);}else{var questionEtot=Math.floor(Math.random()*11)+1
sym.setVariable("questionEtot",questionEtot);sym.getSymbol('challenges').$('challenge3').html('By selecting the quantum numbers n<sub>x</sub> and n<sub>y</sub>, find a combination of quantum numbers that give the total energy '
+questionEtot+' &#295;&omega; ');}
while(question==4&&((questionNx==0&&questionNy==0)||(questionNx==5&&questionNy==5))){var questionNx=Math.floor(Math.random()*6);var questionNy=Math.floor(Math.random()*6);sym.setVariable("questionNx",questionNx);sym.setVariable("questionNy",questionNy);}
if(question==1){sym.$('psi_graph').hide();sym.$('psiFormula').hide();sym.$('magFormula').show();var mag_challenge_graph=$('#Stage_mag_challenge_image');var src_challenge='./images/croppedimages2/mag'+questionNx+questionNy+'.png';mag_challenge_graph.attr("src",src_challenge);sym.$('mag_challenge_graph').show();sym.$('challengeMagFormula').show();}else if(question==2){sym.$('mag_challenge_graph').hide();sym.$('challengeMagFormula').hide();var psi_graph=$('#Stage_psi_image');var src_psi='./images/croppedimages2/psi'+questionNx+questionNy+'.png';psi_graph.attr("src",src_psi);sym.$('psi_graph').show();sym.$('psiFormula').show();sym.$('magFormula').hide();}else if(question==3){var questions=sym.getSymbol("challenges");questions.$('challenge3Text').text(questionEtot);sym.$('psi_graph').hide();sym.$('psiFormula').hide();sym.$('challengeMagFormula').hide();sym.$('mag_challenge_graph').hide();sym.$('magFormula').hide();sym.$('psiFormula').hide();}else{sym.$('mag_challenge_graph').hide();sym.$('challengeMagFormula').hide();var psi_graph=$('#Stage_psi_image');var src_psi='./images/croppedimages2/psi'+questionNx+questionNy+'.png';psi_graph.attr("src",src_psi);sym.$('psi_graph').show();sym.$('psiFormula').show();sym.$('magFormula').hide();}}
sym.checkAnswer=function(){var question=sym.getVariable("questionNo")
var xChosen=sym.getAnswer('x');var yChosen=sym.getAnswer('y');var correct=false;if(question==1||question==2){correct=((xChosen==sym.getVariable("questionNx"))&&(yChosen==sym.getVariable("questionNy")));}else if(question==3){correct=(xChosen+yChosen+1==sym.getVariable("questionEtot"));}else{correct=((xChosen+yChosen==sym.getVariable("questionNx")+sym.getVariable("questionNy"))&&xChosen!=sym.getVariable("questionNx"));}
if(xChosen+yChosen>50){sym.getComposition().getStage().getSymbol('responses').stop('unselected');}else if(correct){var sendBalloons=true;if(!tickArray[question-1]){sym.$('tick'+question).show();tickArray[question-1]=true;startScoreAnimation(score,score+questionScore[question-1]);score+=questionScore[question-1];if(score==100){sym.$('fancyExcellent').show();sym.getSymbol('fancyExcellent').play();sendBalloons=false;}}
if(Math.random()<0.5&&sendBalloons){sym.getSymbol('sillyBalloons').play();}
responses=sym.getComposition().getStage().getSymbol('responses');responses.$('_1t').html('Correct, congratulations! The probability density has '+
(+xChosen+1)+' maxima along x and '+
(+yChosen+1)+' along y. Thus, <span style = "white-space: nowrap;">n<sub>x</sub> = '+
xChosen+'</span> and <span style = "white-space: nowrap;">n<sub>y</sub> = '+yChosen+'</span>.');responses.$('_2t').html('Correct, congratulations! The energy eigenfunction has '+
(+xChosen+1)+' maxima or minima along x and '+
(+yChosen+1)+' along y. Thus, <span style = "white-space: nowrap;">n<sub>x</sub> = '+
xChosen+'</span> and <span style = "white-space: nowrap;">n<sub>y</sub> = '+yChosen+'</span>.');responses.$('_3t').html('Correct, congratulations! The quantum numbers <span style = "white-space: nowrap;">n<sub>x</sub> = '+
xChosen+'</span> and <span style = "white-space: nowrap;">n<sub>y</sub> = '+
yChosen+'</span> give the total energy <span style = "white-space: nowrap;">E<sub>total</sub> = E<sub>x</sub> + E<sub>y</sub> = '+
sym.getVariable("questionEtot")+'  &#295;&omega;</span>.');responses.$('_4t').html('Correct, congratulations! The quantum numbers <span style = "white-space: nowrap;">n<sub>x</sub> = '+
(sym.getVariable("questionNx"))+'</span> and <span style = "white-space: nowrap;">n<sub>y</sub> = '+
(sym.getVariable("questionNy"))+'</span> shown in the graph and your chosen quantum numbers <span style = "white-space: nowrap;">n<sub>x</sub> = '+
xChosen+'</span> and <span style = "white-space: nowrap;">n<sub>y</sub> = '+
yChosen+'</span> both give the same total energy <span style = "white-space: nowrap;">E<sub>total</sub> =&#295;&omega;'+'(n<sub>x</sub> + n<sub>y</sub> + 1) ='+(+xChosen+yChosen+1)+'&#295;&omega;</span>.');responses.stop(""+question+'t');}else{sym.getComposition().getStage().getSymbol('responses').stop(""+question+'f');responses=sym.getComposition().getStage().getSymbol('responses');responses.$('_3f').html('This is not yet correct. Remember that the total energy is <span style = "white-space: nowrap;"> E<sub>total</sub> = '+' &#295;&omega;(n<sub>x</sub> + n<sub>y</sub> + 1)</span>. Please try again.');responses.$('_4f').html('This is not yet correct. Remember that the total energy is <span style = "white-space: nowrap;"> E<sub>total</sub> = '+' &#295;&omega;(n<sub>x</sub> + n<sub>y</sub> + 1)</span>. Please try again.');}}
sym.getAnswer=function(n){if(sym.$('n'+n+'0Radio').hasClass('selected')){return 0;}else if(sym.$('n'+n+'1Radio').hasClass('selected')){return 1;}else if(sym.$('n'+n+'2Radio').hasClass('selected')){return 2;}else if(sym.$('n'+n+'3Radio').hasClass('selected')){return 3;}else if(sym.$('n'+n+'4Radio').hasClass('selected')){return 4;}else if(sym.$('n'+n+'5Radio').hasClass('selected')){return 5;}else{return 100;}}
sym.deselectRadios=function(){for(var i=0;i<6;i++){sym_deselect(sym.$('nx'+i+'Radio'));sym_deselect(sym.$('ny'+i+'Radio'));}}
$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('sliderX');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));var nx=6-slider.data('val')
sym.setNx(nx);},20));}});$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('sliderY');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));var ny=6-slider.data('val')
sym.setNy(ny);},20));}});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_energyCheckbox}","click",function(sym,e){if(sym.$('energyCheckbox').hasClass('selected')){sym.$("energyFormulae").show();}else{sym.$("energyFormulae").hide();}});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){sym.stop('controls');sym.$('mag_challenge_graph').hide();sym.$('mag_graph').show();sym.$('psi_graph').show();var psi_graph=$('#Stage_psi_image');var src_psi='./images/croppedimages2/psi'+sym.getVariable("nx")+sym.getVariable("ny")+'.png';psi_graph.attr("src",src_psi);var mag_graph=$('#Stage_mag_image');var src_mag='./images/croppedImages2/mag'+sym.getVariable("nx")+sym.getVariable("ny")+'.png';mag_graph.attr("src",src_mag);sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);sym.$('psiFormula').html('&Psi;<sub>'+sym.getVariable("nx")+sym.getVariable("ny")+'</sub>(x,y)');sym.$('magFormula').html('|&Psi;<sub>'+sym.getVariable("nx")+sym.getVariable("ny")+'</sub>(x,y)|<sup>2</sup>');sym_val('#Stage_sliderY',sym.getVariable("ny")+1);if(sym.$('energyCheckbox').hasClass('selected')){sym.$("energyFormulae").show();}else{sym.$("energyFormulae").hide();}});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_explanation}","click",function(sym,e){sym.$('psiFormula').html('&Psi;<sub>??</sub>(x,y)');sym.$('magFormula').html('|&Psi;<sub>??</sub>(x,y)|<sup>2</sup>');sym.stop('challenges');sym.resetChallenge(1);sym.displayTicks();sym_features();sym_step(1);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_submitButton}","click",function(sym,e){sym.checkAnswer();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelp1}","click",function(sym,e){enableButtons(1);sym.$('help_content').show();sym.getSymbol('helpTexts').stop('1');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelp2}","click",function(sym,e){enableButtons(2);sym.$('help_content').show();sym.getSymbol('helpTexts').stop('2');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelp3}","click",function(sym,e){enableButtons(3);sym.$('help_content').show();sym.getSymbol('helpTexts').stop('3');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelp4}","click",function(sym,e){enableButtons(4);sym.$('help_content').show();sym.getSymbol('helpTexts').stop('4');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_button_help_close}","click",function(sym,e){sym.$('help_content').hide();enableButtons();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrewsCopy}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank')});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelp5}","click",function(sym,e){enableButtons(5);sym.$('help_content').show();sym.getSymbol('helpTexts').stop('5');});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"${_step2}","click",function(sym,e){sym.getComposition().getStage().resetChallenge(2);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_step3}","click",function(sym,e){sym.getComposition().getStage().resetChallenge(3);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_step4}","click",function(sym,e){sym.getComposition().getStage().resetChallenge(4);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_step1}","click",function(sym,e){sym.getComposition().getStage().resetChallenge(1);});
//Edge binding end
})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'highlight'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight");
//Edge symbol end:'highlight'

//=========================================================

//Edge symbol: 'ETotForumla'
(function(symbolName){})("ETotFormula");
//Edge symbol end:'ETotFormula'

//=========================================================

//Edge symbol: 'EnergiesGraph'
(function(symbolName){})("EnergiesGraph");
//Edge symbol end:'EnergiesGraph'

//=========================================================

//Edge symbol: 'challenges'
(function(symbolName){})("challenges");
//Edge symbol end:'challenges'

//=========================================================

//Edge symbol: 'psiGraphs'
(function(symbolName){})("psiGraphs");
//Edge symbol end:'psiGraphs'

//=========================================================

//Edge symbol: 'Responses'
(function(symbolName){})("Responses");
//Edge symbol end:'Responses'

//=========================================================

//Edge symbol: 'psiGraphs_1'
(function(symbolName){})("magGraphs");
//Edge symbol end:'magGraphs'

//=========================================================

//Edge symbol: 'fancyExcellent'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().$('fancyExcellent').hide();sym.stop(0);});
//Edge binding end
})("fancyExcellent");
//Edge symbol end:'fancyExcellent'

//=========================================================

//Edge symbol: 'sillyBalloons'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.stop(0);});
//Edge binding end
})("sillyBalloons");
//Edge symbol end:'sillyBalloons'

//=========================================================

//Edge symbol: 'helpTexts'
(function(symbolName){})("helpTexts");
//Edge symbol end:'helpTexts'
})(jQuery,AdobeEdge,"EDGE-19890435");