/*  Copyright 2018, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
*/
(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var bosonEnergy=[['-1','-1','-1','-1','-1','-1','-1'],[' 1',' 4',' 9','16','25','Ex','Ex'],[' 2',' 5',' 8','10','13','17','18'],[' 3',' 6',' 9','11','12','14','17'],[' 4',' 7','10','12','13','15','16'],[' 5',' 8','11','13','14','16','17'],[' 6',' 9','12','14','15','17','18'],[' 7','10','13','15','16','18','19'],[' 8','11','14','16','17','19','20']];var fermionEnergy=[['-1','-1','-1','-1','-1','-1','-1'],[' 1',' 4',' 9','16','25','Ex','Ex'],[' 2',' 5',' 8','10','13','17','18'],[' 6',' 9','11','14','17','18','19'],['10','15','18','20','23','26','33'],['19','24','26','27','31','34','35'],['28','35','40','42','43','44','47'],['44','51','53','56','59','60','65'],['60','69','76','78','81','84','85']];var stateName=['Grundzustand','Erster Anregungszustand','Zweiter Anregungszustand','Dritter Anregungszustand','Vierter Anregungszustand','Fünfter Anregungszustand','Sechster Anregungszustand','Hoch angeregter Zustand','Hoch angeregter Zustand','Hoch angeregter Zustand'];var eUPOccupancy=[0,0,0,0,0];var eDOWNOccupancy=[0,0,0,0,0];var eBOSOccupancy=[0,0,0,0,0];var Elevels=[443,396,317,216,81];var answerEnergy;var answerState;var answerNumberOfParticles;var N=3;var balloonProbability=1;var challengeQuestions=[0,0,0,0,0];var challengeScores=[10,10,20,20,40];var totalScore=0;function debug(t){$('#Stage_debug').text(t);}
function setChallengeQuestions(){$('#Stage_buttonSetNewCh').hide();$('#Stage .tick').hide();$('#Stage .tick').removeClass('show');totalScore=0;$('#Stage_textScore').text(totalScore+'/100');challengeQuestions[0]=Math.floor(Math.random()*5)+2;challengeQuestions[1]=Math.floor(Math.random()*2)+2;challengeQuestions[2]=Math.floor(Math.random()*5+2);challengeQuestions[3]=Math.floor(Math.random()*4)+3;challengeQuestions[4]=Math.floor(Math.random()*2)+2;challengeQuestions[5]=Math.ceil(Math.random()*3);}
function startScoreAnimation(a,b){startValue=a;endValue=b;if(b>a)
scoreIncrementer=setInterval(function(){startValue++;$('#Stage_textScore').text(startValue+'/100');if(startValue==endValue)clearInterval(scoreIncrementer);},40);}
function addedFeedback(score){if(totalScore<100){if(totalScore>score&&Math.random()<balloonProbability){$('#Stage_balloons').css('top',600);$('#Stage_balloons').animate({top:'-350px'},1500);balloonProbability=0.25;}
startScoreAnimation(score,totalScore)}else
$('#Stage_textScore').text('100/100');if(totalScore==100){AdobeEdge.getComposition(compId).getStage().getSymbol('fancyExcellent').play();totalScore=101;$('#Stage_buttonSetNewCh').delay(1000).fadeIn(1000);}}
function putBack2(element){var x0=60,xPos,yPos=500;if(element.hasClass('down'))
x0=175;element.hide();if(element.hasClass('eld'))element.removeClass('eld');var i=parseInt(element.attr("id").charAt(element.attr("id").length-1));if(element.hasClass("EL"+i))element.removeClass("EL"+i);xPos=x0+20*i;element.css({left:xPos+'px',top:yPos+'px'});}
function checkPauli(step){var pauli=true;if(step==1||step==4)
pauli=true;else{updateOccupancy2();for(var i=0;i<5;i++)
pauli=pauli&&eUPOccupancy[i]<2&&eDOWNOccupancy[i]<2;}
return pauli;}
function step_answers(){clearTimeout(AdobeEdge.step_animation);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];var step=$('#Stage').data('step');var energy=-10,numOfPart=-10;var currentScore=totalScore;energy=displayTotalBosonEnergy();numOfPart=getNumberOfBosons();if(!checkPauli(step)){balloonProbability*=2;sym.$('wrongText').show();sym.$('correctText').hide();sym.$('wrongText').html('Das ist noch nicht korrekt. Diese Konfiguration würde dem Pauli-Prinzip widersprechen. Du kannst Dir das in der Simulation noch einmal genauer ansehen.');}else if(answerNumberOfParticles>numOfPart){balloonProbability*=2;sym.$('wrongText').show();sym.$('correctText').hide();sym.$('wrongText').html("Bitte benutze sämtliche Teilchen.");}else if(answerEnergy==energy){sym.$('#Stage_Tick'+step).show();if(!$('#Stage_Tick'+step).hasClass('show'))
totalScore+=challengeScores[step-1];sym.$('#Stage_Tick'+step).addClass('show');sym.$('wrongText').hide();sym.$('correctText').show();sym.$('correctText').html("Herzlichen Glückwunsch – das ist korrekt! Die Gesamtenergie beträgt  "+answerEnergy+"E<sub>1</sub>");addedFeedback(currentScore);releaseBalloons();}else{balloonProbability*=2;sym.$('wrongText').show();sym.$('correctText').hide();sym.$('wrongText').html("Das ist noch nicht korrekt. Bedenke, dass sich die Gesamtenergie als Summe der individuellen Energien ergibt. Versuche es noch einmal.");}}
function step_functions(step){clearTimeout(AdobeEdge.step_animation);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.$('wrongText').hide();sym.$('correctText').hide();resetButton();resetParameters();switch(step){case 0:$('#Stage_buttonSubmit').hide();sym.play('0');break;case 1:$('#Stage_buttonSubmit').show();$('#Stage .boson').show();$('#Stage .up,.down').hide();$('#Stage_boson5').hide();$('#Stage_boson6').hide();$('#Stage_boson7').hide();$('#Stage_boson8').hide();answerNumberOfParticles=4;answerEnergy=bosonEnergy[4][challengeQuestions[0]];sym.$('dynamicText').text(answerEnergy);break;case 2:$('#Stage_buttonSubmit').show();$('#Stage .boson').hide();$('#Stage .up,.down').show();answerNumberOfParticles=challengeQuestions[1];answerEnergy=fermionEnergy[answerNumberOfParticles*2][0];for(var i=answerNumberOfParticles+1;i<7;i++){$('#Stage_Up'+i).hide();$('#Stage_Down'+i).hide();}
answerNumberOfParticles=2*answerNumberOfParticles;break;case 3:$('#Stage_buttonSubmit').show();$('#Stage .boson').hide();$('#Stage .up,.down').show();for(var i=4;i<7;i++){$('#Stage_Up'+i).hide();$('#Stage_Down'+i).hide();}
answerNumberOfParticles=6;answerEnergy=fermionEnergy[answerNumberOfParticles][challengeQuestions[2]];var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.$('dynamicText').text(answerEnergy);break;case 4:$('#Stage_buttonSubmit').show();$('#Stage .boson').show();$('#Stage .up,.down').hide();answerNumberOfParticles=challengeQuestions[3];for(var i=answerNumberOfParticles+1;i<9;i++){$('#Stage_boson'+i).hide();}
answerState=Math.ceil(Math.random()*2)+2;answerEnergy=bosonEnergy[answerNumberOfParticles][answerState];sym.$('dynamicText2').text(stateName[answerState]);break;case 5:$('#Stage_buttonSubmit').show();$('#Stage .boson').hide();$('#Stage .up,.down').show();answerNumberOfParticles=challengeQuestions[4];for(var i=answerNumberOfParticles+1;i<7;i++){$('#Stage_Up'+i).hide();$('#Stage_Down'+i).hide();}
answerState=challengeQuestions[5];answerNumberOfParticles*=2;answerEnergy=fermionEnergy[answerNumberOfParticles][answerState];sym.$('dynamicText2').text(stateName[answerState]);break;}}
function resetParameters(){eUPOccupancy=[0,0,0,0,0];eDOWNOccupancy=[0,0,0,0,0];eBOSOccupancy=[0,0,0,0,0];$('#Stage .boson.movable,.up.movable,.down.movable').each(function(){var x0=60,xPos,yPos=500;var element=$(this);if(element.hasClass('down'))
x0=175;xPos=x0+20*parseInt(element.attr("id").charAt(element.attr("id").length-1));element.animate({left:xPos+'px',top:yPos+'px'},500);});}
function resetButton(){var old=$('#Stage .showingText');old.hide();old.removeClass('showingText');old=$('#Stage .Initial');old.addClass('showingText');old.show();$('#Stage .eld').removeClass('eld');displayTotalBosonEnergy();resetParameters();getEnergyState(0);}
function putBackNoAnimation(element){var x0=60,xPos,yPos=500;if(element.hasClass('down'))
x0=175;var i=parseInt(element.attr("id").charAt(element.attr("id").length-1));xPos=x0+20*i;element.animate({left:xPos+'px',top:yPos+'px'},500);}
function putBack(element){var x0=60,xPos,yPos=500;if(element.hasClass('down'))
x0=175;xPos=x0+20*parseInt(element.attr("id").charAt(element.attr("id").length-1));element.animate({top:'+=5px'},100);element.animate({top:'-=10px'},100);element.animate({top:'+=10px'},100);element.animate({top:'-=10px'},100);element.animate({left:xPos+'px',top:yPos+'px'},500);}
function displayParticles(){var sliderVal=$('#Stage_slider').data('val');N=sliderVal;$('#Stage_textWarning').stop();$('#Stage_textState').stop();var number=-1;if($('#Stage_bosons').hasClass('selected')){for(var i=1;i<=8;i++){if(i<=sliderVal){$('#Stage_boson'+i).show();$('#Stage_boson'+i).removeClass('hidden');}else{putBack2($('#Stage_boson'+i));$('#Stage_boson'+i).hide();$('#Stage_boson'+i).addClass('hidden');}}}else{if(sliderVal%2){for(i=1;i<=4;i++)
if(i<=Math.ceil(sliderVal/2)){$('#Stage_Up'+i).show();$('#Stage_Down'+i).show();}else{putBack2($('#Stage_Up'+i));putBack2($('#Stage_Down'+i));}
putBack2($('#Stage_Down'+Math.ceil(sliderVal/2)));}else
for(i=1;i<=4;i++)
if(i<=(sliderVal/2)){$('#Stage_Up'+i).show();$('#Stage_Down'+i).show();}else{putBack2($('#Stage_Up'+i));putBack2($('#Stage_Down'+i));}}
updateOccupancy2();if($('#Stage_bosons').hasClass('selected'))
number=getNumberOfBosons();else{number=getNumberOfFermions();}}
function getEnergyState(number){var energy=-1,state=0;if($('#Stage_fermions').hasClass('selected')){energy=parseInt(displayTotalFermionEnergy());while(parseInt(fermionEnergy[number][state])!=energy&&state<9)
state++;}else{energy=parseInt(displayTotalBosonEnergy());while(parseInt(bosonEnergy[number][state])!=energy&&state<9)
state++;}
var text=stateName[state];$('#Stage_textState').text(text);if(number==N){$('#Stage_textWarning').hide();$('#Stage_textState').fadeIn();}else{$('#Stage_textState').hide();$('#Stage_energyTextValue').html('E<sub>System</sub> = undefiniert');$('#Stage_textWarning').fadeIn();}}
function getNumberOfBosons(){var counter=0;for(var i=0;i<5;i++)
counter+=eBOSOccupancy[i];getEnergyState(counter);return counter;}
function getNumberOfFermions(){var counter=0;for(var i=0;i<5;i++)
counter+=eUPOccupancy[i]+eDOWNOccupancy[i];getEnergyState(counter);return counter;}
function displayTotalFermionEnergy(){var energy=0;var text='E<sub>System</sub> = ';for(var i=0;i<5;i++){var n=eUPOccupancy[i]+eDOWNOccupancy[i];energy+=n*(i+1)*(i+1);text+=n+'E<sub>'+(i+1)+'</sub> ';if(i<4)text+=' + ';}
if(energy<10)
text+=' =&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+energy+'E<sub>1</sub>';else if(energy<100)
text+=' =&nbsp;&nbsp;&nbsp;'+energy+'E<sub>1</sub>';else
text+=' =&nbsp;'+energy+'E<sub>1</sub>';$('#Stage_energyTextValue').html(text);return energy;}
function displayTotalBosonEnergy(){var energy=0;var text='E<sub>System</sub> = ';for(var i=0;i<5;i++){var n=eBOSOccupancy[i];energy+=(i+1)*(i+1)*n;text+=n+'E<sub>'+(i+1)+'</sub>';if(i<4)text+=' + ';}
if(energy<10)
text+=' =&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+energy+'E<sub>1</sub>';else if(energy<100)
text+=' =&nbsp;&nbsp;&nbsp;'+energy+'E<sub>1</sub>';else
text+=' =&nbsp;'+energy+'E<sub>1</sub>';$('#Stage_energyTextValue').html(text);return energy;}
function findPlaceForFermion(element,energy){var xPos=parseInt(element.css('left'));element.animate({left:xPos+'px',top:Elevels[energy]+'px'},500);var spinType='down';if(element.hasClass('down'))
spinType='up';if($('#Stage .movable.'+spinType).hasClass('EL'+energy)){var xPos2=parseInt($('#Stage .movable.'+spinType+'.EL'+energy).css('left'));if(Math.abs(xPos2-xPos)<30){var dx=Math.abs(xPos2-xPos);var sign=-1;if(xPos>xPos2)
sign=-sign;if((xPos+sign*(30-dx)/2)<73)
xPos2=xPos2+30;else if((xPos2-sign*(30-dx)/2)<73)
xPos=xPos+30;else if((xPos+sign*(30-dx)/2)>374)
xPos2=xPos2-30;else if((xPos2-sign*(30-dx)/2)>374)
xPos=xPos-30;else{xPos=xPos+sign*(30-dx)/2;xPos2=xPos2-sign*(30-dx)/2;}
element.animate({left:xPos+'px'},500);$('#Stage .movable.'+spinType+'.EL'+energy).animate({left:xPos2+'px'},500);}}}
function findPlaceForBoson(element,energy){var xPos=parseInt(element.css('left'));var horizontalDelta=20;xPos=73+horizontalDelta*Math.floor((xPos-73)/horizontalDelta);var overLapped=false,sign=1,overLapFlag=true
do{overLapped=false;$('#Stage .boson.EL'+energy).each(function(){if(parseInt($(this).css('left'))==xPos){xPos+=sign*horizontalDelta;overLapped=true;if(xPos>373){sign=-1;xPos+=sign*horizontalDelta;}}});if(overLapped&&overLapFlag){overLapFlag=false;}
if(xPos<73){xPos=73+Math.floor(Math.random()*300);overLapped=false;}}while(overLapped&&xPos<=373)
element.animate({left:xPos+'px',top:Elevels[energy]+'px'},500);}
function moveParticle(movable){var y=parseInt(movable.css('top'));var energyLevelIndex=findEnergy(movable,y);var xPos;var putBackParticle=true;switch(getParticleType(movable)){case'boson':putBackParticle=energyLevelIndex<0;findPlaceForBoson(movable,energyLevelIndex);break;case'up':putBackParticle=energyLevelIndex<0||(eUPOccupancy[energyLevelIndex]==1);if(!putBackParticle)
findPlaceForFermion(movable,energyLevelIndex);break;case'down':putBackParticle=energyLevelIndex<0||(eDOWNOccupancy[energyLevelIndex]==1);if(!putBackParticle)
findPlaceForFermion(movable,energyLevelIndex);}
if(!putBackParticle){movable.addClass('eld');movable.addClass('EL'+energyLevelIndex);}else{if(y<470)
putBack(movable);else
putBackNoAnimation(movable);movable.removeClass('eld');}
updateOccupancy2();if(getParticleType(movable)!='boson'){displayTotalFermionEnergy();getNumberOfFermions();}else{displayTotalBosonEnergy();getNumberOfBosons();}}
function getParticleType(element){if(element.hasClass('boson'))
return'boson';else if(element.hasClass('down'))
return'down';else if(element.hasClass('up'))
return'up';else
return"";}
function findEnergy(element,y){var energyLevelIndex=-1;for(var j=0;j<5;j++){if(Math.abs(y-Elevels[j])<30)
energyLevelIndex=j;}
return energyLevelIndex;}
function updateOccupancy2(){eUPOccupancy=[0,0,0,0,0];eDOWNOccupancy=[0,0,0,0,0];eBOSOccupancy=[0,0,0,0,0];for(var i=0;i<5;i++){$('#Stage .boson.eld.EL'+i+':visible').each(function(){eBOSOccupancy[i]++;});$('#Stage .up.eld.EL'+i).each(function(){eUPOccupancy[i]++;});$('#Stage .down.eld.EL'+i).each(function(){eDOWNOccupancy[i]++;});}}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=55;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;tempX=Math.min(Math.max(tempX,movable.data('minX')+movable.width()/2*scale),(movable.data('maxX')-movable.width()/2)*scale)/scale;tempY=Math.min(Math.max(tempY,movable.data('minY')+movable.height()/2*scale),(movable.data('maxY')-movable.height()/2)*scale)/scale;var snap=1;tempX=Math.round((tempX-movable.width()/2)/snap)*snap;tempY=Math.round((tempY-movable.height()/2)/snap)*snap;movable.data('xPos',tempX);movable.data('yPos',tempY);movable.css('left',tempX);movable.css('top',tempY);}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').hide();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click touchstart',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){$(element).addClass('disabled');$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();if(!$('#'+$(element).attr('id')+'_mask').length){$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){yepnope({load:"normalize.css"});sym.$('button_label').html('Verteilung zur&uuml;cksetzen');sym.$('initialText').html('Links siehst Du die Energieniveaus eines unendlich<br> hohen Potentialtopfs. Du kannst Teilchen auf die einzelnen Niveaus verteilen, wobei du jeweils die Anzahl der Teilchen und deren Art (Boson oder Fermion) einstellen kannst. Wenn alle Teilchen verteilt sind, wird Dir rechts die zugehörige Gesamtenergie des Zustands angezeigt; links siehst Du zusätzlich, den wievielten Anregungszustand (bis zum sechsten) Du eingestellt hast. ');sym.$('diagramText').html('Das Diagramm zeigt die unteren fünf Energieniveaus<br> in einem eindimensionalen Potentialtopf mit unendlich hohen Wänden. Jedes Energieniveau wird durch eine gestrichelte Linie dargestellt, wobei E<sub>1</sub> das niedrigste Niveau bezeichnet. Die horizontale Anordnung der Teilchen hat keine physikalische Bedeutung. Wenn sämtliche Teilchen verteilt sind, wird die Bezeichnung des Anregungszustands (bis zum sechsten angeregten Zustand) des Systems angezeigt.');sym.$('fermionText').html('Fermionen sind Spin ½ Teilchen wie das Elektron.<br> Sie werden mit einem Pfeil dargestellt, wobei die Pfeilrichtung für den Zustand des Spins steht (entweder „Spin rauf“ oder „Spin runter“). Nach dem Pauli-Prinzip dürfen in einem System nicht zwei identische Fermionen dieselben Quantenzahlen besitzen. <b>Probiere aus, was dies für die Platzierung von Fermionen auf die Energieniveaus bedeutet.</b>');sym.$('bosonText').html('Bosonen sind Teilchen, die einen Spin von 0 haben,<br> wie z.B. Helium-4 Kerne. Im Gegensatz zu den identischen Fermionen können beliebig viele Bosonen dieselben Quantenzahlen haben. <b>Beobachte das Verhalten der Bosonen und vergleiche dann mit den Fermionen.<b>');sym.$('energyText').html('Die Gesamtenergie des Systems E<sub>System</sub> ergibt<br> sich als Summe der Energien der einzelnen Teilchen. Der Zustand des Systems mit der niedrigsten Gesamtenergie wird als der „Grundzustand“ bezeichnet. Andere Anregungszustände werden nach ihrer Energie benannt, so ist „Zweite Anregungszustand“ der Zustand mit der zweit-niedrigsten Energie über dem Grundzustand, etc.');$('#Stage_textState').hide();$('#Stage_textWarning').show();$('#Stage_energyTextValue').html('Platziere alle Teilchen!');sym_features();yepnope({load:"normalize.css"});$('#Stage .popUp').hide();sym.$('.up, .down').hide();$('#Stage_textState').hide();$('#Stage_textWarning').show();sym.$('.text').hide();var old=sym.$('.Initial');old.addClass('showingText');old.show();sym.$('buttonClose').show();sym.$('.boson').show();displayParticles();resetParameters();setChallengeQuestions();$('#Stage .boson.movable,up.movable,.down.movable').each(function(){putBack($(this));});sym.$('#Stage .tick').hide();$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=sym.$('slider');if(slider.hasClass('active')&&!slider.data('timeout')){slider.data('timeout',setTimeout(function(){slider.data('timeout',false);if(slider.data('timeout_val')===slider.data('val'))return;slider.data('timeout_val',slider.data('val'));N=slider.data('val');debug('display particles');displayParticles();},20));}});$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('active')&&!movable.data('timeout')){movable.data('timeout',setTimeout(function(){movable.data('timeout',false);if(movable.data('xtimeout_val')===movable.data('xPos')&&movable.data('ytimeout_val')===movable.data('yPos')){return;}
movable.data('xtimeout_val',movable.data('xPos'));movable.data('ytimeout_val',movable.data('yPos'));},20));}});$(document).on('mousedown touchstart',function(e){var movable=$('#Stage .movable.active');for(var i=0;i<5;i++)
if(movable.hasClass("EL"+i))
movable.removeClass("EL"+i);updateOccupancy2();if(movable.hasClass('eld'))
movable.removeClass('eld');});$(document).on('mouseup touchend',function(e){var movable=$('#Stage .movable.unActive');movable.removeClass('unActive');moveParticle(movable);});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_fermions}","click touchstart",function(sym,e){sym.$('.boson').hide();sym.$('.up').show();sym.$('.down').show();for(var i=5;i<7;i++){sym.$('#Stage_Up'+i).hide();sym.$('#Stage_Down'+i).hide();}
displayParticles();getNumberOfFermions();displayTotalFermionEnergy();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_bosons}","click touchstart",function(sym,e){sym.$('.up').hide();sym.$('.down').hide();sym.$('.boson').show();displayParticles();getNumberOfBosons();displayTotalBosonEnergy();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonReset}","click touchstart",function(sym,e){resetButton();sym.$('buttonClose').show();sym_enable(sym.$('buttonEnergyHelp'));sym_enable(sym.$('buttonHelpBoson'));sym_enable(sym.$('buttonHelpFermion'));sym_enable(sym.$('buttonDiagramHelp'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrews}","click touchstart",function(sym,e){window.open('http://www.st-andrews.ac.uk','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click touchstart",function(sym,e){clearTimeout(AdobeEdge.step_animation);sym.getComposition().getStage().getSymbol('steps').stop();sym.stop('simulation');sym.$('#Stage .tick.show').hide();for(var i=5;i<7;i++){sym.$('#Stage_Up'+i).hide();sym.$('#Stage_Down'+i).hide();}
sym.$('.up, .down').each(function(){if($(this).hasClass('boson'))
$(this).removeClass('boson');if(!($(this).hasClass('fermion')))
$(this).addClass('fermion');});sym.$('.boson').hide();sym.$('.up, .down').show();for(var i=5;i<7;i++){sym.$('#Stage_Up'+i).hide();sym.$('#Stage_Down'+i).hide();}
sym_select(sym.$('fermions'));resetParameters();resetButton();displayParticles();getNumberOfFermions();displayTotalFermionEnergy();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_explanation}","click touchstart",function(sym,e){sym.stop('explanation');sym.$('.tick.show').show();sym.$('.fermion').each(function(){$(this).removeClass('fermion');$(this).addClass('boson');});if(sym.$('#Stage').data('step')>0||sym.$('#Stage').data('step')<6)
sym_step(sym.$('#Stage').data('step'));else{sym_step(0);}});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelpBoson}","click touchstart",function(sym,e){sym.$('buttonClose').show();sym.$('.showingText').hide();sym.$('.showingText').removeClass('showingText');sym.$('.BosonHelp').addClass('showingText');sym.$('.BosonHelp').show();sym_enable(sym.$('buttonEnergyHelp'));sym_disable(sym.$('buttonHelpBoson'));sym_enable(sym.$('buttonHelpFermion'));sym_enable(sym.$('buttonDiagramHelp'));sym_enable(sym.$('buttonHelpNumber'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelpFermion}","click touchstart",function(sym,e){sym.$('buttonClose').show();sym.$('.showingText').hide();sym.$('.showingText').removeClass('showingText');sym.$('.FermionHelp').show();sym.$('.FermionHelp').addClass('showingText');sym_enable(sym.$('buttonEnergyHelp'));sym_enable(sym.$('buttonHelpBoson'));sym_disable(sym.$('buttonHelpFermion'));sym_enable(sym.$('buttonDiagramHelp'));sym_enable(sym.$('buttonHelpNumber'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonEnergyHelp}","click touchstart",function(sym,e){sym.$('buttonClose').show();sym.$('.showingText').hide();sym.$('.showingText').removeClass('showingText');sym.$('.energyHelp').show();sym.$('.energyHelp').addClass('showingText');sym_disable(sym.$('buttonEnergyHelp'));sym_enable(sym.$('buttonHelpBoson'));sym_enable(sym.$('buttonHelpFermion'));sym_enable(sym.$('buttonDiagramHelp'));sym_enable(sym.$('buttonHelpNumber'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonDiagramHelp}","click touchstart",function(sym,e){sym.$('buttonClose').show();sym.$('.showingText').hide();sym.$('.showingText').removeClass('showingText');sym.$('.Diagram').show();sym.$('.Diagram').addClass('showingText');sym_enable(sym.$('buttonEnergyHelp'));sym_enable(sym.$('buttonHelpBoson'));sym_enable(sym.$('buttonHelpFermion'));sym_disable(sym.$('buttonDiagramHelp'));sym_enable(sym.$('buttonHelpNumber'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonSubmit}","click touchstart",function(sym,e){step_answers();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonClose}","click touchstart",function(sym,e){sym.$('buttonClose').hide();sym.$('.showingText').hide();sym.$('.showingText').removeClass('showingText');sym_enable(sym.$('buttonEnergyHelp'));sym_enable(sym.$('buttonHelpBoson'));sym_enable(sym.$('buttonHelpFermion'));sym_enable(sym.$('buttonDiagramHelp'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_TRU_div}","click touchstart",function(sym,e){window.open('http://www.tru.ca','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonHelpNumber}","click touchstart",function(sym,e){sym.$('buttonClose').show();sym.$('.showingText').hide();sym.$('.showingText').removeClass('showingText');sym.$('numberText').addClass('showingText');sym.$('numberText').show();sym_enable(sym.$('buttonEnergyHelp'));sym_enable(sym.$('buttonHelpBoson'));sym_disable(sym.$('buttonHelpNumber'));sym_enable(sym.$('buttonHelpFermion'));sym_enable(sym.$('buttonDiagramHelp'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_buttonSetNewCh}","click touchstart",function(sym,e){setChallengeQuestions();sym_step(1);});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrewsCopy}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank');});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",11000,function(sym,e){sym.stop();sym_step(1);});
//Edge binding end
})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'fancyExcellent'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().$('fancyExcellent').hide();sym.stop(0);});
//Edge binding end
})("fancyExcellent");
//Edge symbol end:'fancyExcellent'
})(jQuery,AdobeEdge,"EDGE-19890435");