/*  Copyright 2015, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
*/

(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var streaming=false;var stepN=0;var multiple=false;function debug(value){$('#Stage_debug').text(value);}
function step_functions(step){clearTimeout(AdobeEdge.step_animation);switch(step){case 1:stepN=1;AdobeEdge.getComposition(compId).getStage().getSymbol('#Stage_steps').getSymbol('xzSwitchSymbol3').play(0);$('#Stage_observedProbabilityPositive').text(' ');$('#Stage_observedProbabilityNegative').text(' ');$('#Stage_negativeMeasurementText').text('0');$('#Stage_positiveMeasurementText').text('0');$('#Stage_totalMeasurementText').text('0');sym_select($('#Stage_Input1'));break;case 2:stepN=2;AdobeEdge.getComposition(compId).getStage().getSymbol('#Stage_steps').getSymbol('xzSwitchSymbol3').play(0);sym_select($('#Stage_Input2'));break;case 3:stepN=3;AdobeEdge.getComposition(compId).getStage().getSymbol('#Stage_steps').getSymbol('xzSwitchSymbol3').play(0);sym_select($('#Stage_Input3'));break;case 4:stepN=4;AdobeEdge.getComposition(compId).getStage().getSymbol('#Stage_steps').getSymbol('xzSwitchSymbol3').play(0);sym_select($('#Stage_Input3'));break;case 5:stepN=5;AdobeEdge.getComposition(compId).getStage().getSymbol('#Stage_steps').getSymbol('xzSwitchSymbol3').play(0);sym_select($('#Stage_Input4'));break;}}
var n_input=1;var n_input_saved=1;function N(){if($('#Stage_zButton').hasClass('selected')){if($('#Stage_Input1').hasClass('selected')){n_input=1}
if($('#Stage_Input2').hasClass('selected')){n_input=2}
if($('#Stage_Input3').hasClass('selected')){n_input=3}
if($('#Stage_Input4').hasClass('selected')){n_input=4}
if($('#Stage_Input5').hasClass('selected')){n_input=5}
if($('#Stage_Input6').hasClass('selected')){n_input=6}}
else{if($('#Stage_Input1').hasClass('selected')){n_input=7}
if($('#Stage_Input2').hasClass('selected')){n_input=8}
if($('#Stage_Input3').hasClass('selected')){n_input=9}
if($('#Stage_Input4').hasClass('selected')){n_input=10}
if($('#Stage_Input5').hasClass('selected')){n_input=11}
if($('#Stage_Input6').hasClass('selected')){n_input=12}}}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .movable').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
$('#Stage .movable').each(function(){if(!$(this).attr('class').match(/minX_(\d+)/))var minX=1;else var minX=$(this).attr('class').match(/minX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxX_\d+/))var maxX=899;else var maxX=$(this).attr('class').match(/maxX_(\d+)/)[1]*1;if(!$(this).attr('class').match(/minY_\d+/))var minY=41;else var minY=$(this).attr('class').match(/minY_(\d+)/)[1]*1;if(!$(this).attr('class').match(/maxY_\d+/))var maxY=589;else var maxY=$(this).attr('class').match(/maxY_(\d+)/)[1]*1;$(this).data('minX',minX);$(this).data('maxX',maxX);$(this).data('minY',minY);$(this).data('maxY',maxY);});if(!$('#Stage').data('movable_events')){$('#Stage').data('movable_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var movable=$('#Stage .movable.active');if(movable.hasClass('movable')){if(movable.data('minX')>=0||movable.data('minX')<0){e.preventDefault();var tempX=0;var tempY=0;if(e.type=='mousedown'||e.type=='mousemove'){if(!e.pageX){tempX=e.clientX+document.body.scrollLeft;tempY=e.clientY+document.body.scrollTop;}else{tempX=e.pageX;tempY=e.pageY;}}else{tempX=e.originalEvent.touches[0].pageX;tempY=e.originalEvent.touches[0].pageY;}
if(e.type=='mousedown'||e.type=='touchstart'){movable.data('x0',tempX);movable.data('y0',tempY);movable.data('xStart',parseInt(movable.css('left')));movable.data('yStart',parseInt(movable.css('top')));}
var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;var newX=movable.data('xStart')+(tempX-movable.data('x0'))/scale;var newY=movable.data('yStart')+(tempY-movable.data('y0'))/scale;newX=Math.min(Math.max(newX,movable.data('minX')),movable.data('maxX')-movable.width());newY=Math.min(Math.max(newY,movable.data('minY')),movable.data('maxY')-movable.height());movable.css('left',Math.round(newX));movable.css('top',Math.round(newY));movable.data('xPos',Math.round(newX));movable.data('yPos',Math.round(newY));}}});$(document).on('mouseup touchend',function(e){$('#Stage .movable.active').addClass('unActive');$('#Stage .movable.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').remove();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('movable')){$(element).css('cursor','pointer');$(element).on('mouseover mouseup',function(){});$(element).on('mousedown touchstart',function(){$(this).addClass('active');});$(element).on('mouseout touchend',function(){});}}
function sym_disable(element){if(!$(element).hasClass('disabled')){$(element).addClass('disabled');if(!$(element).hasClass('movable'))
$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();sym.$('.disabled').each(function(){$(this).removeClass('disabled');sym_disable(this);});yepnope({load:"normalize.css"});var probabilities=[1,0,0.5,0.5,0.2,0.2,0.5,0.5,0.5,1,0.5,0.9];var nTots=[0,0,0,0,0,0,0,0,0,0,0,0];var nPluss=[0,0,0,0,0,0,0,0,0,0,0,0];var measurementAccuracys=[0,0,0,0,0,0,0,0,0,0,0,0];var nTot=0;var nPlus=0;var nMinus=0;sym.sendParticle=function(){nTot++;nTots[n_input-1]++;var wentUp=Math.random()<probabilities[n_input-1];if(wentUp){nPlus++;nPluss[n_input-1]++;if(multiple==false){if($('#Stage_zButton').hasClass('selected')){sym.getSymbol('blueFlashZ').stop(0);sym.getSymbol('blueFlash2Z').stop(0);sym.getSymbol('greenFlashZ').play(0);sym.getSymbol('greenFlash2Z').play(0);}
else{sym.getSymbol('blueFlashX').stop(0);sym.getSymbol('blueFlash2Z').stop(0);sym.getSymbol('greenFlashX').play(0);sym.getSymbol('greenFlash2Z').play(0);}}}else{nMinus++;if(multiple==false){if($('#Stage_zButton').hasClass('selected')){sym.getSymbol('blueFlashZ').play(0);sym.getSymbol('blueFlash2Z').play(0);sym.getSymbol('greenFlashZ').stop(0);sym.getSymbol('greenFlash2Z').stop(0);}
else{sym.getSymbol('blueFlashX').play(0);sym.getSymbol('blueFlash2Z').play(0);sym.getSymbol('greenFlashX').stop(0);sym.getSymbol('greenFlash2Z').stop(0);}}}
if(multiple==false){if(n_input==1||n_input==7){sym.getSymbol('inputUp').play(0);sym.getSymbol('inputDown').stop(0);sym.getSymbol('inputSuperposition').stop(0);sym.getSymbol('inputQuestion1').stop(0);sym.getSymbol('inputQuestion2').stop(0);}
if(n_input==2||n_input==8){sym.getSymbol('inputDown').play(0);sym.getSymbol('inputUp').stop(0);sym.getSymbol('inputSuperposition').stop(0);sym.getSymbol('inputQuestion1').stop(0);sym.getSymbol('inputQuestion2').stop(0);}
if(n_input==3){if(wentUp){sym.getSymbol('inputUp').play(0);sym.getSymbol('inputDown').stop(0);sym.getSymbol('inputSuperposition').stop(0);sym.getSymbol('inputQuestion1').stop(0);sym.getSymbol('inputQuestion2').stop(0);}
else{sym.getSymbol('inputUp').stop(0);sym.getSymbol('inputDown').play(0);sym.getSymbol('inputSuperposition').stop(0);sym.getSymbol('inputQuestion1').stop(0);sym.getSymbol('inputQuestion2').stop(0);}}
if(n_input==9){var wentUp2=Math.random()<0.5;if(wentUp2){sym.getSymbol('inputUp').play(0);sym.getSymbol('inputDown').stop(0);sym.getSymbol('inputSuperposition').stop(0);sym.getSymbol('inputQuestion1').stop(0);sym.getSymbol('inputQuestion2').stop(0);}
else{sym.getSymbol('inputUp').stop(0);sym.getSymbol('inputDown').play(0);sym.getSymbol('inputSuperposition').stop(0);sym.getSymbol('inputQuestion1').stop(0);sym.getSymbol('inputQuestion2').stop(0);}}
if(n_input==4||n_input==10){sym.getSymbol('inputSuperposition').play(0);sym.getSymbol('inputUp').stop(0);sym.getSymbol('inputDown').stop(0);sym.getSymbol('inputQuestion1').stop(0);sym.getSymbol('inputQuestion2').stop(0);}
if(n_input==5||n_input==11){sym.getSymbol('inputUp').stop(0);sym.getSymbol('inputDown').stop(0);sym.getSymbol('inputSuperposition').stop(0);sym.getSymbol('inputQuestion1').play(0);sym.getSymbol('inputQuestion2').stop(0);}
if(n_input==6||n_input==12){sym.getSymbol('inputUp').stop(0);sym.getSymbol('inputDown').stop(0);sym.getSymbol('inputSuperposition').stop(0);sym.getSymbol('inputQuestion1').stop(0);sym.getSymbol('inputQuestion2').play(0);}}
sym.checkMeasurementAccuracy();}
sym.startStream=function(){streaming=true;sym_disable(sym.$('singleButton'));sym_disable(sym.$('fastForwardButton'));sym.$('continousButtonLabel').text('Stop Messungen');sym.sendParticle();sym.updateDisplays();}
sym.continueStream=function(){if(streaming){sym.sendParticle();sym.updateDisplays();}}
sym.stopStream=function(){streaming=false;sym_enable(sym.$('singleButton'));sym_enable(sym.$('fastForwardButton'));sym.$('continousButtonLabel').text('Kontinuierliche Messungen');}
sym.updateDisplays=function(){sym.displayNs();sym.updateHistogram();sym.updateLikelyOutcome();sym.updateProbabilities();sym.toggleMeasurementsText();}
sym.displayNs=function(){sym.$('totalMeasurementText').text(nTot);sym.$('positiveMeasurementText').text(nPlus);sym.$('positiveOutcomeText').text((nPlus/nTot).toFixed(3));sym.$('negativeMeasurementText').text(nMinus);sym.$('negativeOutcomeText').text((nMinus/nTot).toFixed(3));}
sym.updateLikelyOutcome=function(){sym.$('negativeLikelyOutcome').hide();sym.$('positiveLikelyOutcome').hide();sym.$('equallyLikely').hide();if(probabilities[n_input-1]<0.5){sym.$('negativeLikelyOutcome').show();}else if(probabilities[n_input-1]>0.5){sym.$('positiveLikelyOutcome').show();}else{sym.$('equallyLikely').show();}}
sym.updateHistogram=function(){if(nTot!=0){var positivePercentage=nPlus/(nTot);var negativePercentage=nMinus/(nTot);if(n_input!=5&&n_input!=6&&n_input!=11&&n_input!=12){sym.$('positiveOutcomeBar').show();sym.$('negativeOutcomeBar').show();}}
else{var positivePercentage=0;var negativePercentage=0;sym.$('positiveOutcomeBar').hide();sym.$('negativeOutcomeBar').hide();}
var positiveLength=positivePercentage*200;sym.$('positiveBar').css({'width':(nTot==0?0:positiveLength)});var negativeLength=negativePercentage*200;sym.$('negativeBar').css({'width':(nTot==0?0:negativeLength)});sym.$('positiveOutcomeBar').parent().css({position:'relative'});sym.$('positiveOutcomeBar').css({left:(probabilities[n_input-1]*200),position:'absolute'});sym.$('negativeOutcomeBar').parent().css({position:'relative'});sym.$('negativeOutcomeBar').css({left:((1-probabilities[n_input-1])*200),position:'absolute'});}
sym.updateProbabilities=function(){if(nTot!=0){sym.$('observedProbabilityPositive').text((nPlus/nTot).toFixed(3));sym.$('observedProbabilityNegative').text((nMinus/nTot).toFixed(3));}
else{sym.$('observedProbabilityPositive').text(' ');sym.$('observedProbabilityNegative').text(' ');}}
sym.toggleMeasurementsText=function(){if(measurementAccuracy>5){sym.$('moreMeasurementsText').hide();}else{sym.$('moreMeasurementsText').show();}}
sym.checkMeasurementAccuracy=function(){if(probabilities[n_input-1]==1||probabilities[n_input-1]==0){if(measurementAccuracy<6){measurementAccuracy+=((Math.abs((nPlus-nMinus)/(2*nTot)-(probabilities[n_input-1]-0.5))<0.02)?1:(0-measurementAccuracy));measurementAccuracys[n_input-1]+=((Math.abs((nPlus-nMinus)/(2*nTot)-(probabilities[n_input-1]-0.5))<0.02)?1:(0-measurementAccuracy));}}
else{if(measurementAccuracy<6&&nTot>494){measurementAccuracy+=((Math.abs((nPlus-nMinus)/(2*nTot)-(probabilities[n_input-1]-0.5))<0.02)?1:(0-measurementAccuracy));measurementAccuracys[n_input-1]+=((Math.abs((nPlus-nMinus)/(2*nTot)-(probabilities[n_input-1]-0.5))<0.02)?1:(0-measurementAccuracy));}}
sym.toggleMeasurementsText();}
sym.clearValues=function(){nTots[n_input-1]=0;nPluss[n_input-1]=0;measurementAccuracys[n_input-1]=0;sym.resetValues();}
sym.resetValues=function(){nTot=nTots[n_input-1];nPlus=nPluss[n_input-1];nMinus=nTot-nPlus;measurementAccuracy=measurementAccuracys[n_input-1];if(measurementAccuracy<=5||nTot<500){sym.$('moreMeasurementsText').show();}
sym.updateDisplays();if(nTot==0){sym.$('positiveOutcomeText').text('');sym.$('negativeOutcomeText').text('');sym.$('observedProbabilityPositive').text(' ');sym.$('observedProbabilityNegative').text(' ');}
if(n_input==1||n_input==2||n_input==3||n_input==4||n_input==7||n_input==8||n_input==9||n_input==10){sym.$('theoreticalProbabilityPositive').text(probabilities[n_input-1]);sym.$('theoreticalProbabilityNegative').text((1-probabilities[n_input-1]).toFixed(1));}else{if(n_input==5||n_input==11){sym.$('theoreticalProbabilityPositive').text('?');sym.$('theoreticalProbabilityNegative').text('?');}
else{sym.$('theoreticalProbabilityPositive').text('??');sym.$('theoreticalProbabilityNegative').text('??');};}
debug(n_input);if(n_input==1||n_input==2||n_input==3||n_input==4||n_input==7||n_input==8||n_input==9||n_input==10){sym_disable($('#Stage_hintButton'));sym.$('likelyTextRectangle').show();}
else{sym_enable($('#Stage_hintButton'));sym.$('negativeOutcomeBar').hide();sym.$('positiveOutcomeBar').hide();sym.$('likelyTextRectangle').hide();}
if($('#Stage_zButton').hasClass('selected')){$('#Stage_ProbObserved').html('Beobachteter Wert S<sub>z</sub>');$('#Stage_OutcomePlus').html('Messwert S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');$('#Stage_OutcomeMinus').html('Messwert S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_diagramCopy').show();$('#Stage_diagram90').hide();$('#Stage_TextPlus2').show();$('#Stage_TextPlus3').hide();$('#Stage_TextMinus2').show();$('#Stage_TextMinus3').hide();}
else{$('#Stage_ProbObserved').html('Beobachtet S<sub>x</sub>');$('#Stage_OutcomePlus').html('Messwert S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');$('#Stage_OutcomeMinus').html('Messwert S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_diagramCopy').hide();$('#Stage_diagram90').show();$('#Stage_TextPlus2').hide();$('#Stage_TextPlus3').show();$('#Stage_TextMinus2').hide();$('#Stage_TextMinus3').show();}
sym.stopStream();sym.getSymbol('greenFlashZ').stop(0);sym.getSymbol('greenFlash2Z').stop(0);sym.getSymbol('blueFlashZ').stop(0);sym.getSymbol('blueFlash2Z').stop(0);sym.getSymbol('greenFlashX').stop(0);sym.getSymbol('blueFlashX').stop(0);sym.getSymbol('inputUp').stop(0);sym.getSymbol('inputDown').stop(0);sym.getSymbol('inputSuperposition').stop(0);sym.getSymbol('inputQuestion1').stop(0);sym.getSymbol('inputQuestion2').stop(0);}
sym.hideIfNotSelected=function(){if(sym.$('showProbabilitiesCheckbox').hasClass('selected')){sym.$('ProbabilitiesBox').show()}
else sym.$('ProbabilitiesBox').hide();if(sym.$('showGraphCheckbox').hasClass('selected')){sym.$('outcomeHistogram').show()}
else sym.$('outcomeHistogram').hide();}
$('#Stage_TextMinus').html('&#8211;');$('#Stage_button_labelCopy5').html('Messungen zur&uuml;cksetzen');$('#Stage_IntroText2').html('Misst man also in z-Richtung, so hat der obere Strahl eine Spinkomponente von +&#295;/2 (wobei &#295;=h/2&#960; und h das Planck’sche Wirkungsquantum ist) und der untere Strahl eine von &#8211;&#295;/2. Wir bezeichnen die Eigenzustände der <span style="white-space: nowrap;">z-Messung</span> mit |&#8593;&#x232A; und |&#8595;&#x232A;. ');$('#Stage_IntroText3').html('In der Simulation kannst du verschiedene Eingangszustände wählen. Hier stehen dir einerseits reine Zustände, wie die besagten Eigenzustände und der Superpositionszustand <span style="white-space: nowrap;">1/&radic;<span style="text-decoration: overline">2</span>(|&#8593;&#x232A;+|&#8595;&#x232A;)</span> zur Verfügung, andererseits auch gemischte Zustände, wie die gleichmäßige Mischung von |&#8593;&#x232A; und |&#8595;&#x232A;.');$('#Stage_IntroText4').html('<b>Dein Ziel ist es, für zwei unbekannte Zustände durch Messen zu entscheiden, ob es sich um reine oder gemischte Zustände handelt. </b> Drücke auf „Los geht’s!“, um den Eingangszustand und die Ausrichtung des SGAs zu wählen. Wähle „Anleitung“ für eine Schritt-für-Schritt Erklärung.');$('#Stage_LegendInput1').html('Spin-Zustand mit S<sub>z</sub> = +&#295;/2');$('#Stage_LegendInput2').html('Spin-Zustand mit S<sub>z</sub> = &#8211;&#295;/2');$('#Stage_TextInput1').html('|&#8593;&#x232A;');$('#Stage_TextInput2').html('|&#8595;&#x232A;');$('#Stage_TextInput3').html('50% |&#8593;&#x232A;, 50% |&#8595;&#x232A;');$('#Stage_TextInput4').html('1/&radic;<span style="text-decoration: overline">2</span>  (|&#8593;&#x232A+|&#8595;&#x232A)');$('#Stage_TextInput5').html('Rein oder gemischt?');$('#Stage_TextInput6').html('Rein oder gemischt??');$('#Stage_OutcomePlus').html('Messwert S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');$('#Stage_OutcomeMinus').html('Messwert S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_TotalMeasurements').html('Gesamtanzahl der Messungen: N<sub>tot</sub> = ');$('#Stage_ProbObserved').html('Beobachtet S<sub>z</sub>');$('#Stage_ProbUp').html('+&#295;/2: &nbsp;&nbsp;Prob<sub>+</sub> = N<sub>+</sub>/N<sub>tot</sub> =');$('#Stage_ProbDown').html('&#8211;&#295;/2: &nbsp;&nbsp;Prob<sub>&#8211;</sub> = N<sub>&#8211;</sub>/N<sub>tot</sub> =');$('#Stage_negativeLikelyOutcome').html('Wahrscheinlichster theoretischer Messwert einer Einzelmessung: <b>&#8211;&#295;/2</b>');$('#Stage_positiveLikelyOutcome').html('Wahrscheinlichster theoretischer Messwert einer Einzelmessung: <b>+&#295;/2</b>');$('#Stage_helpText').html('Der Zustand ist entweder ein reiner Zustand, der sich als a<sub>Z</sub>|&#8593;&#x232A; + b<sub>Z</sub> |&#8595;&#x232A;  mit a<sub>Z</sub><sup>2</sup>+b<sub>Z</sub><sup>2</sup> = 1 schreiben lässt, oder eine Mischung der Zustände  |&#8593;&#x232A; und |&#8595;&#x232A;.  Du brauchst beide Messrichtungen des SGAs.');$('#Stage_h2Positive').html('+&#295;/2');$('#Stage_h2Negative').html('&#8211;&#295;/2');$('#Stage_crossText').html('&#10005;');sym.getSymbol('#Stage_inputUp').$('TextUp').html('|&#8593;&#x232A;');sym.getSymbol('#Stage_inputDown').$('TextUp').html('|&#8595;&#x232A;');sym.getSymbol('#Stage_inputSuperposition').$('TextUp').html('1/&radic;<span style="text-decoration: overline">2</span>  (|&#8593;&#x232A+|&#8595;&#x232A)');sym.getSymbol('#Stage_inputQuestion1').$('TextUp').html('?');sym.getSymbol('#Stage_inputQuestion2').$('TextUp').html('??');sym.getSymbol('#Stage_steps').$('text1').html('Der Zustand |&#8593;&#x232A;  ist ein Eigenzustand von S<sub>z</sub>. Das bedeutet, dass bei einer Messung in z-Richtung immer nur das Ergebnis +&#295;/2 auftreten kann. Dies nennt man auch ein deterministisches Ergebnis. In x-Richtung hingegen sind die Ergebnisse völlig zufällig. Messungen in x&#8211; und z&#8211;Richtung in einem SGA sind komplementär zueinander; es gibt keinen Zustand, der sowohl für x&#8211; als auch für z&#8211;Messungen deterministische Ergebnisse liefert.');sym.getSymbol('#Stage_steps').$('text2').html('Der Zustand |&#8595;&#x232A; ist Eigenzustand von S<sub>z</sub> zum Eigenwert &#8211;&#295;/2. Auch hier sind Messungen in z-Richtung deterministisch und in x-Richtung völlig zufällig. Beachte, dass die Eigenzustände von z auch als Superposition der Eigenzustände von x geschrieben werden können. Wenn wir den Eigenzustand von x zum Eigenwert +&#295;/2  mit  |+&#x232A;  bezeichnen und den zum Eigenwert &#8211;&#295;/2  mit |&#8211;&#x232A;, so ergibt sich <span style="white-space: nowrap;">|&#8593;&#x232A; = 1/&radic;<span style="text-decoration: overline">2</span>(|+&#x232A; + |&#8211;&#x232A;)</span> und <span style="white-space: nowrap;">|&#8595;&#x232A; = 1/&radic;<span style="text-decoration: overline">2</span>(|+&#x232A; &#8211; |&#8211;&#x232A;)</span>.');sym.getSymbol('#Stage_steps').$('text3').html('Wenn man vor jeder Messung zufällig wählt, ob man den Zustand |&#8593;&#x232A; oder |&#8595;&#x232A; losschickt, erhält man einen maximal gemischten Zustand. Für diesen sind sowohl die Ergebnisse bei einer z-Messung als auch bei einer x-Messung zufällig. In der Simulation wird zur besseren Ansicht links angezeigt, ob jeweils |&#8593;&#x232A; oder |&#8595;&#x232A; präpariert wurde. In einem echten Experiment hat man diese Information normalerweise nicht.  Überlege dir, wie man aus den Wahrscheinlichkeiten der Messwerte für die Zustände |&#8593;&#x232A; und |&#8595;&#x232A; auf die der Mischung schließen kann.');sym.getSymbol('#Stage_steps').$('text4').html('Bei der Durchführung des Experiments werden die beobachteten Wahrscheinlichkeiten angezeigt. Nimmt man immer mehr Daten auf, so nähern sich diese Werte immer mehr dem asymptotischen (theoretischen) Wahrscheinlichkeiten an.  ');sym.getSymbol('#Stage_steps').$('text5').html('Du kannst als Eingangszustand die Superposition  <span style="white-space: nowrap;">|+&#x232A; = 1/&radic;<span style="text-decoration: overline">2</span>(|&#8593;&#x232A;+|&#8595;&#x232A;)</span> wählen. Auch dies ist ein reiner Zustand, nämlich gerade ein Eigenzustand der x-Messung.Überlege dir, wie du experimentell einen gemischten von einem reinen Zustand im gegebenen Experiment unterscheiden kannst. Reichen die gegebenen Messungen aus, um eine eindeutige Unterscheidung zu treffen? ');sym_select($('#Stage_Input1'));sym_select($('#Stage_zButton'));sym_disable(sym.$('hintButton'));sym.$('#Stage_hintRectangle').hide();sym.clearValues();sym.$('negativeBar').css({'background':'#7db9e8','background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzdkYjllOCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjUyJSIgc3RvcC1jb2xvcj0iIzFlNTc5OSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM3ZGI5ZTgiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)','background':'-moz-linear-gradient(top,  #7db9e8 0%, #1e5799 52%, #7db9e8 100%)','background':'-webkit-gradient(linear, left top, left bottom, color-stop(0%,#7db9e8), color-stop(52%,#1e5799), color-stop(100%,#7db9e8))','background':'-webkit-linear-gradient(top,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','background':'-o-linear-gradient(top,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','background':'-ms-linear-gradient(top,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','background':'linear-gradient(to bottom,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','filter':'progid:DXImageTransform.Microsoft.gradient( startColorstr=#7db9e8, endColorstr=#7db9e8,GradientType=0 )',});sym.$('positiveBar').css({'background':'#88ea91','background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzg4ZWE5MSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjUwJSIgc3RvcC1jb2xvcj0iIzAwZDMwMCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjUzJSIgc3RvcC1jb2xvcj0iIzAwZDMwMCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM4OGVhOTEiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)','background':'-moz-linear-gradient(top,  #88ea91 0%, #00d300 50%, #00d300 53%, #88ea91 100%)','background':'-webkit-gradient(linear, left top, left bottom, color-stop(0%,#88ea91), color-stop(50%,#00d300), color-stop(53%,#00d300), color-stop(100%,#88ea91))','background':'-webkit-linear-gradient(top,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','background':'-o-linear-gradient(top,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','background':'-ms-linear-gradient(top,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','background':'linear-gradient(to bottom,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','filter':'progid:DXImageTransform.Microsoft.gradient( startColorstr=#88ea91, endColorstr=#88ea91,GradientType=0 )',});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){sym.stop('controls');$('#Stage .radio').each(function(){sym_enable($(this));});$('#Stage .button').each(function(){sym_enable($(this));});sym_enable(sym.$('showProbabilitiesCheckbox'));sym_enable(sym.$('controlsButtonCopy3'));sym_enable(sym.$('clearMeasurementsButton'));sym_enable(sym.$('showGraphCheckbox'));sym.getSymbol('#Stage_steps').getSymbol('xzSwitchSymbol3').stop(0);sym.hideIfNotSelected();sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);if(n_input>6){sym_select(sym.$('xButton'));sym_select(sym.$('Input'+(n_input-6)));}
else{sym_select(sym.$('zButton'));sym_select(sym.$('Input'+(n_input)));}
sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_explanation}","click",function(sym,e){sym.stop('explanation');sym_features();sym.resetValues();sym_step(1);sym_select(sym.$('Input1'));sym_select(sym.$('zButton'));$('#Stage .radio').each(function(){sym_disable($(this));});$('#Stage .button').each(function(){sym_disable($(this));});sym_disable(sym.$('showProbabilitiesCheckbox'));sym_disable(sym.$('showGraphCheckbox'));});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_controlsButton}","click",function(sym,e){sym.stop('controls');sym.hideIfNotSelected();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_hintButton}","click",function(sym,e){sym.$('#Stage_hintRectangle').show();sym.$('#Stage_DisplayControlsBox').hide();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_hintButtonCopy}","click",function(sym,e){sym.$('hintRectangle').hide();sym.$('#Stage_DisplayControlsBox').show();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_st_andrewsCopy2}","click",function(sym,e){window.open('http://www.st-andrews.ac.uk/physics/quvis','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_quantumphysicsCopy}","click",function(sym,e){window.open('http://quantumphysics.iop.org','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_link_iopCopy}","click",function(sym,e){window.open('http://www.iop.org','_blank');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_controlsButtonCopy3}","click",function(sym,e){sym.stop('intro');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_clearMeasurementsButton}","click",function(sym,e){sym.clearValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_Input1}","click",function(sym,e){N();sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_Input2}","click",function(sym,e){N();sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_Input3}","click",function(sym,e){N();sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_Input4}","click",function(sym,e){N();sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_Input5}","click",function(sym,e){N();sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_Input6}","click",function(sym,e){N();sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_xButton}","click",function(sym,e){N();sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_zButton}","click",function(sym,e){N();sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_showProbabilitiesCheckbox}","click",function(sym,e){sym.hideIfNotSelected();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_showGraphCheckbox}","click",function(sym,e){sym.hideIfNotSelected();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_singleButton}","click",function(sym,e){N();sym.sendParticle(n_input);sym.updateDisplays();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_continuosButton}","click",function(sym,e){N();if(!streaming){sym.startStream(n_input);}else{sym.stopStream();}});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_fastForwardButton}","click",function(sym,e){N();multiple=true;for(var i=0;i<99;i++){sym.sendParticle();}
multiple=false;sym.sendParticle();sym.updateDisplays()});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'highlight'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight2");
//Edge symbol end:'highlight2'

//=========================================================

//Edge symbol: 'blueFlash'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
})("blueFlash");
//Edge symbol end:'blueFlash'

//=========================================================

//Edge symbol: 'greenFlash'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
})("greenFlash");
//Edge symbol end:'greenFlash'

//=========================================================

//Edge symbol: 'equations'
(function(symbolName){})("equations");
//Edge symbol end:'equations'

//=========================================================

//Edge symbol: 'blueFlashGap'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
})("blueFlashGap");
//Edge symbol end:'blueFlashGap'

//=========================================================

//Edge symbol: 'greenFlashGap'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
})("greenFlashGap");
//Edge symbol end:'greenFlashGap'

//=========================================================

//Edge symbol: 'blueFlash_1'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
})("blueFlash_1");
//Edge symbol end:'blueFlash_1'

//=========================================================

//Edge symbol: 'xzSwitchSymbol'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",4500,function(sym,e){sym_select($('#Stage_xButton'));sym_deselect($('#Stage_zButton'));sym.$('#Stage_diagram90').show();sym.$('#Stage_diagramCopy').hide();sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');sym.$('#Stage_ProbObserved').html('Beobachtet S<sub>x</sub>');sym.$('#Stage_OutcomePlus').html('Messwert S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');sym.$('#Stage_OutcomeMinus').html('Messwert S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_TextPlus2').hide();$('#Stage_TextPlus3').show();$('#Stage_TextMinus2').hide();$('#Stage_TextMinus3').show();});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","play",function(sym,e){sym_deselect($('#Stage_xButton'));sym_select($('#Stage_zButton'));sym.$('#Stage_diagram90').hide();sym.$('#Stage_diagramCopy').show();sym.$('#Stage_theoreticalProbabilityNegative').text('0');sym.$('#Stage_theoreticalProbabilityPositive').text('1');$('#Stage_ProbObserved').html('Beobachtet S<sub>z</sub>');$('#Stage_OutcomePlus').html('Messwert S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');$('#Stage_OutcomeMinus').html('Messwert S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_TextPlus2').show();$('#Stage_TextPlus3').hide();$('#Stage_TextMinus2').show();$('#Stage_TextMinus3').hide();});
//Edge binding end
})("xzSwitchSymbol");
//Edge symbol end:'xzSwitchSymbol'

//=========================================================

//Edge symbol: 'xzSwitchSymbol_1'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",4500,function(sym,e){sym_select($('#Stage_xButton'));sym_deselect($('#Stage_zButton'));sym.$('#Stage_diagram90').show();sym.$('#Stage_diagramCopy').hide();sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');sym.$('#Stage_ProbObserved').html('Beobachtet S<sub>x</sub>');sym.$('#Stage_OutcomePlus').html('Messwert S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');sym.$('#Stage_OutcomeMinus').html('Messwert S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_TextPlus2').hide();$('#Stage_TextPlus3').show();$('#Stage_TextMinus2').hide();$('#Stage_TextMinus3').show();});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","play",function(sym,e){sym_deselect($('#Stage_xButton'));sym_select($('#Stage_zButton'));sym.$('#Stage_diagram90').hide();sym.$('#Stage_diagramCopy').show();sym.$('#Stage_theoreticalProbabilityNegative').text('1');sym.$('#Stage_theoreticalProbabilityPositive').text('0');$('#Stage_ProbObserved').html('Beobachtet S<sub>z</sub>');$('#Stage_OutcomePlus').html('Messwert S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');$('#Stage_OutcomeMinus').html('Messwert S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_TextPlus2').show();$('#Stage_TextPlus3').hide();$('#Stage_TextMinus2').show();$('#Stage_TextMinus3').hide();});
//Edge binding end
})("xzSwitchSymbol2");
//Edge symbol end:'xzSwitchSymbol2'

//=========================================================

//Edge symbol: 'xzSwitchSymbol2_1'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",4500,function(sym,e){sym_select($('#Stage_xButton'));sym_deselect($('#Stage_zButton'));sym.$('#Stage_diagram90').show();sym.$('#Stage_diagramCopy').hide();sym.$('#Stage_ProbObserved').html('Beobachtet S<sub>x</sub>');sym.$('#Stage_OutcomePlus').html('Messwert S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');sym.$('#Stage_OutcomeMinus').html('Messwert S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_TextPlus2').hide();$('#Stage_TextPlus3').show();$('#Stage_TextMinus2').hide();$('#Stage_TextMinus3').show();if(stepN==1){sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');}
if(stepN==2){sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');}
if(stepN==3){sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');}
if(stepN==4){sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');}
if(stepN==5){sym.$('#Stage_theoreticalProbabilityNegative').text('0');sym.$('#Stage_theoreticalProbabilityPositive').text('1');}});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","play",function(sym,e){sym_deselect($('#Stage_xButton'));sym_select($('#Stage_zButton'));sym.$('#Stage_diagram90').hide();sym.$('#Stage_diagramCopy').show();if(stepN==1){sym.$('#Stage_theoreticalProbabilityNegative').text('0');sym.$('#Stage_theoreticalProbabilityPositive').text('1');}
if(stepN==2){sym.$('#Stage_theoreticalProbabilityNegative').text('1');sym.$('#Stage_theoreticalProbabilityPositive').text('0');}
if(stepN==3){sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');}
if(stepN==4){sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');}
if(stepN==5){sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');}
$('#Stage_ProbObserved').html('Beobachtet S<sub>z</sub>');$('#Stage_OutcomePlus').html('Messwert S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');$('#Stage_OutcomeMinus').html('Messwert S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_TextPlus2').show();$('#Stage_TextPlus3').hide();$('#Stage_TextMinus2').show();$('#Stage_TextMinus3').hide();});
//Edge binding end
})("xzSwitchSymbol3");
//Edge symbol end:'xzSwitchSymbol3'

//=========================================================

//Edge symbol: 'xzSwitchSymbol3_1'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",4500,function(sym,e){sym_select($('#Stage_xButton'));sym_deselect($('#Stage_zButton'));sym.$('#Stage_diagram90').show();sym.$('#Stage_diagramCopy').hide();sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');sym.$('#Stage_ProbObserved').html('Beobachtet S<sub>x</sub>');sym.$('#Stage_OutcomePlus').html('Messwert S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');sym.$('#Stage_OutcomeMinus').html('Messwert S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_TextPlus2').hide();$('#Stage_TextPlus3').show();$('#Stage_TextMinus2').hide();$('#Stage_TextMinus3').show();});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","play",function(sym,e){sym_deselect($('#Stage_xButton'));sym_select($('#Stage_zButton'));sym.$('#Stage_diagram90').hide();sym.$('#Stage_diagramCopy').show();sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');$('#Stage_ProbObserved').html('Beobachtet S<sub>z</sub>');$('#Stage_OutcomePlus').html('Messwert S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');$('#Stage_OutcomeMinus').html('Messwert S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_TextPlus2').show();$('#Stage_TextPlus3').hide();$('#Stage_TextMinus2').show();$('#Stage_TextMinus3').hide();});
//Edge binding end
})("xzSwitchSymbol4");
//Edge symbol end:'xzSwitchSymbol4'

//=========================================================

//Edge symbol: 'xzSwitchSymbol4_1'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",4500,function(sym,e){sym_select($('#Stage_xButton'));sym_deselect($('#Stage_zButton'));sym.$('#Stage_diagram90').show();sym.$('#Stage_diagramCopy').hide();sym.$('#Stage_theoreticalProbabilityNegative').text('1');sym.$('#Stage_theoreticalProbabilityPositive').text('0');sym.$('#Stage_ProbObserved').html('Beobachtet S<sub>x</sub>');sym.$('#Stage_OutcomePlus').html('Messwert S<sub>x</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');sym.$('#Stage_OutcomeMinus').html('Messwert S<sub>x</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_TextPlus2').hide();$('#Stage_TextPlus3').show();$('#Stage_TextMinus2').hide();$('#Stage_TextMinus3').show();});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","play",function(sym,e){sym_deselect($('#Stage_xButton'));sym_select($('#Stage_zButton'));sym.$('#Stage_diagram90').hide();sym.$('#Stage_diagramCopy').show();sym.$('#Stage_theoreticalProbabilityNegative').text('0.5');sym.$('#Stage_theoreticalProbabilityPositive').text('0.5');$('#Stage_ProbObserved').html('Beobachtet S<sub>z</sub>');$('#Stage_OutcomePlus').html('Messwert S<sub>z</sub> = +&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>+</sub> = ');$('#Stage_OutcomeMinus').html('Messwert S<sub>z</sub> = &#8211;&#295;/2:&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> = ');$('#Stage_TextPlus2').show();$('#Stage_TextPlus3').hide();$('#Stage_TextMinus2').show();$('#Stage_TextMinus3').hide();});
//Edge binding end
})("xzSwitchSymbol5");
//Edge symbol end:'xzSwitchSymbol5'

//=========================================================

//=========================================================

//Edge symbol: 'highlight'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight");
//Edge symbol end:'highlight'
})(jQuery,AdobeEdge,"EDGE-19890435");