/*  Copyright 2015, University of St Andrews QuVis Interactive Simulations
jQuery JavaScript Library v2.0.n Copyright 2005, 2013 jQuery Foundation, Inc. and other contributors http://jquery.com/ Released under the MIT license http://jquery.org/license
edge Adobe Edge Animate JavaScript Library v3.0 Copyright 2014 Adobe Systems Inc. and its licensors. Released under the CC BY-NC-SA license, creativecommons.org/licenses   
fastclick.js Version: 1.0.6 Copyright (c) 2014 The Financial Times Ltd. https://github.com/ftlabs/fastclick Released under the MIT license https://github.com/ftlabs/fastclick/blob/master/LICENSE
normalize.css v3 Copyright (c) Nicolas Gallagher and Jonathan Neal https://github.com/necolas/normalize.css Released under the MIT license https://github.com/necolas/normalize.css/blob/master/LICENSE.md
*/

(function($,Edge,compId){var Composition=Edge.Composition,Symbol=Edge.Symbol;var currentEquation=1;var oldEquation=1;var streaming=false;function step_functions(step){clearTimeout(AdobeEdge.step_animation);switch(step){case 1:break;}}
function sym_features(){$('#Stage').css({'-webkit-user-select':'none','-moz-user-select':'none','-ms-user-select':'none','user-select':'none'});if(sym_ie()==9){makeUnselectable($('#Stage')[0]);function makeUnselectable(node){if(node.nodeType==1)node.setAttribute("unselectable","on");var child=node.firstChild;while(child){makeUnselectable(child);child=child.nextSibling;}}}
if(!$('#Stage').data('link_areas')){$('#Stage').data('link_areas',true);$('#Stage_links').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});}
$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox, .radio .tickbox div').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});$('#Stage .slider').not('.vertical').children().children().css({'width':'100%','border-top-color':'#575E62','border-right-color':'#8C9295','border-bottom-color':'#AEB2B4','border-left-color':'#8C9295'});$('#Stage .slider.vertical').children().children().css({'height':'100%','border-top-color':'#8C9295','border-right-color':'#575E62','border-bottom-color':'#8C9295','border-left-color':'#AEB2B4'});var is_chrome=navigator.userAgent.toLowerCase().indexOf('chrome')>-1;if(is_chrome){$('#Stage .slider').each(function(){var webkit_origin=$(this).find('.handle')[0].style.webkitTransformOrigin;$(this).find('.handle')[0].style.transformOrigin=webkit_origin;});}
$(function(){FastClick.attach(document.body);});if(sym_ie()==9){$('#Stage').find('.button > div, .checkbox .tickbox, .radio .tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});$('#Stage .radio .tickbox div').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPHJhZGlhbEdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgY3g9IjUwJSIgY3k9IjUwJSIgcj0iNzUlIj4KICAgIDxzdG9wIG9mZnNldD0iMCUiIHN0b3AtY29sb3I9IiMwMDJkMDAiIHN0b3Atb3BhY2l0eT0iMSIvPgogICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdG9wLWNvbG9yPSIjYmZmZmJmIiBzdG9wLW9wYWNpdHk9IjEiLz4KICA8L3JhZGlhbEdyYWRpZW50PgogIDxyZWN0IHg9Ii01MCIgeT0iLTUwIiB3aWR0aD0iMTAxIiBoZWlnaHQ9IjEwMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});}
$('#Stage').find('*').each(function(){if($(this).css('-webkit-transform')!=''&&$(this).css('-webkit-transform')!='none')
$(this).css('-webkit-transform',$(this).css('-webkit-transform'));});$('#Stage').find('.button, .checkbox, .radio, .slider, .arrowButton').each(function(){if(!$(this).hasClass('disabled'))sym_enable(this)});$('#Stage .disabled').each(function(){sym_disable(this)});$('#Stage').find('.checkbox, .radio').each(function(){if(!$(this).hasClass('selected'))sym_deselect(this)});$('#Stage .selected').each(function(){sym_select(this)});$('#Stage .slider').each(function(){if(!$(this).attr('class').match(/min_(\d+)/))var min=0;else var min=$(this).attr('class').match(/min_(\d+)/)[1]*1;if(!$(this).attr('class').match(/max_\d+/))var max=100;else var max=$(this).attr('class').match(/max_(\d+)/)[1]*1;if(!$(this).attr('class').match(/snap_\d+/))var snap=1;else var snap=$(this).attr('class').match(/snap_(\d+)/)[1]*1;if(!$(this).attr('class').match(/val_\d+/))var val=min;else var val=$(this).attr('class').match(/val_(\d+)/)[1]*1;$(this).data('min',min);$(this).data('max',max);$(this).data('snap',snap);$(this).data('default',val);sym_val(this,$(this).data('val')===undefined?val:$(this).data('val'));});if(!$('#Stage').data('slider_events')){$('#Stage').data('slider_events',true);$(document).on('mousedown mousemove touchstart touchmove',function(e){var slider=$('#Stage .slider.active');if(slider.length){e.preventDefault();var min=slider.data('min');var max=slider.data('max');var snap=slider.data('snap');var range,pos;var scale=$('#Stage').attr('style').match(/scale *\(([0-9\.]+)\)/)[1]*1;if(slider.hasClass('vertical')){range=slider.children().height();pos=-slider.children().offset().top;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageY;else pos+=e.originalEvent.touches[0].pageY;}else{range=slider.children().width();pos=-slider.children().offset().left;if(e.type=='mousedown'||e.type=='mousemove')pos+=e.pageX;else pos+=e.originalEvent.touches[0].pageX;}
pos=Math.min(Math.max(pos,0),range*scale)/scale;var snap_steps=(max-min)/snap;var snap_interval=range/snap_steps;pos=Math.round(pos/snap_interval)*snap_interval;slider.find('.handle').css(slider.hasClass('vertical')?'top':'left',pos+'px');var val=Math.round(min+pos/range*(max-min));slider.data('val',val);}});$(document).on('mouseup touchend',function(e){$('#Stage .slider.active').removeClass('active');});}
if(!$('#Stage').data('step_events')){$('#Stage').data('step_events',true);$('#Stage_steps').children().find('*').each(function(){if($(this).attr('id')&&$(this).attr('id').match(/_highlight_circle$/))
$(this).css({'outline':'transparent solid 1px'});});$('#Stage_steps_step_buttons').children().each(function(){$(this).append('<div id="'+$(this).attr('id')+'_area"></div>');$('#'+$(this).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});});var i=1;while(i){if(!$('#Stage_steps_step'+i).length)break;$('#Stage_steps_step'+i).click(function(){sym_step(this.id.match(/\d+/)*1)});i++;}
$('#Stage').data('step_count',i-1);}}
function sym_enable(element){$(element).removeClass('disabled');$(element).css({'opacity':''});$('#'+$(element).attr('id')+'_mask').hide();if($(element).data('css_events'))return;$(element).data('css_events',true);$(element).append('<div id="'+$(element).attr('id')+'_area"></div>');$('#'+$(element).attr('id')+'_area').css({'background':'black','opacity':'0','position':'absolute','width':'100%','height':'100%','left':'0px','top':'0px'});if($(element).hasClass('button')){$(element).on('mouseover touchstart',function(){$(this).children().first().css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).children().first().css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).children().first().attr('style',$(this).children().first().attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).children().first().css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});}
else if($(element).hasClass('checkbox')||$(element).hasClass('radio')){$('#'+$(element).attr('id')+'_area').on('click',function(){if($(this).parent().hasClass('selected')){if($(this).parent().hasClass('radio'))return;sym_deselect($(this).parent());}
else{sym_select($(this).parent());}});$(element).on('mouseover touchstart',function(){$(this).find('.tickbox').css({'border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mousedown touchstart',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #e1f3fe 0%, #9cd8fd 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#e1f3fe), color-stop(100%,#9cd8fd));'
+'background:-webkit-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-o-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:-ms-linear-gradient(top, #e1f3fe 0%,#9cd8fd 100%);'
+'background:linear-gradient(to bottom, #e1f3fe 0%,#9cd8fd 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2UxZjNmZSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM5Y2Q4ZmQiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox').css({'border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});$(element).on('mouseout mouseup touchend',function(){$(this).find('.tickbox').attr('style',$(this).find('.tickbox').attr('style')
+'background:-moz-linear-gradient(top, #fdfdfd 0%, #ebebeb 100%);'
+'background:-webkit-gradient(linear, left top, left bottom, color-stop(0%,#fdfdfd), color-stop(100%,#ebebeb));'
+'background:-webkit-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-o-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:-ms-linear-gradient(top, #fdfdfd 0%,#ebebeb 100%);'
+'background:linear-gradient(to bottom, #fdfdfd 0%,#ebebeb 100%);');if(sym_ie()==9)$(this).find('.tickbox').css({'background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iI2ZkZmRmZCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiNlYmViZWIiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)'});});if($(element).hasClass('radio')){$(element).on('mouseover touchstart',function(){$(this).find('.tickbox div').css({'opacity':'0.8','border-top-color':'#009CFE','border-right-color':'#0089DF','border-bottom-color':'#0076C1','border-left-color':'#0089DF'});});$(element).on('mouseout touchend',function(){$(this).find('.tickbox div').css({'opacity':'','border-top-color':'#B5B8BA','border-right-color':'#898E91','border-bottom-color':'#5A6165','border-left-color':'#898E91'});});}}
else if($(element).hasClass('slider')){$(element).on('mouseover mouseup',function(){$(this).find('.handle').css({'background-position':'0% 50%'});});$(element).on('mousedown touchstart',function(){$(this).find('.handle').css({'background-position':'0% 100%'});$(this).addClass('active');});$(element).on('mouseout touchend',function(){$(this).find('.handle').css({'background-position':'0% 0%'});});}
else if($(element).hasClass('arrowButton')){$(element).on('mouseover touchstart',function(){$(this).find('.box').css({'border-color':'rgba(0,156,254,1.00)'})
if($(this).data('down')){$(this).find('.box').css({'background-color':'rgba(187,229,255,1.00)'})}});$(element).on('mouseout touchend',function(){$(this).find('.box').css({'border-color':'rgba(137,142,145,1.00)'})});$(element).on('mousedown touchstart',function(){$(this).find('.box').css({'background-color':'rgba(187,229,255,1.00)'})
$(this).data('down',true);});$(element).on('mouseup touchend',function(){$(this).find('.box').css({'background-color':'rgba(249,249,249,1.00)'});$(this).data('down',false);});$(element).on('mouseout touchend',function(){$(this).find('.box').css({'background-color':'rgba(249,249,249,1.00)'});});}}
$('#Stage').on('mouseup touchend',function(){$('#Stage').find('.arrowButton').each(function(){$(this).data('down',false);});})
function sym_disable(element){$(element).addClass('disabled');$(element).css({'opacity':'0.4'});$('#'+$(element).attr('id')+'_mask').show();if(!$('#'+$(element).attr('id')+'_mask').length){$(element).after('<div id="'+$(element).attr('id')+'_mask"></div>');$('#'+$(element).attr('id')+'_mask').css({'background':'black','opacity':'0','position':$(element).css('position'),'width':$(element).css('width'),'height':$(element).css('height'),'left':$(element)[0].style.left,'top':$(element)[0].style.top,'right':$(element)[0].style.right,'bottom':$(element)[0].style.bottom});}}
function sym_select(element){$(element).addClass('selected');$(element).find('.tickbox div').show();if($(element).hasClass('radio')){$(element).data('selecting',true);var group=$(element).attr('class').match(/group_[^ ]+/)[0];$('#Stage .'+group).each(function(){if($(this).data('selecting'))$(this).data('selecting',false);else sym_deselect(this);});}}
function sym_deselect(element){$(element).removeClass('selected');$(element).find('.tickbox div').hide();}
function sym_val(element,val){var min=$(element).data('min');var max=$(element).data('max');var range=$(element).hasClass('vertical')?$(element).children().height():$(element).children().width();var pos=(val-min)/(max-min)*range;$(element).find('.handle').css($(element).hasClass('vertical')?'top':'left',pos+'px');$(element).data('val',val);}
function sym_step(step){$('#Stage').data('step',step);var sym=AdobeEdge.getComposition(compId).getSymbols('steps')[0];sym.stop(step+'');sym.$('step_buttons').children().children().css({'border-color':'#999999'});sym.$('step'+step).children().css({'border-color':'#1F7258'});sym.$('step_buttons').children().children().children().css({'color':'#999999'});sym.$('step'+step).children().children().css({'color':'#1F7258'});step_functions(step);}
function sym_ie(){var version=false;if(navigator.appVersion.indexOf("MSIE")!=-1)
version=parseFloat(navigator.appVersion.split("MSIE")[1]);return version;}

//Edge symbol: 'stage'
(function(symbolName){Symbol.bindElementAction(compId,symbolName,"document","compositionReady",function(sym,e){sym_features();yepnope({load:"normalize.css"});var probabilities=[0.3,0.8,0.4];var nTots=[0,0,0];var nPluss=[0,0,0];var measurementAccuracys=[0,0,0];var nTot=0;var nPlus=0;var nMinus=0;var measurementAccuracy=0;sym.$('totalMeasurementsText').html('Gesamtzahl:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N<sub>tot</sub> =');sym.$('outcomePlusText').html('Ausgang S<sub>z</sub>=+&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;N<sub>+</sub> =');sym.$('outcomeMinusText').html('Ausgang S<sub>z</sub>=&#8722;&#295;/2:&nbsp;&nbsp;&nbsp;&nbsp;N<sub>&#8211;</sub> =');sym.$('introText11').html('In dieser Simulation kannst Du Messungen mit Spin-1/2-Teilchen durchführen. Diese Teilchen bewegen sich durch einen Stern-Gerlach Apparat (SGA), welcher ein inhomogenes Magnetfeld entlang einer Achse (hier der Z-Achse) erzeugt. Dieses Magnetfeld erlaubt es, die Z-Komponente des Spins S<sub>z</sub> des Teilchens zu bestimmen. Hierbei teilt sich der Strom von Spin ½ Teilchen in einen oberen Teil mit Spin-Wert +&#295;/2 ("Spin hoch") und einen unteren Teil mit Spin-Wert &#8722;&#295;/2 ("Spin runter") entlang der Achse des Magneten. Die Position jedes Teilchens wird dann hinter dem Magneten durch einen Leuchtschirm gemessen. Je nachdem wie die Eingangszustände präpariert sind, ergeben sich unterschiedliche Wahrscheinlichkeiten für beide mögliche Messergebnisse.');sym.$('introText33').html('Drücke auf "Los geht’s" um die Simulation zu starten. Drücke auf "Anleitung" um eine Erklärung der angezeigen Gr&ouml;&szlig;en zu bekommen.');sym.getSymbol("equations").$('equation11').html('&radic;<span style="text-decoration: overline">3/10</span>|&uarr;&#x232A; + &radic;<span style="text-decoration: overline">7/10</span>|&darr;&#x232A;');sym.getSymbol("equations").$('equation22').html('1/&radic;<span style="text-decoration: overline">5</span> (&#8211;2|&uarr;&#x232A; + |&darr;&#x232A;)');sym.getSymbol("equations").$('equation33').html('a|&uarr;&#x232A; + b|&darr;&#x232A;');sym.$('mostLikelyOutcome').html('+&#295;/2');sym.$('Text11').html('Beobachteter Wert S<sub>z</sub>');sym.$('probabilityNegativeText').html('&#8211;&#295;/2:&nbsp;&nbsp;Prob<sub>&#8211;</sub>&nbsp;=&nbsp;N<sub>&#8211;</sub>&nbsp;/&nbsp;N<sub>tot</sub>&nbsp;=&nbsp;');sym.$('probabilityPositiveText').html('+&#295;/2:&nbsp;&nbsp;Prob<sub>+</sub>&nbsp;=&nbsp;N<sub>+</sub>&nbsp;/&nbsp;N<sub>tot</sub>&nbsp;=&nbsp;');sym.$('SzFractionText').html('&#x2329;&#348;<sub>z</sub>&#x232A;&nbsp;=&nbsp;Summe der Ergebnisse / N<sub>tot</sub>');sym.$('SzValueCopy3Text').html('&#x2329;&#348;<sub>z</sub>&#x232A;&nbsp;=&nbsp;');sym.$('SzValueText').html('&#x2329;&#348;<sub>z</sub>&#x232A;&nbsp;=&nbsp;');sym.$('SzFormula2Text').html('&#x2329;&#348;<sub>z</sub>&#x232A;&nbsp;=&nbsp;(+&#295;/2)Prob<sub>+</sub>+(&#8211;&#295;/2)Prob<sub>&#8211;</sub>');sym.$('labelHistogram1').html('+&#295;/2 ');sym.$('labelHistogram2').html('&#8722;&#295;/2');sym.$('likelyOutcomeText').html('Wahrscheinlichster theoretischer Ausgang <br> f&uuml;r eine Einzelmessung:');sym.getSymbol('steps').$('stepText44').html('Wenn man die Messergebnisse +&#295;/2 für "Spin hoch" und &#8211;&#295;/2 für "Spin runter" mittelt, kann man den Erwartungswert der Messung bestimmen. Auch hier nähert sich der beobachtete Wert an den asymptotischen (theoretischen) Wert an, je mehr Messungen gemacht wurden. Die Quantenphysik erlaubt im Allgemeinen keine Vorhersage für ein einzelnes Messergebnis, nur die asymptotischen Werte sind bestimmt.');sym.getSymbol('steps').$('stepText33').html('Wenn Du das Experiment für verschiedene Eingangszustände ausf&uuml;hrst, kannst Du beobachten, wie sich die Wahrscheinlichkeiten f&uuml;r die beiden Messergebnisse verändern. Je öfter man das Experiment wiederholt, desto besser nähern sich die beobachteten Wahrscheinlichkeiten an die asymptotisch zu erwartenden (theoretischen) Werte an.');sym.sendParticle=function(){nTot++;nTots[currentEquation-1]++;var wentUp=Math.random()<probabilities[currentEquation-1];if(wentUp){nPlus++;nPluss[currentEquation-1]++;sym.getSymbol('blueFlash').stop(0);sym.getSymbol('blueFlash2').stop(0);sym.getSymbol('greenFlash').play(0);sym.getSymbol('greenFlash2').play(0);}else{nMinus++;sym.getSymbol('blueFlash').play(0);sym.getSymbol('blueFlash2').play(0);sym.getSymbol('greenFlash').stop(0);sym.getSymbol('greenFlash2').stop(0);}
sym.checkMeasurementAccuracy();}
sym.startStream=function(){streaming=true;sym_disable(sym.$('singleButton'));sym_disable(sym.$('fastForwardButton'));sym.$('continousButtonLabel').text('Strom stoppen');sym.sendParticle();sym.updateDisplays();}
sym.continueStream=function(){if(streaming){sym.sendParticle();sym.updateDisplays();}}
sym.stopStream=function(){streaming=false;sym_enable(sym.$('singleButton'));sym_enable(sym.$('fastForwardButton'));sym.$('continousButtonLabel').text('Strom von Teilchen');}
sym.updateDisplays=function(){sym.displayNs();sym.updateHistogram();sym.updateLikelyOutcome();sym.updateProbabilities();sym.updateExpectationValueI();sym.updateExpectationValueII();sym.toggleMeasurementsText();}
sym.displayNs=function(){sym.$('totalMeasurementText').text(nTot);sym.$('totalOutcomeText').html(sym.roundN(nTot));sym.$('positiveMeasurementText').text(nPlus);sym.$('positiveOutcomeText').text(nPlus);sym.$('negativeMeasurementText').text(nMinus);sym.$('negativeOutcomeText').text(nMinus);}
sym.roundN=function(n){if(n<=50){if(n<=20)return 20;return 50;}
return(Math.ceil(n/100)*100);}
sym.updateHistogram=function(){var positivePercentage=nPlus/(sym.roundN(nTot));var positiveLength=positivePercentage*200;sym.$('positiveBar').css({'width':(nTot==0?0:positiveLength)});var negativePercentage=nMinus/(sym.roundN(nTot));var negativeLength=negativePercentage*200;sym.$('negativeBar').css({'width':(nTot==0?0:negativeLength)});}
sym.updateLikelyOutcome=function(){sym.$('negativeLikelyOutcome').hide();sym.$('positiveLikelyOutcome').hide();sym.$('likelyOutcomeText').show()
if(currentEquation==1){sym.$('negativeLikelyOutcome').show();sym.$('mostLikelyOutcome').show();sym.$('mostLikelyOutcome').html('&#8211;&#295;/2');}else if(currentEquation==2){sym.$('positiveLikelyOutcome').show();sym.$('mostLikelyOutcome').show();sym.$('mostLikelyOutcome').html('+&#295;/2');}else{sym.$('likelyOutcomeText').hide();sym.$('mostLikelyOutcome').hide();}}
sym.updateProbabilities=function(){sym.$('observedProbabilityPositive').text((nPlus/nTot).toFixed(3));sym.$('observedProbabilityNegative').text((nMinus/nTot).toFixed(3));}
sym.updateExpectationValueI=function(){if(((nPlus-nMinus)/2)<0){sym.$('expectationValueNew').html('<font color = #009900>'+nPlus+'&nbsp;</font>(+&#295;/2)&nbsp;+&nbsp;<font color = #000099>&nbsp;'+nMinus+'&nbsp;</font>(&#8211;&#295;/2) = &#8211;&nbsp;'+((nMinus-nPlus)/2).toFixed(1)+'&nbsp;&#295;');}
else{sym.$('expectationValueNew').html('<font color = #009900>'+nPlus+'&nbsp;</font>(+&#295;/2)&nbsp;+&nbsp;<font color = #000099>&nbsp;'+nMinus+'&nbsp;</font>(&#8211;&#295;/2) = +&nbsp;'+((nPlus-nMinus)/2).toFixed(1)+'&nbsp;&#295;');}
if(((nPlus-nMinus)/2)<0){sym.$('expectationValueIText').html('<font color = #990066>&#8211;</font>'+(Math.abs((nPlus-nMinus)/(2*nTot)).toFixed(3)).fontcolor('#990066')+'<font color = #990066>&nbsp;&#295;</font>');}
else{sym.$('expectationValueIText').html('<font color = #990066></font>'+(Math.abs((nPlus-nMinus)/(2*nTot)).toFixed(3)).fontcolor('#990066')+'<font color = #990066>&nbsp;&#295;</font>');}}
sym.updateExpectationValueII=function(){if(((nPlus-nMinus)/2)<0){sym.$('expectationValueIIText').html('<font color = #990066>&#8211;</font>'+(Math.abs((nPlus-nMinus)/(2*nTot)).toFixed(3)).fontcolor('#990066')+'<font color = #990066>&nbsp;&#295;</font>');}
else{sym.$('expectationValueIIText').html('<font color = #990066></font>'+(Math.abs((nPlus-nMinus)/(2*nTot)).toFixed(3)).fontcolor('#990066')+'<font color = #990066>&nbsp;&#295;</font>');}}
sym.toggleMeasurementsText=function(){if(measurementAccuracy>5){sym.$('moreMeasurementsText').hide();}else{sym.$('moreMeasurementsText').show();}}
sym.checkMeasurementAccuracy=function(){if(measurementAccuracy<6&&nTot>494){measurementAccuracy+=((Math.abs((nPlus-nMinus)/(2*nTot)-(probabilities[currentEquation-1]-0.5))<0.02)?1:(0-measurementAccuracy));measurementAccuracys[currentEquation-1]+=((Math.abs((nPlus-nMinus)/(2*nTot)-(probabilities[currentEquation-1]-0.5))<0.02)?1:(0-measurementAccuracy));}
sym.toggleMeasurementsText();}
sym.clearValues=function(){nTots[currentEquation-1]=0;nPluss[currentEquation-1]=0;measurementAccuracys[currentEquation-1]=0;sym.resetValues();}
sym.resetValues=function(){nTot=nTots[currentEquation-1];nPlus=nPluss[currentEquation-1];nMinus=nTot-nPlus;measurementAccuracy=measurementAccuracys[currentEquation-1];if(measurementAccuracy<=5||nTot<500){sym.$('moreMeasurementsText').show();}
sym.updateDisplays();sym.$('totalOutcomeText').text(sym.roundN(nTot));if(nTot==0){sym.$('positiveOutcomeText').text('');sym.$('negativeOutcomeText').text('');sym.$('observedProbabilityPositive').text((0).toFixed(3));sym.$('observedProbabilityNegative').text((0).toFixed(3));sym.$('expectationValueIText').text((0).toFixed(3));sym.$('expectationValueIIText').text((0).toFixed(3));}
if(currentEquation!=3){sym.$('theoreticalProbabilityPositive').text(probabilities[currentEquation-1]);sym.$('theoreticalProbabilityNegative').text((1-probabilities[currentEquation-1]).toFixed(1));sym.$('theoreticalExpectationValueIText').text((probabilities[currentEquation-1]-0.5).toFixed(1));if((probabilities[currentEquation-1]-0.5).toFixed(1)<0){sym.$('theoreticalExpectationValueIIText').html('<font color = #990066>&#8211;</font>'+Math.abs((probabilities[currentEquation-1]-0.5)).toFixed(1).fontcolor('#990066')+'<font color = #990066>&nbsp;&#295;</font>');}
else{sym.$('theoreticalExpectationValueIIText').html((probabilities[currentEquation-1]-0.5).toFixed(1).fontcolor('#990066')+'<font color = #990066>&nbsp;&#295;</font>');}
sym.$('expectationIHbar').show()
sym.$('expectationIIHbar').show()}else{sym.$('theoreticalProbabilityPositive').text('');sym.$('theoreticalProbabilityNegative').text('');sym.$('theoreticalExpectationValueIText').text('');sym.$('theoreticalExpectationValueIIText').text('');sym.$('expectationIHbar').hide()
sym.$('expectationIIHbar').hide()}
sym.stopStream();sym.getSymbol('greenFlash').stop(0);sym.getSymbol('greenFlash2').stop(0);sym.getSymbol('blueFlash').stop(0);sym.getSymbol('blueFlash2').stop(0);}
sym.displaySelectedControls=function(){if(sym.$('showHistogramCheckbox').hasClass('selected')){sym.$('outcomeHistogram').show();}
if(sym.$('showExpectationsCheckbox').hasClass('selected')){sym.$('expectationValueI').show();sym.$('expectationValueII').show();}
if(sym.$('showProbabilitiesCheckbox').hasClass('selected')){sym.$('probabilities').show();}}
sym.resetValues();sym.getComposition().getStage().getSymbol('equations').stop('intro');sym.$('negativeBar').css({'background':'#7db9e8','background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzdkYjllOCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjUyJSIgc3RvcC1jb2xvcj0iIzFlNTc5OSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM3ZGI5ZTgiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)','background':'-moz-linear-gradient(top,  #7db9e8 0%, #1e5799 52%, #7db9e8 100%)','background':'-webkit-gradient(linear, left top, left bottom, color-stop(0%,#7db9e8), color-stop(52%,#1e5799), color-stop(100%,#7db9e8))','background':'-webkit-linear-gradient(top,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','background':'-o-linear-gradient(top,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','background':'-ms-linear-gradient(top,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','background':'linear-gradient(to bottom,  #7db9e8 0%,#1e5799 52%,#7db9e8 100%)','filter':'progid:DXImageTransform.Microsoft.gradient( startColorstr=#7db9e8, endColorstr=#7db9e8,GradientType=0 )',});sym.$('positiveBar').css({'background':'#88ea91','background':'url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiA/Pgo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDEgMSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+CiAgPGxpbmVhckdyYWRpZW50IGlkPSJncmFkLXVjZ2ctZ2VuZXJhdGVkIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSIgeDE9IjAlIiB5MT0iMCUiIHgyPSIwJSIgeTI9IjEwMCUiPgogICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3RvcC1jb2xvcj0iIzg4ZWE5MSIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjUwJSIgc3RvcC1jb2xvcj0iIzAwZDMwMCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjUzJSIgc3RvcC1jb2xvcj0iIzAwZDMwMCIgc3RvcC1vcGFjaXR5PSIxIi8+CiAgICA8c3RvcCBvZmZzZXQ9IjEwMCUiIHN0b3AtY29sb3I9IiM4OGVhOTEiIHN0b3Atb3BhY2l0eT0iMSIvPgogIDwvbGluZWFyR3JhZGllbnQ+CiAgPHJlY3QgeD0iMCIgeT0iMCIgd2lkdGg9IjEiIGhlaWdodD0iMSIgZmlsbD0idXJsKCNncmFkLXVjZ2ctZ2VuZXJhdGVkKSIgLz4KPC9zdmc+)','background':'-moz-linear-gradient(top,  #88ea91 0%, #00d300 50%, #00d300 53%, #88ea91 100%)','background':'-webkit-gradient(linear, left top, left bottom, color-stop(0%,#88ea91), color-stop(50%,#00d300), color-stop(53%,#00d300), color-stop(100%,#88ea91))','background':'-webkit-linear-gradient(top,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','background':'-o-linear-gradient(top,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','background':'-ms-linear-gradient(top,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','background':'linear-gradient(to bottom,  #88ea91 0%,#00d300 50%,#00d300 53%,#88ea91 100%)','filter':'progid:DXImageTransform.Microsoft.gradient( startColorstr=#88ea91, endColorstr=#88ea91,GradientType=0 )',});});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_simulation}","click",function(sym,e){sym.stop('controls');sym_features();$('#Stage').data('step',false);clearTimeout(AdobeEdge.step_animation);currentEquation=oldEquation;sym.getComposition().getStage().getSymbol('equations').stop(''+currentEquation);if(currentEquation!=1){sym_enable(sym.$('leftButton'));}
if(currentEquation!=3){sym_enable(sym.$('rightButton'));}
sym.displaySelectedControls();sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_tab_explanation}","click",function(sym,e){sym.stop('explanation');sym_features();sym_step(1);if(streaming){sym.stopStream();}
sym_disable(sym.$('leftButton'));sym_disable(sym.$('rightButton'));sym.getComposition().getStage().getSymbol('equations').stop('1');oldEquation=currentEquation;currentEquation=1;sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_rightButton}","click",function(sym,e){sym_enable(sym.$('leftButton'));currentEquation++;if(currentEquation==3){sym_disable(sym.$('rightButton'));}
sym.getComposition().getStage().getSymbol('equations').stop(''+currentEquation);sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_leftButton}","click",function(sym,e){sym_enable(sym.$('rightButton'));currentEquation--;if(currentEquation==1){sym_disable(sym.$('leftButton'));}
sym.getComposition().getStage().getSymbol('equations').stop(''+currentEquation);sym.resetValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_singleButton}","click",function(sym,e){sym.sendParticle();sym.updateDisplays()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_showHistogramCheckbox}","click",function(sym,e){sym.$('outcomeHistogram').toggle();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_showProbabilitiesCheckbox}","click",function(sym,e){sym.$('probabilities').toggle();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_showExpectationsCheckbox}","click",function(sym,e){sym.$('expectationValueI').toggle();sym.$('expectationValueII').toggle();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_fastForwardButton}","click",function(sym,e){for(var i=0;i<100;i++){sym.sendParticle();sym.toggleMeasurementsText();}
sym.updateDisplays()});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_continousButton}","click",function(sym,e){if(!streaming){sym.startStream();}else{sym.stopStream();}});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_clearMeasurementsButton}","click",function(sym,e){sym.clearValues();});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_introButton}","click",function(sym,e){sym.stop('intro');sym_features();if(streaming){sym.stopStream();}
sym.resetValues();sym.getComposition().getStage().getSymbol('equations').stop('intro');});
//Edge binding end
Symbol.bindElementAction(compId,symbolName,"${_controlsButton}","click",function(sym,e){sym.stop('controls');sym_features();sym.displaySelectedControls();sym.getComposition().getStage().getSymbol('equations').stop(''+currentEquation);});
//Edge binding end
})("stage");
//Edge symbol end:'stage'

//=========================================================

//Edge symbol: 'checkbox_tickbox'
(function(symbolName){})("checkbox_tickbox");
//Edge symbol end:'checkbox_tickbox'

//=========================================================

//Edge symbol: 'radio_tickbox'
(function(symbolName){})("radio_tickbox");
//Edge symbol end:'radio_tickbox'

//=========================================================

//Edge symbol: 'exploration'
(function(symbolName){})("steps");
//Edge symbol end:'steps'

//=========================================================

//Edge symbol: 'highlight'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.play(0);});
//Edge binding end
})("highlight");
//Edge symbol end:'highlight'

//=========================================================

//Edge symbol: 'equations'
(function(symbolName){})("equations");
//Edge symbol end:'equations'

//=========================================================

//Edge symbol: 'blueFlash'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
})("blueFlash");
//Edge symbol end:'blueFlash'

//=========================================================

//Edge symbol: 'greenFlash'
(function(symbolName){Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
})("greenFlash");
//Edge symbol end:'greenFlash'

//=========================================================

//Edge symbol: 'blueFlash_1'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
})("blueFlashGap");
//Edge symbol end:'blueFlashGap'

//=========================================================

//Edge symbol: 'greenFlash_1'
(function(symbolName){Symbol.bindTriggerAction(compId,symbolName,"Default Timeline",250,function(sym,e){if(!streaming){sym.stop();}});
//Edge binding end
Symbol.bindTimelineAction(compId,symbolName,"Default Timeline","complete",function(sym,e){sym.getComposition().getStage().continueStream();});
//Edge binding end
})("greenFlashGap");
//Edge symbol end:'greenFlashGap'
})(jQuery,AdobeEdge,"EDGE-19890435");